/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.utils.componentproviders;

import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.gephi.desktop.datalab.utils.GraphModelProvider;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.ui.utils.UIUtils;
import org.gephi.utils.TimeIntervalGraphics;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.painter.ImagePainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.JRendererLabel;

public abstract class AbstractTimeSetGraphicsComponentProvider
extends ComponentProvider<JLabel> {
    protected static final Color SELECTED_BACKGROUND = UIManager.getColor("Table.selectionBackground");
    protected static final Color UNSELECTED_BACKGROUND = UIManager.getColor("Table.background");
    protected final Color lineColor;
    protected final Color fillColor;
    protected final Color borderColor;
    protected final TimeIntervalGraphics timeIntervalGraphics;
    protected final JXTable table;
    protected final GraphModelProvider graphModelProvider;
    protected JRendererLabel rendererLabel;

    public AbstractTimeSetGraphicsComponentProvider(GraphModelProvider graphModelProvider, JXTable table) {
        super(null, 10);
        this.graphModelProvider = graphModelProvider;
        this.table = table;
        this.timeIntervalGraphics = new TimeIntervalGraphics(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        if (UIUtils.isDarkLookAndFeel()) {
            this.lineColor = Color.LIGHT_GRAY;
            this.fillColor = new Color(94, 98, 100);
            this.borderColor = Color.LIGHT_GRAY;
        } else {
            this.lineColor = Color.BLUE;
            this.fillColor = new Color(153, 255, 255);
            this.borderColor = new Color(2, 104, 255);
        }
    }

    private String getTextFromValue(Object value) {
        TimeSet timeSet = (TimeSet)value;
        String text = null;
        if (timeSet != null) {
            text = timeSet.toString(this.graphModelProvider.getGraphModel().getTimeFormat(), this.graphModelProvider.getGraphModel().getTimeZone());
        }
        return text;
    }

    protected void format(CellContext context) {
        int witdth = this.table.getColumnModel().getColumn(context.getColumn()).getWidth();
        int height = this.table.getRowHeight(context.getRow());
        String text = this.getTextFromValue(context.getValue());
        this.rendererLabel.setSize(witdth, height);
        this.rendererLabel.setToolTipText(text);
        this.rendererLabel.setBorder(null);
        this.setImagePainter((TimeSet)context.getValue(), context.isSelected());
    }

    protected void configureState(CellContext context) {
    }

    protected JLabel createRendererComponent() {
        this.rendererLabel = new JRendererLabel();
        return this.rendererLabel;
    }

    public abstract TimeIntervalGraphicsParameters getTimeIntervalGraphicsParameters(TimeSet var1);

    public void setImagePainter(TimeSet value, boolean isSelected) {
        if (value == null) {
            this.rendererLabel.setPainter(null);
            return;
        }
        Color background = isSelected ? SELECTED_BACKGROUND : UNSELECTED_BACKGROUND;
        TimeIntervalGraphicsParameters params = this.getTimeIntervalGraphicsParameters(value);
        BufferedImage image = this.timeIntervalGraphics.createTimeIntervalImage(params.starts, params.ends, this.rendererLabel.getWidth() - 1, this.rendererLabel.getHeight() - 1, this.fillColor, this.borderColor, background);
        this.rendererLabel.setPainter((Painter)new ImagePainter(image));
    }

    public double getMax() {
        return this.timeIntervalGraphics.getMax();
    }

    public double getMin() {
        return this.timeIntervalGraphics.getMin();
    }

    public void setMinMax(double min, double max) {
        this.timeIntervalGraphics.setMinMax(min, max);
    }

    protected class TimeIntervalGraphicsParameters {
        private final double[] starts;
        private final double[] ends;

        public TimeIntervalGraphicsParameters(double[] starts, double[] ends) {
            this.starts = starts;
            this.ends = ends;
        }
    }
}

