/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.api.DefaultsKt;
import org.jetbrains.kotlinx.dataframe.impl.RenderingKt;
import org.jetbrains.kotlinx.dataframe.impl.TypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.math.BasicStats;
import org.jetbrains.kotlinx.dataframe.math.BasicStatsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0001\u001a+\u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u0013\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0000\"H\u0010\u000b\u001a6\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00060\fj\u0002`\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"std", "", "T", "", "Lkotlin/sequences/Sequence;", "type", "Lkotlin/reflect/KType;", "skipNaN", "", "ddof", "", "stdTypeConversion", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "emptyInput", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/CalculateReturnType;", "getStdTypeConversion", "()Lkotlin/jvm/functions/Function2;", "doubleStd", "Lorg/jetbrains/kotlinx/dataframe/math/BasicStats;", "core"})
public final class StdKt {
    @NotNull
    private static final Function2<KType, Boolean, KType> stdTypeConversion = StdKt::stdTypeConversion$lambda$5;

    @PublishedApi
    public static final <T extends Number> double std(@NotNull Sequence<? extends T> $this$std, @NotNull KType type, boolean skipNaN, int ddof) {
        double d;
        Intrinsics.checkNotNullParameter($this$std, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type.isMarkedNullable()) {
            throw new IllegalStateException(("Encountered nullable type " + RenderingKt.renderType(type) + " in std function. This should not occur.").toString());
        }
        KType kType = type;
        if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Double.TYPE))) {
            d = StdKt.doubleStd($this$std, skipNaN, ddof);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Float.TYPE))) {
            d = StdKt.doubleStd((Sequence<Double>)SequencesKt.map($this$std, StdKt::std$lambda$0), skipNaN, ddof);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Integer.TYPE))) {
            d = StdKt.doubleStd((Sequence<Double>)SequencesKt.map($this$std, StdKt::std$lambda$1), false, ddof);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Short.TYPE))) {
            d = StdKt.doubleStd((Sequence<Double>)SequencesKt.map($this$std, StdKt::std$lambda$2), false, ddof);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Byte.TYPE))) {
            d = StdKt.doubleStd((Sequence<Double>)SequencesKt.map($this$std, StdKt::std$lambda$3), false, ddof);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Long.TYPE))) {
            d = StdKt.doubleStd((Sequence<Double>)SequencesKt.map($this$std, StdKt::std$lambda$4), false, ddof);
        } else {
            if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(BigInteger.class)) || Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(BigDecimal.class))) {
                throw new IllegalArgumentException("Cannot calculate the std for big numbers in DataFrame. Only primitive numbers are supported.");
            }
            if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Number.class))) {
                throw new IllegalStateException("Encountered non-specific Number type in std function. This should not occur.".toString());
            }
            if (Intrinsics.areEqual((Object)kType, (Object)TypeUtilsKt.getNothingType())) {
                d = Double.NaN;
            } else {
                throw new IllegalArgumentException("Unable to compute the std for type " + RenderingKt.renderType(type) + ". Only primitive numbers are supported");
            }
        }
        return d;
    }

    @NotNull
    public static final Function2<KType, Boolean, KType> getStdTypeConversion() {
        return stdTypeConversion;
    }

    @JvmName(name="doubleStd")
    public static final double doubleStd(@NotNull Sequence<Double> $this$std, boolean skipNaN, int ddof) {
        Intrinsics.checkNotNullParameter($this$std, (String)"<this>");
        BasicStats basicStats = BasicStatsKt.calculateBasicStatsOrNull($this$std, skipNaN);
        return basicStats != null ? StdKt.std(basicStats, ddof) : Double.NaN;
    }

    public static /* synthetic */ double doubleStd$default(Sequence sequence, boolean bl, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = DefaultsKt.getSkipNaNDefault();
        }
        if ((n2 & 2) != 0) {
            n = DefaultsKt.getDdofDefault();
        }
        return StdKt.doubleStd((Sequence<Double>)sequence, bl, n);
    }

    public static final double std(@NotNull BasicStats $this$std, int ddof) {
        Intrinsics.checkNotNullParameter((Object)$this$std, (String)"<this>");
        return $this$std.getCount() <= ddof ? Double.NaN : Math.sqrt($this$std.getVariance() / (double)($this$std.getCount() - ddof));
    }

    private static final double std$lambda$0(float it) {
        return it;
    }

    private static final double std$lambda$1(int it) {
        return it;
    }

    private static final double std$lambda$2(short it) {
        return it;
    }

    private static final double std$lambda$3(byte it) {
        return it;
    }

    private static final double std$lambda$4(long it) {
        return it;
    }

    private static final KType stdTypeConversion$lambda$5(KType kType, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)kType, (String)"<unused var>");
        return Reflection.typeOf(Double.TYPE);
    }
}

