/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.ssl;

import java.io.OutputStream;
import java.security.cert.X509Certificate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.server.ssl.Idle;
import org.jetbrains.idea.maven.server.ssl.State;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u001e\u0010\u0002\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0014\u001a\u00020\u00152\u000b\u0010\u0016\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0017R)\u0010\u0002\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/idea/maven/server/ssl/SslDelegateHandlerStateMachine;", "", "checkTrusted", "Lkotlin/Function2;", "", "Ljava/security/cert/X509Certificate;", "", "", "<init>", "(Lkotlin/jvm/functions/Function2;)V", "getCheckTrusted", "()Lkotlin/jvm/functions/Function2;", "currentState", "Lorg/jetbrains/idea/maven/server/ssl/State;", "output", "Ljava/io/OutputStream;", "getOutput", "()Ljava/io/OutputStream;", "setOutput", "(Ljava/io/OutputStream;)V", "addLine", "", "text", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.maven"})
public class SslDelegateHandlerStateMachine {
    @NotNull
    private final Function2<X509Certificate[], String, Boolean> checkTrusted;
    @NotNull
    private State currentState;
    public OutputStream output;

    public SslDelegateHandlerStateMachine(@NotNull Function2<? super X509Certificate[], ? super String, Boolean> checkTrusted) {
        Intrinsics.checkNotNullParameter(checkTrusted, (String)"checkTrusted");
        this.checkTrusted = checkTrusted;
        this.currentState = new Idle(this);
    }

    @NotNull
    public final Function2<X509Certificate[], String, Boolean> getCheckTrusted() {
        return this.checkTrusted;
    }

    @NotNull
    public final OutputStream getOutput() {
        OutputStream outputStream = this.output;
        if (outputStream != null) {
            return outputStream;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"output");
        return null;
    }

    public final void setOutput(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"<set-?>");
        this.output = outputStream;
    }

    public final void addLine(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.output == null) {
            return;
        }
        char[] cArray = new char[]{'\n', '\r', '\t', ' '};
        this.currentState = this.currentState.addLine(StringsKt.trim((String)text, (char[])cArray));
    }
}

