/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.preprocessing;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.synthetics.SyntheticClassOrObjectDescriptorKt;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/psi2ir/preprocessing/SourceDeclarationsPreprocessor;", "", "context", "Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;", "<init>", "(Lorg/jetbrains/kotlin/psi2ir/generators/GeneratorContext;)V", "run", "", "ktFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "processDeclaration", "ktDeclaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "processClassOrObject", "ktClassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "ir.psi2ir"})
@SourceDebugExtension(value={"SMAP\nSourceDeclarationsPreprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceDeclarationsPreprocessor.kt\norg/jetbrains/kotlin/psi2ir/preprocessing/SourceDeclarationsPreprocessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1869#2,2:42\n*S KotlinDebug\n*F\n+ 1 SourceDeclarationsPreprocessor.kt\norg/jetbrains/kotlin/psi2ir/preprocessing/SourceDeclarationsPreprocessor\n*L\n37#1:42,2\n*E\n"})
public final class SourceDeclarationsPreprocessor {
    @NotNull
    private final GeneratorContext context;

    public SourceDeclarationsPreprocessor(@NotNull GeneratorContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
    }

    public final void run(@NotNull Collection<? extends KtFile> ktFiles) {
        Intrinsics.checkNotNullParameter(ktFiles, "ktFiles");
        for (KtFile ktFile : CollectionsKt.toSet((Iterable)ktFiles)) {
            for (KtDeclaration ktDeclaration : ktFile.getDeclarations()) {
                this.processDeclaration(ktDeclaration);
            }
        }
    }

    private final void processDeclaration(KtDeclaration ktDeclaration) {
        if (ktDeclaration instanceof KtClassOrObject) {
            this.processClassOrObject((KtClassOrObject)ktDeclaration);
        }
    }

    private final void processClassOrObject(KtClassOrObject ktClassOrObject) {
        block2: {
            ClassDescriptor classDescriptor = SyntheticClassOrObjectDescriptorKt.findClassDescriptor(ktClassOrObject, this.context.getBindingContext());
            if (DescriptorUtils.isEnumEntry(classDescriptor)) {
                return;
            }
            this.context.getSymbolTable().getDescriptorExtension().referenceClass(classDescriptor);
            KtClassBody ktClassBody = ktClassOrObject.getBody();
            if (ktClassBody == null) break block2;
            KtClassBody ktClassBody2 = ktClassBody;
            boolean bl = false;
            Iterable $this$forEach$iv = ktClassBody2.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtDeclaration it = (KtDeclaration)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull(it);
                this.processDeclaration(it);
            }
        }
    }
}

