/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.update;

import com.install4j.api.beans.ErrorHandlingCallback;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.update.ApplicationDisplayMode;
import com.install4j.api.update.UpdateCheckRequest;
import com.install4j.api.update.UpdateDescriptor;
import com.install4j.runtime.installer.helper.apiimpl.UpdateCheckerImpl;
import com.install4j.runtime.launcher.integration.AutomaticUpdate;
import com.install4j.runtime.launcher.integration.UpdateExecutionConfig;
import com.install4j.runtime.util.VersionCheck;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class UpdateChecker {
    public static UpdateDescriptor getUpdateDescriptor(String urlSpec, ApplicationDisplayMode displayMode) throws UserCanceledException, IOException {
        return UpdateChecker.getUpdateDescriptor(urlSpec, displayMode, null);
    }

    public static UpdateDescriptor getUpdateDescriptor(String urlSpec, ApplicationDisplayMode displayMode, ErrorHandlingCallback errorHandlingCallback) throws UserCanceledException, IOException {
        UpdateCheckRequest updateCheckRequest = new UpdateCheckRequest(urlSpec).applicationDisplayMode(displayMode).errorHandlingCallback(errorHandlingCallback);
        return UpdateChecker.getUpdateDescriptor(updateCheckRequest);
    }

    public static UpdateDescriptor getUpdateDescriptor(UpdateCheckRequest updateCheckRequest) throws UserCanceledException, IOException {
        return UpdateCheckerImpl.getUpdateDescriptor(updateCheckRequest);
    }

    public static boolean isUpdateScheduled() {
        return AutomaticUpdate.isScheduled(null, true, true);
    }

    public static void executeScheduledUpdate(List<String> updaterArguments, boolean restartLauncher, Runnable shutdownRunnable) {
        UpdateChecker.executeScheduledUpdate(updaterArguments, restartLauncher, null, shutdownRunnable);
    }

    public static void executeScheduledUpdate(List<String> updaterArguments, boolean restartLauncher, List<String> launcherArguments, Runnable shutdownRunnable) {
        AutomaticUpdate.checkUpdates(launcherArguments == null || launcherArguments.isEmpty() ? null : launcherArguments.toArray(new String[0]), new UpdateExecutionConfig(updaterArguments), restartLauncher, shutdownRunnable);
    }

    public static boolean isVersionLessThanOrEqual(String expectedLowerVersion, String expectedHigherVersion) {
        return VersionCheck.checkCompatible(expectedLowerVersion, expectedHigherVersion);
    }

    public static boolean isVersionGreaterThan(String expectedHigherVersion, String expectedLowerVersion) {
        return !Objects.equals(expectedLowerVersion, expectedHigherVersion) && UpdateChecker.isVersionLessThanOrEqual(expectedLowerVersion, expectedHigherVersion);
    }
}

