/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import org.jdesktop.swingx.painter.AbstractLayoutPainter;
import org.jdesktop.swingx.painter.effects.AreaEffect;
import org.jdesktop.swingx.util.PaintUtils;

public abstract class AbstractAreaPainter<T>
extends AbstractLayoutPainter<T> {
    private boolean stretchPaint;
    private AreaEffect[] areaEffects = new AreaEffect[0];
    private Style style = Style.BOTH;
    private float borderWidth;
    private Paint fillPaint;
    private Paint borderPaint;

    public AbstractAreaPainter() {
        this.fillPaint = Color.RED;
    }

    public AbstractAreaPainter(Paint paint) {
        this.fillPaint = paint;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setFillPaint(Paint p) {
        Paint old = this.getFillPaint();
        this.fillPaint = p;
        this.setDirty(true);
        this.firePropertyChange("fillPaint", old, this.getFillPaint());
    }

    public boolean isPaintStretched() {
        return this.stretchPaint;
    }

    public void setPaintStretched(boolean paintStretched) {
        boolean old = this.isPaintStretched();
        this.stretchPaint = paintStretched;
        this.setDirty(true);
        this.firePropertyChange("paintStretched", old, this.isPaintStretched());
    }

    public void setBorderPaint(Paint p) {
        Paint old = this.getBorderPaint();
        this.borderPaint = p;
        this.setDirty(true);
        this.firePropertyChange("borderPaint", old, this.getBorderPaint());
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setStyle(Style s2) {
        Style old = this.getStyle();
        this.style = s2 == null ? Style.BOTH : s2;
        this.setDirty(true);
        this.firePropertyChange("style", (Object)old, (Object)this.getStyle());
    }

    public Style getStyle() {
        return this.style;
    }

    public void setBorderWidth(float s2) {
        float old = this.getBorderWidth();
        this.borderWidth = s2;
        this.setDirty(true);
        this.firePropertyChange("borderWidth", Float.valueOf(old), Float.valueOf(this.getBorderWidth()));
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    Paint calculateSnappedPaint(Paint p, int width, int height) {
        return PaintUtils.resizeGradient(p, width, height);
    }

    protected abstract Shape provideShape(Graphics2D var1, T var2, int var3, int var4);

    public void setAreaEffects(AreaEffect ... areaEffects) {
        AreaEffect[] old = this.getAreaEffects();
        this.areaEffects = new AreaEffect[areaEffects == null ? 0 : areaEffects.length];
        if (areaEffects != null) {
            System.arraycopy(areaEffects, 0, this.areaEffects, 0, this.areaEffects.length);
        }
        this.setDirty(true);
        this.firePropertyChange("areaEffects", old, this.getAreaEffects());
    }

    public AreaEffect[] getAreaEffects() {
        AreaEffect[] results = new AreaEffect[this.areaEffects.length];
        System.arraycopy(this.areaEffects, 0, results, 0, results.length);
        return results;
    }

    public static enum Style {
        BOTH,
        FILLED,
        OUTLINE,
        NONE;

    }
}

