/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.timeseries.model.DateRange;

public class JobRequest
extends ActionRequest {
    private String configID;
    private DateRange dateRange;
    private boolean historical;
    private String rawPath;

    public JobRequest(StreamInput in) throws IOException {
        super(in);
        this.configID = in.readString();
        this.rawPath = in.readString();
        if (in.readBoolean()) {
            this.dateRange = new DateRange(in);
        }
        this.historical = in.readBoolean();
    }

    public JobRequest(String detectorID, String rawPath) {
        this(detectorID, null, false, rawPath);
    }

    public JobRequest(String configID, DateRange dateRange, boolean historical, String rawPath) {
        this.configID = configID;
        this.dateRange = dateRange;
        this.historical = historical;
        this.rawPath = rawPath;
    }

    public String getConfigID() {
        return this.configID;
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public boolean isHistorical() {
        return this.historical;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.configID);
        out.writeString(this.rawPath);
        if (this.dateRange != null) {
            out.writeBoolean(true);
            this.dateRange.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.historical);
    }

    public ActionRequestValidationException validate() {
        return null;
    }
}

