/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DnsRecordIpType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnsOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DnsOptions> {
    private static final SdkField<String> DNS_RECORD_IP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsRecordIpType").getter(DnsOptions.getter(DnsOptions::dnsRecordIpTypeAsString)).setter(DnsOptions.setter(Builder::dnsRecordIpType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsRecordIpType").unmarshallLocationName("dnsRecordIpType").build()}).build();
    private static final SdkField<Boolean> PRIVATE_DNS_ONLY_FOR_INBOUND_RESOLVER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PrivateDnsOnlyForInboundResolverEndpoint").getter(DnsOptions.getter(DnsOptions::privateDnsOnlyForInboundResolverEndpoint)).setter(DnsOptions.setter(Builder::privateDnsOnlyForInboundResolverEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsOnlyForInboundResolverEndpoint").unmarshallLocationName("privateDnsOnlyForInboundResolverEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_RECORD_IP_TYPE_FIELD, PRIVATE_DNS_ONLY_FOR_INBOUND_RESOLVER_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DnsOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dnsRecordIpType;
    private final Boolean privateDnsOnlyForInboundResolverEndpoint;

    private DnsOptions(BuilderImpl builder) {
        this.dnsRecordIpType = builder.dnsRecordIpType;
        this.privateDnsOnlyForInboundResolverEndpoint = builder.privateDnsOnlyForInboundResolverEndpoint;
    }

    public final DnsRecordIpType dnsRecordIpType() {
        return DnsRecordIpType.fromValue(this.dnsRecordIpType);
    }

    public final String dnsRecordIpTypeAsString() {
        return this.dnsRecordIpType;
    }

    public final Boolean privateDnsOnlyForInboundResolverEndpoint() {
        return this.privateDnsOnlyForInboundResolverEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsRecordIpTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsOnlyForInboundResolverEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsOptions)) {
            return false;
        }
        DnsOptions other = (DnsOptions)obj;
        return Objects.equals(this.dnsRecordIpTypeAsString(), other.dnsRecordIpTypeAsString()) && Objects.equals(this.privateDnsOnlyForInboundResolverEndpoint(), other.privateDnsOnlyForInboundResolverEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"DnsOptions").add("DnsRecordIpType", (Object)this.dnsRecordIpTypeAsString()).add("PrivateDnsOnlyForInboundResolverEndpoint", (Object)this.privateDnsOnlyForInboundResolverEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DnsRecordIpType": {
                return Optional.ofNullable(clazz.cast(this.dnsRecordIpTypeAsString()));
            }
            case "PrivateDnsOnlyForInboundResolverEndpoint": {
                return Optional.ofNullable(clazz.cast(this.privateDnsOnlyForInboundResolverEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DnsRecordIpType", DNS_RECORD_IP_TYPE_FIELD);
        map.put("PrivateDnsOnlyForInboundResolverEndpoint", PRIVATE_DNS_ONLY_FOR_INBOUND_RESOLVER_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DnsOptions, T> g) {
        return obj -> g.apply((DnsOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dnsRecordIpType;
        private Boolean privateDnsOnlyForInboundResolverEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsOptions model) {
            this.dnsRecordIpType(model.dnsRecordIpType);
            this.privateDnsOnlyForInboundResolverEndpoint(model.privateDnsOnlyForInboundResolverEndpoint);
        }

        public final String getDnsRecordIpType() {
            return this.dnsRecordIpType;
        }

        public final void setDnsRecordIpType(String dnsRecordIpType) {
            this.dnsRecordIpType = dnsRecordIpType;
        }

        @Override
        public final Builder dnsRecordIpType(String dnsRecordIpType) {
            this.dnsRecordIpType = dnsRecordIpType;
            return this;
        }

        @Override
        public final Builder dnsRecordIpType(DnsRecordIpType dnsRecordIpType) {
            this.dnsRecordIpType(dnsRecordIpType == null ? null : dnsRecordIpType.toString());
            return this;
        }

        public final Boolean getPrivateDnsOnlyForInboundResolverEndpoint() {
            return this.privateDnsOnlyForInboundResolverEndpoint;
        }

        public final void setPrivateDnsOnlyForInboundResolverEndpoint(Boolean privateDnsOnlyForInboundResolverEndpoint) {
            this.privateDnsOnlyForInboundResolverEndpoint = privateDnsOnlyForInboundResolverEndpoint;
        }

        @Override
        public final Builder privateDnsOnlyForInboundResolverEndpoint(Boolean privateDnsOnlyForInboundResolverEndpoint) {
            this.privateDnsOnlyForInboundResolverEndpoint = privateDnsOnlyForInboundResolverEndpoint;
            return this;
        }

        public DnsOptions build() {
            return new DnsOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DnsOptions> {
        public Builder dnsRecordIpType(String var1);

        public Builder dnsRecordIpType(DnsRecordIpType var1);

        public Builder privateDnsOnlyForInboundResolverEndpoint(Boolean var1);
    }
}

