/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.model;

import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.ParseException;
import com.amazonaws.encryptionsdk.internal.PrimitivesParser;
import com.amazonaws.encryptionsdk.internal.Utils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class CiphertextFooters {
    private int authLength_ = -1;
    private byte[] mAuth_ = null;
    private boolean isComplete_ = false;

    public CiphertextFooters() {
    }

    public CiphertextFooters(byte[] mAuth) {
        int length = Utils.assertNonNull(mAuth, "mAuth").length;
        if (length < 0 || length > 65535) {
            throw new IllegalArgumentException("Invalid length for mAuth: " + length);
        }
        this.authLength_ = length;
        this.mAuth_ = (byte[])mAuth.clone();
        this.isComplete_ = true;
    }

    public int deserialize(byte[] b, int off) throws ParseException {
        if (b == null) {
            return 0;
        }
        int parsedBytes = 0;
        try {
            if (this.authLength_ < 0) {
                parsedBytes += this.parseLength(b, off + parsedBytes);
            }
            if (this.mAuth_ == null) {
                parsedBytes += this.parseMauth(b, off + parsedBytes);
            }
            this.isComplete_ = true;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return parsedBytes;
    }

    public int getAuthLength() {
        return this.authLength_;
    }

    public byte[] getMAuth() {
        return this.mAuth_ != null ? (byte[])this.mAuth_.clone() : null;
    }

    public boolean isComplete() {
        return this.isComplete_;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] toByteArray() {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(baos);){
                PrimitivesParser.writeUnsignedShort(dos, this.authLength_);
                dos.write(this.mAuth_);
                dos.close();
                baos.close();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException ex) {
            throw new AwsCryptoException(ex);
        }
    }

    private int parseLength(byte[] b, int off) throws ParseException {
        this.authLength_ = PrimitivesParser.parseUnsignedShort(b, off);
        return 2;
    }

    private int parseMauth(byte[] b, int off) throws ParseException {
        int len = b.length - off;
        if (len >= this.authLength_) {
            this.mAuth_ = Arrays.copyOfRange(b, off, off + this.authLength_);
            return this.authLength_;
        }
        throw new ParseException("Not enough bytes to parse mAuth,  needed at least " + this.authLength_ + " bytes, but only had " + len + " bytes");
    }
}

