/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexRepeatedZeroOrMore;

public class Words {
    public static final String AFTER = "after";
    public static final String AND = "and";
    public static final String AS = "as";
    public static final String AT = "at";
    public static final String BEFORE = "before";
    public static final String COMPLETION = "completion";
    public static final String DAY = "day";
    public static final String END = "end";
    public static final String FOR = "for";
    public static final String FROM = "from";
    public static final String ON = "on";
    public static final String START = "start";
    public static final String THE = "the";
    public static final String TO = "to";
    public static final String WEEK = "week";
    public static final String WITH = "with";
    public static final String WORKING = "working";

    public static IRegex zeroOrMore(String ... words) {
        IRegex[] tmp = new IRegex[words.length];
        for (int i = 0; i < words.length; ++i) {
            tmp[i] = new RegexLeaf(words[i]);
        }
        RegexOr or = new RegexOr(tmp);
        return new RegexRepeatedZeroOrMore((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), or));
    }

    public static IRegex exactly(String ... words) {
        IRegex[] tmp = new IRegex[words.length];
        for (int i = 0; i < words.length; ++i) {
            tmp[i] = new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf(words[i]));
        }
        return new RegexConcat(tmp);
    }

    public static IRegex single(String word) {
        return new RegexLeaf(word);
    }

    public static IRegex namedSingle(String name, String word) {
        return new RegexLeaf(name, word);
    }

    public static IRegex namedOneOf(String name, String ... words) {
        IRegex[] tmp = new IRegex[words.length];
        for (int i = 0; i < words.length; ++i) {
            tmp[i] = new RegexLeaf(words[i]);
        }
        return new RegexOr(name, tmp);
    }

    public static IRegex concat(IRegex ... expressions) {
        return new RegexConcat(expressions);
    }
}

