/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import org.semanticweb.owlapi.model.OWLRuntimeException;

public class OWLParserException
extends OWLRuntimeException {
    private static final long serialVersionUID = 40000L;
    private final int lineNumber;
    private final int columnNumber;

    public OWLParserException() {
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public OWLParserException(String message) {
        super(message);
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public OWLParserException(String message, Throwable cause) {
        super(message, cause);
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public OWLParserException(Throwable cause) {
        super(cause);
        this.lineNumber = -1;
        this.columnNumber = -1;
    }

    public OWLParserException(String message, int lineNumber, int columnNumber) {
        super(message);
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public OWLParserException(Throwable cause, int lineNumber, int columnNumber) {
        super(cause);
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public OWLParserException(String message, Throwable cause, int lineNumber, int columnNumber) {
        super(message, cause);
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public String getMessage() {
        if (this.lineNumber != -1) {
            return super.getMessage() + " (Line " + this.lineNumber + " column " + this.columnNumber + ')';
        }
        return super.getMessage();
    }
}

