/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.drawable;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;
import net.sf.sdedit.util.Pair;
import net.sf.sdedit.util.Utilities;

public class Strokes {
    private static Map<Pair<StrokeType, Integer>, Stroke> strokeCache;
    private static float[][] dashes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Stroke getStroke(StrokeType type, int width) {
        Pair<StrokeType, Integer> key = Utilities.pair(type, width);
        Stroke stroke = strokeCache.get(key);
        if (stroke == null) {
            int cap = 0;
            int join = 1;
            float miterlimit = 1.0f;
            float dash_phase = 0.0f;
            stroke = new BasicStroke(width, cap, join, miterlimit, dashes[type.ordinal()], dash_phase);
            Map<Pair<StrokeType, Integer>, Stroke> map = strokeCache;
            synchronized (map) {
                strokeCache.put(key, stroke);
            }
        }
        return stroke;
    }

    public static Stroke defaultStroke() {
        return Strokes.getStroke(StrokeType.SOLID, 1);
    }

    private Strokes() {
    }

    static {
        dashes = new float[4][2];
        Strokes.dashes[StrokeType.SOLID.ordinal()] = null;
        Strokes.dashes[StrokeType.EMPTY.ordinal()] = new float[]{0.0f, 1.0f};
        Strokes.dashes[StrokeType.DASHED.ordinal()] = new float[]{5.0f, 5.0f};
        Strokes.dashes[StrokeType.DOTTED.ordinal()] = new float[]{1.0f, 2.0f};
        strokeCache = new HashMap<Pair<StrokeType, Integer>, Stroke>();
    }

    public static enum StrokeType {
        SOLID,
        EMPTY,
        DASHED,
        DOTTED;

    }
}

