/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.IOException;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;

public class ImportFDF {
    public void importFDF(PDDocument pdfDocument, FDFDocument fdfDocument) throws IOException {
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        if (acroForm == null) {
            return;
        }
        acroForm.setCacheFields(true);
        acroForm.importFDF(fdfDocument);
        ((COSDictionary)acroForm.getCOSObject()).setBoolean(COSName.getPDFName("NeedAppearances"), true);
    }

    public static void main(String[] args) throws Exception {
        ImportFDF importer = new ImportFDF();
        importer.importFDF(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFDF(String[] args) throws Exception {
        PDDocument pdf = null;
        FDFDocument fdf = null;
        try {
            if (args.length != 3) {
                ImportFDF.usage();
            } else {
                ImportFDF importer = new ImportFDF();
                pdf = PDDocument.load(args[0]);
                fdf = FDFDocument.load(args[1]);
                importer.importFDF(pdf, fdf);
                pdf.save(args[2]);
            }
        }
        finally {
            this.close(fdf);
            this.close(pdf);
        }
    }

    private static void usage() {
        System.err.println("usage: org.apache.pdfbox.ImportFDF <pdf-file> <fdf-file> <output-file>");
    }

    public void close(FDFDocument doc) throws IOException {
        if (doc != null) {
            doc.close();
        }
    }

    public void close(PDDocument doc) throws IOException {
        if (doc != null) {
            doc.close();
        }
    }
}

