// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from esp32c6.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Espressif

//go:build esp && esp32c6

/*
// 32-bit RISC-V MCU & 2.4 GHz Wi-Fi 6 & Bluetooth 5 (LE) & IEEE 802.15.4
*/
//     Copyright 2023 Espressif Systems (Shanghai) PTE LTD Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
package esp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ESP32-C6"
	CPU          = "RV32IMAC"
	FPUPresent   = false
	NVICPrioBits = 0
)

// Interrupt numbers.
const (
	// Interrupt Controller (Core 0)
	IRQ_WIFI_MAC = 0

	// Interrupt Controller (Core 0)
	IRQ_WIFI_MAC_NMI = 1

	// Interrupt Controller (Core 0)
	IRQ_WIFI_PWR = 2

	// Interrupt Controller (Core 0)
	IRQ_WIFI_BB = 3

	// Interrupt Controller (Core 0)
	IRQ_BT_MAC = 4

	// Interrupt Controller (Core 0)
	IRQ_BT_BB = 5

	// Interrupt Controller (Core 0)
	IRQ_BT_BB_NMI = 6

	// Interrupt Controller (Core 0)
	IRQ_LP_TIMER = 7

	// Interrupt Controller (Core 0)
	IRQ_COEX = 8

	// Interrupt Controller (Core 0)
	IRQ_BLE_TIMER = 9

	// Interrupt Controller (Core 0)
	IRQ_BLE_SEC = 10

	// I2C (Inter-Integrated Circuit) Controller 0
	IRQ_I2C_MASTER = 11

	// Interrupt Controller (Core 0)
	IRQ_ZB_MAC = 12

	// PMU Peripheral
	IRQ_PMU = 13

	// eFuse Controller
	IRQ_EFUSE = 14

	// Low-power Timer
	IRQ_LP_RTC_TIMER = 15

	// Low-power UART (Universal Asynchronous Receiver-Transmitter) Controller
	IRQ_LP_UART = 16

	// Low-power I2C (Inter-Integrated Circuit) Controller 0
	IRQ_LP_I2C = 17

	// Low-power Watchdog Timer
	IRQ_LP_WDT = 18

	// LP_PERI Peripheral
	IRQ_LP_PERI_TIMEOUT = 19

	// Low-power Access Permission Management Controller
	IRQ_LP_APM_M0 = 20

	// Low-power Access Permission Management Controller
	IRQ_LP_APM_M1 = 21

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR0 = 22

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR1 = 23

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR2 = 24

	// Interrupt Controller (Core 0)
	IRQ_FROM_CPU_INTR3 = 25

	// Debug Assist
	IRQ_ASSIST_DEBUG = 26

	// RISC-V Trace Encoder
	IRQ_TRACE = 27

	// Interrupt Controller (Core 0)
	IRQ_CACHE = 28

	// Interrupt Controller (Core 0)
	IRQ_CPU_PERI_TIMEOUT = 29

	// General Purpose Input/Output
	IRQ_GPIO = 30

	// General Purpose Input/Output
	IRQ_GPIO_NMI = 31

	// PAU Peripheral
	IRQ_PAU = 32

	// High-Power System
	IRQ_HP_PERI_TIMEOUT = 33

	// High-Power System
	IRQ_MODEM_PERI_TIMEOUT = 34

	// HP_APM Peripheral
	IRQ_HP_APM_M0 = 35

	// HP_APM Peripheral
	IRQ_HP_APM_M1 = 36

	// HP_APM Peripheral
	IRQ_HP_APM_M2 = 37

	// HP_APM Peripheral
	IRQ_HP_APM_M3 = 38

	// Low-power Access Permission Management Controller
	IRQ_LP_APM0 = 39

	// SPI (Serial Peripheral Interface) Controller 2
	IRQ_MSPI = 40

	// I2S (Inter-IC Sound) Controller 0
	IRQ_I2S1 = 41

	// Universal Host Controller Interface 0
	IRQ_UHCI0 = 42

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 0
	IRQ_UART0 = 43

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 1
	IRQ_UART1 = 44

	// LED Control PWM (Pulse Width Modulation)
	IRQ_LEDC = 45

	// Two-Wire Automotive Interface
	IRQ_TWAI0 = 46

	// Two-Wire Automotive Interface
	IRQ_TWAI1 = 47

	// Full-speed USB Serial/JTAG Controller
	IRQ_USB_DEVICE = 48

	// Remote Control
	IRQ_RMT = 49

	// I2C (Inter-Integrated Circuit) Controller 0
	IRQ_I2C_EXT0 = 50

	// Timer Group 0
	IRQ_TG0_T0_LEVEL = 51

	// Timer Group 0
	IRQ_TG0_T1_LEVEL = 52

	// Timer Group 0
	IRQ_TG0_WDT_LEVEL = 53

	// Timer Group 1
	IRQ_TG1_T0_LEVEL = 54

	// Timer Group 1
	IRQ_TG1_T1_LEVEL = 55

	// Timer Group 1
	IRQ_TG1_WDT_LEVEL = 56

	// System Timer
	IRQ_SYSTIMER_TARGET0 = 57

	// System Timer
	IRQ_SYSTIMER_TARGET1 = 58

	// System Timer
	IRQ_SYSTIMER_TARGET2 = 59

	// SAR (Successive Approximation Register) Analog-to-Digital Converter
	IRQ_APB_SARADC = 60

	// Motor Control Pulse-Width Modulation 0
	IRQ_MCPWM0 = 61

	// Pulse Count Controller
	IRQ_PCNT = 62

	// Parallel IO Controller
	IRQ_PARL_IO = 63

	// SLCHOST Peripheral
	IRQ_SLC0 = 64

	// SLCHOST Peripheral
	IRQ_SLC1 = 65

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_IN_CH0 = 66

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_IN_CH1 = 67

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_IN_CH2 = 68

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_OUT_CH0 = 69

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_OUT_CH1 = 70

	// DMA (Direct Memory Access) Controller
	IRQ_DMA_OUT_CH2 = 71

	// SPI (Serial Peripheral Interface) Controller 2
	IRQ_SPI2 = 72

	// AES (Advanced Encryption Standard) Accelerator
	IRQ_AES = 73

	// SHA (Secure Hash Algorithm) Accelerator
	IRQ_SHA = 74

	// RSA (Rivest Shamir Adleman) Accelerator
	IRQ_RSA = 75

	// ECC (ECC Hardware Accelerator)
	IRQ_ECC = 76

	// Highest interrupt number on this device.
	IRQ_max = 76
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)
func HandleInterrupt(num int) {
	switch num {
	case IRQ_WIFI_MAC:
		callHandlers(IRQ_WIFI_MAC)
	case IRQ_WIFI_MAC_NMI:
		callHandlers(IRQ_WIFI_MAC_NMI)
	case IRQ_WIFI_PWR:
		callHandlers(IRQ_WIFI_PWR)
	case IRQ_WIFI_BB:
		callHandlers(IRQ_WIFI_BB)
	case IRQ_BT_MAC:
		callHandlers(IRQ_BT_MAC)
	case IRQ_BT_BB:
		callHandlers(IRQ_BT_BB)
	case IRQ_BT_BB_NMI:
		callHandlers(IRQ_BT_BB_NMI)
	case IRQ_LP_TIMER:
		callHandlers(IRQ_LP_TIMER)
	case IRQ_COEX:
		callHandlers(IRQ_COEX)
	case IRQ_BLE_TIMER:
		callHandlers(IRQ_BLE_TIMER)
	case IRQ_BLE_SEC:
		callHandlers(IRQ_BLE_SEC)
	case IRQ_I2C_MASTER:
		callHandlers(IRQ_I2C_MASTER)
	case IRQ_ZB_MAC:
		callHandlers(IRQ_ZB_MAC)
	case IRQ_PMU:
		callHandlers(IRQ_PMU)
	case IRQ_EFUSE:
		callHandlers(IRQ_EFUSE)
	case IRQ_LP_RTC_TIMER:
		callHandlers(IRQ_LP_RTC_TIMER)
	case IRQ_LP_UART:
		callHandlers(IRQ_LP_UART)
	case IRQ_LP_I2C:
		callHandlers(IRQ_LP_I2C)
	case IRQ_LP_WDT:
		callHandlers(IRQ_LP_WDT)
	case IRQ_LP_PERI_TIMEOUT:
		callHandlers(IRQ_LP_PERI_TIMEOUT)
	case IRQ_LP_APM_M0:
		callHandlers(IRQ_LP_APM_M0)
	case IRQ_LP_APM_M1:
		callHandlers(IRQ_LP_APM_M1)
	case IRQ_FROM_CPU_INTR0:
		callHandlers(IRQ_FROM_CPU_INTR0)
	case IRQ_FROM_CPU_INTR1:
		callHandlers(IRQ_FROM_CPU_INTR1)
	case IRQ_FROM_CPU_INTR2:
		callHandlers(IRQ_FROM_CPU_INTR2)
	case IRQ_FROM_CPU_INTR3:
		callHandlers(IRQ_FROM_CPU_INTR3)
	case IRQ_ASSIST_DEBUG:
		callHandlers(IRQ_ASSIST_DEBUG)
	case IRQ_TRACE:
		callHandlers(IRQ_TRACE)
	case IRQ_CACHE:
		callHandlers(IRQ_CACHE)
	case IRQ_CPU_PERI_TIMEOUT:
		callHandlers(IRQ_CPU_PERI_TIMEOUT)
	case IRQ_GPIO:
		callHandlers(IRQ_GPIO)
	case IRQ_GPIO_NMI:
		callHandlers(IRQ_GPIO_NMI)
	case IRQ_PAU:
		callHandlers(IRQ_PAU)
	case IRQ_HP_PERI_TIMEOUT:
		callHandlers(IRQ_HP_PERI_TIMEOUT)
	case IRQ_MODEM_PERI_TIMEOUT:
		callHandlers(IRQ_MODEM_PERI_TIMEOUT)
	case IRQ_HP_APM_M0:
		callHandlers(IRQ_HP_APM_M0)
	case IRQ_HP_APM_M1:
		callHandlers(IRQ_HP_APM_M1)
	case IRQ_HP_APM_M2:
		callHandlers(IRQ_HP_APM_M2)
	case IRQ_HP_APM_M3:
		callHandlers(IRQ_HP_APM_M3)
	case IRQ_LP_APM0:
		callHandlers(IRQ_LP_APM0)
	case IRQ_MSPI:
		callHandlers(IRQ_MSPI)
	case IRQ_I2S1:
		callHandlers(IRQ_I2S1)
	case IRQ_UHCI0:
		callHandlers(IRQ_UHCI0)
	case IRQ_UART0:
		callHandlers(IRQ_UART0)
	case IRQ_UART1:
		callHandlers(IRQ_UART1)
	case IRQ_LEDC:
		callHandlers(IRQ_LEDC)
	case IRQ_TWAI0:
		callHandlers(IRQ_TWAI0)
	case IRQ_TWAI1:
		callHandlers(IRQ_TWAI1)
	case IRQ_USB_DEVICE:
		callHandlers(IRQ_USB_DEVICE)
	case IRQ_RMT:
		callHandlers(IRQ_RMT)
	case IRQ_I2C_EXT0:
		callHandlers(IRQ_I2C_EXT0)
	case IRQ_TG0_T0_LEVEL:
		callHandlers(IRQ_TG0_T0_LEVEL)
	case IRQ_TG0_T1_LEVEL:
		callHandlers(IRQ_TG0_T1_LEVEL)
	case IRQ_TG0_WDT_LEVEL:
		callHandlers(IRQ_TG0_WDT_LEVEL)
	case IRQ_TG1_T0_LEVEL:
		callHandlers(IRQ_TG1_T0_LEVEL)
	case IRQ_TG1_T1_LEVEL:
		callHandlers(IRQ_TG1_T1_LEVEL)
	case IRQ_TG1_WDT_LEVEL:
		callHandlers(IRQ_TG1_WDT_LEVEL)
	case IRQ_SYSTIMER_TARGET0:
		callHandlers(IRQ_SYSTIMER_TARGET0)
	case IRQ_SYSTIMER_TARGET1:
		callHandlers(IRQ_SYSTIMER_TARGET1)
	case IRQ_SYSTIMER_TARGET2:
		callHandlers(IRQ_SYSTIMER_TARGET2)
	case IRQ_APB_SARADC:
		callHandlers(IRQ_APB_SARADC)
	case IRQ_MCPWM0:
		callHandlers(IRQ_MCPWM0)
	case IRQ_PCNT:
		callHandlers(IRQ_PCNT)
	case IRQ_PARL_IO:
		callHandlers(IRQ_PARL_IO)
	case IRQ_SLC0:
		callHandlers(IRQ_SLC0)
	case IRQ_SLC1:
		callHandlers(IRQ_SLC1)
	case IRQ_DMA_IN_CH0:
		callHandlers(IRQ_DMA_IN_CH0)
	case IRQ_DMA_IN_CH1:
		callHandlers(IRQ_DMA_IN_CH1)
	case IRQ_DMA_IN_CH2:
		callHandlers(IRQ_DMA_IN_CH2)
	case IRQ_DMA_OUT_CH0:
		callHandlers(IRQ_DMA_OUT_CH0)
	case IRQ_DMA_OUT_CH1:
		callHandlers(IRQ_DMA_OUT_CH1)
	case IRQ_DMA_OUT_CH2:
		callHandlers(IRQ_DMA_OUT_CH2)
	case IRQ_SPI2:
		callHandlers(IRQ_SPI2)
	case IRQ_AES:
		callHandlers(IRQ_AES)
	case IRQ_SHA:
		callHandlers(IRQ_SHA)
	case IRQ_RSA:
		callHandlers(IRQ_RSA)
	case IRQ_ECC:
		callHandlers(IRQ_ECC)
	}
}

// Peripherals.
var (
	// AES (Advanced Encryption Standard) Accelerator
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x60088000)))

	// SAR (Successive Approximation Register) Analog-to-Digital Converter
	APB_SARADC = (*APB_SARADC_Type)(unsafe.Pointer(uintptr(0x6000e000)))

	// Debug Assist
	ASSIST_DEBUG = (*ASSIST_DEBUG_Type)(unsafe.Pointer(uintptr(0x600c2000)))

	// Atomic Locker
	ATOMIC = (*ATOMIC_Type)(unsafe.Pointer(uintptr(0x60011000)))

	// DMA (Direct Memory Access) Controller
	DMA = (*DMA_Type)(unsafe.Pointer(uintptr(0x60080000)))

	// Digital Signature
	DS = (*DS_Type)(unsafe.Pointer(uintptr(0x6008c000)))

	// ECC (ECC Hardware Accelerator)
	ECC = (*ECC_Type)(unsafe.Pointer(uintptr(0x6008b000)))

	// eFuse Controller
	EFUSE = (*EFUSE_Type)(unsafe.Pointer(uintptr(0x600b0800)))

	// External Memory
	EXTMEM = (*EXTMEM_Type)(unsafe.Pointer(uintptr(0x600c8000)))

	// General Purpose Input/Output
	GPIO = (*GPIO_Type)(unsafe.Pointer(uintptr(0x60091000)))

	// Sigma-Delta Modulation
	GPIO_SD = (*GPIOSD_Type)(unsafe.Pointer(uintptr(0x60091f00)))

	// HINF Peripheral
	HINF = (*HINF_Type)(unsafe.Pointer(uintptr(0x60016000)))

	// HMAC (Hash-based Message Authentication Code) Accelerator
	HMAC = (*HMAC_Type)(unsafe.Pointer(uintptr(0x6008d000)))

	// HP_APM Peripheral
	HP_APM = (*HP_APM_Type)(unsafe.Pointer(uintptr(0x60099000)))

	// High-Power System
	HP_SYS = (*HP_SYS_Type)(unsafe.Pointer(uintptr(0x60095000)))

	// I2C (Inter-Integrated Circuit) Controller 0
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x60004000)))

	// I2S (Inter-IC Sound) Controller 0
	I2S0 = (*I2S_Type)(unsafe.Pointer(uintptr(0x6000c000)))

	// Interrupt Controller (Core 0)
	INTERRUPT_CORE0 = (*INTMTX_CORE0_Type)(unsafe.Pointer(uintptr(0x60010000)))

	// INTPRI Peripheral
	INTPRI = (*INTPRI_Type)(unsafe.Pointer(uintptr(0x600c5000)))

	// Input/Output Multiplexer
	IO_MUX = (*IO_MUX_Type)(unsafe.Pointer(uintptr(0x60090000)))

	// LED Control PWM (Pulse Width Modulation)
	LEDC = (*LEDC_Type)(unsafe.Pointer(uintptr(0x60007000)))

	// LP_PERI Peripheral
	LP_PERI = (*LPPERI_Type)(unsafe.Pointer(uintptr(0x600b2800)))

	// LP_ANA Peripheral
	LP_ANA = (*LP_ANA_Type)(unsafe.Pointer(uintptr(0x600b2c00)))

	// LP_AON Peripheral
	LP_AON = (*LP_AON_Type)(unsafe.Pointer(uintptr(0x600b1000)))

	// Low-power Access Permission Management Controller
	LP_APM = (*LP_APM_Type)(unsafe.Pointer(uintptr(0x600b3800)))

	// LP_APM0 Peripheral
	LP_APM0 = (*LP_APM0_Type)(unsafe.Pointer(uintptr(0x60099800)))

	// LP_CLKRST Peripheral
	LP_CLKRST = (*LP_CLKRST_Type)(unsafe.Pointer(uintptr(0x600b0400)))

	// Low-power I2C (Inter-Integrated Circuit) Controller 0
	LP_I2C0 = (*LP_I2C0_Type)(unsafe.Pointer(uintptr(0x600b1800)))

	// LP_I2C_ANA_MST Peripheral
	LP_I2C_ANA_MST = (*LP_I2C_ANA_MST_Type)(unsafe.Pointer(uintptr(0x600b2400)))

	// LP_IO Peripheral
	LP_IO = (*LP_IO_Type)(unsafe.Pointer(uintptr(0x600b2000)))

	// Low-power Trusted Execution Environment
	LP_TEE = (*LP_TEE_Type)(unsafe.Pointer(uintptr(0x600b3400)))

	// Low-power Timer
	LP_TIMER = (*LP_TIMER_Type)(unsafe.Pointer(uintptr(0x600b0c00)))

	// Low-power UART (Universal Asynchronous Receiver-Transmitter) Controller
	LP_UART = (*LP_UART_Type)(unsafe.Pointer(uintptr(0x600b1400)))

	// Low-power Watchdog Timer
	LP_WDT = (*LP_WDT_Type)(unsafe.Pointer(uintptr(0x600b1c00)))

	// Motor Control Pulse-Width Modulation 0
	MCPWM0 = (*MCPWM_Type)(unsafe.Pointer(uintptr(0x60014000)))

	// MEM_MONITOR Peripheral
	MEM_MONITOR = (*MEM_MONITOR_Type)(unsafe.Pointer(uintptr(0x60092000)))

	// MODEM_LPCON Peripheral
	MODEM_LPCON = (*MODEM_LPCON_Type)(unsafe.Pointer(uintptr(0x600af000)))

	// MODEM_SYSCON Peripheral
	MODEM_SYSCON = (*MODEM_SYSCON_Type)(unsafe.Pointer(uintptr(0x600a9800)))

	// OTP_DEBUG Peripheral
	OTP_DEBUG = (*OTP_DEBUG_Type)(unsafe.Pointer(uintptr(0x600b3c00)))

	// Parallel IO Controller
	PARL_IO = (*PARL_IO_Type)(unsafe.Pointer(uintptr(0x60015000)))

	// PAU Peripheral
	PAU = (*PAU_Type)(unsafe.Pointer(uintptr(0x60093000)))

	// Pulse Count Controller
	PCNT = (*PCNT_Type)(unsafe.Pointer(uintptr(0x60012000)))

	// PCR Peripheral
	PCR = (*PCR_Type)(unsafe.Pointer(uintptr(0x60096000)))

	// PMU Peripheral
	PMU = (*PMU_Type)(unsafe.Pointer(uintptr(0x600b0000)))

	// Remote Control
	RMT = (*RMT_Type)(unsafe.Pointer(uintptr(0x60006000)))

	// Hardware Random Number Generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x600b2800)))

	// RSA (Rivest Shamir Adleman) Accelerator
	RSA = (*RSA_Type)(unsafe.Pointer(uintptr(0x6008a000)))

	// SHA (Secure Hash Algorithm) Accelerator
	SHA = (*SHA_Type)(unsafe.Pointer(uintptr(0x60089000)))

	// SLCHOST Peripheral
	SLCHOST = (*SLCHOST_Type)(unsafe.Pointer(uintptr(0x60017000)))

	// Event Task Matrix
	SOC_ETM = (*SOC_ETM_Type)(unsafe.Pointer(uintptr(0x60013000)))

	// SPI (Serial Peripheral Interface) Controller 0
	SPI0 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x60002000)))

	// SPI (Serial Peripheral Interface) Controller 1
	SPI1 = (*SPI1_Type)(unsafe.Pointer(uintptr(0x60003000)))

	// SPI (Serial Peripheral Interface) Controller 2
	SPI2 = (*SPI2_Type)(unsafe.Pointer(uintptr(0x60081000)))

	// System Timer
	SYSTIMER = (*SYSTIMER_Type)(unsafe.Pointer(uintptr(0x6000a000)))

	// TEE Peripheral
	TEE = (*TEE_Type)(unsafe.Pointer(uintptr(0x60098000)))

	// Timer Group 0
	TIMG0 = (*TIMG_Type)(unsafe.Pointer(uintptr(0x60008000)))

	// RISC-V Trace Encoder
	TRACE = (*TRACE_Type)(unsafe.Pointer(uintptr(0x600c0000)))

	// Two-Wire Automotive Interface
	TWAI0 = (*TWAI_Type)(unsafe.Pointer(uintptr(0x6000b000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 0
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x60000000)))

	// Universal Host Controller Interface 0
	UHCI0 = (*UHCI_Type)(unsafe.Pointer(uintptr(0x60005000)))

	// Full-speed USB Serial/JTAG Controller
	USB_DEVICE = (*USB_DEVICE_Type)(unsafe.Pointer(uintptr(0x6000f000)))

	// Timer Group 1
	TIMG1 = (*TIMG_Type)(unsafe.Pointer(uintptr(0x60009000)))

	// Two-Wire Automotive Interface
	TWAI1 = (*TWAI_Type)(unsafe.Pointer(uintptr(0x6000d000)))

	// UART (Universal Asynchronous Receiver-Transmitter) Controller 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x60001000)))
)

// AES (Advanced Encryption Standard) Accelerator
type AES_Type struct {
	KEY_0             volatile.Register32    // 0x0
	KEY_1             volatile.Register32    // 0x4
	KEY_2             volatile.Register32    // 0x8
	KEY_3             volatile.Register32    // 0xC
	KEY_4             volatile.Register32    // 0x10
	KEY_5             volatile.Register32    // 0x14
	KEY_6             volatile.Register32    // 0x18
	KEY_7             volatile.Register32    // 0x1C
	TEXT_IN_0         volatile.Register32    // 0x20
	TEXT_IN_1         volatile.Register32    // 0x24
	TEXT_IN_2         volatile.Register32    // 0x28
	TEXT_IN_3         volatile.Register32    // 0x2C
	TEXT_OUT_0        volatile.Register32    // 0x30
	TEXT_OUT_1        volatile.Register32    // 0x34
	TEXT_OUT_2        volatile.Register32    // 0x38
	TEXT_OUT_3        volatile.Register32    // 0x3C
	MODE              volatile.Register32    // 0x40
	ENDIAN            volatile.Register32    // 0x44
	TRIGGER           volatile.Register32    // 0x48
	STATE             volatile.Register32    // 0x4C
	IV_MEM            [16]volatile.Register8 // 0x50
	H_MEM             [16]volatile.Register8 // 0x60
	J0_MEM            [16]volatile.Register8 // 0x70
	T0_MEM            [16]volatile.Register8 // 0x80
	DMA_ENABLE        volatile.Register32    // 0x90
	BLOCK_MODE        volatile.Register32    // 0x94
	BLOCK_NUM         volatile.Register32    // 0x98
	INC_SEL           volatile.Register32    // 0x9C
	AAD_BLOCK_NUM     volatile.Register32    // 0xA0
	REMAINDER_BIT_NUM volatile.Register32    // 0xA4
	CONTINUE          volatile.Register32    // 0xA8
	INT_CLEAR         volatile.Register32    // 0xAC
	INT_ENA           volatile.Register32    // 0xB0
	DATE              volatile.Register32    // 0xB4
	DMA_EXIT          volatile.Register32    // 0xB8
}

// AES.KEY_0: Key material key_0 configure register
func (o *AES_Type) SetKEY_0(value uint32) {
	volatile.StoreUint32(&o.KEY_0.Reg, value)
}
func (o *AES_Type) GetKEY_0() uint32 {
	return volatile.LoadUint32(&o.KEY_0.Reg)
}

// AES.KEY_1: Key material key_1 configure register
func (o *AES_Type) SetKEY_1(value uint32) {
	volatile.StoreUint32(&o.KEY_1.Reg, value)
}
func (o *AES_Type) GetKEY_1() uint32 {
	return volatile.LoadUint32(&o.KEY_1.Reg)
}

// AES.KEY_2: Key material key_2 configure register
func (o *AES_Type) SetKEY_2(value uint32) {
	volatile.StoreUint32(&o.KEY_2.Reg, value)
}
func (o *AES_Type) GetKEY_2() uint32 {
	return volatile.LoadUint32(&o.KEY_2.Reg)
}

// AES.KEY_3: Key material key_3 configure register
func (o *AES_Type) SetKEY_3(value uint32) {
	volatile.StoreUint32(&o.KEY_3.Reg, value)
}
func (o *AES_Type) GetKEY_3() uint32 {
	return volatile.LoadUint32(&o.KEY_3.Reg)
}

// AES.KEY_4: Key material key_4 configure register
func (o *AES_Type) SetKEY_4(value uint32) {
	volatile.StoreUint32(&o.KEY_4.Reg, value)
}
func (o *AES_Type) GetKEY_4() uint32 {
	return volatile.LoadUint32(&o.KEY_4.Reg)
}

// AES.KEY_5: Key material key_5 configure register
func (o *AES_Type) SetKEY_5(value uint32) {
	volatile.StoreUint32(&o.KEY_5.Reg, value)
}
func (o *AES_Type) GetKEY_5() uint32 {
	return volatile.LoadUint32(&o.KEY_5.Reg)
}

// AES.KEY_6: Key material key_6 configure register
func (o *AES_Type) SetKEY_6(value uint32) {
	volatile.StoreUint32(&o.KEY_6.Reg, value)
}
func (o *AES_Type) GetKEY_6() uint32 {
	return volatile.LoadUint32(&o.KEY_6.Reg)
}

// AES.KEY_7: Key material key_7 configure register
func (o *AES_Type) SetKEY_7(value uint32) {
	volatile.StoreUint32(&o.KEY_7.Reg, value)
}
func (o *AES_Type) GetKEY_7() uint32 {
	return volatile.LoadUint32(&o.KEY_7.Reg)
}

// AES.TEXT_IN_0: source text material text_in_0 configure register
func (o *AES_Type) SetTEXT_IN_0(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_0.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_0() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_0.Reg)
}

// AES.TEXT_IN_1: source text material text_in_1 configure register
func (o *AES_Type) SetTEXT_IN_1(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_1.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_1() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_1.Reg)
}

// AES.TEXT_IN_2: source text material text_in_2 configure register
func (o *AES_Type) SetTEXT_IN_2(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_2.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_2() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_2.Reg)
}

// AES.TEXT_IN_3: source text material text_in_3 configure register
func (o *AES_Type) SetTEXT_IN_3(value uint32) {
	volatile.StoreUint32(&o.TEXT_IN_3.Reg, value)
}
func (o *AES_Type) GetTEXT_IN_3() uint32 {
	return volatile.LoadUint32(&o.TEXT_IN_3.Reg)
}

// AES.TEXT_OUT_0: result text material text_out_0 configure register
func (o *AES_Type) SetTEXT_OUT_0(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_0.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_0() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_0.Reg)
}

// AES.TEXT_OUT_1: result text material text_out_1 configure register
func (o *AES_Type) SetTEXT_OUT_1(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_1.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_1() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_1.Reg)
}

// AES.TEXT_OUT_2: result text material text_out_2 configure register
func (o *AES_Type) SetTEXT_OUT_2(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_2.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_2() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_2.Reg)
}

// AES.TEXT_OUT_3: result text material text_out_3 configure register
func (o *AES_Type) SetTEXT_OUT_3(value uint32) {
	volatile.StoreUint32(&o.TEXT_OUT_3.Reg, value)
}
func (o *AES_Type) GetTEXT_OUT_3() uint32 {
	return volatile.LoadUint32(&o.TEXT_OUT_3.Reg)
}

// AES.MODE: AES Mode register
func (o *AES_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x7)|value)
}
func (o *AES_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x7
}

// AES.ENDIAN: AES Endian configure register
func (o *AES_Type) SetENDIAN(value uint32) {
	volatile.StoreUint32(&o.ENDIAN.Reg, volatile.LoadUint32(&o.ENDIAN.Reg)&^(0x3f)|value)
}
func (o *AES_Type) GetENDIAN() uint32 {
	return volatile.LoadUint32(&o.ENDIAN.Reg) & 0x3f
}

// AES.TRIGGER: AES trigger register
func (o *AES_Type) SetTRIGGER(value uint32) {
	volatile.StoreUint32(&o.TRIGGER.Reg, volatile.LoadUint32(&o.TRIGGER.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetTRIGGER() uint32 {
	return volatile.LoadUint32(&o.TRIGGER.Reg) & 0x1
}

// AES.STATE: AES state register
func (o *AES_Type) SetSTATE(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x3)|value)
}
func (o *AES_Type) GetSTATE() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0x3
}

// AES.DMA_ENABLE: DMA-AES working mode register
func (o *AES_Type) SetDMA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DMA_ENABLE.Reg, volatile.LoadUint32(&o.DMA_ENABLE.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetDMA_ENABLE() uint32 {
	return volatile.LoadUint32(&o.DMA_ENABLE.Reg) & 0x1
}

// AES.BLOCK_MODE: AES cipher block mode register
func (o *AES_Type) SetBLOCK_MODE(value uint32) {
	volatile.StoreUint32(&o.BLOCK_MODE.Reg, volatile.LoadUint32(&o.BLOCK_MODE.Reg)&^(0x7)|value)
}
func (o *AES_Type) GetBLOCK_MODE() uint32 {
	return volatile.LoadUint32(&o.BLOCK_MODE.Reg) & 0x7
}

// AES.BLOCK_NUM: AES block number register
func (o *AES_Type) SetBLOCK_NUM(value uint32) {
	volatile.StoreUint32(&o.BLOCK_NUM.Reg, value)
}
func (o *AES_Type) GetBLOCK_NUM() uint32 {
	return volatile.LoadUint32(&o.BLOCK_NUM.Reg)
}

// AES.INC_SEL: Standard incrementing function configure register
func (o *AES_Type) SetINC_SEL(value uint32) {
	volatile.StoreUint32(&o.INC_SEL.Reg, volatile.LoadUint32(&o.INC_SEL.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINC_SEL() uint32 {
	return volatile.LoadUint32(&o.INC_SEL.Reg) & 0x1
}

// AES.AAD_BLOCK_NUM: Additional Authential Data block number register
func (o *AES_Type) SetAAD_BLOCK_NUM(value uint32) {
	volatile.StoreUint32(&o.AAD_BLOCK_NUM.Reg, value)
}
func (o *AES_Type) GetAAD_BLOCK_NUM() uint32 {
	return volatile.LoadUint32(&o.AAD_BLOCK_NUM.Reg)
}

// AES.REMAINDER_BIT_NUM: AES remainder bit number register
func (o *AES_Type) SetREMAINDER_BIT_NUM(value uint32) {
	volatile.StoreUint32(&o.REMAINDER_BIT_NUM.Reg, volatile.LoadUint32(&o.REMAINDER_BIT_NUM.Reg)&^(0x7f)|value)
}
func (o *AES_Type) GetREMAINDER_BIT_NUM() uint32 {
	return volatile.LoadUint32(&o.REMAINDER_BIT_NUM.Reg) & 0x7f
}

// AES.CONTINUE: AES continue register
func (o *AES_Type) SetCONTINUE(value uint32) {
	volatile.StoreUint32(&o.CONTINUE.Reg, volatile.LoadUint32(&o.CONTINUE.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCONTINUE() uint32 {
	return volatile.LoadUint32(&o.CONTINUE.Reg) & 0x1
}

// AES.INT_CLEAR: AES Interrupt clear register
func (o *AES_Type) SetINT_CLEAR(value uint32) {
	volatile.StoreUint32(&o.INT_CLEAR.Reg, volatile.LoadUint32(&o.INT_CLEAR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINT_CLEAR() uint32 {
	return volatile.LoadUint32(&o.INT_CLEAR.Reg) & 0x1
}

// AES.INT_ENA: AES Interrupt enable register
func (o *AES_Type) SetINT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}

// AES.DATE: AES version control register
func (o *AES_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x3fffffff)|value)
}
func (o *AES_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x3fffffff
}

// AES.DMA_EXIT: AES-DMA exit config
func (o *AES_Type) SetDMA_EXIT(value uint32) {
	volatile.StoreUint32(&o.DMA_EXIT.Reg, volatile.LoadUint32(&o.DMA_EXIT.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetDMA_EXIT() uint32 {
	return volatile.LoadUint32(&o.DMA_EXIT.Reg) & 0x1
}

// SAR (Successive Approximation Register) Analog-to-Digital Converter
type APB_SARADC_Type struct {
	CTRL             volatile.Register32 // 0x0
	CTRL2            volatile.Register32 // 0x4
	FILTER_CTRL1     volatile.Register32 // 0x8
	FSM_WAIT         volatile.Register32 // 0xC
	SAR1_STATUS      volatile.Register32 // 0x10
	SAR2_STATUS      volatile.Register32 // 0x14
	SAR_PATT_TAB1    volatile.Register32 // 0x18
	SAR_PATT_TAB2    volatile.Register32 // 0x1C
	ONETIME_SAMPLE   volatile.Register32 // 0x20
	ARB_CTRL         volatile.Register32 // 0x24
	FILTER_CTRL0     volatile.Register32 // 0x28
	SAR1DATA_STATUS  volatile.Register32 // 0x2C
	SAR2DATA_STATUS  volatile.Register32 // 0x30
	THRES0_CTRL      volatile.Register32 // 0x34
	THRES1_CTRL      volatile.Register32 // 0x38
	THRES_CTRL       volatile.Register32 // 0x3C
	INT_ENA          volatile.Register32 // 0x40
	INT_RAW          volatile.Register32 // 0x44
	INT_ST           volatile.Register32 // 0x48
	INT_CLR          volatile.Register32 // 0x4C
	DMA_CONF         volatile.Register32 // 0x50
	CLKM_CONF        volatile.Register32 // 0x54
	APB_TSENS_CTRL   volatile.Register32 // 0x58
	TSENS_CTRL2      volatile.Register32 // 0x5C
	CALI             volatile.Register32 // 0x60
	APB_TSENS_WAKE   volatile.Register32 // 0x64
	APB_TSENS_SAMPLE volatile.Register32 // 0x68
	_                [912]byte
	CTRL_DATE        volatile.Register32 // 0x3FC
}

// APB_SARADC.CTRL: digital saradc configure register
func (o *APB_SARADC_Type) SetCTRL_SARADC_START_FORCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_START_FORCE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_START(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_START() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR_CLK_GATED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR_CLK_GATED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x7f80)|value<<7)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x7f80) >> 7
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR_PATT_LEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x38000)|value<<15)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR_PATT_LEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x38000) >> 15
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_SAR_PATT_P_CLEAR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_SAR_PATT_P_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800000) >> 23
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_XPD_SAR_FORCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x18000000)|value<<27)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_XPD_SAR_FORCE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x18000000) >> 27
}
func (o *APB_SARADC_Type) SetCTRL_SARADC2_PWDET_DRV(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC2_PWDET_DRV() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetCTRL_SARADC_WAIT_ARB_CYCLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc0000000)|value<<30)
}
func (o *APB_SARADC_Type) GetCTRL_SARADC_WAIT_ARB_CYCLE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc0000000) >> 30
}

// APB_SARADC.CTRL2: digital saradc configure register
func (o *APB_SARADC_Type) SetCTRL2_SARADC_MEAS_NUM_LIMIT(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1)|value)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_MEAS_NUM_LIMIT() uint32 {
	return volatile.LoadUint32(&o.CTRL2.Reg) & 0x1
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_MAX_MEAS_NUM(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1fe)|value<<1)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_MAX_MEAS_NUM() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x1fe) >> 1
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_SAR1_INV(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x200)|value<<9)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_SAR1_INV() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x200) >> 9
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_SAR2_INV(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x400)|value<<10)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_SAR2_INV() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x400) >> 10
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_TIMER_TARGET(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0xfff000)|value<<12)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_TIMER_TARGET() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0xfff000) >> 12
}
func (o *APB_SARADC_Type) SetCTRL2_SARADC_TIMER_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL2.Reg, volatile.LoadUint32(&o.CTRL2.Reg)&^(0x1000000)|value<<24)
}
func (o *APB_SARADC_Type) GetCTRL2_SARADC_TIMER_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL2.Reg) & 0x1000000) >> 24
}

// APB_SARADC.FILTER_CTRL1: digital saradc configure register
func (o *APB_SARADC_Type) SetFILTER_CTRL1_APB_SARADC_FILTER_FACTOR1(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL1.Reg, volatile.LoadUint32(&o.FILTER_CTRL1.Reg)&^(0x1c000000)|value<<26)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL1_APB_SARADC_FILTER_FACTOR1() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL1.Reg) & 0x1c000000) >> 26
}
func (o *APB_SARADC_Type) SetFILTER_CTRL1_APB_SARADC_FILTER_FACTOR0(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL1.Reg, volatile.LoadUint32(&o.FILTER_CTRL1.Reg)&^(0xe0000000)|value<<29)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL1_APB_SARADC_FILTER_FACTOR0() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL1.Reg) & 0xe0000000) >> 29
}

// APB_SARADC.FSM_WAIT: digital saradc configure register
func (o *APB_SARADC_Type) SetFSM_WAIT_SARADC_XPD_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff)|value)
}
func (o *APB_SARADC_Type) GetFSM_WAIT_SARADC_XPD_WAIT() uint32 {
	return volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff
}
func (o *APB_SARADC_Type) SetFSM_WAIT_SARADC_RSTB_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff00)|value<<8)
}
func (o *APB_SARADC_Type) GetFSM_WAIT_SARADC_RSTB_WAIT() uint32 {
	return (volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff00) >> 8
}
func (o *APB_SARADC_Type) SetFSM_WAIT_SARADC_STANDBY_WAIT(value uint32) {
	volatile.StoreUint32(&o.FSM_WAIT.Reg, volatile.LoadUint32(&o.FSM_WAIT.Reg)&^(0xff0000)|value<<16)
}
func (o *APB_SARADC_Type) GetFSM_WAIT_SARADC_STANDBY_WAIT() uint32 {
	return (volatile.LoadUint32(&o.FSM_WAIT.Reg) & 0xff0000) >> 16
}

// APB_SARADC.SAR1_STATUS: digital saradc configure register
func (o *APB_SARADC_Type) SetSAR1_STATUS(value uint32) {
	volatile.StoreUint32(&o.SAR1_STATUS.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR1_STATUS() uint32 {
	return volatile.LoadUint32(&o.SAR1_STATUS.Reg)
}

// APB_SARADC.SAR2_STATUS: digital saradc configure register
func (o *APB_SARADC_Type) SetSAR2_STATUS(value uint32) {
	volatile.StoreUint32(&o.SAR2_STATUS.Reg, value)
}
func (o *APB_SARADC_Type) GetSAR2_STATUS() uint32 {
	return volatile.LoadUint32(&o.SAR2_STATUS.Reg)
}

// APB_SARADC.SAR_PATT_TAB1: digital saradc configure register
func (o *APB_SARADC_Type) SetSAR_PATT_TAB1_SARADC_SAR_PATT_TAB1(value uint32) {
	volatile.StoreUint32(&o.SAR_PATT_TAB1.Reg, volatile.LoadUint32(&o.SAR_PATT_TAB1.Reg)&^(0xffffff)|value)
}
func (o *APB_SARADC_Type) GetSAR_PATT_TAB1_SARADC_SAR_PATT_TAB1() uint32 {
	return volatile.LoadUint32(&o.SAR_PATT_TAB1.Reg) & 0xffffff
}

// APB_SARADC.SAR_PATT_TAB2: digital saradc configure register
func (o *APB_SARADC_Type) SetSAR_PATT_TAB2_SARADC_SAR_PATT_TAB2(value uint32) {
	volatile.StoreUint32(&o.SAR_PATT_TAB2.Reg, volatile.LoadUint32(&o.SAR_PATT_TAB2.Reg)&^(0xffffff)|value)
}
func (o *APB_SARADC_Type) GetSAR_PATT_TAB2_SARADC_SAR_PATT_TAB2() uint32 {
	return volatile.LoadUint32(&o.SAR_PATT_TAB2.Reg) & 0xffffff
}

// APB_SARADC.ONETIME_SAMPLE: digital saradc configure register
func (o *APB_SARADC_Type) SetONETIME_SAMPLE_SARADC_ONETIME_ATTEN(value uint32) {
	volatile.StoreUint32(&o.ONETIME_SAMPLE.Reg, volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg)&^(0x1800000)|value<<23)
}
func (o *APB_SARADC_Type) GetONETIME_SAMPLE_SARADC_ONETIME_ATTEN() uint32 {
	return (volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg) & 0x1800000) >> 23
}
func (o *APB_SARADC_Type) SetONETIME_SAMPLE_SARADC_ONETIME_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.ONETIME_SAMPLE.Reg, volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg)&^(0x1e000000)|value<<25)
}
func (o *APB_SARADC_Type) GetONETIME_SAMPLE_SARADC_ONETIME_CHANNEL() uint32 {
	return (volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg) & 0x1e000000) >> 25
}
func (o *APB_SARADC_Type) SetONETIME_SAMPLE_SARADC_ONETIME_START(value uint32) {
	volatile.StoreUint32(&o.ONETIME_SAMPLE.Reg, volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetONETIME_SAMPLE_SARADC_ONETIME_START() uint32 {
	return (volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetONETIME_SAMPLE_SARADC2_ONETIME_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.ONETIME_SAMPLE.Reg, volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetONETIME_SAMPLE_SARADC2_ONETIME_SAMPLE() uint32 {
	return (volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetONETIME_SAMPLE_SARADC1_ONETIME_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.ONETIME_SAMPLE.Reg, volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetONETIME_SAMPLE_SARADC1_ONETIME_SAMPLE() uint32 {
	return (volatile.LoadUint32(&o.ONETIME_SAMPLE.Reg) & 0x80000000) >> 31
}

// APB_SARADC.ARB_CTRL: digital saradc configure register
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_APB_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_APB_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x4) >> 2
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_RTC_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_RTC_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x8) >> 3
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_WIFI_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_WIFI_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x10) >> 4
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_GRANT_FORCE(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_GRANT_FORCE() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x20) >> 5
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_APB_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0xc0)|value<<6)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_APB_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0xc0) >> 6
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_RTC_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x300)|value<<8)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_RTC_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x300) >> 8
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_WIFI_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_WIFI_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0xc00) >> 10
}
func (o *APB_SARADC_Type) SetARB_CTRL_ADC_ARB_FIX_PRIORITY(value uint32) {
	volatile.StoreUint32(&o.ARB_CTRL.Reg, volatile.LoadUint32(&o.ARB_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *APB_SARADC_Type) GetARB_CTRL_ADC_ARB_FIX_PRIORITY() uint32 {
	return (volatile.LoadUint32(&o.ARB_CTRL.Reg) & 0x1000) >> 12
}

// APB_SARADC.FILTER_CTRL0: digital saradc configure register
func (o *APB_SARADC_Type) SetFILTER_CTRL0_APB_SARADC_FILTER_CHANNEL1(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL0.Reg, volatile.LoadUint32(&o.FILTER_CTRL0.Reg)&^(0x3c0000)|value<<18)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL0_APB_SARADC_FILTER_CHANNEL1() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL0.Reg) & 0x3c0000) >> 18
}
func (o *APB_SARADC_Type) SetFILTER_CTRL0_APB_SARADC_FILTER_CHANNEL0(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL0.Reg, volatile.LoadUint32(&o.FILTER_CTRL0.Reg)&^(0x3c00000)|value<<22)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL0_APB_SARADC_FILTER_CHANNEL0() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL0.Reg) & 0x3c00000) >> 22
}
func (o *APB_SARADC_Type) SetFILTER_CTRL0_APB_SARADC_FILTER_RESET(value uint32) {
	volatile.StoreUint32(&o.FILTER_CTRL0.Reg, volatile.LoadUint32(&o.FILTER_CTRL0.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetFILTER_CTRL0_APB_SARADC_FILTER_RESET() uint32 {
	return (volatile.LoadUint32(&o.FILTER_CTRL0.Reg) & 0x80000000) >> 31
}

// APB_SARADC.SAR1DATA_STATUS: digital saradc configure register
func (o *APB_SARADC_Type) SetSAR1DATA_STATUS_APB_SARADC1_DATA(value uint32) {
	volatile.StoreUint32(&o.SAR1DATA_STATUS.Reg, volatile.LoadUint32(&o.SAR1DATA_STATUS.Reg)&^(0x1ffff)|value)
}
func (o *APB_SARADC_Type) GetSAR1DATA_STATUS_APB_SARADC1_DATA() uint32 {
	return volatile.LoadUint32(&o.SAR1DATA_STATUS.Reg) & 0x1ffff
}

// APB_SARADC.SAR2DATA_STATUS: digital saradc configure register
func (o *APB_SARADC_Type) SetSAR2DATA_STATUS_APB_SARADC2_DATA(value uint32) {
	volatile.StoreUint32(&o.SAR2DATA_STATUS.Reg, volatile.LoadUint32(&o.SAR2DATA_STATUS.Reg)&^(0x1ffff)|value)
}
func (o *APB_SARADC_Type) GetSAR2DATA_STATUS_APB_SARADC2_DATA() uint32 {
	return volatile.LoadUint32(&o.SAR2DATA_STATUS.Reg) & 0x1ffff
}

// APB_SARADC.THRES0_CTRL: digital saradc configure register
func (o *APB_SARADC_Type) SetTHRES0_CTRL_APB_SARADC_THRES0_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.THRES0_CTRL.Reg, volatile.LoadUint32(&o.THRES0_CTRL.Reg)&^(0xf)|value)
}
func (o *APB_SARADC_Type) GetTHRES0_CTRL_APB_SARADC_THRES0_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.THRES0_CTRL.Reg) & 0xf
}
func (o *APB_SARADC_Type) SetTHRES0_CTRL_APB_SARADC_THRES0_HIGH(value uint32) {
	volatile.StoreUint32(&o.THRES0_CTRL.Reg, volatile.LoadUint32(&o.THRES0_CTRL.Reg)&^(0x3ffe0)|value<<5)
}
func (o *APB_SARADC_Type) GetTHRES0_CTRL_APB_SARADC_THRES0_HIGH() uint32 {
	return (volatile.LoadUint32(&o.THRES0_CTRL.Reg) & 0x3ffe0) >> 5
}
func (o *APB_SARADC_Type) SetTHRES0_CTRL_APB_SARADC_THRES0_LOW(value uint32) {
	volatile.StoreUint32(&o.THRES0_CTRL.Reg, volatile.LoadUint32(&o.THRES0_CTRL.Reg)&^(0x7ffc0000)|value<<18)
}
func (o *APB_SARADC_Type) GetTHRES0_CTRL_APB_SARADC_THRES0_LOW() uint32 {
	return (volatile.LoadUint32(&o.THRES0_CTRL.Reg) & 0x7ffc0000) >> 18
}

// APB_SARADC.THRES1_CTRL: digital saradc configure register
func (o *APB_SARADC_Type) SetTHRES1_CTRL_APB_SARADC_THRES1_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.THRES1_CTRL.Reg, volatile.LoadUint32(&o.THRES1_CTRL.Reg)&^(0xf)|value)
}
func (o *APB_SARADC_Type) GetTHRES1_CTRL_APB_SARADC_THRES1_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.THRES1_CTRL.Reg) & 0xf
}
func (o *APB_SARADC_Type) SetTHRES1_CTRL_APB_SARADC_THRES1_HIGH(value uint32) {
	volatile.StoreUint32(&o.THRES1_CTRL.Reg, volatile.LoadUint32(&o.THRES1_CTRL.Reg)&^(0x3ffe0)|value<<5)
}
func (o *APB_SARADC_Type) GetTHRES1_CTRL_APB_SARADC_THRES1_HIGH() uint32 {
	return (volatile.LoadUint32(&o.THRES1_CTRL.Reg) & 0x3ffe0) >> 5
}
func (o *APB_SARADC_Type) SetTHRES1_CTRL_APB_SARADC_THRES1_LOW(value uint32) {
	volatile.StoreUint32(&o.THRES1_CTRL.Reg, volatile.LoadUint32(&o.THRES1_CTRL.Reg)&^(0x7ffc0000)|value<<18)
}
func (o *APB_SARADC_Type) GetTHRES1_CTRL_APB_SARADC_THRES1_LOW() uint32 {
	return (volatile.LoadUint32(&o.THRES1_CTRL.Reg) & 0x7ffc0000) >> 18
}

// APB_SARADC.THRES_CTRL: digital saradc configure register
func (o *APB_SARADC_Type) SetTHRES_CTRL_APB_SARADC_THRES_ALL_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_APB_SARADC_THRES_ALL_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_APB_SARADC_THRES1_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_APB_SARADC_THRES1_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetTHRES_CTRL_APB_SARADC_THRES0_EN(value uint32) {
	volatile.StoreUint32(&o.THRES_CTRL.Reg, volatile.LoadUint32(&o.THRES_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetTHRES_CTRL_APB_SARADC_THRES0_EN() uint32 {
	return (volatile.LoadUint32(&o.THRES_CTRL.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_ENA: digital saradc int register
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC_TSENS_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2000000)|value<<25)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC_TSENS_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2000000) >> 25
}
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC_THRES1_LOW_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC_THRES1_LOW_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC_THRES0_LOW_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC_THRES0_LOW_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC_THRES1_HIGH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC_THRES1_HIGH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC_THRES0_HIGH_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC_THRES0_HIGH_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC2_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC2_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_ENA_APB_SARADC1_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_ENA_APB_SARADC1_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_RAW: digital saradc int register
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC_TSENS_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2000000)|value<<25)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC_TSENS_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2000000) >> 25
}
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC_THRES1_LOW_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC_THRES1_LOW_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC_THRES0_LOW_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC_THRES0_LOW_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC_THRES1_HIGH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC_THRES1_HIGH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC_THRES0_HIGH_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC_THRES0_HIGH_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC2_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC2_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_RAW_APB_SARADC1_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_RAW_APB_SARADC1_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_ST: digital saradc int register
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC_TSENS_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2000000)|value<<25)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC_TSENS_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2000000) >> 25
}
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC_THRES1_LOW_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC_THRES1_LOW_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC_THRES0_LOW_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC_THRES0_LOW_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC_THRES1_HIGH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC_THRES1_HIGH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC_THRES0_HIGH_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC_THRES0_HIGH_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC2_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC2_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_ST_APB_SARADC1_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_ST_APB_SARADC1_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x80000000) >> 31
}

// APB_SARADC.INT_CLR: digital saradc int register
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC_TSENS_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2000000)|value<<25)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC_TSENS_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2000000) >> 25
}
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC_THRES1_LOW_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x4000000)|value<<26)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC_THRES1_LOW_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x4000000) >> 26
}
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC_THRES0_LOW_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x8000000)|value<<27)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC_THRES0_LOW_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x8000000) >> 27
}
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC_THRES1_HIGH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x10000000)|value<<28)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC_THRES1_HIGH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x10000000) >> 28
}
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC_THRES0_HIGH_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x20000000)|value<<29)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC_THRES0_HIGH_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x20000000) >> 29
}
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC2_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC2_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetINT_CLR_APB_SARADC1_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetINT_CLR_APB_SARADC1_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x80000000) >> 31
}

// APB_SARADC.DMA_CONF: digital saradc configure register
func (o *APB_SARADC_Type) SetDMA_CONF_APB_ADC_EOF_NUM(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0xffff)|value)
}
func (o *APB_SARADC_Type) GetDMA_CONF_APB_ADC_EOF_NUM() uint32 {
	return volatile.LoadUint32(&o.DMA_CONF.Reg) & 0xffff
}
func (o *APB_SARADC_Type) SetDMA_CONF_APB_ADC_RESET_FSM(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x40000000)|value<<30)
}
func (o *APB_SARADC_Type) GetDMA_CONF_APB_ADC_RESET_FSM() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x40000000) >> 30
}
func (o *APB_SARADC_Type) SetDMA_CONF_APB_ADC_TRANS(value uint32) {
	volatile.StoreUint32(&o.DMA_CONF.Reg, volatile.LoadUint32(&o.DMA_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *APB_SARADC_Type) GetDMA_CONF_APB_ADC_TRANS() uint32 {
	return (volatile.LoadUint32(&o.DMA_CONF.Reg) & 0x80000000) >> 31
}

// APB_SARADC.CLKM_CONF: digital saradc configure register
func (o *APB_SARADC_Type) SetCLKM_CONF_CLKM_DIV_NUM(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0xff)|value)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLKM_DIV_NUM() uint32 {
	return volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0xff
}
func (o *APB_SARADC_Type) SetCLKM_CONF_CLKM_DIV_B(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x3f00)|value<<8)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLKM_DIV_B() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x3f00) >> 8
}
func (o *APB_SARADC_Type) SetCLKM_CONF_CLKM_DIV_A(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0xfc000)|value<<14)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLKM_DIV_A() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0xfc000) >> 14
}
func (o *APB_SARADC_Type) SetCLKM_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x100000) >> 20
}
func (o *APB_SARADC_Type) SetCLKM_CONF_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.CLKM_CONF.Reg, volatile.LoadUint32(&o.CLKM_CONF.Reg)&^(0x600000)|value<<21)
}
func (o *APB_SARADC_Type) GetCLKM_CONF_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.CLKM_CONF.Reg) & 0x600000) >> 21
}

// APB_SARADC.APB_TSENS_CTRL: digital tsens configure register
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL_TSENS_OUT(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg)&^(0xff)|value)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL_TSENS_OUT() uint32 {
	return volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg) & 0xff
}
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL_TSENS_IN_INV(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL_TSENS_IN_INV() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg) & 0x2000) >> 13
}
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL_TSENS_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg)&^(0x3fc000)|value<<14)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL_TSENS_CLK_DIV() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg) & 0x3fc000) >> 14
}
func (o *APB_SARADC_Type) SetAPB_TSENS_CTRL_TSENS_PU(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_CTRL.Reg, volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_CTRL_TSENS_PU() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_CTRL.Reg) & 0x400000) >> 22
}

// APB_SARADC.TSENS_CTRL2: digital tsens configure register
func (o *APB_SARADC_Type) SetTSENS_CTRL2_TSENS_XPD_WAIT(value uint32) {
	volatile.StoreUint32(&o.TSENS_CTRL2.Reg, volatile.LoadUint32(&o.TSENS_CTRL2.Reg)&^(0xfff)|value)
}
func (o *APB_SARADC_Type) GetTSENS_CTRL2_TSENS_XPD_WAIT() uint32 {
	return volatile.LoadUint32(&o.TSENS_CTRL2.Reg) & 0xfff
}
func (o *APB_SARADC_Type) SetTSENS_CTRL2_TSENS_XPD_FORCE(value uint32) {
	volatile.StoreUint32(&o.TSENS_CTRL2.Reg, volatile.LoadUint32(&o.TSENS_CTRL2.Reg)&^(0x3000)|value<<12)
}
func (o *APB_SARADC_Type) GetTSENS_CTRL2_TSENS_XPD_FORCE() uint32 {
	return (volatile.LoadUint32(&o.TSENS_CTRL2.Reg) & 0x3000) >> 12
}
func (o *APB_SARADC_Type) SetTSENS_CTRL2_TSENS_CLK_INV(value uint32) {
	volatile.StoreUint32(&o.TSENS_CTRL2.Reg, volatile.LoadUint32(&o.TSENS_CTRL2.Reg)&^(0x4000)|value<<14)
}
func (o *APB_SARADC_Type) GetTSENS_CTRL2_TSENS_CLK_INV() uint32 {
	return (volatile.LoadUint32(&o.TSENS_CTRL2.Reg) & 0x4000) >> 14
}
func (o *APB_SARADC_Type) SetTSENS_CTRL2_TSENS_CLK_SEL(value uint32) {
	volatile.StoreUint32(&o.TSENS_CTRL2.Reg, volatile.LoadUint32(&o.TSENS_CTRL2.Reg)&^(0x8000)|value<<15)
}
func (o *APB_SARADC_Type) GetTSENS_CTRL2_TSENS_CLK_SEL() uint32 {
	return (volatile.LoadUint32(&o.TSENS_CTRL2.Reg) & 0x8000) >> 15
}

// APB_SARADC.CALI: digital saradc configure register
func (o *APB_SARADC_Type) SetCALI_APB_SARADC_CALI_CFG(value uint32) {
	volatile.StoreUint32(&o.CALI.Reg, volatile.LoadUint32(&o.CALI.Reg)&^(0x1ffff)|value)
}
func (o *APB_SARADC_Type) GetCALI_APB_SARADC_CALI_CFG() uint32 {
	return volatile.LoadUint32(&o.CALI.Reg) & 0x1ffff
}

// APB_SARADC.APB_TSENS_WAKE: digital tsens configure register
func (o *APB_SARADC_Type) SetAPB_TSENS_WAKE_WAKEUP_TH_LOW(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_WAKE.Reg, volatile.LoadUint32(&o.APB_TSENS_WAKE.Reg)&^(0xff)|value)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_WAKE_WAKEUP_TH_LOW() uint32 {
	return volatile.LoadUint32(&o.APB_TSENS_WAKE.Reg) & 0xff
}
func (o *APB_SARADC_Type) SetAPB_TSENS_WAKE_WAKEUP_TH_HIGH(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_WAKE.Reg, volatile.LoadUint32(&o.APB_TSENS_WAKE.Reg)&^(0xff00)|value<<8)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_WAKE_WAKEUP_TH_HIGH() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_WAKE.Reg) & 0xff00) >> 8
}
func (o *APB_SARADC_Type) SetAPB_TSENS_WAKE_WAKEUP_OVER_UPPER_TH(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_WAKE.Reg, volatile.LoadUint32(&o.APB_TSENS_WAKE.Reg)&^(0x10000)|value<<16)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_WAKE_WAKEUP_OVER_UPPER_TH() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_WAKE.Reg) & 0x10000) >> 16
}
func (o *APB_SARADC_Type) SetAPB_TSENS_WAKE_WAKEUP_MODE(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_WAKE.Reg, volatile.LoadUint32(&o.APB_TSENS_WAKE.Reg)&^(0x20000)|value<<17)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_WAKE_WAKEUP_MODE() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_WAKE.Reg) & 0x20000) >> 17
}
func (o *APB_SARADC_Type) SetAPB_TSENS_WAKE_WAKEUP_EN(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_WAKE.Reg, volatile.LoadUint32(&o.APB_TSENS_WAKE.Reg)&^(0x40000)|value<<18)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_WAKE_WAKEUP_EN() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_WAKE.Reg) & 0x40000) >> 18
}

// APB_SARADC.APB_TSENS_SAMPLE: digital tsens configure register
func (o *APB_SARADC_Type) SetAPB_TSENS_SAMPLE_TSENS_SAMPLE_RATE(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_SAMPLE.Reg, volatile.LoadUint32(&o.APB_TSENS_SAMPLE.Reg)&^(0xffff)|value)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_SAMPLE_TSENS_SAMPLE_RATE() uint32 {
	return volatile.LoadUint32(&o.APB_TSENS_SAMPLE.Reg) & 0xffff
}
func (o *APB_SARADC_Type) SetAPB_TSENS_SAMPLE_TSENS_SAMPLE_EN(value uint32) {
	volatile.StoreUint32(&o.APB_TSENS_SAMPLE.Reg, volatile.LoadUint32(&o.APB_TSENS_SAMPLE.Reg)&^(0x10000)|value<<16)
}
func (o *APB_SARADC_Type) GetAPB_TSENS_SAMPLE_TSENS_SAMPLE_EN() uint32 {
	return (volatile.LoadUint32(&o.APB_TSENS_SAMPLE.Reg) & 0x10000) >> 16
}

// APB_SARADC.CTRL_DATE: version
func (o *APB_SARADC_Type) SetCTRL_DATE(value uint32) {
	volatile.StoreUint32(&o.CTRL_DATE.Reg, value)
}
func (o *APB_SARADC_Type) GetCTRL_DATE() uint32 {
	return volatile.LoadUint32(&o.CTRL_DATE.Reg)
}

// Debug Assist
type ASSIST_DEBUG_Type struct {
	CORE_0_MONTR_ENA                       volatile.Register32 // 0x0
	CORE_0_INTR_RAW                        volatile.Register32 // 0x4
	CORE_0_INTR_ENA                        volatile.Register32 // 0x8
	CORE_0_INTR_CLR                        volatile.Register32 // 0xC
	CORE_0_AREA_DRAM0_0_MIN                volatile.Register32 // 0x10
	CORE_0_AREA_DRAM0_0_MAX                volatile.Register32 // 0x14
	CORE_0_AREA_DRAM0_1_MIN                volatile.Register32 // 0x18
	CORE_0_AREA_DRAM0_1_MAX                volatile.Register32 // 0x1C
	CORE_0_AREA_PIF_0_MIN                  volatile.Register32 // 0x20
	CORE_0_AREA_PIF_0_MAX                  volatile.Register32 // 0x24
	CORE_0_AREA_PIF_1_MIN                  volatile.Register32 // 0x28
	CORE_0_AREA_PIF_1_MAX                  volatile.Register32 // 0x2C
	CORE_0_AREA_PC                         volatile.Register32 // 0x30
	CORE_0_AREA_SP                         volatile.Register32 // 0x34
	CORE_0_SP_MIN                          volatile.Register32 // 0x38
	CORE_0_SP_MAX                          volatile.Register32 // 0x3C
	CORE_0_SP_PC                           volatile.Register32 // 0x40
	CORE_0_RCD_EN                          volatile.Register32 // 0x44
	CORE_0_RCD_PDEBUGPC                    volatile.Register32 // 0x48
	CORE_0_RCD_PDEBUGSP                    volatile.Register32 // 0x4C
	CORE_0_IRAM0_EXCEPTION_MONITOR_0       volatile.Register32 // 0x50
	CORE_0_IRAM0_EXCEPTION_MONITOR_1       volatile.Register32 // 0x54
	CORE_0_DRAM0_EXCEPTION_MONITOR_0       volatile.Register32 // 0x58
	CORE_0_DRAM0_EXCEPTION_MONITOR_1       volatile.Register32 // 0x5C
	CORE_0_DRAM0_EXCEPTION_MONITOR_2       volatile.Register32 // 0x60
	CORE_0_DRAM0_EXCEPTION_MONITOR_3       volatile.Register32 // 0x64
	CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0 volatile.Register32 // 0x68
	CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1 volatile.Register32 // 0x6C
	C0RE_0_LASTPC_BEFORE_EXCEPTION         volatile.Register32 // 0x70
	C0RE_0_DEBUG_MODE                      volatile.Register32 // 0x74
	CLOCK_GATE                             volatile.Register32 // 0x78
	_                                      [896]byte
	DATE                                   volatile.Register32 // 0x3FC
}

// ASSIST_DEBUG.CORE_0_MONTR_ENA: core0 monitor enable configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_0_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_0_RD_ENA() uint32 {
	return volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_0_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_0_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_1_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_1_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_1_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_DRAM0_1_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_0_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_0_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_0_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_0_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_1_RD_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_1_RD_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_1_WR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_MONTR_ENA_CORE_0_AREA_PIF_1_WR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_MONTR_ENA_CORE_0_SP_SPILL_MIN_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_MONTR_ENA_CORE_0_SP_SPILL_MIN_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_MONTR_ENA_CORE_0_SP_SPILL_MAX_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_MONTR_ENA_CORE_0_SP_SPILL_MAX_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_MONTR_ENA_CORE_0_IRAM0_EXCEPTION_MONITOR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_MONTR_ENA_CORE_0_IRAM0_EXCEPTION_MONITOR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_MONTR_ENA_CORE_0_DRAM0_EXCEPTION_MONITOR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_MONTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_MONTR_ENA_CORE_0_DRAM0_EXCEPTION_MONITOR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_MONTR_ENA.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_0_INTR_RAW: core0 monitor interrupt status register
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_RD_RAW() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_0_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_DRAM0_1_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_0_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_RD_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_RD_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_WR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_AREA_PIF_1_WR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MIN_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MIN_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MAX_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_SP_SPILL_MAX_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_IRAM0_EXCEPTION_MONITOR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_IRAM0_EXCEPTION_MONITOR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_RAW_CORE_0_DRAM0_EXCEPTION_MONITOR_RAW(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_RAW.Reg, volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_RAW_CORE_0_DRAM0_EXCEPTION_MONITOR_RAW() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_RAW.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_0_INTR_ENA: core0 monitor interrupt enable register
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_RD_INTR_ENA() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_0_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_RD_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_DRAM0_1_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_RD_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_0_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_RD_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_RD_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_WR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_AREA_PIF_1_WR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MIN_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MIN_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MAX_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_SP_SPILL_MAX_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_IRAM0_EXCEPTION_MONITOR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_IRAM0_EXCEPTION_MONITOR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_ENA_CORE_0_DRAM0_EXCEPTION_MONITOR_INTR_ENA(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_ENA.Reg, volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_ENA_CORE_0_DRAM0_EXCEPTION_MONITOR_INTR_ENA() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_ENA.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_0_INTR_CLR: core0 monitor interrupt clr register
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_RD_CLR() uint32 {
	return volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_0_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x2) >> 1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x4)|value<<2)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x4) >> 2
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x8)|value<<3)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_DRAM0_1_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x8) >> 3
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x10)|value<<4)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x10) >> 4
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x20)|value<<5)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_0_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x20) >> 5
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_RD_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x40)|value<<6)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_RD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x40) >> 6
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_WR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x80)|value<<7)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_AREA_PIF_1_WR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x80) >> 7
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MIN_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x100)|value<<8)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MIN_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x100) >> 8
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MAX_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x200)|value<<9)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_SP_SPILL_MAX_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x200) >> 9
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_IRAM0_EXCEPTION_MONITOR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x400)|value<<10)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_IRAM0_EXCEPTION_MONITOR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x400) >> 10
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_INTR_CLR_CORE_0_DRAM0_EXCEPTION_MONITOR_CLR(value uint32) {
	volatile.StoreUint32(&o.CORE_0_INTR_CLR.Reg, volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg)&^(0x800)|value<<11)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_INTR_CLR_CORE_0_DRAM0_EXCEPTION_MONITOR_CLR() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_INTR_CLR.Reg) & 0x800) >> 11
}

// ASSIST_DEBUG.CORE_0_AREA_DRAM0_0_MIN: core0 dram0 region0 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_DRAM0_0_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_0_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_DRAM0_0_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_0_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_DRAM0_0_MAX: core0 dram0 region0 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_DRAM0_0_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_0_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_DRAM0_0_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_0_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_DRAM0_1_MIN: core0 dram0 region1 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_DRAM0_1_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_1_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_DRAM0_1_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_1_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_DRAM0_1_MAX: core0 dram0 region1 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_DRAM0_1_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_DRAM0_1_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_DRAM0_1_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_DRAM0_1_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_PIF_0_MIN: core0 PIF region0 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_PIF_0_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_0_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_PIF_0_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_0_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_PIF_0_MAX: core0 PIF region0 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_PIF_0_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_0_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_PIF_0_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_0_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_PIF_1_MIN: core0 PIF region1 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_PIF_1_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_1_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_PIF_1_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_1_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_PIF_1_MAX: core0 PIF region1 addr configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_PIF_1_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PIF_1_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_PIF_1_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PIF_1_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_PC: core0 area pc status register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_PC(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_PC.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_PC() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_PC.Reg)
}

// ASSIST_DEBUG.CORE_0_AREA_SP: core0 area sp status register
func (o *ASSIST_DEBUG_Type) SetCORE_0_AREA_SP(value uint32) {
	volatile.StoreUint32(&o.CORE_0_AREA_SP.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_AREA_SP() uint32 {
	return volatile.LoadUint32(&o.CORE_0_AREA_SP.Reg)
}

// ASSIST_DEBUG.CORE_0_SP_MIN: stack min value
func (o *ASSIST_DEBUG_Type) SetCORE_0_SP_MIN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_MIN.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_SP_MIN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_MIN.Reg)
}

// ASSIST_DEBUG.CORE_0_SP_MAX: stack max value
func (o *ASSIST_DEBUG_Type) SetCORE_0_SP_MAX(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_MAX.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_SP_MAX() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_MAX.Reg)
}

// ASSIST_DEBUG.CORE_0_SP_PC: stack monitor pc status register
func (o *ASSIST_DEBUG_Type) SetCORE_0_SP_PC(value uint32) {
	volatile.StoreUint32(&o.CORE_0_SP_PC.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_SP_PC() uint32 {
	return volatile.LoadUint32(&o.CORE_0_SP_PC.Reg)
}

// ASSIST_DEBUG.CORE_0_RCD_EN: record enable configuration register
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_EN_CORE_0_RCD_RECORDEN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_EN.Reg, volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_EN_CORE_0_RCD_RECORDEN() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_EN_CORE_0_RCD_PDEBUGEN(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_EN.Reg, volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_EN_CORE_0_RCD_PDEBUGEN() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_RCD_EN.Reg) & 0x2) >> 1
}

// ASSIST_DEBUG.CORE_0_RCD_PDEBUGPC: record status regsiter
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_PDEBUGPC(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGPC.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_PDEBUGPC() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGPC.Reg)
}

// ASSIST_DEBUG.CORE_0_RCD_PDEBUGSP: record status regsiter
func (o *ASSIST_DEBUG_Type) SetCORE_0_RCD_PDEBUGSP(value uint32) {
	volatile.StoreUint32(&o.CORE_0_RCD_PDEBUGSP.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_RCD_PDEBUGSP() uint32 {
	return volatile.LoadUint32(&o.CORE_0_RCD_PDEBUGSP.Reg)
}

// ASSIST_DEBUG.CORE_0_IRAM0_EXCEPTION_MONITOR_0: exception monitor status register0
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_ADDR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_ADDR_0() uint32 {
	return volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0xffffff
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_WR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x1000000)|value<<24)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_WR_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0x1000000) >> 24
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_LOADSTORE_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x2000000)|value<<25)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_0_CORE_0_IRAM0_RECORDING_LOADSTORE_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_0.Reg) & 0x2000000) >> 25
}

// ASSIST_DEBUG.CORE_0_IRAM0_EXCEPTION_MONITOR_1: exception monitor status register1
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_ADDR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_ADDR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0xffffff
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_WR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0x1000000)|value<<24)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_WR_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0x1000000) >> 24
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_LOADSTORE_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg)&^(0x2000000)|value<<25)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_IRAM0_EXCEPTION_MONITOR_1_CORE_0_IRAM0_RECORDING_LOADSTORE_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_IRAM0_EXCEPTION_MONITOR_1.Reg) & 0x2000000) >> 25
}

// ASSIST_DEBUG.CORE_0_DRAM0_EXCEPTION_MONITOR_0: exception monitor status register2
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_ADDR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_ADDR_0() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0xffffff
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_WR_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x1000000)|value<<24)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_WR_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0x1000000) >> 24
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_BYTEEN_0(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0x1e000000)|value<<25)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_0_CORE_0_DRAM0_RECORDING_BYTEEN_0() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0x1e000000) >> 25
}

// ASSIST_DEBUG.CORE_0_DRAM0_EXCEPTION_MONITOR_1: exception monitor status register3
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_1.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_1.Reg)
}

// ASSIST_DEBUG.CORE_0_DRAM0_EXCEPTION_MONITOR_2: exception monitor status register4
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_2_CORE_0_DRAM0_RECORDING_ADDR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg)&^(0xffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_2_CORE_0_DRAM0_RECORDING_ADDR_1() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg) & 0xffffff
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_2_CORE_0_DRAM0_RECORDING_WR_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg)&^(0x1000000)|value<<24)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_2_CORE_0_DRAM0_RECORDING_WR_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg) & 0x1000000) >> 24
}
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_2_CORE_0_DRAM0_RECORDING_BYTEEN_1(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg, volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg)&^(0x1e000000)|value<<25)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_2_CORE_0_DRAM0_RECORDING_BYTEEN_1() uint32 {
	return (volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_2.Reg) & 0x1e000000) >> 25
}

// ASSIST_DEBUG.CORE_0_DRAM0_EXCEPTION_MONITOR_3: exception monitor status register5
func (o *ASSIST_DEBUG_Type) SetCORE_0_DRAM0_EXCEPTION_MONITOR_3(value uint32) {
	volatile.StoreUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_0_DRAM0_EXCEPTION_MONITOR_3() uint32 {
	return volatile.LoadUint32(&o.CORE_0_DRAM0_EXCEPTION_MONITOR_3.Reg)
}

// ASSIST_DEBUG.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0: exception monitor status register6
func (o *ASSIST_DEBUG_Type) SetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_0(value uint32) {
	volatile.StoreUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0.Reg, volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0.Reg)&^(0xfffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_0() uint32 {
	return volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_0.Reg) & 0xfffff
}

// ASSIST_DEBUG.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1: exception monitor status register7
func (o *ASSIST_DEBUG_Type) SetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_1(value uint32) {
	volatile.StoreUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1.Reg, volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1.Reg)&^(0xfffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetCORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1_CORE_X_IRAM0_DRAM0_LIMIT_CYCLE_1() uint32 {
	return volatile.LoadUint32(&o.CORE_X_IRAM0_DRAM0_EXCEPTION_MONITOR_1.Reg) & 0xfffff
}

// ASSIST_DEBUG.C0RE_0_LASTPC_BEFORE_EXCEPTION: cpu status register
func (o *ASSIST_DEBUG_Type) SetC0RE_0_LASTPC_BEFORE_EXCEPTION(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_LASTPC_BEFORE_EXCEPTION.Reg, value)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_LASTPC_BEFORE_EXCEPTION() uint32 {
	return volatile.LoadUint32(&o.C0RE_0_LASTPC_BEFORE_EXCEPTION.Reg)
}

// ASSIST_DEBUG.C0RE_0_DEBUG_MODE: cpu status register
func (o *ASSIST_DEBUG_Type) SetC0RE_0_DEBUG_MODE_CORE_0_DEBUG_MODE(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_DEBUG_MODE.Reg, volatile.LoadUint32(&o.C0RE_0_DEBUG_MODE.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_DEBUG_MODE_CORE_0_DEBUG_MODE() uint32 {
	return volatile.LoadUint32(&o.C0RE_0_DEBUG_MODE.Reg) & 0x1
}
func (o *ASSIST_DEBUG_Type) SetC0RE_0_DEBUG_MODE_CORE_0_DEBUG_MODULE_ACTIVE(value uint32) {
	volatile.StoreUint32(&o.C0RE_0_DEBUG_MODE.Reg, volatile.LoadUint32(&o.C0RE_0_DEBUG_MODE.Reg)&^(0x2)|value<<1)
}
func (o *ASSIST_DEBUG_Type) GetC0RE_0_DEBUG_MODE_CORE_0_DEBUG_MODULE_ACTIVE() uint32 {
	return (volatile.LoadUint32(&o.C0RE_0_DEBUG_MODE.Reg) & 0x2) >> 1
}

// ASSIST_DEBUG.CLOCK_GATE: clock register
func (o *ASSIST_DEBUG_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *ASSIST_DEBUG_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// ASSIST_DEBUG.DATE: version register
func (o *ASSIST_DEBUG_Type) SetDATE_ASSIST_DEBUG_DATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *ASSIST_DEBUG_Type) GetDATE_ASSIST_DEBUG_DATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// Atomic Locker
type ATOMIC_Type struct {
	ADDR_LOCK   volatile.Register32 // 0x0
	LR_ADDR     volatile.Register32 // 0x4
	LR_VALUE    volatile.Register32 // 0x8
	LOCK_STATUS volatile.Register32 // 0xC
	COUNTER     volatile.Register32 // 0x10
}

// ATOMIC.ADDR_LOCK: hardware lock regsiter
func (o *ATOMIC_Type) SetADDR_LOCK_LOCK(value uint32) {
	volatile.StoreUint32(&o.ADDR_LOCK.Reg, volatile.LoadUint32(&o.ADDR_LOCK.Reg)&^(0x3)|value)
}
func (o *ATOMIC_Type) GetADDR_LOCK_LOCK() uint32 {
	return volatile.LoadUint32(&o.ADDR_LOCK.Reg) & 0x3
}

// ATOMIC.LR_ADDR: gloable lr address regsiter
func (o *ATOMIC_Type) SetLR_ADDR(value uint32) {
	volatile.StoreUint32(&o.LR_ADDR.Reg, value)
}
func (o *ATOMIC_Type) GetLR_ADDR() uint32 {
	return volatile.LoadUint32(&o.LR_ADDR.Reg)
}

// ATOMIC.LR_VALUE: gloable lr value regsiter
func (o *ATOMIC_Type) SetLR_VALUE(value uint32) {
	volatile.StoreUint32(&o.LR_VALUE.Reg, value)
}
func (o *ATOMIC_Type) GetLR_VALUE() uint32 {
	return volatile.LoadUint32(&o.LR_VALUE.Reg)
}

// ATOMIC.LOCK_STATUS: lock status regsiter
func (o *ATOMIC_Type) SetLOCK_STATUS(value uint32) {
	volatile.StoreUint32(&o.LOCK_STATUS.Reg, volatile.LoadUint32(&o.LOCK_STATUS.Reg)&^(0x3)|value)
}
func (o *ATOMIC_Type) GetLOCK_STATUS() uint32 {
	return volatile.LoadUint32(&o.LOCK_STATUS.Reg) & 0x3
}

// ATOMIC.COUNTER: wait counter register
func (o *ATOMIC_Type) SetCOUNTER_WAIT_COUNTER(value uint32) {
	volatile.StoreUint32(&o.COUNTER.Reg, volatile.LoadUint32(&o.COUNTER.Reg)&^(0xffff)|value)
}
func (o *ATOMIC_Type) GetCOUNTER_WAIT_COUNTER() uint32 {
	return volatile.LoadUint32(&o.COUNTER.Reg) & 0xffff
}

// DMA (Direct Memory Access) Controller
type DMA_Type struct {
	IN_INT_RAW_CH0           volatile.Register32 // 0x0
	IN_INT_ST_CH0            volatile.Register32 // 0x4
	IN_INT_ENA_CH0           volatile.Register32 // 0x8
	IN_INT_CLR_CH0           volatile.Register32 // 0xC
	IN_INT_RAW_CH1           volatile.Register32 // 0x10
	IN_INT_ST_CH1            volatile.Register32 // 0x14
	IN_INT_ENA_CH1           volatile.Register32 // 0x18
	IN_INT_CLR_CH1           volatile.Register32 // 0x1C
	IN_INT_RAW_CH2           volatile.Register32 // 0x20
	IN_INT_ST_CH2            volatile.Register32 // 0x24
	IN_INT_ENA_CH2           volatile.Register32 // 0x28
	IN_INT_CLR_CH2           volatile.Register32 // 0x2C
	OUT_INT_RAW_CH0          volatile.Register32 // 0x30
	OUT_INT_ST_CH0           volatile.Register32 // 0x34
	OUT_INT_ENA_CH0          volatile.Register32 // 0x38
	OUT_INT_CLR_CH0          volatile.Register32 // 0x3C
	OUT_INT_RAW_CH1          volatile.Register32 // 0x40
	OUT_INT_ST_CH1           volatile.Register32 // 0x44
	OUT_INT_ENA_CH1          volatile.Register32 // 0x48
	OUT_INT_CLR_CH1          volatile.Register32 // 0x4C
	OUT_INT_RAW_CH2          volatile.Register32 // 0x50
	OUT_INT_ST_CH2           volatile.Register32 // 0x54
	OUT_INT_ENA_CH2          volatile.Register32 // 0x58
	OUT_INT_CLR_CH2          volatile.Register32 // 0x5C
	AHB_TEST                 volatile.Register32 // 0x60
	MISC_CONF                volatile.Register32 // 0x64
	DATE                     volatile.Register32 // 0x68
	_                        [4]byte
	IN_CONF0_CH0             volatile.Register32 // 0x70
	IN_CONF1_CH0             volatile.Register32 // 0x74
	INFIFO_STATUS_CH0        volatile.Register32 // 0x78
	IN_POP_CH0               volatile.Register32 // 0x7C
	IN_LINK_CH0              volatile.Register32 // 0x80
	IN_STATE_CH0             volatile.Register32 // 0x84
	IN_SUC_EOF_DES_ADDR_CH0  volatile.Register32 // 0x88
	IN_ERR_EOF_DES_ADDR_CH0  volatile.Register32 // 0x8C
	IN_DSCR_CH0              volatile.Register32 // 0x90
	IN_DSCR_BF0_CH0          volatile.Register32 // 0x94
	IN_DSCR_BF1_CH0          volatile.Register32 // 0x98
	IN_PRI_CH0               volatile.Register32 // 0x9C
	IN_PERI_SEL_CH0          volatile.Register32 // 0xA0
	_                        [48]byte
	OUT_CONF1_CH0            volatile.Register32 // 0xD4
	OUTFIFO_STATUS_CH0       volatile.Register32 // 0xD8
	OUT_PUSH_CH0             volatile.Register32 // 0xDC
	OUT_LINK_CH0             volatile.Register32 // 0xE0
	OUT_STATE_CH0            volatile.Register32 // 0xE4
	OUT_EOF_DES_ADDR_CH0     volatile.Register32 // 0xE8
	OUT_EOF_BFR_DES_ADDR_CH0 volatile.Register32 // 0xEC
	OUT_DSCR_CH0             volatile.Register32 // 0xF0
	OUT_DSCR_BF0_CH0         volatile.Register32 // 0xF4
	OUT_DSCR_BF1_CH0         volatile.Register32 // 0xF8
	OUT_PRI_CH0              volatile.Register32 // 0xFC
	OUT_PERI_SEL_CH0         volatile.Register32 // 0x100
	_                        [44]byte
	IN_CONF0_CH1             volatile.Register32 // 0x130
	IN_CONF1_CH1             volatile.Register32 // 0x134
	INFIFO_STATUS_CH1        volatile.Register32 // 0x138
	IN_POP_CH1               volatile.Register32 // 0x13C
	IN_LINK_CH1              volatile.Register32 // 0x140
	IN_STATE_CH1             volatile.Register32 // 0x144
	IN_SUC_EOF_DES_ADDR_CH1  volatile.Register32 // 0x148
	IN_ERR_EOF_DES_ADDR_CH1  volatile.Register32 // 0x14C
	IN_DSCR_CH1              volatile.Register32 // 0x150
	IN_DSCR_BF0_CH1          volatile.Register32 // 0x154
	IN_DSCR_BF1_CH1          volatile.Register32 // 0x158
	IN_PRI_CH1               volatile.Register32 // 0x15C
	IN_PERI_SEL_CH1          volatile.Register32 // 0x160
	_                        [44]byte
	OUT_CONF0_CH0            volatile.Register32 // 0x190
	OUT_CONF1_CH1            volatile.Register32 // 0x194
	OUTFIFO_STATUS_CH1       volatile.Register32 // 0x198
	OUT_PUSH_CH1             volatile.Register32 // 0x19C
	OUT_LINK_CH1             volatile.Register32 // 0x1A0
	OUT_STATE_CH1            volatile.Register32 // 0x1A4
	OUT_EOF_DES_ADDR_CH1     volatile.Register32 // 0x1A8
	OUT_EOF_BFR_DES_ADDR_CH1 volatile.Register32 // 0x1AC
	OUT_DSCR_CH1             volatile.Register32 // 0x1B0
	OUT_DSCR_BF0_CH1         volatile.Register32 // 0x1B4
	OUT_DSCR_BF1_CH1         volatile.Register32 // 0x1B8
	OUT_PRI_CH1              volatile.Register32 // 0x1BC
	OUT_PERI_SEL_CH1         volatile.Register32 // 0x1C0
	_                        [44]byte
	IN_CONF0_CH2             volatile.Register32 // 0x1F0
	IN_CONF1_CH2             volatile.Register32 // 0x1F4
	INFIFO_STATUS_CH2        volatile.Register32 // 0x1F8
	IN_POP_CH2               volatile.Register32 // 0x1FC
	IN_LINK_CH2              volatile.Register32 // 0x200
	IN_STATE_CH2             volatile.Register32 // 0x204
	IN_SUC_EOF_DES_ADDR_CH2  volatile.Register32 // 0x208
	IN_ERR_EOF_DES_ADDR_CH2  volatile.Register32 // 0x20C
	IN_DSCR_CH2              volatile.Register32 // 0x210
	IN_DSCR_BF0_CH2          volatile.Register32 // 0x214
	IN_DSCR_BF1_CH2          volatile.Register32 // 0x218
	IN_PRI_CH2               volatile.Register32 // 0x21C
	IN_PERI_SEL_CH2          volatile.Register32 // 0x220
	_                        [44]byte
	OUT_CONF0_CH1            volatile.Register32 // 0x250
	OUT_CONF1_CH2            volatile.Register32 // 0x254
	OUTFIFO_STATUS_CH2       volatile.Register32 // 0x258
	OUT_PUSH_CH2             volatile.Register32 // 0x25C
	OUT_LINK_CH2             volatile.Register32 // 0x260
	OUT_STATE_CH2            volatile.Register32 // 0x264
	OUT_EOF_DES_ADDR_CH2     volatile.Register32 // 0x268
	OUT_EOF_BFR_DES_ADDR_CH2 volatile.Register32 // 0x26C
	OUT_DSCR_CH2             volatile.Register32 // 0x270
	OUT_DSCR_BF0_CH2         volatile.Register32 // 0x274
	OUT_DSCR_BF1_CH2         volatile.Register32 // 0x278
	OUT_PRI_CH2              volatile.Register32 // 0x27C
	OUT_PERI_SEL_CH2         volatile.Register32 // 0x280
	_                        [140]byte
	OUT_CONF0_CH2            volatile.Register32 // 0x310
}

// DMA.IN_INT_RAW_CH0: Raw status interrupt of channel 0
func (o *DMA_Type) SetIN_INT_RAW_CH0_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_RAW_CH0_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_RAW_CH0_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_RAW_CH0_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_RAW_CH0_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_RAW_CH0_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_RAW_CH0_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_RAW_CH0_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH0.Reg) & 0x40) >> 6
}

// DMA.IN_INT_ST_CH0: Masked interrupt of channel 0
func (o *DMA_Type) SetIN_INT_ST_CH0_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ST_CH0_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ST_CH0_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ST_CH0_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ST_CH0_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ST_CH0_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ST_CH0_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ST_CH0_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH0.Reg) & 0x40) >> 6
}

// DMA.IN_INT_ENA_CH0: Interrupt enable bits of channel 0
func (o *DMA_Type) SetIN_INT_ENA_CH0_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ENA_CH0_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ENA_CH0_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ENA_CH0_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ENA_CH0_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ENA_CH0_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ENA_CH0_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ENA_CH0_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH0.Reg) & 0x40) >> 6
}

// DMA.IN_INT_CLR_CH0: Interrupt clear bits of channel 0
func (o *DMA_Type) SetIN_INT_CLR_CH0_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_CLR_CH0_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_CLR_CH0_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_CLR_CH0_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_CLR_CH0_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_CLR_CH0_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_CLR_CH0_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_CLR_CH0_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH0.Reg) & 0x40) >> 6
}

// DMA.IN_INT_RAW_CH1: Raw status interrupt of channel 0
func (o *DMA_Type) SetIN_INT_RAW_CH1_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_RAW_CH1_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_RAW_CH1_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_RAW_CH1_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_RAW_CH1_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_RAW_CH1_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_RAW_CH1_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_RAW_CH1_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH1.Reg) & 0x40) >> 6
}

// DMA.IN_INT_ST_CH1: Masked interrupt of channel 0
func (o *DMA_Type) SetIN_INT_ST_CH1_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ST_CH1_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ST_CH1_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ST_CH1_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ST_CH1_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ST_CH1_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ST_CH1_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ST_CH1_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH1.Reg) & 0x40) >> 6
}

// DMA.IN_INT_ENA_CH1: Interrupt enable bits of channel 0
func (o *DMA_Type) SetIN_INT_ENA_CH1_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ENA_CH1_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ENA_CH1_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ENA_CH1_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ENA_CH1_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ENA_CH1_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ENA_CH1_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ENA_CH1_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH1.Reg) & 0x40) >> 6
}

// DMA.IN_INT_CLR_CH1: Interrupt clear bits of channel 0
func (o *DMA_Type) SetIN_INT_CLR_CH1_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_CLR_CH1_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_CLR_CH1_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_CLR_CH1_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_CLR_CH1_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_CLR_CH1_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_CLR_CH1_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_CLR_CH1_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH1.Reg) & 0x40) >> 6
}

// DMA.IN_INT_RAW_CH2: Raw status interrupt of channel 0
func (o *DMA_Type) SetIN_INT_RAW_CH2_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_RAW_CH2_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_RAW_CH2_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_RAW_CH2_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_RAW_CH2_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_RAW_CH2_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_RAW_CH2_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_RAW_CH2_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_RAW_CH2.Reg) & 0x40) >> 6
}

// DMA.IN_INT_ST_CH2: Masked interrupt of channel 0
func (o *DMA_Type) SetIN_INT_ST_CH2_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ST_CH2_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ST_CH2_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ST_CH2_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ST_CH2_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ST_CH2_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ST_CH2_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ST_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ST_CH2_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ST_CH2.Reg) & 0x40) >> 6
}

// DMA.IN_INT_ENA_CH2: Interrupt enable bits of channel 0
func (o *DMA_Type) SetIN_INT_ENA_CH2_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_ENA_CH2_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_ENA_CH2_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_ENA_CH2_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_ENA_CH2_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_ENA_CH2_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_ENA_CH2_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_ENA_CH2_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_ENA_CH2.Reg) & 0x40) >> 6
}

// DMA.IN_INT_CLR_CH2: Interrupt clear bits of channel 0
func (o *DMA_Type) SetIN_INT_CLR_CH2_IN_DONE(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_IN_DONE() uint32 {
	return volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetIN_INT_CLR_CH2_IN_SUC_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_IN_SUC_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_INT_CLR_CH2_IN_ERR_EOF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_IN_ERR_EOF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_INT_CLR_CH2_IN_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_IN_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_INT_CLR_CH2_IN_DSCR_EMPTY(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_IN_DSCR_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_INT_CLR_CH2_INFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_INFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIN_INT_CLR_CH2_INFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.IN_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIN_INT_CLR_CH2_INFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.IN_INT_CLR_CH2.Reg) & 0x40) >> 6
}

// DMA.OUT_INT_RAW_CH0: Raw status interrupt of channel 0
func (o *DMA_Type) SetOUT_INT_RAW_CH0_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH0_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH0_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH0_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH0_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH0_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_RAW_CH0_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH0_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_RAW_CH0_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH0_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_RAW_CH0_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH0_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH0.Reg) & 0x20) >> 5
}

// DMA.OUT_INT_ST_CH0: Masked interrupt of channel 0
func (o *DMA_Type) SetOUT_INT_ST_CH0_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ST_CH0_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ST_CH0_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ST_CH0_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ST_CH0_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ST_CH0_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ST_CH0_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ST_CH0_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ST_CH0_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ST_CH0_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ST_CH0_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ST_CH0_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH0.Reg) & 0x20) >> 5
}

// DMA.OUT_INT_ENA_CH0: Interrupt enable bits of channel 0
func (o *DMA_Type) SetOUT_INT_ENA_CH0_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH0_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH0_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH0_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH0_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH0_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ENA_CH0_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH0_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ENA_CH0_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH0_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ENA_CH0_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH0_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH0.Reg) & 0x20) >> 5
}

// DMA.OUT_INT_CLR_CH0: Interrupt clear bits of channel 0
func (o *DMA_Type) SetOUT_INT_CLR_CH0_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH0_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH0_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH0_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH0_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH0_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_CLR_CH0_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH0_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_CLR_CH0_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH0_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_CLR_CH0_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH0.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH0_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH0.Reg) & 0x20) >> 5
}

// DMA.OUT_INT_RAW_CH1: Raw status interrupt of channel 0
func (o *DMA_Type) SetOUT_INT_RAW_CH1_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH1_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH1_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH1_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH1_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH1_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_RAW_CH1_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH1_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_RAW_CH1_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH1_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_RAW_CH1_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH1_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH1.Reg) & 0x20) >> 5
}

// DMA.OUT_INT_ST_CH1: Masked interrupt of channel 0
func (o *DMA_Type) SetOUT_INT_ST_CH1_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ST_CH1_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ST_CH1_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ST_CH1_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ST_CH1_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ST_CH1_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ST_CH1_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ST_CH1_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ST_CH1_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ST_CH1_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ST_CH1_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ST_CH1_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH1.Reg) & 0x20) >> 5
}

// DMA.OUT_INT_ENA_CH1: Interrupt enable bits of channel 0
func (o *DMA_Type) SetOUT_INT_ENA_CH1_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH1_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH1_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH1_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH1_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH1_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ENA_CH1_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH1_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ENA_CH1_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH1_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ENA_CH1_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH1_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH1.Reg) & 0x20) >> 5
}

// DMA.OUT_INT_CLR_CH1: Interrupt clear bits of channel 0
func (o *DMA_Type) SetOUT_INT_CLR_CH1_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH1_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH1_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH1_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH1_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH1_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_CLR_CH1_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH1_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_CLR_CH1_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH1_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_CLR_CH1_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH1.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH1_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH1.Reg) & 0x20) >> 5
}

// DMA.OUT_INT_RAW_CH2: Raw status interrupt of channel 0
func (o *DMA_Type) SetOUT_INT_RAW_CH2_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH2_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH2_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH2_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_RAW_CH2_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH2_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_RAW_CH2_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH2_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_RAW_CH2_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH2_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_RAW_CH2_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_RAW_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_RAW_CH2_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_RAW_CH2.Reg) & 0x20) >> 5
}

// DMA.OUT_INT_ST_CH2: Masked interrupt of channel 0
func (o *DMA_Type) SetOUT_INT_ST_CH2_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ST_CH2_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ST_CH2_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ST_CH2_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ST_CH2_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ST_CH2_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ST_CH2_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ST_CH2_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ST_CH2_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ST_CH2_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ST_CH2_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ST_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ST_CH2_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ST_CH2.Reg) & 0x20) >> 5
}

// DMA.OUT_INT_ENA_CH2: Interrupt enable bits of channel 0
func (o *DMA_Type) SetOUT_INT_ENA_CH2_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH2_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH2_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH2_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_ENA_CH2_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH2_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_ENA_CH2_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH2_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_ENA_CH2_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH2_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_ENA_CH2_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_ENA_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_ENA_CH2_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_ENA_CH2.Reg) & 0x20) >> 5
}

// DMA.OUT_INT_CLR_CH2: Interrupt clear bits of channel 0
func (o *DMA_Type) SetOUT_INT_CLR_CH2_OUT_DONE(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH2_OUT_DONE() uint32 {
	return volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH2_OUT_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH2_OUT_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_INT_CLR_CH2_OUT_DSCR_ERR(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH2_OUT_DSCR_ERR() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_INT_CLR_CH2_OUT_TOTAL_EOF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH2_OUT_TOTAL_EOF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_INT_CLR_CH2_OUTFIFO_OVF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH2_OUTFIFO_OVF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_INT_CLR_CH2_OUTFIFO_UDF(value uint32) {
	volatile.StoreUint32(&o.OUT_INT_CLR_CH2.Reg, volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_INT_CLR_CH2_OUTFIFO_UDF() uint32 {
	return (volatile.LoadUint32(&o.OUT_INT_CLR_CH2.Reg) & 0x20) >> 5
}

// DMA.AHB_TEST: reserved
func (o *DMA_Type) SetAHB_TEST_AHB_TESTMODE(value uint32) {
	volatile.StoreUint32(&o.AHB_TEST.Reg, volatile.LoadUint32(&o.AHB_TEST.Reg)&^(0x7)|value)
}
func (o *DMA_Type) GetAHB_TEST_AHB_TESTMODE() uint32 {
	return volatile.LoadUint32(&o.AHB_TEST.Reg) & 0x7
}
func (o *DMA_Type) SetAHB_TEST_AHB_TESTADDR(value uint32) {
	volatile.StoreUint32(&o.AHB_TEST.Reg, volatile.LoadUint32(&o.AHB_TEST.Reg)&^(0x30)|value<<4)
}
func (o *DMA_Type) GetAHB_TEST_AHB_TESTADDR() uint32 {
	return (volatile.LoadUint32(&o.AHB_TEST.Reg) & 0x30) >> 4
}

// DMA.MISC_CONF: MISC register
func (o *DMA_Type) SetMISC_CONF_AHBM_RST_INTER(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetMISC_CONF_AHBM_RST_INTER() uint32 {
	return volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x1
}
func (o *DMA_Type) SetMISC_CONF_ARB_PRI_DIS(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetMISC_CONF_ARB_PRI_DIS() uint32 {
	return (volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetMISC_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.MISC_CONF.Reg, volatile.LoadUint32(&o.MISC_CONF.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetMISC_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.MISC_CONF.Reg) & 0x8) >> 3
}

// DMA.DATE: Version control register
func (o *DMA_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, value)
}
func (o *DMA_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg)
}

// DMA.IN_CONF0_CH0: Configure 0 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF0_CH0_IN_RST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_CONF0_CH0_IN_RST() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetIN_CONF0_CH0_IN_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_CONF0_CH0_IN_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_CONF0_CH0_INDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_CONF0_CH0_INDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_CONF0_CH0_IN_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_CONF0_CH0_IN_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_CONF0_CH0_MEM_TRANS_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_CONF0_CH0_MEM_TRANS_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_CONF0_CH0_IN_ETM_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH0.Reg, volatile.LoadUint32(&o.IN_CONF0_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_CONF0_CH0_IN_ETM_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH0.Reg) & 0x20) >> 5
}

// DMA.IN_CONF1_CH0: Configure 1 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF1_CH0_IN_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH0.Reg, volatile.LoadUint32(&o.IN_CONF1_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_CONF1_CH0_IN_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH0.Reg) & 0x1000) >> 12
}

// DMA.INFIFO_STATUS_CH0: Receive FIFO status of Rx channel 0
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_FULL(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_FULL() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_EMPTY(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_INFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0xfc)|value<<2)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_INFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0xfc) >> 2
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_1B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_1B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_2B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_2B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_3B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_3B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_4B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_REMAIN_UNDER_4B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetINFIFO_STATUS_CH0_IN_BUF_HUNGRY(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH0_IN_BUF_HUNGRY() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH0.Reg) & 0x8000000) >> 27
}

// DMA.IN_POP_CH0: Pop control register of Rx channel 0
func (o *DMA_Type) SetIN_POP_CH0_INFIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH0.Reg, volatile.LoadUint32(&o.IN_POP_CH0.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_POP_CH0_INFIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH0.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_POP_CH0_INFIFO_POP(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH0.Reg, volatile.LoadUint32(&o.IN_POP_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_POP_CH0_INFIFO_POP() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH0.Reg) & 0x1000) >> 12
}

// DMA.IN_LINK_CH0: Link descriptor configure and control register of Rx channel 0
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0xfffff
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_AUTO_RET(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_AUTO_RET() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_START(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_START() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIN_LINK_CH0_INLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH0.Reg, volatile.LoadUint32(&o.IN_LINK_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIN_LINK_CH0_INLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH0.Reg) & 0x1000000) >> 24
}

// DMA.IN_STATE_CH0: Receive status of Rx channel 0
func (o *DMA_Type) SetIN_STATE_CH0_INLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetIN_STATE_CH0_INLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0x3ffff
}
func (o *DMA_Type) SetIN_STATE_CH0_IN_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetIN_STATE_CH0_IN_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetIN_STATE_CH0_IN_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH0.Reg, volatile.LoadUint32(&o.IN_STATE_CH0.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetIN_STATE_CH0_IN_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH0.Reg) & 0x700000) >> 20
}

// DMA.IN_SUC_EOF_DES_ADDR_CH0: Inlink descriptor address when EOF occurs of Rx channel 0
func (o *DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH0.Reg)
}

// DMA.IN_ERR_EOF_DES_ADDR_CH0: Inlink descriptor address when errors occur of Rx channel 0
func (o *DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH0.Reg)
}

// DMA.IN_DSCR_CH0: Current inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH0.Reg)
}

// DMA.IN_DSCR_BF0_CH0: The last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF0_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF0_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH0.Reg)
}

// DMA.IN_DSCR_BF1_CH0: The second-to-last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF1_CH0(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH0.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF1_CH0() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH0.Reg)
}

// DMA.IN_PRI_CH0: Priority register of Rx channel 0
func (o *DMA_Type) SetIN_PRI_CH0_RX_PRI(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH0.Reg, volatile.LoadUint32(&o.IN_PRI_CH0.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetIN_PRI_CH0_RX_PRI() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH0.Reg) & 0xf
}

// DMA.IN_PERI_SEL_CH0: Peripheral selection of Rx channel 0
func (o *DMA_Type) SetIN_PERI_SEL_CH0_PERI_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH0.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH0.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetIN_PERI_SEL_CH0_PERI_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH0.Reg) & 0x3f
}

// DMA.OUT_CONF1_CH0: Configure 1 register of Tx channel 0
func (o *DMA_Type) SetOUT_CONF1_CH0_OUT_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH0.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetOUT_CONF1_CH0_OUT_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH0.Reg) & 0x1000) >> 12
}

// DMA.OUTFIFO_STATUS_CH0: Transmit FIFO status of Tx channel 0
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_FULL(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_FULL() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_EMPTY(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUTFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0xfc)|value<<2)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUTFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0xfc) >> 2
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_1B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_1B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_2B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_2B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_3B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_3B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_4B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH0.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH0_OUT_REMAIN_UNDER_4B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH0.Reg) & 0x4000000) >> 26
}

// DMA.OUT_PUSH_CH0: Push control register of Rx channel 0
func (o *DMA_Type) SetOUT_PUSH_CH0_OUTFIFO_WDATA(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH0.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg)&^(0x1ff)|value)
}
func (o *DMA_Type) GetOUT_PUSH_CH0_OUTFIFO_WDATA() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg) & 0x1ff
}
func (o *DMA_Type) SetOUT_PUSH_CH0_OUTFIFO_PUSH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH0.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetOUT_PUSH_CH0_OUTFIFO_PUSH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH0.Reg) & 0x200) >> 9
}

// DMA.OUT_LINK_CH0: Link descriptor configure and control register of Tx channel 0
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0xfffff
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_START(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_START() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetOUT_LINK_CH0_OUTLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH0.Reg, volatile.LoadUint32(&o.OUT_LINK_CH0.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUT_LINK_CH0_OUTLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH0.Reg) & 0x800000) >> 23
}

// DMA.OUT_STATE_CH0: Transmit status of Tx channel 0
func (o *DMA_Type) SetOUT_STATE_CH0_OUTLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetOUT_STATE_CH0_OUTLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0x3ffff
}
func (o *DMA_Type) SetOUT_STATE_CH0_OUT_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetOUT_STATE_CH0_OUT_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetOUT_STATE_CH0_OUT_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH0.Reg, volatile.LoadUint32(&o.OUT_STATE_CH0.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetOUT_STATE_CH0_OUT_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH0.Reg) & 0x700000) >> 20
}

// DMA.OUT_EOF_DES_ADDR_CH0: Outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH0.Reg)
}

// DMA.OUT_EOF_BFR_DES_ADDR_CH0: The last outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH0.Reg)
}

// DMA.OUT_DSCR_CH0: Current inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH0.Reg)
}

// DMA.OUT_DSCR_BF0_CH0: The last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF0_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF0_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH0.Reg)
}

// DMA.OUT_DSCR_BF1_CH0: The second-to-last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF1_CH0(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH0.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF1_CH0() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH0.Reg)
}

// DMA.OUT_PRI_CH0: Priority register of Tx channel 0.
func (o *DMA_Type) SetOUT_PRI_CH0_TX_PRI(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH0.Reg, volatile.LoadUint32(&o.OUT_PRI_CH0.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetOUT_PRI_CH0_TX_PRI() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH0.Reg) & 0xf
}

// DMA.OUT_PERI_SEL_CH0: Peripheral selection of Tx channel 0
func (o *DMA_Type) SetOUT_PERI_SEL_CH0_PERI_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH0.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH0.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetOUT_PERI_SEL_CH0_PERI_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH0.Reg) & 0x3f
}

// DMA.IN_CONF0_CH1: Configure 0 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF0_CH1_IN_RST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_CONF0_CH1_IN_RST() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetIN_CONF0_CH1_IN_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_CONF0_CH1_IN_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_CONF0_CH1_INDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_CONF0_CH1_INDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_CONF0_CH1_IN_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_CONF0_CH1_IN_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_CONF0_CH1_MEM_TRANS_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_CONF0_CH1_MEM_TRANS_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_CONF0_CH1_IN_ETM_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH1.Reg, volatile.LoadUint32(&o.IN_CONF0_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_CONF0_CH1_IN_ETM_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH1.Reg) & 0x20) >> 5
}

// DMA.IN_CONF1_CH1: Configure 1 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF1_CH1_IN_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH1.Reg, volatile.LoadUint32(&o.IN_CONF1_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_CONF1_CH1_IN_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH1.Reg) & 0x1000) >> 12
}

// DMA.INFIFO_STATUS_CH1: Receive FIFO status of Rx channel 0
func (o *DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_FULL(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_FULL() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_EMPTY(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_INFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0xfc)|value<<2)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_INFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0xfc) >> 2
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_1B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_1B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_2B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_2B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_3B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_3B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_4B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_IN_REMAIN_UNDER_4B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetINFIFO_STATUS_CH1_IN_BUF_HUNGRY(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH1_IN_BUF_HUNGRY() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH1.Reg) & 0x8000000) >> 27
}

// DMA.IN_POP_CH1: Pop control register of Rx channel 0
func (o *DMA_Type) SetIN_POP_CH1_INFIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH1.Reg, volatile.LoadUint32(&o.IN_POP_CH1.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_POP_CH1_INFIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH1.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_POP_CH1_INFIFO_POP(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH1.Reg, volatile.LoadUint32(&o.IN_POP_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_POP_CH1_INFIFO_POP() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH1.Reg) & 0x1000) >> 12
}

// DMA.IN_LINK_CH1: Link descriptor configure and control register of Rx channel 0
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0xfffff
}
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_AUTO_RET(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_AUTO_RET() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_START(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_START() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIN_LINK_CH1_INLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH1.Reg, volatile.LoadUint32(&o.IN_LINK_CH1.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIN_LINK_CH1_INLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH1.Reg) & 0x1000000) >> 24
}

// DMA.IN_STATE_CH1: Receive status of Rx channel 0
func (o *DMA_Type) SetIN_STATE_CH1_INLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH1.Reg, volatile.LoadUint32(&o.IN_STATE_CH1.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetIN_STATE_CH1_INLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH1.Reg) & 0x3ffff
}
func (o *DMA_Type) SetIN_STATE_CH1_IN_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH1.Reg, volatile.LoadUint32(&o.IN_STATE_CH1.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetIN_STATE_CH1_IN_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH1.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetIN_STATE_CH1_IN_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH1.Reg, volatile.LoadUint32(&o.IN_STATE_CH1.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetIN_STATE_CH1_IN_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH1.Reg) & 0x700000) >> 20
}

// DMA.IN_SUC_EOF_DES_ADDR_CH1: Inlink descriptor address when EOF occurs of Rx channel 0
func (o *DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH1.Reg, value)
}
func (o *DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH1.Reg)
}

// DMA.IN_ERR_EOF_DES_ADDR_CH1: Inlink descriptor address when errors occur of Rx channel 0
func (o *DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH1.Reg, value)
}
func (o *DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH1.Reg)
}

// DMA.IN_DSCR_CH1: Current inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH1.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH1.Reg)
}

// DMA.IN_DSCR_BF0_CH1: The last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF0_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH1.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF0_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH1.Reg)
}

// DMA.IN_DSCR_BF1_CH1: The second-to-last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF1_CH1(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH1.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF1_CH1() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH1.Reg)
}

// DMA.IN_PRI_CH1: Priority register of Rx channel 0
func (o *DMA_Type) SetIN_PRI_CH1_RX_PRI(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH1.Reg, volatile.LoadUint32(&o.IN_PRI_CH1.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetIN_PRI_CH1_RX_PRI() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH1.Reg) & 0xf
}

// DMA.IN_PERI_SEL_CH1: Peripheral selection of Rx channel 0
func (o *DMA_Type) SetIN_PERI_SEL_CH1_PERI_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH1.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH1.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetIN_PERI_SEL_CH1_PERI_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH1.Reg) & 0x3f
}

// DMA.OUT_CONF0_CH0: Configure 0 register of Tx channel 1
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_RST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_RST() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_AUTO_WRBACK(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_AUTO_WRBACK() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_EOF_MODE(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_EOF_MODE() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUTDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUTDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_CONF0_CH0_OUT_ETM_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH0.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_CONF0_CH0_OUT_ETM_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH0.Reg) & 0x40) >> 6
}

// DMA.OUT_CONF1_CH1: Configure 1 register of Tx channel 0
func (o *DMA_Type) SetOUT_CONF1_CH1_OUT_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH1.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetOUT_CONF1_CH1_OUT_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH1.Reg) & 0x1000) >> 12
}

// DMA.OUTFIFO_STATUS_CH1: Transmit FIFO status of Tx channel 0
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_FULL(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_FULL() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_EMPTY(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUTFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0xfc)|value<<2)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUTFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0xfc) >> 2
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_1B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_1B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_2B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_2B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_3B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_3B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_4B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH1.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH1_OUT_REMAIN_UNDER_4B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH1.Reg) & 0x4000000) >> 26
}

// DMA.OUT_PUSH_CH1: Push control register of Rx channel 0
func (o *DMA_Type) SetOUT_PUSH_CH1_OUTFIFO_WDATA(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH1.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg)&^(0x1ff)|value)
}
func (o *DMA_Type) GetOUT_PUSH_CH1_OUTFIFO_WDATA() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg) & 0x1ff
}
func (o *DMA_Type) SetOUT_PUSH_CH1_OUTFIFO_PUSH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH1.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetOUT_PUSH_CH1_OUTFIFO_PUSH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH1.Reg) & 0x200) >> 9
}

// DMA.OUT_LINK_CH1: Link descriptor configure and control register of Tx channel 0
func (o *DMA_Type) SetOUT_LINK_CH1_OUTLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetOUT_LINK_CH1_OUTLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0xfffff
}
func (o *DMA_Type) SetOUT_LINK_CH1_OUTLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetOUT_LINK_CH1_OUTLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetOUT_LINK_CH1_OUTLINK_START(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetOUT_LINK_CH1_OUTLINK_START() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetOUT_LINK_CH1_OUTLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetOUT_LINK_CH1_OUTLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetOUT_LINK_CH1_OUTLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH1.Reg, volatile.LoadUint32(&o.OUT_LINK_CH1.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUT_LINK_CH1_OUTLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH1.Reg) & 0x800000) >> 23
}

// DMA.OUT_STATE_CH1: Transmit status of Tx channel 0
func (o *DMA_Type) SetOUT_STATE_CH1_OUTLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH1.Reg, volatile.LoadUint32(&o.OUT_STATE_CH1.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetOUT_STATE_CH1_OUTLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH1.Reg) & 0x3ffff
}
func (o *DMA_Type) SetOUT_STATE_CH1_OUT_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH1.Reg, volatile.LoadUint32(&o.OUT_STATE_CH1.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetOUT_STATE_CH1_OUT_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH1.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetOUT_STATE_CH1_OUT_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH1.Reg, volatile.LoadUint32(&o.OUT_STATE_CH1.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetOUT_STATE_CH1_OUT_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH1.Reg) & 0x700000) >> 20
}

// DMA.OUT_EOF_DES_ADDR_CH1: Outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH1.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH1.Reg)
}

// DMA.OUT_EOF_BFR_DES_ADDR_CH1: The last outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH1.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH1.Reg)
}

// DMA.OUT_DSCR_CH1: Current inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH1.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH1.Reg)
}

// DMA.OUT_DSCR_BF0_CH1: The last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF0_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH1.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF0_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH1.Reg)
}

// DMA.OUT_DSCR_BF1_CH1: The second-to-last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF1_CH1(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH1.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF1_CH1() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH1.Reg)
}

// DMA.OUT_PRI_CH1: Priority register of Tx channel 0.
func (o *DMA_Type) SetOUT_PRI_CH1_TX_PRI(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH1.Reg, volatile.LoadUint32(&o.OUT_PRI_CH1.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetOUT_PRI_CH1_TX_PRI() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH1.Reg) & 0xf
}

// DMA.OUT_PERI_SEL_CH1: Peripheral selection of Tx channel 0
func (o *DMA_Type) SetOUT_PERI_SEL_CH1_PERI_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH1.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH1.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetOUT_PERI_SEL_CH1_PERI_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH1.Reg) & 0x3f
}

// DMA.IN_CONF0_CH2: Configure 0 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF0_CH2_IN_RST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIN_CONF0_CH2_IN_RST() uint32 {
	return volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetIN_CONF0_CH2_IN_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIN_CONF0_CH2_IN_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIN_CONF0_CH2_INDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIN_CONF0_CH2_INDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIN_CONF0_CH2_IN_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIN_CONF0_CH2_IN_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIN_CONF0_CH2_MEM_TRANS_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIN_CONF0_CH2_MEM_TRANS_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIN_CONF0_CH2_IN_ETM_EN(value uint32) {
	volatile.StoreUint32(&o.IN_CONF0_CH2.Reg, volatile.LoadUint32(&o.IN_CONF0_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIN_CONF0_CH2_IN_ETM_EN() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF0_CH2.Reg) & 0x20) >> 5
}

// DMA.IN_CONF1_CH2: Configure 1 register of Rx channel 0
func (o *DMA_Type) SetIN_CONF1_CH2_IN_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.IN_CONF1_CH2.Reg, volatile.LoadUint32(&o.IN_CONF1_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_CONF1_CH2_IN_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.IN_CONF1_CH2.Reg) & 0x1000) >> 12
}

// DMA.INFIFO_STATUS_CH2: Receive FIFO status of Rx channel 0
func (o *DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_FULL(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_FULL() uint32 {
	return volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_EMPTY(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_INFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0xfc)|value<<2)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_INFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0xfc) >> 2
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_1B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_1B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_2B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_2B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_3B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_3B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_4B(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_IN_REMAIN_UNDER_4B() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetINFIFO_STATUS_CH2_IN_BUF_HUNGRY(value uint32) {
	volatile.StoreUint32(&o.INFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetINFIFO_STATUS_CH2_IN_BUF_HUNGRY() uint32 {
	return (volatile.LoadUint32(&o.INFIFO_STATUS_CH2.Reg) & 0x8000000) >> 27
}

// DMA.IN_POP_CH2: Pop control register of Rx channel 0
func (o *DMA_Type) SetIN_POP_CH2_INFIFO_RDATA(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH2.Reg, volatile.LoadUint32(&o.IN_POP_CH2.Reg)&^(0xfff)|value)
}
func (o *DMA_Type) GetIN_POP_CH2_INFIFO_RDATA() uint32 {
	return volatile.LoadUint32(&o.IN_POP_CH2.Reg) & 0xfff
}
func (o *DMA_Type) SetIN_POP_CH2_INFIFO_POP(value uint32) {
	volatile.StoreUint32(&o.IN_POP_CH2.Reg, volatile.LoadUint32(&o.IN_POP_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIN_POP_CH2_INFIFO_POP() uint32 {
	return (volatile.LoadUint32(&o.IN_POP_CH2.Reg) & 0x1000) >> 12
}

// DMA.IN_LINK_CH2: Link descriptor configure and control register of Rx channel 0
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0xfffff
}
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_AUTO_RET(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_AUTO_RET() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_START(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_START() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIN_LINK_CH2_INLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.IN_LINK_CH2.Reg, volatile.LoadUint32(&o.IN_LINK_CH2.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIN_LINK_CH2_INLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.IN_LINK_CH2.Reg) & 0x1000000) >> 24
}

// DMA.IN_STATE_CH2: Receive status of Rx channel 0
func (o *DMA_Type) SetIN_STATE_CH2_INLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH2.Reg, volatile.LoadUint32(&o.IN_STATE_CH2.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetIN_STATE_CH2_INLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.IN_STATE_CH2.Reg) & 0x3ffff
}
func (o *DMA_Type) SetIN_STATE_CH2_IN_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH2.Reg, volatile.LoadUint32(&o.IN_STATE_CH2.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetIN_STATE_CH2_IN_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH2.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetIN_STATE_CH2_IN_STATE(value uint32) {
	volatile.StoreUint32(&o.IN_STATE_CH2.Reg, volatile.LoadUint32(&o.IN_STATE_CH2.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetIN_STATE_CH2_IN_STATE() uint32 {
	return (volatile.LoadUint32(&o.IN_STATE_CH2.Reg) & 0x700000) >> 20
}

// DMA.IN_SUC_EOF_DES_ADDR_CH2: Inlink descriptor address when EOF occurs of Rx channel 0
func (o *DMA_Type) SetIN_SUC_EOF_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_SUC_EOF_DES_ADDR_CH2.Reg, value)
}
func (o *DMA_Type) GetIN_SUC_EOF_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_SUC_EOF_DES_ADDR_CH2.Reg)
}

// DMA.IN_ERR_EOF_DES_ADDR_CH2: Inlink descriptor address when errors occur of Rx channel 0
func (o *DMA_Type) SetIN_ERR_EOF_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_ERR_EOF_DES_ADDR_CH2.Reg, value)
}
func (o *DMA_Type) GetIN_ERR_EOF_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_ERR_EOF_DES_ADDR_CH2.Reg)
}

// DMA.IN_DSCR_CH2: Current inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_CH2.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_CH2.Reg)
}

// DMA.IN_DSCR_BF0_CH2: The last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF0_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF0_CH2.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF0_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF0_CH2.Reg)
}

// DMA.IN_DSCR_BF1_CH2: The second-to-last inlink descriptor address of Rx channel 0
func (o *DMA_Type) SetIN_DSCR_BF1_CH2(value uint32) {
	volatile.StoreUint32(&o.IN_DSCR_BF1_CH2.Reg, value)
}
func (o *DMA_Type) GetIN_DSCR_BF1_CH2() uint32 {
	return volatile.LoadUint32(&o.IN_DSCR_BF1_CH2.Reg)
}

// DMA.IN_PRI_CH2: Priority register of Rx channel 0
func (o *DMA_Type) SetIN_PRI_CH2_RX_PRI(value uint32) {
	volatile.StoreUint32(&o.IN_PRI_CH2.Reg, volatile.LoadUint32(&o.IN_PRI_CH2.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetIN_PRI_CH2_RX_PRI() uint32 {
	return volatile.LoadUint32(&o.IN_PRI_CH2.Reg) & 0xf
}

// DMA.IN_PERI_SEL_CH2: Peripheral selection of Rx channel 0
func (o *DMA_Type) SetIN_PERI_SEL_CH2_PERI_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.IN_PERI_SEL_CH2.Reg, volatile.LoadUint32(&o.IN_PERI_SEL_CH2.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetIN_PERI_SEL_CH2_PERI_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.IN_PERI_SEL_CH2.Reg) & 0x3f
}

// DMA.OUT_CONF0_CH1: Configure 0 register of Tx channel 1
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_RST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_RST() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_AUTO_WRBACK(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_AUTO_WRBACK() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_EOF_MODE(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_EOF_MODE() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUTDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUTDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_CONF0_CH1_OUT_ETM_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH1.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_CONF0_CH1_OUT_ETM_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH1.Reg) & 0x40) >> 6
}

// DMA.OUT_CONF1_CH2: Configure 1 register of Tx channel 0
func (o *DMA_Type) SetOUT_CONF1_CH2_OUT_CHECK_OWNER(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF1_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF1_CH2.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetOUT_CONF1_CH2_OUT_CHECK_OWNER() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF1_CH2.Reg) & 0x1000) >> 12
}

// DMA.OUTFIFO_STATUS_CH2: Transmit FIFO status of Tx channel 0
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_FULL(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_FULL() uint32 {
	return volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_EMPTY(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_EMPTY() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUTFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0xfc)|value<<2)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUTFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0xfc) >> 2
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_1B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_1B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_2B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_2B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_3B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_3B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_4B(value uint32) {
	volatile.StoreUint32(&o.OUTFIFO_STATUS_CH2.Reg, volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetOUTFIFO_STATUS_CH2_OUT_REMAIN_UNDER_4B() uint32 {
	return (volatile.LoadUint32(&o.OUTFIFO_STATUS_CH2.Reg) & 0x4000000) >> 26
}

// DMA.OUT_PUSH_CH2: Push control register of Rx channel 0
func (o *DMA_Type) SetOUT_PUSH_CH2_OUTFIFO_WDATA(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH2.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg)&^(0x1ff)|value)
}
func (o *DMA_Type) GetOUT_PUSH_CH2_OUTFIFO_WDATA() uint32 {
	return volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg) & 0x1ff
}
func (o *DMA_Type) SetOUT_PUSH_CH2_OUTFIFO_PUSH(value uint32) {
	volatile.StoreUint32(&o.OUT_PUSH_CH2.Reg, volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetOUT_PUSH_CH2_OUTFIFO_PUSH() uint32 {
	return (volatile.LoadUint32(&o.OUT_PUSH_CH2.Reg) & 0x200) >> 9
}

// DMA.OUT_LINK_CH2: Link descriptor configure and control register of Tx channel 0
func (o *DMA_Type) SetOUT_LINK_CH2_OUTLINK_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0xfffff)|value)
}
func (o *DMA_Type) GetOUT_LINK_CH2_OUTLINK_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0xfffff
}
func (o *DMA_Type) SetOUT_LINK_CH2_OUTLINK_STOP(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetOUT_LINK_CH2_OUTLINK_STOP() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetOUT_LINK_CH2_OUTLINK_START(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetOUT_LINK_CH2_OUTLINK_START() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetOUT_LINK_CH2_OUTLINK_RESTART(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetOUT_LINK_CH2_OUTLINK_RESTART() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetOUT_LINK_CH2_OUTLINK_PARK(value uint32) {
	volatile.StoreUint32(&o.OUT_LINK_CH2.Reg, volatile.LoadUint32(&o.OUT_LINK_CH2.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetOUT_LINK_CH2_OUTLINK_PARK() uint32 {
	return (volatile.LoadUint32(&o.OUT_LINK_CH2.Reg) & 0x800000) >> 23
}

// DMA.OUT_STATE_CH2: Transmit status of Tx channel 0
func (o *DMA_Type) SetOUT_STATE_CH2_OUTLINK_DSCR_ADDR(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH2.Reg, volatile.LoadUint32(&o.OUT_STATE_CH2.Reg)&^(0x3ffff)|value)
}
func (o *DMA_Type) GetOUT_STATE_CH2_OUTLINK_DSCR_ADDR() uint32 {
	return volatile.LoadUint32(&o.OUT_STATE_CH2.Reg) & 0x3ffff
}
func (o *DMA_Type) SetOUT_STATE_CH2_OUT_DSCR_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH2.Reg, volatile.LoadUint32(&o.OUT_STATE_CH2.Reg)&^(0xc0000)|value<<18)
}
func (o *DMA_Type) GetOUT_STATE_CH2_OUT_DSCR_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH2.Reg) & 0xc0000) >> 18
}
func (o *DMA_Type) SetOUT_STATE_CH2_OUT_STATE(value uint32) {
	volatile.StoreUint32(&o.OUT_STATE_CH2.Reg, volatile.LoadUint32(&o.OUT_STATE_CH2.Reg)&^(0x700000)|value<<20)
}
func (o *DMA_Type) GetOUT_STATE_CH2_OUT_STATE() uint32 {
	return (volatile.LoadUint32(&o.OUT_STATE_CH2.Reg) & 0x700000) >> 20
}

// DMA.OUT_EOF_DES_ADDR_CH2: Outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_DES_ADDR_CH2.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_DES_ADDR_CH2.Reg)
}

// DMA.OUT_EOF_BFR_DES_ADDR_CH2: The last outlink descriptor address when EOF occurs of Tx channel 0
func (o *DMA_Type) SetOUT_EOF_BFR_DES_ADDR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_EOF_BFR_DES_ADDR_CH2.Reg, value)
}
func (o *DMA_Type) GetOUT_EOF_BFR_DES_ADDR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_EOF_BFR_DES_ADDR_CH2.Reg)
}

// DMA.OUT_DSCR_CH2: Current inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_CH2.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_CH2.Reg)
}

// DMA.OUT_DSCR_BF0_CH2: The last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF0_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF0_CH2.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF0_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF0_CH2.Reg)
}

// DMA.OUT_DSCR_BF1_CH2: The second-to-last inlink descriptor address of Tx channel 0
func (o *DMA_Type) SetOUT_DSCR_BF1_CH2(value uint32) {
	volatile.StoreUint32(&o.OUT_DSCR_BF1_CH2.Reg, value)
}
func (o *DMA_Type) GetOUT_DSCR_BF1_CH2() uint32 {
	return volatile.LoadUint32(&o.OUT_DSCR_BF1_CH2.Reg)
}

// DMA.OUT_PRI_CH2: Priority register of Tx channel 0.
func (o *DMA_Type) SetOUT_PRI_CH2_TX_PRI(value uint32) {
	volatile.StoreUint32(&o.OUT_PRI_CH2.Reg, volatile.LoadUint32(&o.OUT_PRI_CH2.Reg)&^(0xf)|value)
}
func (o *DMA_Type) GetOUT_PRI_CH2_TX_PRI() uint32 {
	return volatile.LoadUint32(&o.OUT_PRI_CH2.Reg) & 0xf
}

// DMA.OUT_PERI_SEL_CH2: Peripheral selection of Tx channel 0
func (o *DMA_Type) SetOUT_PERI_SEL_CH2_PERI_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.OUT_PERI_SEL_CH2.Reg, volatile.LoadUint32(&o.OUT_PERI_SEL_CH2.Reg)&^(0x3f)|value)
}
func (o *DMA_Type) GetOUT_PERI_SEL_CH2_PERI_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.OUT_PERI_SEL_CH2.Reg) & 0x3f
}

// DMA.OUT_CONF0_CH2: Configure 0 register of Tx channel 1
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_RST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_RST() uint32 {
	return volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x1
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_LOOP_TEST(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_LOOP_TEST() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_AUTO_WRBACK(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_AUTO_WRBACK() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_EOF_MODE(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_EOF_MODE() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUTDSCR_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUTDSCR_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_DATA_BURST_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_DATA_BURST_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetOUT_CONF0_CH2_OUT_ETM_EN(value uint32) {
	volatile.StoreUint32(&o.OUT_CONF0_CH2.Reg, volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetOUT_CONF0_CH2_OUT_ETM_EN() uint32 {
	return (volatile.LoadUint32(&o.OUT_CONF0_CH2.Reg) & 0x40) >> 6
}

// Digital Signature
type DS_Type struct {
	Y_MEM           [512]volatile.Register8 // 0x0
	M_MEM           [512]volatile.Register8 // 0x200
	RB_MEM          [512]volatile.Register8 // 0x400
	BOX_MEM         [48]volatile.Register8  // 0x600
	IV_MEM          [16]volatile.Register8  // 0x630
	_               [448]byte
	X_MEM           [512]volatile.Register8 // 0x800
	Z_MEM           [512]volatile.Register8 // 0xA00
	_               [512]byte
	SET_START       volatile.Register32 // 0xE00
	SET_CONTINUE    volatile.Register32 // 0xE04
	SET_FINISH      volatile.Register32 // 0xE08
	QUERY_BUSY      volatile.Register32 // 0xE0C
	QUERY_KEY_WRONG volatile.Register32 // 0xE10
	QUERY_CHECK     volatile.Register32 // 0xE14
	_               [8]byte
	DATE            volatile.Register32 // 0xE20
}

// DS.SET_START: DS start control register
func (o *DS_Type) SetSET_START(value uint32) {
	volatile.StoreUint32(&o.SET_START.Reg, volatile.LoadUint32(&o.SET_START.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetSET_START() uint32 {
	return volatile.LoadUint32(&o.SET_START.Reg) & 0x1
}

// DS.SET_CONTINUE: DS continue control register
func (o *DS_Type) SetSET_CONTINUE(value uint32) {
	volatile.StoreUint32(&o.SET_CONTINUE.Reg, volatile.LoadUint32(&o.SET_CONTINUE.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetSET_CONTINUE() uint32 {
	return volatile.LoadUint32(&o.SET_CONTINUE.Reg) & 0x1
}

// DS.SET_FINISH: DS finish control register
func (o *DS_Type) SetSET_FINISH(value uint32) {
	volatile.StoreUint32(&o.SET_FINISH.Reg, volatile.LoadUint32(&o.SET_FINISH.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetSET_FINISH() uint32 {
	return volatile.LoadUint32(&o.SET_FINISH.Reg) & 0x1
}

// DS.QUERY_BUSY: DS query busy register
func (o *DS_Type) SetQUERY_BUSY(value uint32) {
	volatile.StoreUint32(&o.QUERY_BUSY.Reg, volatile.LoadUint32(&o.QUERY_BUSY.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetQUERY_BUSY() uint32 {
	return volatile.LoadUint32(&o.QUERY_BUSY.Reg) & 0x1
}

// DS.QUERY_KEY_WRONG: DS query key-wrong counter register
func (o *DS_Type) SetQUERY_KEY_WRONG(value uint32) {
	volatile.StoreUint32(&o.QUERY_KEY_WRONG.Reg, volatile.LoadUint32(&o.QUERY_KEY_WRONG.Reg)&^(0xf)|value)
}
func (o *DS_Type) GetQUERY_KEY_WRONG() uint32 {
	return volatile.LoadUint32(&o.QUERY_KEY_WRONG.Reg) & 0xf
}

// DS.QUERY_CHECK: DS query check result register
func (o *DS_Type) SetQUERY_CHECK_MD_ERROR(value uint32) {
	volatile.StoreUint32(&o.QUERY_CHECK.Reg, volatile.LoadUint32(&o.QUERY_CHECK.Reg)&^(0x1)|value)
}
func (o *DS_Type) GetQUERY_CHECK_MD_ERROR() uint32 {
	return volatile.LoadUint32(&o.QUERY_CHECK.Reg) & 0x1
}
func (o *DS_Type) SetQUERY_CHECK_PADDING_BAD(value uint32) {
	volatile.StoreUint32(&o.QUERY_CHECK.Reg, volatile.LoadUint32(&o.QUERY_CHECK.Reg)&^(0x2)|value<<1)
}
func (o *DS_Type) GetQUERY_CHECK_PADDING_BAD() uint32 {
	return (volatile.LoadUint32(&o.QUERY_CHECK.Reg) & 0x2) >> 1
}

// DS.DATE: DS version control register
func (o *DS_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x3fffffff)|value)
}
func (o *DS_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x3fffffff
}

// ECC (ECC Hardware Accelerator)
type ECC_Type struct {
	_            [12]byte
	MULT_INT_RAW volatile.Register32 // 0xC
	MULT_INT_ST  volatile.Register32 // 0x10
	MULT_INT_ENA volatile.Register32 // 0x14
	MULT_INT_CLR volatile.Register32 // 0x18
	MULT_CONF    volatile.Register32 // 0x1C
	_            [220]byte
	MULT_DATE    volatile.Register32    // 0xFC
	K_MEM        [32]volatile.Register8 // 0x100
	PX_MEM       [32]volatile.Register8 // 0x120
	PY_MEM       [32]volatile.Register8 // 0x140
}

// ECC.MULT_INT_RAW: ECC interrupt raw register, valid in level.
func (o *ECC_Type) SetMULT_INT_RAW_CALC_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.MULT_INT_RAW.Reg, volatile.LoadUint32(&o.MULT_INT_RAW.Reg)&^(0x1)|value)
}
func (o *ECC_Type) GetMULT_INT_RAW_CALC_DONE_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.MULT_INT_RAW.Reg) & 0x1
}

// ECC.MULT_INT_ST: ECC interrupt status register.
func (o *ECC_Type) SetMULT_INT_ST_CALC_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.MULT_INT_ST.Reg, volatile.LoadUint32(&o.MULT_INT_ST.Reg)&^(0x1)|value)
}
func (o *ECC_Type) GetMULT_INT_ST_CALC_DONE_INT_ST() uint32 {
	return volatile.LoadUint32(&o.MULT_INT_ST.Reg) & 0x1
}

// ECC.MULT_INT_ENA: ECC interrupt enable register.
func (o *ECC_Type) SetMULT_INT_ENA_CALC_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.MULT_INT_ENA.Reg, volatile.LoadUint32(&o.MULT_INT_ENA.Reg)&^(0x1)|value)
}
func (o *ECC_Type) GetMULT_INT_ENA_CALC_DONE_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.MULT_INT_ENA.Reg) & 0x1
}

// ECC.MULT_INT_CLR: ECC interrupt clear register.
func (o *ECC_Type) SetMULT_INT_CLR_CALC_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.MULT_INT_CLR.Reg, volatile.LoadUint32(&o.MULT_INT_CLR.Reg)&^(0x1)|value)
}
func (o *ECC_Type) GetMULT_INT_CLR_CALC_DONE_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.MULT_INT_CLR.Reg) & 0x1
}

// ECC.MULT_CONF: ECC configure register
func (o *ECC_Type) SetMULT_CONF_START(value uint32) {
	volatile.StoreUint32(&o.MULT_CONF.Reg, volatile.LoadUint32(&o.MULT_CONF.Reg)&^(0x1)|value)
}
func (o *ECC_Type) GetMULT_CONF_START() uint32 {
	return volatile.LoadUint32(&o.MULT_CONF.Reg) & 0x1
}
func (o *ECC_Type) SetMULT_CONF_RESET(value uint32) {
	volatile.StoreUint32(&o.MULT_CONF.Reg, volatile.LoadUint32(&o.MULT_CONF.Reg)&^(0x2)|value<<1)
}
func (o *ECC_Type) GetMULT_CONF_RESET() uint32 {
	return (volatile.LoadUint32(&o.MULT_CONF.Reg) & 0x2) >> 1
}
func (o *ECC_Type) SetMULT_CONF_KEY_LENGTH(value uint32) {
	volatile.StoreUint32(&o.MULT_CONF.Reg, volatile.LoadUint32(&o.MULT_CONF.Reg)&^(0x4)|value<<2)
}
func (o *ECC_Type) GetMULT_CONF_KEY_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.MULT_CONF.Reg) & 0x4) >> 2
}
func (o *ECC_Type) SetMULT_CONF_SECURITY_MODE(value uint32) {
	volatile.StoreUint32(&o.MULT_CONF.Reg, volatile.LoadUint32(&o.MULT_CONF.Reg)&^(0x8)|value<<3)
}
func (o *ECC_Type) GetMULT_CONF_SECURITY_MODE() uint32 {
	return (volatile.LoadUint32(&o.MULT_CONF.Reg) & 0x8) >> 3
}
func (o *ECC_Type) SetMULT_CONF_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.MULT_CONF.Reg, volatile.LoadUint32(&o.MULT_CONF.Reg)&^(0x10)|value<<4)
}
func (o *ECC_Type) GetMULT_CONF_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.MULT_CONF.Reg) & 0x10) >> 4
}
func (o *ECC_Type) SetMULT_CONF_WORK_MODE(value uint32) {
	volatile.StoreUint32(&o.MULT_CONF.Reg, volatile.LoadUint32(&o.MULT_CONF.Reg)&^(0xe0)|value<<5)
}
func (o *ECC_Type) GetMULT_CONF_WORK_MODE() uint32 {
	return (volatile.LoadUint32(&o.MULT_CONF.Reg) & 0xe0) >> 5
}
func (o *ECC_Type) SetMULT_CONF_VERIFICATION_RESULT(value uint32) {
	volatile.StoreUint32(&o.MULT_CONF.Reg, volatile.LoadUint32(&o.MULT_CONF.Reg)&^(0x100)|value<<8)
}
func (o *ECC_Type) GetMULT_CONF_VERIFICATION_RESULT() uint32 {
	return (volatile.LoadUint32(&o.MULT_CONF.Reg) & 0x100) >> 8
}
func (o *ECC_Type) SetMULT_CONF_MEM_CLOCK_GATE_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.MULT_CONF.Reg, volatile.LoadUint32(&o.MULT_CONF.Reg)&^(0x80000000)|value<<31)
}
func (o *ECC_Type) GetMULT_CONF_MEM_CLOCK_GATE_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.MULT_CONF.Reg) & 0x80000000) >> 31
}

// ECC.MULT_DATE: Version control register
func (o *ECC_Type) SetMULT_DATE_DATE(value uint32) {
	volatile.StoreUint32(&o.MULT_DATE.Reg, volatile.LoadUint32(&o.MULT_DATE.Reg)&^(0xfffffff)|value)
}
func (o *ECC_Type) GetMULT_DATE_DATE() uint32 {
	return volatile.LoadUint32(&o.MULT_DATE.Reg) & 0xfffffff
}

// eFuse Controller
type EFUSE_Type struct {
	PGM_DATA0              volatile.Register32 // 0x0
	PGM_DATA1              volatile.Register32 // 0x4
	PGM_DATA2              volatile.Register32 // 0x8
	PGM_DATA3              volatile.Register32 // 0xC
	PGM_DATA4              volatile.Register32 // 0x10
	PGM_DATA5              volatile.Register32 // 0x14
	PGM_DATA6              volatile.Register32 // 0x18
	PGM_DATA7              volatile.Register32 // 0x1C
	PGM_CHECK_VALUE0       volatile.Register32 // 0x20
	PGM_CHECK_VALUE1       volatile.Register32 // 0x24
	PGM_CHECK_VALUE2       volatile.Register32 // 0x28
	RD_WR_DIS              volatile.Register32 // 0x2C
	RD_REPEAT_DATA0        volatile.Register32 // 0x30
	RD_REPEAT_DATA1        volatile.Register32 // 0x34
	RD_REPEAT_DATA2        volatile.Register32 // 0x38
	RD_REPEAT_DATA3        volatile.Register32 // 0x3C
	RD_REPEAT_DATA4        volatile.Register32 // 0x40
	RD_MAC_SPI_SYS_0       volatile.Register32 // 0x44
	RD_MAC_SPI_SYS_1       volatile.Register32 // 0x48
	RD_MAC_SPI_SYS_2       volatile.Register32 // 0x4C
	RD_MAC_SPI_SYS_3       volatile.Register32 // 0x50
	RD_MAC_SPI_SYS_4       volatile.Register32 // 0x54
	RD_MAC_SPI_SYS_5       volatile.Register32 // 0x58
	RD_SYS_PART1_DATA0     volatile.Register32 // 0x5C
	RD_SYS_PART1_DATA1     volatile.Register32 // 0x60
	RD_SYS_PART1_DATA2     volatile.Register32 // 0x64
	RD_SYS_PART1_DATA3     volatile.Register32 // 0x68
	RD_SYS_PART1_DATA4     volatile.Register32 // 0x6C
	RD_SYS_PART1_DATA5     volatile.Register32 // 0x70
	RD_SYS_PART1_DATA6     volatile.Register32 // 0x74
	RD_SYS_PART1_DATA7     volatile.Register32 // 0x78
	RD_USR_DATA0           volatile.Register32 // 0x7C
	RD_USR_DATA1           volatile.Register32 // 0x80
	RD_USR_DATA2           volatile.Register32 // 0x84
	RD_USR_DATA3           volatile.Register32 // 0x88
	RD_USR_DATA4           volatile.Register32 // 0x8C
	RD_USR_DATA5           volatile.Register32 // 0x90
	RD_USR_DATA6           volatile.Register32 // 0x94
	RD_USR_DATA7           volatile.Register32 // 0x98
	RD_KEY0_DATA0          volatile.Register32 // 0x9C
	RD_KEY0_DATA1          volatile.Register32 // 0xA0
	RD_KEY0_DATA2          volatile.Register32 // 0xA4
	RD_KEY0_DATA3          volatile.Register32 // 0xA8
	RD_KEY0_DATA4          volatile.Register32 // 0xAC
	RD_KEY0_DATA5          volatile.Register32 // 0xB0
	RD_KEY0_DATA6          volatile.Register32 // 0xB4
	RD_KEY0_DATA7          volatile.Register32 // 0xB8
	RD_KEY1_DATA0          volatile.Register32 // 0xBC
	RD_KEY1_DATA1          volatile.Register32 // 0xC0
	RD_KEY1_DATA2          volatile.Register32 // 0xC4
	RD_KEY1_DATA3          volatile.Register32 // 0xC8
	RD_KEY1_DATA4          volatile.Register32 // 0xCC
	RD_KEY1_DATA5          volatile.Register32 // 0xD0
	RD_KEY1_DATA6          volatile.Register32 // 0xD4
	RD_KEY1_DATA7          volatile.Register32 // 0xD8
	RD_KEY2_DATA0          volatile.Register32 // 0xDC
	RD_KEY2_DATA1          volatile.Register32 // 0xE0
	RD_KEY2_DATA2          volatile.Register32 // 0xE4
	RD_KEY2_DATA3          volatile.Register32 // 0xE8
	RD_KEY2_DATA4          volatile.Register32 // 0xEC
	RD_KEY2_DATA5          volatile.Register32 // 0xF0
	RD_KEY2_DATA6          volatile.Register32 // 0xF4
	RD_KEY2_DATA7          volatile.Register32 // 0xF8
	RD_KEY3_DATA0          volatile.Register32 // 0xFC
	RD_KEY3_DATA1          volatile.Register32 // 0x100
	RD_KEY3_DATA2          volatile.Register32 // 0x104
	RD_KEY3_DATA3          volatile.Register32 // 0x108
	RD_KEY3_DATA4          volatile.Register32 // 0x10C
	RD_KEY3_DATA5          volatile.Register32 // 0x110
	RD_KEY3_DATA6          volatile.Register32 // 0x114
	RD_KEY3_DATA7          volatile.Register32 // 0x118
	RD_KEY4_DATA0          volatile.Register32 // 0x11C
	RD_KEY4_DATA1          volatile.Register32 // 0x120
	RD_KEY4_DATA2          volatile.Register32 // 0x124
	RD_KEY4_DATA3          volatile.Register32 // 0x128
	RD_KEY4_DATA4          volatile.Register32 // 0x12C
	RD_KEY4_DATA5          volatile.Register32 // 0x130
	RD_KEY4_DATA6          volatile.Register32 // 0x134
	RD_KEY4_DATA7          volatile.Register32 // 0x138
	RD_KEY5_DATA0          volatile.Register32 // 0x13C
	RD_KEY5_DATA1          volatile.Register32 // 0x140
	RD_KEY5_DATA2          volatile.Register32 // 0x144
	RD_KEY5_DATA3          volatile.Register32 // 0x148
	RD_KEY5_DATA4          volatile.Register32 // 0x14C
	RD_KEY5_DATA5          volatile.Register32 // 0x150
	RD_KEY5_DATA6          volatile.Register32 // 0x154
	RD_KEY5_DATA7          volatile.Register32 // 0x158
	RD_SYS_PART2_DATA0     volatile.Register32 // 0x15C
	RD_SYS_PART2_DATA1     volatile.Register32 // 0x160
	RD_SYS_PART2_DATA2     volatile.Register32 // 0x164
	RD_SYS_PART2_DATA3     volatile.Register32 // 0x168
	RD_SYS_PART2_DATA4     volatile.Register32 // 0x16C
	RD_SYS_PART2_DATA5     volatile.Register32 // 0x170
	RD_SYS_PART2_DATA6     volatile.Register32 // 0x174
	RD_SYS_PART2_DATA7     volatile.Register32 // 0x178
	RD_REPEAT_ERR0         volatile.Register32 // 0x17C
	RD_REPEAT_ERR1         volatile.Register32 // 0x180
	RD_REPEAT_ERR2         volatile.Register32 // 0x184
	RD_REPEAT_ERR3         volatile.Register32 // 0x188
	_                      [4]byte
	RD_REPEAT_ERR4         volatile.Register32 // 0x190
	_                      [44]byte
	RD_RS_ERR0             volatile.Register32 // 0x1C0
	RD_RS_ERR1             volatile.Register32 // 0x1C4
	CLK                    volatile.Register32 // 0x1C8
	CONF                   volatile.Register32 // 0x1CC
	STATUS                 volatile.Register32 // 0x1D0
	CMD                    volatile.Register32 // 0x1D4
	INT_RAW                volatile.Register32 // 0x1D8
	INT_ST                 volatile.Register32 // 0x1DC
	INT_ENA                volatile.Register32 // 0x1E0
	INT_CLR                volatile.Register32 // 0x1E4
	DAC_CONF               volatile.Register32 // 0x1E8
	RD_TIM_CONF            volatile.Register32 // 0x1EC
	WR_TIM_CONF1           volatile.Register32 // 0x1F0
	WR_TIM_CONF2           volatile.Register32 // 0x1F4
	WR_TIM_CONF0_RS_BYPASS volatile.Register32 // 0x1F8
	DATE                   volatile.Register32 // 0x1FC
}

// EFUSE.PGM_DATA0: Register 0 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA0(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA0() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA0.Reg)
}

// EFUSE.PGM_DATA1: Register 1 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA1(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA1() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA1.Reg)
}

// EFUSE.PGM_DATA2: Register 2 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA2(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA2() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA2.Reg)
}

// EFUSE.PGM_DATA3: Register 3 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA3(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA3() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA3.Reg)
}

// EFUSE.PGM_DATA4: Register 4 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA4(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA4() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA4.Reg)
}

// EFUSE.PGM_DATA5: Register 5 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA5(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA5() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA5.Reg)
}

// EFUSE.PGM_DATA6: Register 6 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA6(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA6() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA6.Reg)
}

// EFUSE.PGM_DATA7: Register 7 that stores data to be programmed.
func (o *EFUSE_Type) SetPGM_DATA7(value uint32) {
	volatile.StoreUint32(&o.PGM_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetPGM_DATA7() uint32 {
	return volatile.LoadUint32(&o.PGM_DATA7.Reg)
}

// EFUSE.PGM_CHECK_VALUE0: Register 0 that stores the RS code to be programmed.
func (o *EFUSE_Type) SetPGM_CHECK_VALUE0(value uint32) {
	volatile.StoreUint32(&o.PGM_CHECK_VALUE0.Reg, value)
}
func (o *EFUSE_Type) GetPGM_CHECK_VALUE0() uint32 {
	return volatile.LoadUint32(&o.PGM_CHECK_VALUE0.Reg)
}

// EFUSE.PGM_CHECK_VALUE1: Register 1 that stores the RS code to be programmed.
func (o *EFUSE_Type) SetPGM_CHECK_VALUE1(value uint32) {
	volatile.StoreUint32(&o.PGM_CHECK_VALUE1.Reg, value)
}
func (o *EFUSE_Type) GetPGM_CHECK_VALUE1() uint32 {
	return volatile.LoadUint32(&o.PGM_CHECK_VALUE1.Reg)
}

// EFUSE.PGM_CHECK_VALUE2: Register 2 that stores the RS code to be programmed.
func (o *EFUSE_Type) SetPGM_CHECK_VALUE2(value uint32) {
	volatile.StoreUint32(&o.PGM_CHECK_VALUE2.Reg, value)
}
func (o *EFUSE_Type) GetPGM_CHECK_VALUE2() uint32 {
	return volatile.LoadUint32(&o.PGM_CHECK_VALUE2.Reg)
}

// EFUSE.RD_WR_DIS: BLOCK0 data register 0.
func (o *EFUSE_Type) SetRD_WR_DIS(value uint32) {
	volatile.StoreUint32(&o.RD_WR_DIS.Reg, value)
}
func (o *EFUSE_Type) GetRD_WR_DIS() uint32 {
	return volatile.LoadUint32(&o.RD_WR_DIS.Reg)
}

// EFUSE.RD_REPEAT_DATA0: BLOCK0 data register 1.
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_RD_DIS(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x7f)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_RD_DIS() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x7f
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_SWAP_UART_SDIO_EN(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_SWAP_UART_SDIO_EN() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_ICACHE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_ICACHE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_USB_JTAG(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_USB_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DOWNLOAD_ICACHE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x400)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DOWNLOAD_ICACHE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x400) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_USB_SERIAL_JTAG(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x800)|value<<11)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_USB_SERIAL_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x800) >> 11
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_FORCE_DOWNLOAD(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_FORCE_DOWNLOAD() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_SPI_DOWNLOAD_MSPI_DIS(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_SPI_DOWNLOAD_MSPI_DIS() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_CAN(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x4000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_CAN() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x4000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_JTAG_SEL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_JTAG_SEL_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_SOFT_DIS_JTAG(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x70000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_SOFT_DIS_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x70000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_PAD_JTAG(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x80000)|value<<19)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_PAD_JTAG() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x80000) >> 19
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_DIS_DOWNLOAD_MANUAL_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_DIS_DOWNLOAD_MANUAL_ENCRYPT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_USB_DREFH(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x600000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_USB_DREFH() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x600000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_USB_DREFL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x1800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_USB_DREFL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x1800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_USB_EXCHG_PINS(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x2000000)|value<<25)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_USB_EXCHG_PINS() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x2000000) >> 25
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_VDD_SPI_AS_GPIO(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x4000000)|value<<26)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_VDD_SPI_AS_GPIO() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x4000000) >> 26
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_RPT4_RESERVED0_2(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x18000000)|value<<27)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_RPT4_RESERVED0_2() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x18000000) >> 27
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_RPT4_RESERVED0_1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0x20000000)|value<<29)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_RPT4_RESERVED0_1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0x20000000) >> 29
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA0_RPT4_RESERVED0_0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA0.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg)&^(0xc0000000)|value<<30)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA0_RPT4_RESERVED0_0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA0.Reg) & 0xc0000000) >> 30
}

// EFUSE.RD_REPEAT_DATA1: BLOCK0 data register 2.
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_RPT4_RESERVED1_0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_RPT4_RESERVED1_0() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xffff
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_WDT_DELAY_SEL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x30000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_WDT_DELAY_SEL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x30000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SPI_BOOT_CRYPT_CNT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x1c0000)|value<<18)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SPI_BOOT_CRYPT_CNT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x1c0000) >> 18
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x400000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x400000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE2(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0x800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_SECURE_BOOT_KEY_REVOKE2() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0x800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_KEY_PURPOSE_0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xf000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_KEY_PURPOSE_0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xf000000) >> 24
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA1_KEY_PURPOSE_1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA1.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA1_KEY_PURPOSE_1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA1.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_DATA2: BLOCK0 data register 3.
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_2(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_2() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_3(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf0)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_3() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf0) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_4(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf00)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_4() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf00) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_KEY_PURPOSE_5(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_KEY_PURPOSE_5() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_DPA_SEC_LEVEL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0x30000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_DPA_SEC_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0x30000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_RPT4_RESERVED2_1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0x40000)|value<<18)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_RPT4_RESERVED2_1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0x40000) >> 18
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_CRYPT_DPA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0x80000)|value<<19)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_CRYPT_DPA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0x80000) >> 19
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_SECURE_BOOT_EN(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_SECURE_BOOT_EN() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_SECURE_BOOT_AGGRESSIVE_REVOKE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_SECURE_BOOT_AGGRESSIVE_REVOKE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_RPT4_RESERVED2_0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xfc00000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_RPT4_RESERVED2_0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xfc00000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA2_FLASH_TPUW(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA2.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA2_FLASH_TPUW() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA2.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_DATA3: BLOCK0 data register 4.
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_DIS_DOWNLOAD_MODE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_DIS_DOWNLOAD_MODE() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x1
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_DIS_DIRECT_BOOT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_DIS_DIRECT_BOOT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_DIS_USB_PRINT(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_DIS_USB_PRINT() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_RPT4_RESERVED3_5(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_RPT4_RESERVED3_5() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_DIS_USB_SERIAL_JTAG_DOWNLOAD_MODE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_DIS_USB_SERIAL_JTAG_DOWNLOAD_MODE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_ENABLE_SECURITY_DOWNLOAD(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_ENABLE_SECURITY_DOWNLOAD() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_UART_PRINT_CONTROL(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0xc0)|value<<6)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_UART_PRINT_CONTROL() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0xc0) >> 6
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_RPT4_RESERVED3_4(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_RPT4_RESERVED3_4() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_RPT4_RESERVED3_3(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_RPT4_RESERVED3_3() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_RPT4_RESERVED3_2(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0xc00)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_RPT4_RESERVED3_2() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0xc00) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_RPT4_RESERVED3_1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_RPT4_RESERVED3_1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_FORCE_SEND_RESUME(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_FORCE_SEND_RESUME() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_SECURE_VERSION(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x3fffc000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_SECURE_VERSION() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x3fffc000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_SECURE_BOOT_DISABLE_FAST_WAKE(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x40000000)|value<<30)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_SECURE_BOOT_DISABLE_FAST_WAKE() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x40000000) >> 30
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA3_RPT4_RESERVED3_0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA3.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg)&^(0x80000000)|value<<31)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA3_RPT4_RESERVED3_0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA3.Reg) & 0x80000000) >> 31
}

// EFUSE.RD_REPEAT_DATA4: BLOCK0 data register 5.
func (o *EFUSE_Type) SetRD_REPEAT_DATA4_RPT4_RESERVED4_1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA4.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA4.Reg)&^(0xffffff)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA4_RPT4_RESERVED4_1() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_DATA4.Reg) & 0xffffff
}
func (o *EFUSE_Type) SetRD_REPEAT_DATA4_RPT4_RESERVED4_0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_DATA4.Reg, volatile.LoadUint32(&o.RD_REPEAT_DATA4.Reg)&^(0xff000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_REPEAT_DATA4_RPT4_RESERVED4_0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_DATA4.Reg) & 0xff000000) >> 24
}

// EFUSE.RD_MAC_SPI_SYS_0: BLOCK1 data register $n.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_0(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_0.Reg, value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_0() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_0.Reg)
}

// EFUSE.RD_MAC_SPI_SYS_1: BLOCK1 data register $n.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_1_MAC_1(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_1.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_1_MAC_1() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg) & 0xffff
}
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_1_MAC_EXT(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_1.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg)&^(0xffff0000)|value<<16)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_1_MAC_EXT() uint32 {
	return (volatile.LoadUint32(&o.RD_MAC_SPI_SYS_1.Reg) & 0xffff0000) >> 16
}

// EFUSE.RD_MAC_SPI_SYS_2: BLOCK1 data register $n.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_2_MAC_SPI_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_2.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_2.Reg)&^(0x3fff)|value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_2_MAC_SPI_RESERVED() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_2.Reg) & 0x3fff
}
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_2_SPI_PAD_CONF_1(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_2.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_2.Reg)&^(0xffffc000)|value<<14)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_2_SPI_PAD_CONF_1() uint32 {
	return (volatile.LoadUint32(&o.RD_MAC_SPI_SYS_2.Reg) & 0xffffc000) >> 14
}

// EFUSE.RD_MAC_SPI_SYS_3: BLOCK1 data register $n.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_3_SPI_PAD_CONF_2(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_3.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg)&^(0x3ffff)|value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_3_SPI_PAD_CONF_2() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg) & 0x3ffff
}
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_3_SYS_DATA_PART0_0(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_3.Reg, volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg)&^(0xfffc0000)|value<<18)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_3_SYS_DATA_PART0_0() uint32 {
	return (volatile.LoadUint32(&o.RD_MAC_SPI_SYS_3.Reg) & 0xfffc0000) >> 18
}

// EFUSE.RD_MAC_SPI_SYS_4: BLOCK1 data register $n.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_4(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_4.Reg, value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_4() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_4.Reg)
}

// EFUSE.RD_MAC_SPI_SYS_5: BLOCK1 data register $n.
func (o *EFUSE_Type) SetRD_MAC_SPI_SYS_5(value uint32) {
	volatile.StoreUint32(&o.RD_MAC_SPI_SYS_5.Reg, value)
}
func (o *EFUSE_Type) GetRD_MAC_SPI_SYS_5() uint32 {
	return volatile.LoadUint32(&o.RD_MAC_SPI_SYS_5.Reg)
}

// EFUSE.RD_SYS_PART1_DATA0: Register $n of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA0.Reg)
}

// EFUSE.RD_SYS_PART1_DATA1: Register $n of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA1.Reg)
}

// EFUSE.RD_SYS_PART1_DATA2: Register $n of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA2.Reg)
}

// EFUSE.RD_SYS_PART1_DATA3: Register $n of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA3.Reg)
}

// EFUSE.RD_SYS_PART1_DATA4: Register $n of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA4.Reg)
}

// EFUSE.RD_SYS_PART1_DATA5: Register $n of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA5.Reg)
}

// EFUSE.RD_SYS_PART1_DATA6: Register $n of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA6.Reg)
}

// EFUSE.RD_SYS_PART1_DATA7: Register $n of BLOCK2 (system).
func (o *EFUSE_Type) SetRD_SYS_PART1_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART1_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART1_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART1_DATA7.Reg)
}

// EFUSE.RD_USR_DATA0: Register $n of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA0.Reg)
}

// EFUSE.RD_USR_DATA1: Register $n of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA1.Reg)
}

// EFUSE.RD_USR_DATA2: Register $n of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA2.Reg)
}

// EFUSE.RD_USR_DATA3: Register $n of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA3.Reg)
}

// EFUSE.RD_USR_DATA4: Register $n of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA4.Reg)
}

// EFUSE.RD_USR_DATA5: Register $n of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA5.Reg)
}

// EFUSE.RD_USR_DATA6: Register $n of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA6.Reg)
}

// EFUSE.RD_USR_DATA7: Register $n of BLOCK3 (user).
func (o *EFUSE_Type) SetRD_USR_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_USR_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_USR_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_USR_DATA7.Reg)
}

// EFUSE.RD_KEY0_DATA0: Register $n of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA0.Reg)
}

// EFUSE.RD_KEY0_DATA1: Register $n of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA1.Reg)
}

// EFUSE.RD_KEY0_DATA2: Register $n of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA2.Reg)
}

// EFUSE.RD_KEY0_DATA3: Register $n of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA3.Reg)
}

// EFUSE.RD_KEY0_DATA4: Register $n of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA4.Reg)
}

// EFUSE.RD_KEY0_DATA5: Register $n of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA5.Reg)
}

// EFUSE.RD_KEY0_DATA6: Register $n of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA6.Reg)
}

// EFUSE.RD_KEY0_DATA7: Register $n of BLOCK4 (KEY0).
func (o *EFUSE_Type) SetRD_KEY0_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY0_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY0_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY0_DATA7.Reg)
}

// EFUSE.RD_KEY1_DATA0: Register $n of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA0.Reg)
}

// EFUSE.RD_KEY1_DATA1: Register $n of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA1.Reg)
}

// EFUSE.RD_KEY1_DATA2: Register $n of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA2.Reg)
}

// EFUSE.RD_KEY1_DATA3: Register $n of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA3.Reg)
}

// EFUSE.RD_KEY1_DATA4: Register $n of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA4.Reg)
}

// EFUSE.RD_KEY1_DATA5: Register $n of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA5.Reg)
}

// EFUSE.RD_KEY1_DATA6: Register $n of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA6.Reg)
}

// EFUSE.RD_KEY1_DATA7: Register $n of BLOCK5 (KEY1).
func (o *EFUSE_Type) SetRD_KEY1_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY1_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY1_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY1_DATA7.Reg)
}

// EFUSE.RD_KEY2_DATA0: Register $n of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA0.Reg)
}

// EFUSE.RD_KEY2_DATA1: Register $n of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA1.Reg)
}

// EFUSE.RD_KEY2_DATA2: Register $n of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA2.Reg)
}

// EFUSE.RD_KEY2_DATA3: Register $n of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA3.Reg)
}

// EFUSE.RD_KEY2_DATA4: Register $n of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA4.Reg)
}

// EFUSE.RD_KEY2_DATA5: Register $n of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA5.Reg)
}

// EFUSE.RD_KEY2_DATA6: Register $n of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA6.Reg)
}

// EFUSE.RD_KEY2_DATA7: Register $n of BLOCK6 (KEY2).
func (o *EFUSE_Type) SetRD_KEY2_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY2_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY2_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY2_DATA7.Reg)
}

// EFUSE.RD_KEY3_DATA0: Register $n of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA0.Reg)
}

// EFUSE.RD_KEY3_DATA1: Register $n of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA1.Reg)
}

// EFUSE.RD_KEY3_DATA2: Register $n of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA2.Reg)
}

// EFUSE.RD_KEY3_DATA3: Register $n of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA3.Reg)
}

// EFUSE.RD_KEY3_DATA4: Register $n of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA4.Reg)
}

// EFUSE.RD_KEY3_DATA5: Register $n of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA5.Reg)
}

// EFUSE.RD_KEY3_DATA6: Register $n of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA6.Reg)
}

// EFUSE.RD_KEY3_DATA7: Register $n of BLOCK7 (KEY3).
func (o *EFUSE_Type) SetRD_KEY3_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY3_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY3_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY3_DATA7.Reg)
}

// EFUSE.RD_KEY4_DATA0: Register $n of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA0.Reg)
}

// EFUSE.RD_KEY4_DATA1: Register $n of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA1.Reg)
}

// EFUSE.RD_KEY4_DATA2: Register $n of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA2.Reg)
}

// EFUSE.RD_KEY4_DATA3: Register $n of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA3.Reg)
}

// EFUSE.RD_KEY4_DATA4: Register $n of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA4.Reg)
}

// EFUSE.RD_KEY4_DATA5: Register $n of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA5.Reg)
}

// EFUSE.RD_KEY4_DATA6: Register $n of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA6.Reg)
}

// EFUSE.RD_KEY4_DATA7: Register $n of BLOCK8 (KEY4).
func (o *EFUSE_Type) SetRD_KEY4_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY4_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY4_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY4_DATA7.Reg)
}

// EFUSE.RD_KEY5_DATA0: Register $n of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA0.Reg)
}

// EFUSE.RD_KEY5_DATA1: Register $n of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA1.Reg)
}

// EFUSE.RD_KEY5_DATA2: Register $n of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA2.Reg)
}

// EFUSE.RD_KEY5_DATA3: Register $n of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA3.Reg)
}

// EFUSE.RD_KEY5_DATA4: Register $n of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA4.Reg)
}

// EFUSE.RD_KEY5_DATA5: Register $n of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA5.Reg)
}

// EFUSE.RD_KEY5_DATA6: Register $n of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA6.Reg)
}

// EFUSE.RD_KEY5_DATA7: Register $n of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_KEY5_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_KEY5_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_KEY5_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_KEY5_DATA7.Reg)
}

// EFUSE.RD_SYS_PART2_DATA0: Register $n of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA0(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA0.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA0() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA0.Reg)
}

// EFUSE.RD_SYS_PART2_DATA1: Register $n of BLOCK9 (KEY5).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA1(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA1.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA1() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA1.Reg)
}

// EFUSE.RD_SYS_PART2_DATA2: Register $n of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA2(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA2.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA2() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA2.Reg)
}

// EFUSE.RD_SYS_PART2_DATA3: Register $n of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA3(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA3.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA3() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA3.Reg)
}

// EFUSE.RD_SYS_PART2_DATA4: Register $n of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA4(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA4.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA4() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA4.Reg)
}

// EFUSE.RD_SYS_PART2_DATA5: Register $n of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA5(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA5.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA5() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA5.Reg)
}

// EFUSE.RD_SYS_PART2_DATA6: Register $n of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA6(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA6.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA6() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA6.Reg)
}

// EFUSE.RD_SYS_PART2_DATA7: Register $n of BLOCK10 (system).
func (o *EFUSE_Type) SetRD_SYS_PART2_DATA7(value uint32) {
	volatile.StoreUint32(&o.RD_SYS_PART2_DATA7.Reg, value)
}
func (o *EFUSE_Type) GetRD_SYS_PART2_DATA7() uint32 {
	return volatile.LoadUint32(&o.RD_SYS_PART2_DATA7.Reg)
}

// EFUSE.RD_REPEAT_ERR0: Programming error record register 0 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_RD_DIS_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x7f)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_RD_DIS_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x7f
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_SWAP_UART_SDIO_EN_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_SWAP_UART_SDIO_EN_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_ICACHE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_ICACHE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_USB_JTAG_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_USB_JTAG_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_DOWNLOAD_ICACHE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x400)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_DOWNLOAD_ICACHE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x400) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_USB_SERIAL_JTAG_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x800)|value<<11)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_USB_SERIAL_JTAG_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x800) >> 11
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_FORCE_DOWNLOAD_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_FORCE_DOWNLOAD_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_SPI_DOWNLOAD_MSPI_DIS_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_SPI_DOWNLOAD_MSPI_DIS_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_TWAI_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x4000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_TWAI_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x4000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_JTAG_SEL_ENABLE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_JTAG_SEL_ENABLE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_SOFT_DIS_JTAG_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x70000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_SOFT_DIS_JTAG_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x70000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_PAD_JTAG_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x80000)|value<<19)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_PAD_JTAG_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x80000) >> 19
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_DIS_DOWNLOAD_MANUAL_ENCRYPT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_DIS_DOWNLOAD_MANUAL_ENCRYPT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_USB_DREFH_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x600000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_USB_DREFH_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x600000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_USB_DREFL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x1800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_USB_DREFL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x1800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_USB_EXCHG_PINS_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x2000000)|value<<25)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_USB_EXCHG_PINS_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x2000000) >> 25
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_VDD_SPI_AS_GPIO_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x4000000)|value<<26)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_VDD_SPI_AS_GPIO_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x4000000) >> 26
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_RPT4_RESERVED0_ERR_2(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x18000000)|value<<27)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_RPT4_RESERVED0_ERR_2() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x18000000) >> 27
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_RPT4_RESERVED0_ERR_1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0x20000000)|value<<29)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_RPT4_RESERVED0_ERR_1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0x20000000) >> 29
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR0_RPT4_RESERVED0_ERR_0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR0.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg)&^(0xc0000000)|value<<30)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR0_RPT4_RESERVED0_ERR_0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR0.Reg) & 0xc0000000) >> 30
}

// EFUSE.RD_REPEAT_ERR1: Programming error record register 1 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_RPT4_RESERVED1_ERR_0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_RPT4_RESERVED1_ERR_0() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xffff
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_WDT_DELAY_SEL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x30000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_WDT_DELAY_SEL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x30000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SPI_BOOT_CRYPT_CNT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x1c0000)|value<<18)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SPI_BOOT_CRYPT_CNT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x1c0000) >> 18
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE0_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE0_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE1_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x400000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE1_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x400000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE2_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0x800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_SECURE_BOOT_KEY_REVOKE2_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0x800000) >> 23
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_KEY_PURPOSE_0_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xf000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_KEY_PURPOSE_0_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xf000000) >> 24
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR1_KEY_PURPOSE_1_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR1.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR1_KEY_PURPOSE_1_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR1.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_ERR2: Programming error record register 2 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_2_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_2_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_3_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf0)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_3_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf0) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_4_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf00)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_4_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf00) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_KEY_PURPOSE_5_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_KEY_PURPOSE_5_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_SEC_DPA_LEVEL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0x30000)|value<<16)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_SEC_DPA_LEVEL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0x30000) >> 16
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_RPT4_RESERVED2_ERR_1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0x40000)|value<<18)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_RPT4_RESERVED2_ERR_1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0x40000) >> 18
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_CRYPT_DPA_ENABLE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0x80000)|value<<19)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_CRYPT_DPA_ENABLE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0x80000) >> 19
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_SECURE_BOOT_EN_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0x100000)|value<<20)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_SECURE_BOOT_EN_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0x100000) >> 20
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_SECURE_BOOT_AGGRESSIVE_REVOKE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0x200000)|value<<21)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_SECURE_BOOT_AGGRESSIVE_REVOKE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0x200000) >> 21
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_RPT4_RESERVED2_ERR_0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xfc00000)|value<<22)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_RPT4_RESERVED2_ERR_0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xfc00000) >> 22
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR2_FLASH_TPUW_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR2.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg)&^(0xf0000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR2_FLASH_TPUW_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR2.Reg) & 0xf0000000) >> 28
}

// EFUSE.RD_REPEAT_ERR3: Programming error record register 3 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_DIS_DOWNLOAD_MODE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_DIS_DOWNLOAD_MODE_ERR() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x1
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_DIS_DIRECT_BOOT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_DIS_DIRECT_BOOT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_USB_PRINT_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_USB_PRINT_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_RPT4_RESERVED3_ERR_5(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_RPT4_RESERVED3_ERR_5() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_DIS_USB_SERIAL_JTAG_DOWNLOAD_MODE_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_DIS_USB_SERIAL_JTAG_DOWNLOAD_MODE_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_ENABLE_SECURITY_DOWNLOAD_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_ENABLE_SECURITY_DOWNLOAD_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_UART_PRINT_CONTROL_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0xc0)|value<<6)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_UART_PRINT_CONTROL_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0xc0) >> 6
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_RPT4_RESERVED3_ERR_4(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_RPT4_RESERVED3_ERR_4() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_RPT4_RESERVED3_ERR_3(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_RPT4_RESERVED3_ERR_3() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_RPT4_RESERVED3_ERR_2(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0xc00)|value<<10)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_RPT4_RESERVED3_ERR_2() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0xc00) >> 10
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_RPT4_RESERVED3_ERR_1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_RPT4_RESERVED3_ERR_1() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_FORCE_SEND_RESUME_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x2000)|value<<13)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_FORCE_SEND_RESUME_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x2000) >> 13
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_SECURE_VERSION_ERR(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0x3fffc000)|value<<14)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_SECURE_VERSION_ERR() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0x3fffc000) >> 14
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR3_RPT4_RESERVED3_ERR_0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR3.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg)&^(0xc0000000)|value<<30)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR3_RPT4_RESERVED3_ERR_0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR3.Reg) & 0xc0000000) >> 30
}

// EFUSE.RD_REPEAT_ERR4: Programming error record register 4 of BLOCK0.
func (o *EFUSE_Type) SetRD_REPEAT_ERR4_RPT4_RESERVED4_ERR_1(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR4.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR4.Reg)&^(0xffffff)|value)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR4_RPT4_RESERVED4_ERR_1() uint32 {
	return volatile.LoadUint32(&o.RD_REPEAT_ERR4.Reg) & 0xffffff
}
func (o *EFUSE_Type) SetRD_REPEAT_ERR4_RPT4_RESERVED4_ERR_0(value uint32) {
	volatile.StoreUint32(&o.RD_REPEAT_ERR4.Reg, volatile.LoadUint32(&o.RD_REPEAT_ERR4.Reg)&^(0xff000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_REPEAT_ERR4_RPT4_RESERVED4_ERR_0() uint32 {
	return (volatile.LoadUint32(&o.RD_REPEAT_ERR4.Reg) & 0xff000000) >> 24
}

// EFUSE.RD_RS_ERR0: Programming error record register 0 of BLOCK1-10.
func (o *EFUSE_Type) SetRD_RS_ERR0_MAC_SPI_8M_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x7)|value)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_MAC_SPI_8M_ERR_NUM() uint32 {
	return volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x7
}
func (o *EFUSE_Type) SetRD_RS_ERR0_MAC_SPI_8M_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_MAC_SPI_8M_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_RS_ERR0_SYS_PART1_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x70)|value<<4)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_SYS_PART1_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x70) >> 4
}
func (o *EFUSE_Type) SetRD_RS_ERR0_SYS_PART1_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_SYS_PART1_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetRD_RS_ERR0_USR_DATA_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x700)|value<<8)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_USR_DATA_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x700) >> 8
}
func (o *EFUSE_Type) SetRD_RS_ERR0_USR_DATA_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x800)|value<<11)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_USR_DATA_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x800) >> 11
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY0_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x7000)|value<<12)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY0_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x7000) >> 12
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY0_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x8000)|value<<15)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY0_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x8000) >> 15
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY1_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x70000)|value<<16)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY1_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x70000) >> 16
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY1_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x80000)|value<<19)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY1_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x80000) >> 19
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY2_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x700000)|value<<20)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY2_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x700000) >> 20
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY2_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x800000)|value<<23)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY2_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x800000) >> 23
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY3_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x7000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY3_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x7000000) >> 24
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY3_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x8000000)|value<<27)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY3_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x8000000) >> 27
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY4_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x70000000)|value<<28)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY4_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x70000000) >> 28
}
func (o *EFUSE_Type) SetRD_RS_ERR0_KEY4_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR0.Reg, volatile.LoadUint32(&o.RD_RS_ERR0.Reg)&^(0x80000000)|value<<31)
}
func (o *EFUSE_Type) GetRD_RS_ERR0_KEY4_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR0.Reg) & 0x80000000) >> 31
}

// EFUSE.RD_RS_ERR1: Programming error record register 1 of BLOCK1-10.
func (o *EFUSE_Type) SetRD_RS_ERR1_KEY5_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x7)|value)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_KEY5_ERR_NUM() uint32 {
	return volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x7
}
func (o *EFUSE_Type) SetRD_RS_ERR1_KEY5_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x8)|value<<3)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_KEY5_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x8) >> 3
}
func (o *EFUSE_Type) SetRD_RS_ERR1_SYS_PART2_ERR_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x70)|value<<4)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_SYS_PART2_ERR_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x70) >> 4
}
func (o *EFUSE_Type) SetRD_RS_ERR1_SYS_PART2_FAIL(value uint32) {
	volatile.StoreUint32(&o.RD_RS_ERR1.Reg, volatile.LoadUint32(&o.RD_RS_ERR1.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetRD_RS_ERR1_SYS_PART2_FAIL() uint32 {
	return (volatile.LoadUint32(&o.RD_RS_ERR1.Reg) & 0x80) >> 7
}

// EFUSE.CLK: eFuse clcok configuration register.
func (o *EFUSE_Type) SetCLK_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetCLK_MEM_FORCE_PD() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0x1
}
func (o *EFUSE_Type) SetCLK_MEM_CLK_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetCLK_MEM_CLK_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetCLK_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x4)|value<<2)
}
func (o *EFUSE_Type) GetCLK_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x4) >> 2
}
func (o *EFUSE_Type) SetCLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x10000)|value<<16)
}
func (o *EFUSE_Type) GetCLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x10000) >> 16
}

// EFUSE.CONF: eFuse operation mode configuraiton register
func (o *EFUSE_Type) SetCONF_OP_CODE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetCONF_OP_CODE() uint32 {
	return volatile.LoadUint32(&o.CONF.Reg) & 0xffff
}

// EFUSE.STATUS: eFuse status register.
func (o *EFUSE_Type) SetSTATUS_STATE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xf)|value)
}
func (o *EFUSE_Type) GetSTATUS_STATE() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0xf
}
func (o *EFUSE_Type) SetSTATUS_OTP_LOAD_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *EFUSE_Type) GetSTATUS_OTP_LOAD_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *EFUSE_Type) SetSTATUS_OTP_VDDQ_C_SYNC2(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *EFUSE_Type) GetSTATUS_OTP_VDDQ_C_SYNC2() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *EFUSE_Type) SetSTATUS_OTP_STROBE_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *EFUSE_Type) GetSTATUS_OTP_STROBE_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *EFUSE_Type) SetSTATUS_OTP_CSB_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *EFUSE_Type) GetSTATUS_OTP_CSB_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80) >> 7
}
func (o *EFUSE_Type) SetSTATUS_OTP_PGENB_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetSTATUS_OTP_PGENB_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetSTATUS_OTP_VDDQ_IS_SW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *EFUSE_Type) GetSTATUS_OTP_VDDQ_IS_SW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *EFUSE_Type) SetSTATUS_BLK0_VALID_BIT_CNT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xffc00)|value<<10)
}
func (o *EFUSE_Type) GetSTATUS_BLK0_VALID_BIT_CNT() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xffc00) >> 10
}

// EFUSE.CMD: eFuse command register.
func (o *EFUSE_Type) SetCMD_READ_CMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetCMD_READ_CMD() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x1
}
func (o *EFUSE_Type) SetCMD_PGM_CMD(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetCMD_PGM_CMD() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x2) >> 1
}
func (o *EFUSE_Type) SetCMD_BLK_NUM(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x3c)|value<<2)
}
func (o *EFUSE_Type) GetCMD_BLK_NUM() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x3c) >> 2
}

// EFUSE.INT_RAW: eFuse raw interrupt register.
func (o *EFUSE_Type) SetINT_RAW_READ_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_RAW_READ_DONE_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.INT_RAW.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_RAW_PGM_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.INT_RAW.Reg, volatile.LoadUint32(&o.INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_RAW_PGM_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.INT_RAW.Reg) & 0x2) >> 1
}

// EFUSE.INT_ST: eFuse interrupt status register.
func (o *EFUSE_Type) SetINT_ST_READ_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_ST_READ_DONE_INT_ST() uint32 {
	return volatile.LoadUint32(&o.INT_ST.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_ST_PGM_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.INT_ST.Reg, volatile.LoadUint32(&o.INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_ST_PGM_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.INT_ST.Reg) & 0x2) >> 1
}

// EFUSE.INT_ENA: eFuse interrupt enable register.
func (o *EFUSE_Type) SetINT_ENA_READ_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_ENA_READ_DONE_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.INT_ENA.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_ENA_PGM_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.INT_ENA.Reg, volatile.LoadUint32(&o.INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_ENA_PGM_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.INT_ENA.Reg) & 0x2) >> 1
}

// EFUSE.INT_CLR: eFuse interrupt clear register.
func (o *EFUSE_Type) SetINT_CLR_READ_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetINT_CLR_READ_DONE_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.INT_CLR.Reg) & 0x1
}
func (o *EFUSE_Type) SetINT_CLR_PGM_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.INT_CLR.Reg, volatile.LoadUint32(&o.INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EFUSE_Type) GetINT_CLR_PGM_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INT_CLR.Reg) & 0x2) >> 1
}

// EFUSE.DAC_CONF: Controls the eFuse programming voltage.
func (o *EFUSE_Type) SetDAC_CONF_DAC_CLK_DIV(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_CLK_DIV() uint32 {
	return volatile.LoadUint32(&o.DAC_CONF.Reg) & 0xff
}
func (o *EFUSE_Type) SetDAC_CONF_DAC_CLK_PAD_SEL(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x100)|value<<8)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_CLK_PAD_SEL() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x100) >> 8
}
func (o *EFUSE_Type) SetDAC_CONF_DAC_NUM(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x1fe00)|value<<9)
}
func (o *EFUSE_Type) GetDAC_CONF_DAC_NUM() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x1fe00) >> 9
}
func (o *EFUSE_Type) SetDAC_CONF_OE_CLR(value uint32) {
	volatile.StoreUint32(&o.DAC_CONF.Reg, volatile.LoadUint32(&o.DAC_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *EFUSE_Type) GetDAC_CONF_OE_CLR() uint32 {
	return (volatile.LoadUint32(&o.DAC_CONF.Reg) & 0x20000) >> 17
}

// EFUSE.RD_TIM_CONF: Configures read timing parameters.
func (o *EFUSE_Type) SetRD_TIM_CONF_THR_A(value uint32) {
	volatile.StoreUint32(&o.RD_TIM_CONF.Reg, volatile.LoadUint32(&o.RD_TIM_CONF.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetRD_TIM_CONF_THR_A() uint32 {
	return volatile.LoadUint32(&o.RD_TIM_CONF.Reg) & 0xff
}
func (o *EFUSE_Type) SetRD_TIM_CONF_TRD(value uint32) {
	volatile.StoreUint32(&o.RD_TIM_CONF.Reg, volatile.LoadUint32(&o.RD_TIM_CONF.Reg)&^(0xff00)|value<<8)
}
func (o *EFUSE_Type) GetRD_TIM_CONF_TRD() uint32 {
	return (volatile.LoadUint32(&o.RD_TIM_CONF.Reg) & 0xff00) >> 8
}
func (o *EFUSE_Type) SetRD_TIM_CONF_TSUR_A(value uint32) {
	volatile.StoreUint32(&o.RD_TIM_CONF.Reg, volatile.LoadUint32(&o.RD_TIM_CONF.Reg)&^(0xff0000)|value<<16)
}
func (o *EFUSE_Type) GetRD_TIM_CONF_TSUR_A() uint32 {
	return (volatile.LoadUint32(&o.RD_TIM_CONF.Reg) & 0xff0000) >> 16
}
func (o *EFUSE_Type) SetRD_TIM_CONF_READ_INIT_NUM(value uint32) {
	volatile.StoreUint32(&o.RD_TIM_CONF.Reg, volatile.LoadUint32(&o.RD_TIM_CONF.Reg)&^(0xff000000)|value<<24)
}
func (o *EFUSE_Type) GetRD_TIM_CONF_READ_INIT_NUM() uint32 {
	return (volatile.LoadUint32(&o.RD_TIM_CONF.Reg) & 0xff000000) >> 24
}

// EFUSE.WR_TIM_CONF1: Configurarion register 1 of eFuse programming timing parameters.
func (o *EFUSE_Type) SetWR_TIM_CONF1_TSUP_A(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF1.Reg, volatile.LoadUint32(&o.WR_TIM_CONF1.Reg)&^(0xff)|value)
}
func (o *EFUSE_Type) GetWR_TIM_CONF1_TSUP_A() uint32 {
	return volatile.LoadUint32(&o.WR_TIM_CONF1.Reg) & 0xff
}
func (o *EFUSE_Type) SetWR_TIM_CONF1_PWR_ON_NUM(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF1.Reg, volatile.LoadUint32(&o.WR_TIM_CONF1.Reg)&^(0xffff00)|value<<8)
}
func (o *EFUSE_Type) GetWR_TIM_CONF1_PWR_ON_NUM() uint32 {
	return (volatile.LoadUint32(&o.WR_TIM_CONF1.Reg) & 0xffff00) >> 8
}
func (o *EFUSE_Type) SetWR_TIM_CONF1_THP_A(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF1.Reg, volatile.LoadUint32(&o.WR_TIM_CONF1.Reg)&^(0xff000000)|value<<24)
}
func (o *EFUSE_Type) GetWR_TIM_CONF1_THP_A() uint32 {
	return (volatile.LoadUint32(&o.WR_TIM_CONF1.Reg) & 0xff000000) >> 24
}

// EFUSE.WR_TIM_CONF2: Configurarion register 2 of eFuse programming timing parameters.
func (o *EFUSE_Type) SetWR_TIM_CONF2_PWR_OFF_NUM(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF2.Reg, volatile.LoadUint32(&o.WR_TIM_CONF2.Reg)&^(0xffff)|value)
}
func (o *EFUSE_Type) GetWR_TIM_CONF2_PWR_OFF_NUM() uint32 {
	return volatile.LoadUint32(&o.WR_TIM_CONF2.Reg) & 0xffff
}
func (o *EFUSE_Type) SetWR_TIM_CONF2_TPGM(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF2.Reg, volatile.LoadUint32(&o.WR_TIM_CONF2.Reg)&^(0xffff0000)|value<<16)
}
func (o *EFUSE_Type) GetWR_TIM_CONF2_TPGM() uint32 {
	return (volatile.LoadUint32(&o.WR_TIM_CONF2.Reg) & 0xffff0000) >> 16
}

// EFUSE.WR_TIM_CONF0_RS_BYPASS: Configurarion register0 of eFuse programming time parameters and rs bypass operation.
func (o *EFUSE_Type) SetWR_TIM_CONF0_RS_BYPASS_BYPASS_RS_CORRECTION(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF0_RS_BYPASS.Reg, volatile.LoadUint32(&o.WR_TIM_CONF0_RS_BYPASS.Reg)&^(0x1)|value)
}
func (o *EFUSE_Type) GetWR_TIM_CONF0_RS_BYPASS_BYPASS_RS_CORRECTION() uint32 {
	return volatile.LoadUint32(&o.WR_TIM_CONF0_RS_BYPASS.Reg) & 0x1
}
func (o *EFUSE_Type) SetWR_TIM_CONF0_RS_BYPASS_BYPASS_RS_BLK_NUM(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF0_RS_BYPASS.Reg, volatile.LoadUint32(&o.WR_TIM_CONF0_RS_BYPASS.Reg)&^(0xffe)|value<<1)
}
func (o *EFUSE_Type) GetWR_TIM_CONF0_RS_BYPASS_BYPASS_RS_BLK_NUM() uint32 {
	return (volatile.LoadUint32(&o.WR_TIM_CONF0_RS_BYPASS.Reg) & 0xffe) >> 1
}
func (o *EFUSE_Type) SetWR_TIM_CONF0_RS_BYPASS_UPDATE(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF0_RS_BYPASS.Reg, volatile.LoadUint32(&o.WR_TIM_CONF0_RS_BYPASS.Reg)&^(0x1000)|value<<12)
}
func (o *EFUSE_Type) GetWR_TIM_CONF0_RS_BYPASS_UPDATE() uint32 {
	return (volatile.LoadUint32(&o.WR_TIM_CONF0_RS_BYPASS.Reg) & 0x1000) >> 12
}
func (o *EFUSE_Type) SetWR_TIM_CONF0_RS_BYPASS_TPGM_INACTIVE(value uint32) {
	volatile.StoreUint32(&o.WR_TIM_CONF0_RS_BYPASS.Reg, volatile.LoadUint32(&o.WR_TIM_CONF0_RS_BYPASS.Reg)&^(0x1fe000)|value<<13)
}
func (o *EFUSE_Type) GetWR_TIM_CONF0_RS_BYPASS_TPGM_INACTIVE() uint32 {
	return (volatile.LoadUint32(&o.WR_TIM_CONF0_RS_BYPASS.Reg) & 0x1fe000) >> 13
}

// EFUSE.DATE: eFuse version register.
func (o *EFUSE_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *EFUSE_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// External Memory
type EXTMEM_Type struct {
	L1_ICACHE_CTRL                  volatile.Register32 // 0x0
	L1_CACHE_CTRL                   volatile.Register32 // 0x4
	L1_BYPASS_CACHE_CONF            volatile.Register32 // 0x8
	L1_CACHE_ATOMIC_CONF            volatile.Register32 // 0xC
	L1_ICACHE_CACHESIZE_CONF        volatile.Register32 // 0x10
	L1_ICACHE_BLOCKSIZE_CONF        volatile.Register32 // 0x14
	L1_CACHE_CACHESIZE_CONF         volatile.Register32 // 0x18
	L1_CACHE_BLOCKSIZE_CONF         volatile.Register32 // 0x1C
	L1_CACHE_WRAP_AROUND_CTRL       volatile.Register32 // 0x20
	L1_CACHE_TAG_MEM_POWER_CTRL     volatile.Register32 // 0x24
	L1_CACHE_DATA_MEM_POWER_CTRL    volatile.Register32 // 0x28
	L1_CACHE_FREEZE_CTRL            volatile.Register32 // 0x2C
	L1_CACHE_DATA_MEM_ACS_CONF      volatile.Register32 // 0x30
	L1_CACHE_TAG_MEM_ACS_CONF       volatile.Register32 // 0x34
	L1_ICACHE0_PRELOCK_CONF         volatile.Register32 // 0x38
	L1_ICACHE0_PRELOCK_SCT0_ADDR    volatile.Register32 // 0x3C
	L1_ICACHE0_PRELOCK_SCT1_ADDR    volatile.Register32 // 0x40
	L1_ICACHE0_PRELOCK_SCT_SIZE     volatile.Register32 // 0x44
	L1_ICACHE1_PRELOCK_CONF         volatile.Register32 // 0x48
	L1_ICACHE1_PRELOCK_SCT0_ADDR    volatile.Register32 // 0x4C
	L1_ICACHE1_PRELOCK_SCT1_ADDR    volatile.Register32 // 0x50
	L1_ICACHE1_PRELOCK_SCT_SIZE     volatile.Register32 // 0x54
	L1_ICACHE2_PRELOCK_CONF         volatile.Register32 // 0x58
	L1_ICACHE2_PRELOCK_SCT0_ADDR    volatile.Register32 // 0x5C
	L1_ICACHE2_PRELOCK_SCT1_ADDR    volatile.Register32 // 0x60
	L1_ICACHE2_PRELOCK_SCT_SIZE     volatile.Register32 // 0x64
	L1_ICACHE3_PRELOCK_CONF         volatile.Register32 // 0x68
	L1_ICACHE3_PRELOCK_SCT0_ADDR    volatile.Register32 // 0x6C
	L1_ICACHE3_PRELOCK_SCT1_ADDR    volatile.Register32 // 0x70
	L1_ICACHE3_PRELOCK_SCT_SIZE     volatile.Register32 // 0x74
	L1_CACHE_PRELOCK_CONF           volatile.Register32 // 0x78
	L1_CACHE_PRELOCK_SCT0_ADDR      volatile.Register32 // 0x7C
	L1_DCACHE_PRELOCK_SCT1_ADDR     volatile.Register32 // 0x80
	L1_DCACHE_PRELOCK_SCT_SIZE      volatile.Register32 // 0x84
	CACHE_LOCK_CTRL                 volatile.Register32 // 0x88
	CACHE_LOCK_MAP                  volatile.Register32 // 0x8C
	CACHE_LOCK_ADDR                 volatile.Register32 // 0x90
	CACHE_LOCK_SIZE                 volatile.Register32 // 0x94
	CACHE_SYNC_CTRL                 volatile.Register32 // 0x98
	CACHE_SYNC_MAP                  volatile.Register32 // 0x9C
	CACHE_SYNC_ADDR                 volatile.Register32 // 0xA0
	CACHE_SYNC_SIZE                 volatile.Register32 // 0xA4
	L1_ICACHE0_PRELOAD_CTRL         volatile.Register32 // 0xA8
	L1_ICACHE0_PRELOAD_ADDR         volatile.Register32 // 0xAC
	L1_ICACHE0_PRELOAD_SIZE         volatile.Register32 // 0xB0
	L1_ICACHE1_PRELOAD_CTRL         volatile.Register32 // 0xB4
	L1_ICACHE1_PRELOAD_ADDR         volatile.Register32 // 0xB8
	L1_ICACHE1_PRELOAD_SIZE         volatile.Register32 // 0xBC
	L1_ICACHE2_PRELOAD_CTRL         volatile.Register32 // 0xC0
	L1_ICACHE2_PRELOAD_ADDR         volatile.Register32 // 0xC4
	L1_ICACHE2_PRELOAD_SIZE         volatile.Register32 // 0xC8
	L1_ICACHE3_PRELOAD_CTRL         volatile.Register32 // 0xCC
	L1_ICACHE3_PRELOAD_ADDR         volatile.Register32 // 0xD0
	L1_ICACHE3_PRELOAD_SIZE         volatile.Register32 // 0xD4
	L1_CACHE_PRELOAD_CTRL           volatile.Register32 // 0xD8
	L1_DCACHE_PRELOAD_ADDR          volatile.Register32 // 0xDC
	L1_DCACHE_PRELOAD_SIZE          volatile.Register32 // 0xE0
	L1_ICACHE0_AUTOLOAD_CTRL        volatile.Register32 // 0xE4
	L1_ICACHE0_AUTOLOAD_SCT0_ADDR   volatile.Register32 // 0xE8
	L1_ICACHE0_AUTOLOAD_SCT0_SIZE   volatile.Register32 // 0xEC
	L1_ICACHE0_AUTOLOAD_SCT1_ADDR   volatile.Register32 // 0xF0
	L1_ICACHE0_AUTOLOAD_SCT1_SIZE   volatile.Register32 // 0xF4
	L1_ICACHE1_AUTOLOAD_CTRL        volatile.Register32 // 0xF8
	L1_ICACHE1_AUTOLOAD_SCT0_ADDR   volatile.Register32 // 0xFC
	L1_ICACHE1_AUTOLOAD_SCT0_SIZE   volatile.Register32 // 0x100
	L1_ICACHE1_AUTOLOAD_SCT1_ADDR   volatile.Register32 // 0x104
	L1_ICACHE1_AUTOLOAD_SCT1_SIZE   volatile.Register32 // 0x108
	L1_ICACHE2_AUTOLOAD_CTRL        volatile.Register32 // 0x10C
	L1_ICACHE2_AUTOLOAD_SCT0_ADDR   volatile.Register32 // 0x110
	L1_ICACHE2_AUTOLOAD_SCT0_SIZE   volatile.Register32 // 0x114
	L1_ICACHE2_AUTOLOAD_SCT1_ADDR   volatile.Register32 // 0x118
	L1_ICACHE2_AUTOLOAD_SCT1_SIZE   volatile.Register32 // 0x11C
	L1_ICACHE3_AUTOLOAD_CTRL        volatile.Register32 // 0x120
	L1_ICACHE3_AUTOLOAD_SCT0_ADDR   volatile.Register32 // 0x124
	L1_ICACHE3_AUTOLOAD_SCT0_SIZE   volatile.Register32 // 0x128
	L1_ICACHE3_AUTOLOAD_SCT1_ADDR   volatile.Register32 // 0x12C
	L1_ICACHE3_AUTOLOAD_SCT1_SIZE   volatile.Register32 // 0x130
	L1_CACHE_AUTOLOAD_CTRL          volatile.Register32 // 0x134
	L1_CACHE_AUTOLOAD_SCT0_ADDR     volatile.Register32 // 0x138
	L1_CACHE_AUTOLOAD_SCT0_SIZE     volatile.Register32 // 0x13C
	L1_CACHE_AUTOLOAD_SCT1_ADDR     volatile.Register32 // 0x140
	L1_CACHE_AUTOLOAD_SCT1_SIZE     volatile.Register32 // 0x144
	L1_CACHE_AUTOLOAD_SCT2_ADDR     volatile.Register32 // 0x148
	L1_CACHE_AUTOLOAD_SCT2_SIZE     volatile.Register32 // 0x14C
	L1_CACHE_AUTOLOAD_SCT3_ADDR     volatile.Register32 // 0x150
	L1_CACHE_AUTOLOAD_SCT3_SIZE     volatile.Register32 // 0x154
	L1_CACHE_ACS_CNT_INT_ENA        volatile.Register32 // 0x158
	L1_CACHE_ACS_CNT_INT_CLR        volatile.Register32 // 0x15C
	L1_CACHE_ACS_CNT_INT_RAW        volatile.Register32 // 0x160
	L1_CACHE_ACS_CNT_INT_ST         volatile.Register32 // 0x164
	L1_CACHE_ACS_FAIL_INT_ENA       volatile.Register32 // 0x168
	L1_CACHE_ACS_FAIL_INT_CLR       volatile.Register32 // 0x16C
	L1_CACHE_ACS_FAIL_INT_RAW       volatile.Register32 // 0x170
	L1_CACHE_ACS_FAIL_INT_ST        volatile.Register32 // 0x174
	L1_CACHE_ACS_CNT_CTRL           volatile.Register32 // 0x178
	L1_IBUS0_ACS_HIT_CNT            volatile.Register32 // 0x17C
	L1_IBUS0_ACS_MISS_CNT           volatile.Register32 // 0x180
	L1_IBUS0_ACS_CONFLICT_CNT       volatile.Register32 // 0x184
	L1_IBUS0_ACS_NXTLVL_CNT         volatile.Register32 // 0x188
	L1_IBUS1_ACS_HIT_CNT            volatile.Register32 // 0x18C
	L1_IBUS1_ACS_MISS_CNT           volatile.Register32 // 0x190
	L1_IBUS1_ACS_CONFLICT_CNT       volatile.Register32 // 0x194
	L1_IBUS1_ACS_NXTLVL_CNT         volatile.Register32 // 0x198
	L1_IBUS2_ACS_HIT_CNT            volatile.Register32 // 0x19C
	L1_IBUS2_ACS_MISS_CNT           volatile.Register32 // 0x1A0
	L1_IBUS2_ACS_CONFLICT_CNT       volatile.Register32 // 0x1A4
	L1_IBUS2_ACS_NXTLVL_CNT         volatile.Register32 // 0x1A8
	L1_IBUS3_ACS_HIT_CNT            volatile.Register32 // 0x1AC
	L1_IBUS3_ACS_MISS_CNT           volatile.Register32 // 0x1B0
	L1_IBUS3_ACS_CONFLICT_CNT       volatile.Register32 // 0x1B4
	L1_IBUS3_ACS_NXTLVL_CNT         volatile.Register32 // 0x1B8
	L1_BUS0_ACS_HIT_CNT             volatile.Register32 // 0x1BC
	L1_BUS0_ACS_MISS_CNT            volatile.Register32 // 0x1C0
	L1_BUS0_ACS_CONFLICT_CNT        volatile.Register32 // 0x1C4
	L1_BUS0_ACS_NXTLVL_CNT          volatile.Register32 // 0x1C8
	L1_BUS1_ACS_HIT_CNT             volatile.Register32 // 0x1CC
	L1_BUS1_ACS_MISS_CNT            volatile.Register32 // 0x1D0
	L1_BUS1_ACS_CONFLICT_CNT        volatile.Register32 // 0x1D4
	L1_BUS1_ACS_NXTLVL_CNT          volatile.Register32 // 0x1D8
	L1_DBUS2_ACS_HIT_CNT            volatile.Register32 // 0x1DC
	L1_DBUS2_ACS_MISS_CNT           volatile.Register32 // 0x1E0
	L1_DBUS2_ACS_CONFLICT_CNT       volatile.Register32 // 0x1E4
	L1_DBUS2_ACS_NXTLVL_CNT         volatile.Register32 // 0x1E8
	L1_DBUS3_ACS_HIT_CNT            volatile.Register32 // 0x1EC
	L1_DBUS3_ACS_MISS_CNT           volatile.Register32 // 0x1F0
	L1_DBUS3_ACS_CONFLICT_CNT       volatile.Register32 // 0x1F4
	L1_DBUS3_ACS_NXTLVL_CNT         volatile.Register32 // 0x1F8
	L1_ICACHE0_ACS_FAIL_ID_ATTR     volatile.Register32 // 0x1FC
	L1_ICACHE0_ACS_FAIL_ADDR        volatile.Register32 // 0x200
	L1_ICACHE1_ACS_FAIL_ID_ATTR     volatile.Register32 // 0x204
	L1_ICACHE1_ACS_FAIL_ADDR        volatile.Register32 // 0x208
	L1_ICACHE2_ACS_FAIL_ID_ATTR     volatile.Register32 // 0x20C
	L1_ICACHE2_ACS_FAIL_ADDR        volatile.Register32 // 0x210
	L1_ICACHE3_ACS_FAIL_ID_ATTR     volatile.Register32 // 0x214
	L1_ICACHE3_ACS_FAIL_ADDR        volatile.Register32 // 0x218
	L1_CACHE_ACS_FAIL_ID_ATTR       volatile.Register32 // 0x21C
	L1_DCACHE_ACS_FAIL_ADDR         volatile.Register32 // 0x220
	L1_CACHE_SYNC_PRELOAD_INT_ENA   volatile.Register32 // 0x224
	L1_CACHE_SYNC_PRELOAD_INT_CLR   volatile.Register32 // 0x228
	L1_CACHE_SYNC_PRELOAD_INT_RAW   volatile.Register32 // 0x22C
	L1_CACHE_SYNC_PRELOAD_INT_ST    volatile.Register32 // 0x230
	L1_CACHE_SYNC_PRELOAD_EXCEPTION volatile.Register32 // 0x234
	L1_CACHE_SYNC_RST_CTRL          volatile.Register32 // 0x238
	L1_CACHE_PRELOAD_RST_CTRL       volatile.Register32 // 0x23C
	L1_CACHE_AUTOLOAD_BUF_CLR_CTRL  volatile.Register32 // 0x240
	L1_UNALLOCATE_BUFFER_CLEAR      volatile.Register32 // 0x244
	L1_CACHE_OBJECT_CTRL            volatile.Register32 // 0x248
	L1_CACHE_WAY_OBJECT             volatile.Register32 // 0x24C
	L1_CACHE_VADDR                  volatile.Register32 // 0x250
	L1_CACHE_DEBUG_BUS              volatile.Register32 // 0x254
	LEVEL_SPLIT0                    volatile.Register32 // 0x258
	L2_CACHE_CTRL                   volatile.Register32 // 0x25C
	L2_BYPASS_CACHE_CONF            volatile.Register32 // 0x260
	L2_CACHE_CACHESIZE_CONF         volatile.Register32 // 0x264
	L2_CACHE_BLOCKSIZE_CONF         volatile.Register32 // 0x268
	L2_CACHE_WRAP_AROUND_CTRL       volatile.Register32 // 0x26C
	L2_CACHE_TAG_MEM_POWER_CTRL     volatile.Register32 // 0x270
	L2_CACHE_DATA_MEM_POWER_CTRL    volatile.Register32 // 0x274
	L2_CACHE_FREEZE_CTRL            volatile.Register32 // 0x278
	L2_CACHE_DATA_MEM_ACS_CONF      volatile.Register32 // 0x27C
	L2_CACHE_TAG_MEM_ACS_CONF       volatile.Register32 // 0x280
	L2_CACHE_PRELOCK_CONF           volatile.Register32 // 0x284
	L2_CACHE_PRELOCK_SCT0_ADDR      volatile.Register32 // 0x288
	L2_CACHE_PRELOCK_SCT1_ADDR      volatile.Register32 // 0x28C
	L2_CACHE_PRELOCK_SCT_SIZE       volatile.Register32 // 0x290
	L2_CACHE_PRELOAD_CTRL           volatile.Register32 // 0x294
	L2_CACHE_PRELOAD_ADDR           volatile.Register32 // 0x298
	L2_CACHE_PRELOAD_SIZE           volatile.Register32 // 0x29C
	L2_CACHE_AUTOLOAD_CTRL          volatile.Register32 // 0x2A0
	L2_CACHE_AUTOLOAD_SCT0_ADDR     volatile.Register32 // 0x2A4
	L2_CACHE_AUTOLOAD_SCT0_SIZE     volatile.Register32 // 0x2A8
	L2_CACHE_AUTOLOAD_SCT1_ADDR     volatile.Register32 // 0x2AC
	L2_CACHE_AUTOLOAD_SCT1_SIZE     volatile.Register32 // 0x2B0
	L2_CACHE_AUTOLOAD_SCT2_ADDR     volatile.Register32 // 0x2B4
	L2_CACHE_AUTOLOAD_SCT2_SIZE     volatile.Register32 // 0x2B8
	L2_CACHE_AUTOLOAD_SCT3_ADDR     volatile.Register32 // 0x2BC
	L2_CACHE_AUTOLOAD_SCT3_SIZE     volatile.Register32 // 0x2C0
	L2_CACHE_ACS_CNT_INT_ENA        volatile.Register32 // 0x2C4
	L2_CACHE_ACS_CNT_INT_CLR        volatile.Register32 // 0x2C8
	L2_CACHE_ACS_CNT_INT_RAW        volatile.Register32 // 0x2CC
	L2_CACHE_ACS_CNT_INT_ST         volatile.Register32 // 0x2D0
	L2_CACHE_ACS_FAIL_INT_ENA       volatile.Register32 // 0x2D4
	L2_CACHE_ACS_FAIL_INT_CLR       volatile.Register32 // 0x2D8
	L2_CACHE_ACS_FAIL_INT_RAW       volatile.Register32 // 0x2DC
	L2_CACHE_ACS_FAIL_INT_ST        volatile.Register32 // 0x2E0
	L2_CACHE_ACS_CNT_CTRL           volatile.Register32 // 0x2E4
	L2_IBUS0_ACS_HIT_CNT            volatile.Register32 // 0x2E8
	L2_IBUS0_ACS_MISS_CNT           volatile.Register32 // 0x2EC
	L2_IBUS0_ACS_CONFLICT_CNT       volatile.Register32 // 0x2F0
	L2_IBUS0_ACS_NXTLVL_CNT         volatile.Register32 // 0x2F4
	L2_IBUS1_ACS_HIT_CNT            volatile.Register32 // 0x2F8
	L2_IBUS1_ACS_MISS_CNT           volatile.Register32 // 0x2FC
	L2_IBUS1_ACS_CONFLICT_CNT       volatile.Register32 // 0x300
	L2_IBUS1_ACS_NXTLVL_CNT         volatile.Register32 // 0x304
	L2_IBUS2_ACS_HIT_CNT            volatile.Register32 // 0x308
	L2_IBUS2_ACS_MISS_CNT           volatile.Register32 // 0x30C
	L2_IBUS2_ACS_CONFLICT_CNT       volatile.Register32 // 0x310
	L2_IBUS2_ACS_NXTLVL_CNT         volatile.Register32 // 0x314
	L2_IBUS3_ACS_HIT_CNT            volatile.Register32 // 0x318
	L2_IBUS3_ACS_MISS_CNT           volatile.Register32 // 0x31C
	L2_IBUS3_ACS_CONFLICT_CNT       volatile.Register32 // 0x320
	L2_IBUS3_ACS_NXTLVL_CNT         volatile.Register32 // 0x324
	L2_DBUS0_ACS_HIT_CNT            volatile.Register32 // 0x328
	L2_DBUS0_ACS_MISS_CNT           volatile.Register32 // 0x32C
	L2_DBUS0_ACS_CONFLICT_CNT       volatile.Register32 // 0x330
	L2_DBUS0_ACS_NXTLVL_CNT         volatile.Register32 // 0x334
	L2_DBUS1_ACS_HIT_CNT            volatile.Register32 // 0x338
	L2_DBUS1_ACS_MISS_CNT           volatile.Register32 // 0x33C
	L2_DBUS1_ACS_CONFLICT_CNT       volatile.Register32 // 0x340
	L2_DBUS1_ACS_NXTLVL_CNT         volatile.Register32 // 0x344
	L2_DBUS2_ACS_HIT_CNT            volatile.Register32 // 0x348
	L2_DBUS2_ACS_MISS_CNT           volatile.Register32 // 0x34C
	L2_DBUS2_ACS_CONFLICT_CNT       volatile.Register32 // 0x350
	L2_DBUS2_ACS_NXTLVL_CNT         volatile.Register32 // 0x354
	L2_DBUS3_ACS_HIT_CNT            volatile.Register32 // 0x358
	L2_DBUS3_ACS_MISS_CNT           volatile.Register32 // 0x35C
	L2_DBUS3_ACS_CONFLICT_CNT       volatile.Register32 // 0x360
	L2_DBUS3_ACS_NXTLVL_CNT         volatile.Register32 // 0x364
	L2_CACHE_ACS_FAIL_ID_ATTR       volatile.Register32 // 0x368
	L2_CACHE_ACS_FAIL_ADDR          volatile.Register32 // 0x36C
	L2_CACHE_SYNC_PRELOAD_INT_ENA   volatile.Register32 // 0x370
	L2_CACHE_SYNC_PRELOAD_INT_CLR   volatile.Register32 // 0x374
	L2_CACHE_SYNC_PRELOAD_INT_RAW   volatile.Register32 // 0x378
	L2_CACHE_SYNC_PRELOAD_INT_ST    volatile.Register32 // 0x37C
	L2_CACHE_SYNC_PRELOAD_EXCEPTION volatile.Register32 // 0x380
	L2_CACHE_SYNC_RST_CTRL          volatile.Register32 // 0x384
	L2_CACHE_PRELOAD_RST_CTRL       volatile.Register32 // 0x388
	L2_CACHE_AUTOLOAD_BUF_CLR_CTRL  volatile.Register32 // 0x38C
	L2_UNALLOCATE_BUFFER_CLEAR      volatile.Register32 // 0x390
	L2_CACHE_ACCESS_ATTR_CTRL       volatile.Register32 // 0x394
	L2_CACHE_OBJECT_CTRL            volatile.Register32 // 0x398
	L2_CACHE_WAY_OBJECT             volatile.Register32 // 0x39C
	L2_CACHE_VADDR                  volatile.Register32 // 0x3A0
	L2_CACHE_DEBUG_BUS              volatile.Register32 // 0x3A4
	LEVEL_SPLIT1                    volatile.Register32 // 0x3A8
	CLOCK_GATE                      volatile.Register32 // 0x3AC
	REDUNDANCY_SIG0                 volatile.Register32 // 0x3B0
	REDUNDANCY_SIG1                 volatile.Register32 // 0x3B4
	REDUNDANCY_SIG2                 volatile.Register32 // 0x3B8
	REDUNDANCY_SIG3                 volatile.Register32 // 0x3BC
	REDUNDANCY_SIG4                 volatile.Register32 // 0x3C0
	_                               [56]byte
	DATE                            volatile.Register32 // 0x3FC
}

// EXTMEM.L1_ICACHE_CTRL: L1 instruction Cache(L1-ICache) control register
func (o *EXTMEM_Type) SetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS0(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS0() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS1(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS1() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS2(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS2() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS3(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CTRL_L1_ICACHE_SHUT_IBUS3() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_ICACHE_CTRL_L1_ICACHE_UNDEF_OP(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg)&^(0xf0)|value<<4)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CTRL_L1_ICACHE_UNDEF_OP() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CTRL.Reg) & 0xf0) >> 4
}

// EXTMEM.L1_CACHE_CTRL: L1 data Cache(L1-Cache) control register
func (o *EXTMEM_Type) SetL1_CACHE_CTRL_L1_CACHE_SHUT_BUS0(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_CTRL_L1_CACHE_SHUT_BUS0() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_CTRL_L1_CACHE_SHUT_BUS1(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_CTRL_L1_CACHE_SHUT_BUS1() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_CTRL_L1_CACHE_SHUT_DBUS2(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_CTRL_L1_CACHE_SHUT_DBUS2() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_CTRL_L1_CACHE_SHUT_DBUS3(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_CTRL_L1_CACHE_SHUT_DBUS3() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_CTRL_L1_CACHE_SHUT_DMA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_CTRL_L1_CACHE_SHUT_DMA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CTRL.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_CTRL_L1_CACHE_UNDEF_OP(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_CTRL.Reg)&^(0xf00)|value<<8)
}
func (o *EXTMEM_Type) GetL1_CACHE_CTRL_L1_CACHE_UNDEF_OP() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CTRL.Reg) & 0xf00) >> 8
}

// EXTMEM.L1_BYPASS_CACHE_CONF: Bypass Cache configure register
func (o *EXTMEM_Type) SetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE0_EN(value uint32) {
	volatile.StoreUint32(&o.L1_BYPASS_CACHE_CONF.Reg, volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE0_EN() uint32 {
	return volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE1_EN(value uint32) {
	volatile.StoreUint32(&o.L1_BYPASS_CACHE_CONF.Reg, volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE1_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE2_EN(value uint32) {
	volatile.StoreUint32(&o.L1_BYPASS_CACHE_CONF.Reg, volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE2_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE3_EN(value uint32) {
	volatile.StoreUint32(&o.L1_BYPASS_CACHE_CONF.Reg, volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_BYPASS_CACHE_CONF_BYPASS_L1_ICACHE3_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_BYPASS_CACHE_CONF_BYPASS_L1_DCACHE_EN(value uint32) {
	volatile.StoreUint32(&o.L1_BYPASS_CACHE_CONF.Reg, volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_BYPASS_CACHE_CONF_BYPASS_L1_DCACHE_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_BYPASS_CACHE_CONF.Reg) & 0x10) >> 4
}

// EXTMEM.L1_CACHE_ATOMIC_CONF: L1 Cache atomic feature configure register
func (o *EXTMEM_Type) SetL1_CACHE_ATOMIC_CONF_L1_CACHE_ATOMIC_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ATOMIC_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_ATOMIC_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_ATOMIC_CONF_L1_CACHE_ATOMIC_EN() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ATOMIC_CONF.Reg) & 0x1
}

// EXTMEM.L1_ICACHE_CACHESIZE_CONF: L1 instruction Cache CacheSize mode configure register
func (o *EXTMEM_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_1K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_1K() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_2K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_2K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_4K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_4K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_8K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_8K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_16K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_16K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_32K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_32K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_64K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_64K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_128K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_128K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_256K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_256K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_512K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_512K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_1024K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_1024K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_2048K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_2048K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_4096K(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL1_ICACHE_CACHESIZE_CONF_L1_ICACHE_CACHESIZE_4096K() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_CACHESIZE_CONF.Reg) & 0x1000) >> 12
}

// EXTMEM.L1_ICACHE_BLOCKSIZE_CONF: L1 instruction Cache BlockSize mode configure register
func (o *EXTMEM_Type) SetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_8(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_8() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_16(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_16() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_32(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_32() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_64(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_64() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_128(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_128() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_256(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL1_ICACHE_BLOCKSIZE_CONF_L1_ICACHE_BLOCKSIZE_256() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE_BLOCKSIZE_CONF.Reg) & 0x20) >> 5
}

// EXTMEM.L1_CACHE_CACHESIZE_CONF: L1 data Cache CacheSize mode configure register
func (o *EXTMEM_Type) SetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_1K(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_1K() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_2K(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_2K() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_4K(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_4K() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_8K(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_8K() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_16K(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_16K() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_32K(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_32K() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_64K(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_64K() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_128K(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_128K() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_256K(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_256K() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_512K(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_512K() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_1024K(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_1024K() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_2048K(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_2048K() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_4096K(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL1_CACHE_CACHESIZE_CONF_L1_CACHE_CACHESIZE_4096K() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_CACHESIZE_CONF.Reg) & 0x1000) >> 12
}

// EXTMEM.L1_CACHE_BLOCKSIZE_CONF: L1 data Cache BlockSize mode configure register
func (o *EXTMEM_Type) SetL1_CACHE_BLOCKSIZE_CONF_L1_CACHE_BLOCKSIZE_8(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_BLOCKSIZE_CONF_L1_CACHE_BLOCKSIZE_8() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_BLOCKSIZE_CONF_L1_CACHE_BLOCKSIZE_16(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_BLOCKSIZE_CONF_L1_CACHE_BLOCKSIZE_16() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_BLOCKSIZE_CONF_L1_CACHE_BLOCKSIZE_32(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_BLOCKSIZE_CONF_L1_CACHE_BLOCKSIZE_32() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_BLOCKSIZE_CONF_L1_CACHE_BLOCKSIZE_64(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_BLOCKSIZE_CONF_L1_CACHE_BLOCKSIZE_64() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_BLOCKSIZE_CONF_L1_CACHE_BLOCKSIZE_128(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_BLOCKSIZE_CONF_L1_CACHE_BLOCKSIZE_128() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_BLOCKSIZE_CONF_L1_CACHE_BLOCKSIZE_256(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL1_CACHE_BLOCKSIZE_CONF_L1_CACHE_BLOCKSIZE_256() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_BLOCKSIZE_CONF.Reg) & 0x20) >> 5
}

// EXTMEM.L1_CACHE_WRAP_AROUND_CTRL: Cache wrap around control register
func (o *EXTMEM_Type) SetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE0_WRAP(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE0_WRAP() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE1_WRAP(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE1_WRAP() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE2_WRAP(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE2_WRAP() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE3_WRAP(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_WRAP_AROUND_CTRL_L1_ICACHE3_WRAP() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_WRAP_AROUND_CTRL_L1_CACHE_WRAP(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_WRAP_AROUND_CTRL_L1_CACHE_WRAP() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_WRAP_AROUND_CTRL.Reg) & 0x10) >> 4
}

// EXTMEM.L1_CACHE_TAG_MEM_POWER_CTRL: Cache tag memory power control register
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE0_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE0_TAG_MEM_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE0_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE0_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE0_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE0_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE1_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE1_TAG_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE1_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE1_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE1_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE1_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE2_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE2_TAG_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE2_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE2_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE2_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE2_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE3_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE3_TAG_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x1000) >> 12
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE3_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE3_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x2000) >> 13
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE3_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_ICACHE3_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x4000) >> 14
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_CACHE_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_CACHE_TAG_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x10000) >> 16
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_CACHE_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_CACHE_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x20000) >> 17
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_POWER_CTRL_L1_CACHE_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_POWER_CTRL_L1_CACHE_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x40000) >> 18
}

// EXTMEM.L1_CACHE_DATA_MEM_POWER_CTRL: Cache data memory power control register
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE0_DATA_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE0_DATA_MEM_FORCE_ON() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE0_DATA_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE0_DATA_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE0_DATA_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE0_DATA_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE1_DATA_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE1_DATA_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE1_DATA_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE1_DATA_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE1_DATA_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE1_DATA_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE2_DATA_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE2_DATA_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE2_DATA_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE2_DATA_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE2_DATA_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE2_DATA_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE3_DATA_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE3_DATA_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x1000) >> 12
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE3_DATA_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE3_DATA_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x2000) >> 13
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE3_DATA_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_ICACHE3_DATA_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x4000) >> 14
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_CACHE_DATA_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_CACHE_DATA_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x10000) >> 16
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_CACHE_DATA_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_CACHE_DATA_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x20000) >> 17
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_POWER_CTRL_L1_CACHE_DATA_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_POWER_CTRL_L1_CACHE_DATA_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x40000) >> 18
}

// EXTMEM.L1_CACHE_FREEZE_CTRL: Cache Freeze control register
func (o *EXTMEM_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE0_FREEZE_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE0_FREEZE_EN() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE0_FREEZE_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE0_FREEZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE0_FREEZE_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE0_FREEZE_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE1_FREEZE_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE1_FREEZE_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE1_FREEZE_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE1_FREEZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE1_FREEZE_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE1_FREEZE_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE2_FREEZE_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE2_FREEZE_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE2_FREEZE_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE2_FREEZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE2_FREEZE_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE2_FREEZE_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE3_FREEZE_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE3_FREEZE_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x1000) >> 12
}
func (o *EXTMEM_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE3_FREEZE_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE3_FREEZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x2000) >> 13
}
func (o *EXTMEM_Type) SetL1_CACHE_FREEZE_CTRL_L1_ICACHE3_FREEZE_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *EXTMEM_Type) GetL1_CACHE_FREEZE_CTRL_L1_ICACHE3_FREEZE_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x4000) >> 14
}
func (o *EXTMEM_Type) SetL1_CACHE_FREEZE_CTRL_L1_CACHE_FREEZE_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_CACHE_FREEZE_CTRL_L1_CACHE_FREEZE_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x10000) >> 16
}
func (o *EXTMEM_Type) SetL1_CACHE_FREEZE_CTRL_L1_CACHE_FREEZE_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *EXTMEM_Type) GetL1_CACHE_FREEZE_CTRL_L1_CACHE_FREEZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x20000) >> 17
}
func (o *EXTMEM_Type) SetL1_CACHE_FREEZE_CTRL_L1_CACHE_FREEZE_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *EXTMEM_Type) GetL1_CACHE_FREEZE_CTRL_L1_CACHE_FREEZE_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_FREEZE_CTRL.Reg) & 0x40000) >> 18
}

// EXTMEM.L1_CACHE_DATA_MEM_ACS_CONF: Cache data memory access configure register
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE0_DATA_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE0_DATA_MEM_RD_EN() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE0_DATA_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE0_DATA_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE1_DATA_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE1_DATA_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE1_DATA_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE1_DATA_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE2_DATA_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE2_DATA_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE2_DATA_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE2_DATA_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE3_DATA_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE3_DATA_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x1000) >> 12
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE3_DATA_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_ICACHE3_DATA_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x2000) >> 13
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_CACHE_DATA_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_CACHE_DATA_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x10000) >> 16
}
func (o *EXTMEM_Type) SetL1_CACHE_DATA_MEM_ACS_CONF_L1_CACHE_DATA_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *EXTMEM_Type) GetL1_CACHE_DATA_MEM_ACS_CONF_L1_CACHE_DATA_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x20000) >> 17
}

// EXTMEM.L1_CACHE_TAG_MEM_ACS_CONF: Cache tag memory access configure register
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE0_TAG_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE0_TAG_MEM_RD_EN() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE0_TAG_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE0_TAG_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE1_TAG_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE1_TAG_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE1_TAG_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE1_TAG_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE2_TAG_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE2_TAG_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE2_TAG_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE2_TAG_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE3_TAG_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE3_TAG_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x1000) >> 12
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE3_TAG_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_ICACHE3_TAG_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x2000) >> 13
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_CACHE_TAG_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_CACHE_TAG_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x10000) >> 16
}
func (o *EXTMEM_Type) SetL1_CACHE_TAG_MEM_ACS_CONF_L1_CACHE_TAG_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *EXTMEM_Type) GetL1_CACHE_TAG_MEM_ACS_CONF_L1_CACHE_TAG_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x20000) >> 17
}

// EXTMEM.L1_ICACHE0_PRELOCK_CONF: L1 instruction Cache 0 prelock configure register
func (o *EXTMEM_Type) SetL1_ICACHE0_PRELOCK_CONF_L1_ICACHE0_PRELOCK_SCT0_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_PRELOCK_CONF_L1_ICACHE0_PRELOCK_SCT0_EN() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_ICACHE0_PRELOCK_CONF_L1_ICACHE0_PRELOCK_SCT1_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_PRELOCK_CONF_L1_ICACHE0_PRELOCK_SCT1_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_ICACHE0_PRELOCK_CONF_L1_ICACHE0_PRELOCK_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg)&^(0x3c)|value<<2)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_PRELOCK_CONF_L1_ICACHE0_PRELOCK_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_CONF.Reg) & 0x3c) >> 2
}

// EXTMEM.L1_ICACHE0_PRELOCK_SCT0_ADDR: L1 instruction Cache 0 prelock section0 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE0_PRELOCK_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOCK_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_PRELOCK_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_SCT0_ADDR.Reg)
}

// EXTMEM.L1_ICACHE0_PRELOCK_SCT1_ADDR: L1 instruction Cache 0 prelock section1 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE0_PRELOCK_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOCK_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_PRELOCK_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_SCT1_ADDR.Reg)
}

// EXTMEM.L1_ICACHE0_PRELOCK_SCT_SIZE: L1 instruction Cache 0 prelock section size configure register
func (o *EXTMEM_Type) SetL1_ICACHE0_PRELOCK_SCT_SIZE_L1_ICACHE0_PRELOCK_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_SCT_SIZE.Reg)&^(0x3fff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_PRELOCK_SCT_SIZE_L1_ICACHE0_PRELOCK_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_SCT_SIZE.Reg) & 0x3fff
}
func (o *EXTMEM_Type) SetL1_ICACHE0_PRELOCK_SCT_SIZE_L1_ICACHE0_PRELOCK_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_SCT_SIZE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_PRELOCK_SCT_SIZE_L1_ICACHE0_PRELOCK_SCT1_SIZE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_PRELOCK_SCT_SIZE.Reg) & 0x3fff0000) >> 16
}

// EXTMEM.L1_ICACHE1_PRELOCK_CONF: L1 instruction Cache 1 prelock configure register
func (o *EXTMEM_Type) SetL1_ICACHE1_PRELOCK_CONF_L1_ICACHE1_PRELOCK_SCT0_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_PRELOCK_CONF_L1_ICACHE1_PRELOCK_SCT0_EN() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_ICACHE1_PRELOCK_CONF_L1_ICACHE1_PRELOCK_SCT1_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_PRELOCK_CONF_L1_ICACHE1_PRELOCK_SCT1_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_ICACHE1_PRELOCK_CONF_L1_ICACHE1_PRELOCK_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg)&^(0x3c)|value<<2)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_PRELOCK_CONF_L1_ICACHE1_PRELOCK_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_CONF.Reg) & 0x3c) >> 2
}

// EXTMEM.L1_ICACHE1_PRELOCK_SCT0_ADDR: L1 instruction Cache 1 prelock section0 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE1_PRELOCK_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOCK_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_PRELOCK_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_SCT0_ADDR.Reg)
}

// EXTMEM.L1_ICACHE1_PRELOCK_SCT1_ADDR: L1 instruction Cache 1 prelock section1 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE1_PRELOCK_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOCK_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_PRELOCK_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_SCT1_ADDR.Reg)
}

// EXTMEM.L1_ICACHE1_PRELOCK_SCT_SIZE: L1 instruction Cache 1 prelock section size configure register
func (o *EXTMEM_Type) SetL1_ICACHE1_PRELOCK_SCT_SIZE_L1_ICACHE1_PRELOCK_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_SCT_SIZE.Reg)&^(0x3fff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_PRELOCK_SCT_SIZE_L1_ICACHE1_PRELOCK_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_SCT_SIZE.Reg) & 0x3fff
}
func (o *EXTMEM_Type) SetL1_ICACHE1_PRELOCK_SCT_SIZE_L1_ICACHE1_PRELOCK_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_SCT_SIZE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_PRELOCK_SCT_SIZE_L1_ICACHE1_PRELOCK_SCT1_SIZE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_PRELOCK_SCT_SIZE.Reg) & 0x3fff0000) >> 16
}

// EXTMEM.L1_ICACHE2_PRELOCK_CONF: L1 instruction Cache 2 prelock configure register
func (o *EXTMEM_Type) SetL1_ICACHE2_PRELOCK_CONF_L1_ICACHE2_PRELOCK_SCT0_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_PRELOCK_CONF_L1_ICACHE2_PRELOCK_SCT0_EN() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_ICACHE2_PRELOCK_CONF_L1_ICACHE2_PRELOCK_SCT1_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_PRELOCK_CONF_L1_ICACHE2_PRELOCK_SCT1_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_ICACHE2_PRELOCK_CONF_L1_ICACHE2_PRELOCK_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg)&^(0x3c)|value<<2)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_PRELOCK_CONF_L1_ICACHE2_PRELOCK_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_CONF.Reg) & 0x3c) >> 2
}

// EXTMEM.L1_ICACHE2_PRELOCK_SCT0_ADDR: L1 instruction Cache 2 prelock section0 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE2_PRELOCK_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOCK_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_PRELOCK_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_SCT0_ADDR.Reg)
}

// EXTMEM.L1_ICACHE2_PRELOCK_SCT1_ADDR: L1 instruction Cache 2 prelock section1 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE2_PRELOCK_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOCK_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_PRELOCK_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_SCT1_ADDR.Reg)
}

// EXTMEM.L1_ICACHE2_PRELOCK_SCT_SIZE: L1 instruction Cache 2 prelock section size configure register
func (o *EXTMEM_Type) SetL1_ICACHE2_PRELOCK_SCT_SIZE_L1_ICACHE2_PRELOCK_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_SCT_SIZE.Reg)&^(0x3fff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_PRELOCK_SCT_SIZE_L1_ICACHE2_PRELOCK_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_SCT_SIZE.Reg) & 0x3fff
}
func (o *EXTMEM_Type) SetL1_ICACHE2_PRELOCK_SCT_SIZE_L1_ICACHE2_PRELOCK_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_SCT_SIZE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_PRELOCK_SCT_SIZE_L1_ICACHE2_PRELOCK_SCT1_SIZE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_PRELOCK_SCT_SIZE.Reg) & 0x3fff0000) >> 16
}

// EXTMEM.L1_ICACHE3_PRELOCK_CONF: L1 instruction Cache 3 prelock configure register
func (o *EXTMEM_Type) SetL1_ICACHE3_PRELOCK_CONF_L1_ICACHE3_PRELOCK_SCT0_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_PRELOCK_CONF_L1_ICACHE3_PRELOCK_SCT0_EN() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_ICACHE3_PRELOCK_CONF_L1_ICACHE3_PRELOCK_SCT1_EN(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_PRELOCK_CONF_L1_ICACHE3_PRELOCK_SCT1_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_ICACHE3_PRELOCK_CONF_L1_ICACHE3_PRELOCK_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg)&^(0x3c)|value<<2)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_PRELOCK_CONF_L1_ICACHE3_PRELOCK_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_CONF.Reg) & 0x3c) >> 2
}

// EXTMEM.L1_ICACHE3_PRELOCK_SCT0_ADDR: L1 instruction Cache 3 prelock section0 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE3_PRELOCK_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOCK_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_PRELOCK_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_SCT0_ADDR.Reg)
}

// EXTMEM.L1_ICACHE3_PRELOCK_SCT1_ADDR: L1 instruction Cache 3 prelock section1 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE3_PRELOCK_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOCK_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_PRELOCK_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_SCT1_ADDR.Reg)
}

// EXTMEM.L1_ICACHE3_PRELOCK_SCT_SIZE: L1 instruction Cache 3 prelock section size configure register
func (o *EXTMEM_Type) SetL1_ICACHE3_PRELOCK_SCT_SIZE_L1_ICACHE3_PRELOCK_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_SCT_SIZE.Reg)&^(0x3fff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_PRELOCK_SCT_SIZE_L1_ICACHE3_PRELOCK_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_SCT_SIZE.Reg) & 0x3fff
}
func (o *EXTMEM_Type) SetL1_ICACHE3_PRELOCK_SCT_SIZE_L1_ICACHE3_PRELOCK_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_SCT_SIZE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_PRELOCK_SCT_SIZE_L1_ICACHE3_PRELOCK_SCT1_SIZE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_PRELOCK_SCT_SIZE.Reg) & 0x3fff0000) >> 16
}

// EXTMEM.L1_CACHE_PRELOCK_CONF: L1 Cache prelock configure register
func (o *EXTMEM_Type) SetL1_CACHE_PRELOCK_CONF_L1_CACHE_PRELOCK_SCT0_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOCK_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_PRELOCK_CONF_L1_CACHE_PRELOCK_SCT0_EN() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_PRELOCK_CONF.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_PRELOCK_CONF_L1_CACHE_PRELOCK_SCT1_EN(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOCK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_PRELOCK_CONF_L1_CACHE_PRELOCK_SCT1_EN() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_PRELOCK_CONF.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_PRELOCK_CONF_L1_CACHE_PRELOCK_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOCK_CONF.Reg)&^(0x3c)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_PRELOCK_CONF_L1_CACHE_PRELOCK_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_PRELOCK_CONF.Reg) & 0x3c) >> 2
}

// EXTMEM.L1_CACHE_PRELOCK_SCT0_ADDR: L1 Cache prelock section0 address configure register
func (o *EXTMEM_Type) SetL1_CACHE_PRELOCK_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOCK_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_CACHE_PRELOCK_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_PRELOCK_SCT0_ADDR.Reg)
}

// EXTMEM.L1_DCACHE_PRELOCK_SCT1_ADDR: L1 Cache prelock section1 address configure register
func (o *EXTMEM_Type) SetL1_DCACHE_PRELOCK_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOCK_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_DCACHE_PRELOCK_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_SCT1_ADDR.Reg)
}

// EXTMEM.L1_DCACHE_PRELOCK_SCT_SIZE: L1 Cache prelock section size configure register
func (o *EXTMEM_Type) SetL1_DCACHE_PRELOCK_SCT_SIZE_L1_CACHE_PRELOCK_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_SCT_SIZE.Reg)&^(0x3fff)|value)
}
func (o *EXTMEM_Type) GetL1_DCACHE_PRELOCK_SCT_SIZE_L1_CACHE_PRELOCK_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_SCT_SIZE.Reg) & 0x3fff
}
func (o *EXTMEM_Type) SetL1_DCACHE_PRELOCK_SCT_SIZE_L1_CACHE_PRELOCK_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_SCT_SIZE.Reg)&^(0x3fff0000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_DCACHE_PRELOCK_SCT_SIZE_L1_CACHE_PRELOCK_SCT1_SIZE() uint32 {
	return (volatile.LoadUint32(&o.L1_DCACHE_PRELOCK_SCT_SIZE.Reg) & 0x3fff0000) >> 16
}

// EXTMEM.CACHE_LOCK_CTRL: Lock-class (manual lock) operation control register
func (o *EXTMEM_Type) SetCACHE_LOCK_CTRL_CACHE_LOCK_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_LOCK_CTRL.Reg, volatile.LoadUint32(&o.CACHE_LOCK_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_LOCK_CTRL_CACHE_LOCK_ENA() uint32 {
	return volatile.LoadUint32(&o.CACHE_LOCK_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_LOCK_CTRL_CACHE_UNLOCK_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_LOCK_CTRL.Reg, volatile.LoadUint32(&o.CACHE_LOCK_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_LOCK_CTRL_CACHE_UNLOCK_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_LOCK_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_LOCK_CTRL_CACHE_LOCK_DONE(value uint32) {
	volatile.StoreUint32(&o.CACHE_LOCK_CTRL.Reg, volatile.LoadUint32(&o.CACHE_LOCK_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_LOCK_CTRL_CACHE_LOCK_DONE() uint32 {
	return (volatile.LoadUint32(&o.CACHE_LOCK_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCACHE_LOCK_CTRL_CACHE_LOCK_RGID(value uint32) {
	volatile.StoreUint32(&o.CACHE_LOCK_CTRL.Reg, volatile.LoadUint32(&o.CACHE_LOCK_CTRL.Reg)&^(0x78)|value<<3)
}
func (o *EXTMEM_Type) GetCACHE_LOCK_CTRL_CACHE_LOCK_RGID() uint32 {
	return (volatile.LoadUint32(&o.CACHE_LOCK_CTRL.Reg) & 0x78) >> 3
}

// EXTMEM.CACHE_LOCK_MAP: Lock (manual lock) map configure register
func (o *EXTMEM_Type) SetCACHE_LOCK_MAP(value uint32) {
	volatile.StoreUint32(&o.CACHE_LOCK_MAP.Reg, volatile.LoadUint32(&o.CACHE_LOCK_MAP.Reg)&^(0x3f)|value)
}
func (o *EXTMEM_Type) GetCACHE_LOCK_MAP() uint32 {
	return volatile.LoadUint32(&o.CACHE_LOCK_MAP.Reg) & 0x3f
}

// EXTMEM.CACHE_LOCK_ADDR: Lock (manual lock) address configure register
func (o *EXTMEM_Type) SetCACHE_LOCK_ADDR(value uint32) {
	volatile.StoreUint32(&o.CACHE_LOCK_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetCACHE_LOCK_ADDR() uint32 {
	return volatile.LoadUint32(&o.CACHE_LOCK_ADDR.Reg)
}

// EXTMEM.CACHE_LOCK_SIZE: Lock (manual lock) size configure register
func (o *EXTMEM_Type) SetCACHE_LOCK_SIZE(value uint32) {
	volatile.StoreUint32(&o.CACHE_LOCK_SIZE.Reg, volatile.LoadUint32(&o.CACHE_LOCK_SIZE.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetCACHE_LOCK_SIZE() uint32 {
	return volatile.LoadUint32(&o.CACHE_LOCK_SIZE.Reg) & 0xffff
}

// EXTMEM.CACHE_SYNC_CTRL: Sync-class operation control register
func (o *EXTMEM_Type) SetCACHE_SYNC_CTRL_CACHE_INVALIDATE_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_CTRL_CACHE_INVALIDATE_ENA() uint32 {
	return volatile.LoadUint32(&o.CACHE_SYNC_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetCACHE_SYNC_CTRL_CACHE_CLEAN_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_CTRL_CACHE_CLEAN_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetCACHE_SYNC_CTRL_CACHE_WRITEBACK_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_CTRL_CACHE_WRITEBACK_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetCACHE_SYNC_CTRL_CACHE_WRITEBACK_INVALIDATE_ENA(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_CTRL_CACHE_WRITEBACK_INVALIDATE_ENA() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetCACHE_SYNC_CTRL_CACHE_SYNC_DONE(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_CTRL_CACHE_SYNC_DONE() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_CTRL.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetCACHE_SYNC_CTRL_CACHE_SYNC_RGID(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_CTRL.Reg, volatile.LoadUint32(&o.CACHE_SYNC_CTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_CTRL_CACHE_SYNC_RGID() uint32 {
	return (volatile.LoadUint32(&o.CACHE_SYNC_CTRL.Reg) & 0x1e0) >> 5
}

// EXTMEM.CACHE_SYNC_MAP: Sync map configure register
func (o *EXTMEM_Type) SetCACHE_SYNC_MAP(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_MAP.Reg, volatile.LoadUint32(&o.CACHE_SYNC_MAP.Reg)&^(0x3f)|value)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_MAP() uint32 {
	return volatile.LoadUint32(&o.CACHE_SYNC_MAP.Reg) & 0x3f
}

// EXTMEM.CACHE_SYNC_ADDR: Sync address configure register
func (o *EXTMEM_Type) SetCACHE_SYNC_ADDR(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_ADDR() uint32 {
	return volatile.LoadUint32(&o.CACHE_SYNC_ADDR.Reg)
}

// EXTMEM.CACHE_SYNC_SIZE: Sync size configure register
func (o *EXTMEM_Type) SetCACHE_SYNC_SIZE(value uint32) {
	volatile.StoreUint32(&o.CACHE_SYNC_SIZE.Reg, volatile.LoadUint32(&o.CACHE_SYNC_SIZE.Reg)&^(0xffffff)|value)
}
func (o *EXTMEM_Type) GetCACHE_SYNC_SIZE() uint32 {
	return volatile.LoadUint32(&o.CACHE_SYNC_SIZE.Reg) & 0xffffff
}

// EXTMEM.L1_ICACHE0_PRELOAD_CTRL: L1 instruction Cache 0 preload-operation control register
func (o *EXTMEM_Type) SetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg)&^(0x78)|value<<3)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_PRELOAD_CTRL_L1_ICACHE0_PRELOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_CTRL.Reg) & 0x78) >> 3
}

// EXTMEM.L1_ICACHE0_PRELOAD_ADDR: L1 instruction Cache 0 preload address configure register
func (o *EXTMEM_Type) SetL1_ICACHE0_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOAD_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_ADDR.Reg)
}

// EXTMEM.L1_ICACHE0_PRELOAD_SIZE: L1 instruction Cache 0 preload size configure register
func (o *EXTMEM_Type) SetL1_ICACHE0_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_SIZE.Reg)&^(0x3fff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_PRELOAD_SIZE.Reg) & 0x3fff
}

// EXTMEM.L1_ICACHE1_PRELOAD_CTRL: L1 instruction Cache 1 preload-operation control register
func (o *EXTMEM_Type) SetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg)&^(0x78)|value<<3)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_PRELOAD_CTRL_L1_ICACHE1_PRELOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_CTRL.Reg) & 0x78) >> 3
}

// EXTMEM.L1_ICACHE1_PRELOAD_ADDR: L1 instruction Cache 1 preload address configure register
func (o *EXTMEM_Type) SetL1_ICACHE1_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOAD_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_ADDR.Reg)
}

// EXTMEM.L1_ICACHE1_PRELOAD_SIZE: L1 instruction Cache 1 preload size configure register
func (o *EXTMEM_Type) SetL1_ICACHE1_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_SIZE.Reg)&^(0x3fff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_PRELOAD_SIZE.Reg) & 0x3fff
}

// EXTMEM.L1_ICACHE2_PRELOAD_CTRL: L1 instruction Cache 2 preload-operation control register
func (o *EXTMEM_Type) SetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg)&^(0x78)|value<<3)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_PRELOAD_CTRL_L1_ICACHE2_PRELOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_CTRL.Reg) & 0x78) >> 3
}

// EXTMEM.L1_ICACHE2_PRELOAD_ADDR: L1 instruction Cache 2 preload address configure register
func (o *EXTMEM_Type) SetL1_ICACHE2_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOAD_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_ADDR.Reg)
}

// EXTMEM.L1_ICACHE2_PRELOAD_SIZE: L1 instruction Cache 2 preload size configure register
func (o *EXTMEM_Type) SetL1_ICACHE2_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_SIZE.Reg)&^(0x3fff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_PRELOAD_SIZE.Reg) & 0x3fff
}

// EXTMEM.L1_ICACHE3_PRELOAD_CTRL: L1 instruction Cache 3 preload-operation control register
func (o *EXTMEM_Type) SetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg)&^(0x78)|value<<3)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_PRELOAD_CTRL_L1_ICACHE3_PRELOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_CTRL.Reg) & 0x78) >> 3
}

// EXTMEM.L1_ICACHE3_PRELOAD_ADDR: L1 instruction Cache 3 preload address configure register
func (o *EXTMEM_Type) SetL1_ICACHE3_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOAD_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_ADDR.Reg)
}

// EXTMEM.L1_ICACHE3_PRELOAD_SIZE: L1 instruction Cache 3 preload size configure register
func (o *EXTMEM_Type) SetL1_ICACHE3_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_SIZE.Reg)&^(0x3fff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_PRELOAD_SIZE.Reg) & 0x3fff
}

// EXTMEM.L1_CACHE_PRELOAD_CTRL: L1 Cache preload-operation control register
func (o *EXTMEM_Type) SetL1_CACHE_PRELOAD_CTRL_L1_CACHE_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_PRELOAD_CTRL_L1_CACHE_PRELOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_PRELOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_PRELOAD_CTRL_L1_CACHE_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_PRELOAD_CTRL_L1_CACHE_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_PRELOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_PRELOAD_CTRL_L1_CACHE_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_PRELOAD_CTRL_L1_CACHE_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_PRELOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_PRELOAD_CTRL_L1_CACHE_PRELOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOAD_CTRL.Reg)&^(0x78)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_PRELOAD_CTRL_L1_CACHE_PRELOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_PRELOAD_CTRL.Reg) & 0x78) >> 3
}

// EXTMEM.L1_DCACHE_PRELOAD_ADDR: L1 Cache preload address configure register
func (o *EXTMEM_Type) SetL1_DCACHE_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOAD_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_DCACHE_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_PRELOAD_ADDR.Reg)
}

// EXTMEM.L1_DCACHE_PRELOAD_SIZE: L1 Cache preload size configure register
func (o *EXTMEM_Type) SetL1_DCACHE_PRELOAD_SIZE_L1_CACHE_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.L1_DCACHE_PRELOAD_SIZE.Reg)&^(0x3fff)|value)
}
func (o *EXTMEM_Type) GetL1_DCACHE_PRELOAD_SIZE_L1_CACHE_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_PRELOAD_SIZE.Reg) & 0x3fff
}

// EXTMEM.L1_ICACHE0_AUTOLOAD_CTRL: L1 instruction Cache 0 autoload-operation control register
func (o *EXTMEM_Type) SetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_TRIGGER_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg)&^(0x18)|value<<3)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_TRIGGER_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg) & 0x18) >> 3
}
func (o *EXTMEM_Type) SetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_SCT0_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg)&^(0x3c00)|value<<10)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_AUTOLOAD_CTRL_L1_ICACHE0_AUTOLOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_CTRL.Reg) & 0x3c00) >> 10
}

// EXTMEM.L1_ICACHE0_AUTOLOAD_SCT0_ADDR: L1 instruction Cache 0 autoload section 0 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE0_AUTOLOAD_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_AUTOLOAD_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_SCT0_ADDR.Reg)
}

// EXTMEM.L1_ICACHE0_AUTOLOAD_SCT0_SIZE: L1 instruction Cache 0 autoload section 0 size configure register
func (o *EXTMEM_Type) SetL1_ICACHE0_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_SCT0_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_SCT0_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_SCT0_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L1_ICACHE0_AUTOLOAD_SCT1_ADDR: L1 instruction Cache 0 autoload section 1 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE0_AUTOLOAD_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_AUTOLOAD_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_SCT1_ADDR.Reg)
}

// EXTMEM.L1_ICACHE0_AUTOLOAD_SCT1_SIZE: L1 instruction Cache 0 autoload section 1 size configure register
func (o *EXTMEM_Type) SetL1_ICACHE0_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_AUTOLOAD_SCT1_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_SCT1_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_AUTOLOAD_SCT1_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L1_ICACHE1_AUTOLOAD_CTRL: L1 instruction Cache 1 autoload-operation control register
func (o *EXTMEM_Type) SetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_TRIGGER_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg)&^(0x18)|value<<3)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_TRIGGER_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg) & 0x18) >> 3
}
func (o *EXTMEM_Type) SetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_SCT0_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg)&^(0x3c00)|value<<10)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_AUTOLOAD_CTRL_L1_ICACHE1_AUTOLOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_CTRL.Reg) & 0x3c00) >> 10
}

// EXTMEM.L1_ICACHE1_AUTOLOAD_SCT0_ADDR: L1 instruction Cache 1 autoload section 0 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE1_AUTOLOAD_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_AUTOLOAD_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_SCT0_ADDR.Reg)
}

// EXTMEM.L1_ICACHE1_AUTOLOAD_SCT0_SIZE: L1 instruction Cache 1 autoload section 0 size configure register
func (o *EXTMEM_Type) SetL1_ICACHE1_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_SCT0_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_SCT0_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_SCT0_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L1_ICACHE1_AUTOLOAD_SCT1_ADDR: L1 instruction Cache 1 autoload section 1 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE1_AUTOLOAD_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_AUTOLOAD_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_SCT1_ADDR.Reg)
}

// EXTMEM.L1_ICACHE1_AUTOLOAD_SCT1_SIZE: L1 instruction Cache 1 autoload section 1 size configure register
func (o *EXTMEM_Type) SetL1_ICACHE1_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_AUTOLOAD_SCT1_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_SCT1_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_AUTOLOAD_SCT1_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L1_ICACHE2_AUTOLOAD_CTRL: L1 instruction Cache 2 autoload-operation control register
func (o *EXTMEM_Type) SetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_TRIGGER_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg)&^(0x18)|value<<3)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_TRIGGER_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg) & 0x18) >> 3
}
func (o *EXTMEM_Type) SetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_SCT0_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg)&^(0x3c00)|value<<10)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_AUTOLOAD_CTRL_L1_ICACHE2_AUTOLOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_CTRL.Reg) & 0x3c00) >> 10
}

// EXTMEM.L1_ICACHE2_AUTOLOAD_SCT0_ADDR: L1 instruction Cache 2 autoload section 0 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE2_AUTOLOAD_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_AUTOLOAD_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_SCT0_ADDR.Reg)
}

// EXTMEM.L1_ICACHE2_AUTOLOAD_SCT0_SIZE: L1 instruction Cache 2 autoload section 0 size configure register
func (o *EXTMEM_Type) SetL1_ICACHE2_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_SCT0_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_SCT0_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_SCT0_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L1_ICACHE2_AUTOLOAD_SCT1_ADDR: L1 instruction Cache 2 autoload section 1 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE2_AUTOLOAD_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_AUTOLOAD_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_SCT1_ADDR.Reg)
}

// EXTMEM.L1_ICACHE2_AUTOLOAD_SCT1_SIZE: L1 instruction Cache 2 autoload section 1 size configure register
func (o *EXTMEM_Type) SetL1_ICACHE2_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_AUTOLOAD_SCT1_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_SCT1_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_AUTOLOAD_SCT1_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L1_ICACHE3_AUTOLOAD_CTRL: L1 instruction Cache 3 autoload-operation control register
func (o *EXTMEM_Type) SetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_TRIGGER_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg)&^(0x18)|value<<3)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_TRIGGER_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg) & 0x18) >> 3
}
func (o *EXTMEM_Type) SetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_SCT0_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg)&^(0x3c00)|value<<10)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_AUTOLOAD_CTRL_L1_ICACHE3_AUTOLOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_CTRL.Reg) & 0x3c00) >> 10
}

// EXTMEM.L1_ICACHE3_AUTOLOAD_SCT0_ADDR: L1 instruction Cache 3 autoload section 0 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE3_AUTOLOAD_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_AUTOLOAD_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_SCT0_ADDR.Reg)
}

// EXTMEM.L1_ICACHE3_AUTOLOAD_SCT0_SIZE: L1 instruction Cache 3 autoload section 0 size configure register
func (o *EXTMEM_Type) SetL1_ICACHE3_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_SCT0_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_SCT0_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_SCT0_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L1_ICACHE3_AUTOLOAD_SCT1_ADDR: L1 instruction Cache 3 autoload section 1 address configure register
func (o *EXTMEM_Type) SetL1_ICACHE3_AUTOLOAD_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_AUTOLOAD_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_SCT1_ADDR.Reg)
}

// EXTMEM.L1_ICACHE3_AUTOLOAD_SCT1_SIZE: L1 instruction Cache 3 autoload section 1 size configure register
func (o *EXTMEM_Type) SetL1_ICACHE3_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_AUTOLOAD_SCT1_SIZE.Reg, volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_SCT1_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_AUTOLOAD_SCT1_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L1_CACHE_AUTOLOAD_CTRL: L1 Cache autoload-operation control register
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_TRIGGER_MODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg)&^(0x18)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_TRIGGER_MODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg) & 0x18) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_SCT0_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_SCT2_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_SCT2_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_SCT3_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_SCT3_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg)&^(0xf000)|value<<12)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_CTRL_L1_CACHE_AUTOLOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_CTRL.Reg) & 0xf000) >> 12
}

// EXTMEM.L1_CACHE_AUTOLOAD_SCT0_ADDR: L1 Cache autoload section 0 address configure register
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_SCT0_ADDR.Reg)
}

// EXTMEM.L1_CACHE_AUTOLOAD_SCT0_SIZE: L1 Cache autoload section 0 size configure register
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_SCT0_SIZE.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_SCT0_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_SCT0_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L1_CACHE_AUTOLOAD_SCT1_ADDR: L1 Cache autoload section 1 address configure register
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_SCT1_ADDR.Reg)
}

// EXTMEM.L1_CACHE_AUTOLOAD_SCT1_SIZE: L1 Cache autoload section 1 size configure register
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_SCT1_SIZE.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_SCT1_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_SCT1_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L1_CACHE_AUTOLOAD_SCT2_ADDR: L1 Cache autoload section 2 address configure register
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_SCT2_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_SCT2_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_SCT2_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_SCT2_ADDR.Reg)
}

// EXTMEM.L1_CACHE_AUTOLOAD_SCT2_SIZE: L1 Cache autoload section 2 size configure register
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_SCT2_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_SCT2_SIZE.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_SCT2_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_SCT2_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_SCT2_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L1_CACHE_AUTOLOAD_SCT3_ADDR: L1 Cache autoload section 1 address configure register
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_SCT3_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_SCT3_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_SCT3_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_SCT3_ADDR.Reg)
}

// EXTMEM.L1_CACHE_AUTOLOAD_SCT3_SIZE: L1 Cache autoload section 1 size configure register
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_SCT3_SIZE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_SCT3_SIZE.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_SCT3_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_SCT3_SIZE() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_SCT3_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L1_CACHE_ACS_CNT_INT_ENA: Cache Access Counter Interrupt enable register
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS0_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS0_OVF_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS1_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS1_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS2_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS2_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS3_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_IBUS3_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_BUS0_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_BUS0_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_BUS1_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_BUS1_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_DBUS2_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_DBUS2_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ENA_L1_DBUS3_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ENA_L1_DBUS3_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ENA.Reg) & 0x80) >> 7
}

// EXTMEM.L1_CACHE_ACS_CNT_INT_CLR: Cache Access Counter Interrupt clear register
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS0_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS0_OVF_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS1_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS1_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS2_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS2_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS3_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_IBUS3_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_BUS0_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_BUS0_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_BUS1_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_BUS1_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_DBUS2_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_DBUS2_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_CLR_L1_DBUS3_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_CLR_L1_DBUS3_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_CLR.Reg) & 0x80) >> 7
}

// EXTMEM.L1_CACHE_ACS_CNT_INT_RAW: Cache Access Counter Interrupt raw register
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS0_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS0_OVF_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS1_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS1_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS2_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS2_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS3_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_IBUS3_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_BUS0_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_BUS0_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_BUS1_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_BUS1_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_DBUS2_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_DBUS2_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_RAW_L1_DBUS3_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_RAW_L1_DBUS3_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_RAW.Reg) & 0x80) >> 7
}

// EXTMEM.L1_CACHE_ACS_CNT_INT_ST: Cache Access Counter Interrupt status register
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS0_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS0_OVF_INT_ST() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS1_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS1_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS2_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS2_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS3_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_IBUS3_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_BUS0_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_BUS0_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_BUS1_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_BUS1_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_DBUS2_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_DBUS2_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_INT_ST_L1_DBUS3_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_INT_ST_L1_DBUS3_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_INT_ST.Reg) & 0x80) >> 7
}

// EXTMEM.L1_CACHE_ACS_FAIL_INT_ENA: Cache Access Fail Interrupt enable register
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE0_FAIL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE0_FAIL_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE1_FAIL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE1_FAIL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE2_FAIL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE2_FAIL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE3_FAIL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_ENA_L1_ICACHE3_FAIL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_ENA_L1_CACHE_FAIL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_ENA_L1_CACHE_FAIL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ENA.Reg) & 0x10) >> 4
}

// EXTMEM.L1_CACHE_ACS_FAIL_INT_CLR: L1-Cache Access Fail Interrupt clear register
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE0_FAIL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE0_FAIL_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE1_FAIL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE1_FAIL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE2_FAIL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE2_FAIL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE3_FAIL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_CLR_L1_ICACHE3_FAIL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_CLR_L1_CACHE_FAIL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_CLR_L1_CACHE_FAIL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_CLR.Reg) & 0x10) >> 4
}

// EXTMEM.L1_CACHE_ACS_FAIL_INT_RAW: Cache Access Fail Interrupt raw register
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE0_FAIL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE0_FAIL_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE1_FAIL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE1_FAIL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE2_FAIL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE2_FAIL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE3_FAIL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_RAW_L1_ICACHE3_FAIL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_RAW_L1_CACHE_FAIL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_RAW_L1_CACHE_FAIL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_RAW.Reg) & 0x10) >> 4
}

// EXTMEM.L1_CACHE_ACS_FAIL_INT_ST: Cache Access Fail Interrupt status register
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE0_FAIL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE0_FAIL_INT_ST() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE1_FAIL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE1_FAIL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE2_FAIL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE2_FAIL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE3_FAIL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_ST_L1_ICACHE3_FAIL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_INT_ST_L1_CACHE_FAIL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_INT_ST_L1_CACHE_FAIL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_INT_ST.Reg) & 0x10) >> 4
}

// EXTMEM.L1_CACHE_ACS_CNT_CTRL: Cache Access Counter enable and clear register
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS0_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS0_CNT_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS1_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS1_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS2_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS2_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS3_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS3_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_BUS0_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_BUS0_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_BUS1_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_BUS1_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_DBUS2_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_DBUS2_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_DBUS3_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_DBUS3_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS0_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS0_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x10000) >> 16
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS1_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x20000)|value<<17)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS1_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x20000) >> 17
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS2_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x40000)|value<<18)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS2_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x40000) >> 18
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_IBUS3_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x80000)|value<<19)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_IBUS3_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x80000) >> 19
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_BUS0_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_BUS0_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x100000) >> 20
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_BUS1_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_BUS1_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x200000) >> 21
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_DBUS2_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_DBUS2_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x400000) >> 22
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_CNT_CTRL_L1_DBUS3_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg)&^(0x800000)|value<<23)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_CNT_CTRL_L1_DBUS3_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_CNT_CTRL.Reg) & 0x800000) >> 23
}

// EXTMEM.L1_IBUS0_ACS_HIT_CNT: L1-ICache bus0 Hit-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS0_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS0_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS0_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS0_ACS_HIT_CNT.Reg)
}

// EXTMEM.L1_IBUS0_ACS_MISS_CNT: L1-ICache bus0 Miss-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS0_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS0_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS0_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS0_ACS_MISS_CNT.Reg)
}

// EXTMEM.L1_IBUS0_ACS_CONFLICT_CNT: L1-ICache bus0 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS0_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS0_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS0_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS0_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L1_IBUS0_ACS_NXTLVL_CNT: L1-ICache bus0 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS0_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS0_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS0_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS0_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L1_IBUS1_ACS_HIT_CNT: L1-ICache bus1 Hit-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS1_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS1_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS1_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS1_ACS_HIT_CNT.Reg)
}

// EXTMEM.L1_IBUS1_ACS_MISS_CNT: L1-ICache bus1 Miss-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS1_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS1_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS1_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS1_ACS_MISS_CNT.Reg)
}

// EXTMEM.L1_IBUS1_ACS_CONFLICT_CNT: L1-ICache bus1 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS1_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS1_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS1_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS1_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L1_IBUS1_ACS_NXTLVL_CNT: L1-ICache bus1 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS1_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS1_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS1_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS1_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L1_IBUS2_ACS_HIT_CNT: L1-ICache bus2 Hit-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS2_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS2_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS2_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS2_ACS_HIT_CNT.Reg)
}

// EXTMEM.L1_IBUS2_ACS_MISS_CNT: L1-ICache bus2 Miss-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS2_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS2_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS2_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS2_ACS_MISS_CNT.Reg)
}

// EXTMEM.L1_IBUS2_ACS_CONFLICT_CNT: L1-ICache bus2 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS2_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS2_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS2_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS2_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L1_IBUS2_ACS_NXTLVL_CNT: L1-ICache bus2 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS2_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS2_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS2_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS2_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L1_IBUS3_ACS_HIT_CNT: L1-ICache bus3 Hit-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS3_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS3_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS3_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS3_ACS_HIT_CNT.Reg)
}

// EXTMEM.L1_IBUS3_ACS_MISS_CNT: L1-ICache bus3 Miss-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS3_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS3_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS3_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS3_ACS_MISS_CNT.Reg)
}

// EXTMEM.L1_IBUS3_ACS_CONFLICT_CNT: L1-ICache bus3 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS3_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS3_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS3_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS3_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L1_IBUS3_ACS_NXTLVL_CNT: L1-ICache bus3 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL1_IBUS3_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_IBUS3_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_IBUS3_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_IBUS3_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L1_BUS0_ACS_HIT_CNT: L1-Cache bus0 Hit-Access Counter register
func (o *EXTMEM_Type) SetL1_BUS0_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_BUS0_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_BUS0_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_BUS0_ACS_HIT_CNT.Reg)
}

// EXTMEM.L1_BUS0_ACS_MISS_CNT: L1-Cache bus0 Miss-Access Counter register
func (o *EXTMEM_Type) SetL1_BUS0_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_BUS0_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_BUS0_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_BUS0_ACS_MISS_CNT.Reg)
}

// EXTMEM.L1_BUS0_ACS_CONFLICT_CNT: L1-Cache bus0 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL1_BUS0_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_BUS0_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_BUS0_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_BUS0_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L1_BUS0_ACS_NXTLVL_CNT: L1-Cache bus0 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL1_BUS0_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_BUS0_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_BUS0_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_BUS0_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L1_BUS1_ACS_HIT_CNT: L1-Cache bus1 Hit-Access Counter register
func (o *EXTMEM_Type) SetL1_BUS1_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_BUS1_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_BUS1_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_BUS1_ACS_HIT_CNT.Reg)
}

// EXTMEM.L1_BUS1_ACS_MISS_CNT: L1-Cache bus1 Miss-Access Counter register
func (o *EXTMEM_Type) SetL1_BUS1_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_BUS1_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_BUS1_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_BUS1_ACS_MISS_CNT.Reg)
}

// EXTMEM.L1_BUS1_ACS_CONFLICT_CNT: L1-Cache bus1 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL1_BUS1_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_BUS1_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_BUS1_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_BUS1_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L1_BUS1_ACS_NXTLVL_CNT: L1-Cache bus1 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL1_BUS1_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_BUS1_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_BUS1_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_BUS1_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L1_DBUS2_ACS_HIT_CNT: L1-DCache bus2 Hit-Access Counter register
func (o *EXTMEM_Type) SetL1_DBUS2_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS2_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_DBUS2_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS2_ACS_HIT_CNT.Reg)
}

// EXTMEM.L1_DBUS2_ACS_MISS_CNT: L1-DCache bus2 Miss-Access Counter register
func (o *EXTMEM_Type) SetL1_DBUS2_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS2_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_DBUS2_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS2_ACS_MISS_CNT.Reg)
}

// EXTMEM.L1_DBUS2_ACS_CONFLICT_CNT: L1-DCache bus2 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL1_DBUS2_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS2_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_DBUS2_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS2_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L1_DBUS2_ACS_NXTLVL_CNT: L1-DCache bus2 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL1_DBUS2_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS2_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_DBUS2_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS2_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L1_DBUS3_ACS_HIT_CNT: L1-DCache bus3 Hit-Access Counter register
func (o *EXTMEM_Type) SetL1_DBUS3_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS3_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_DBUS3_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS3_ACS_HIT_CNT.Reg)
}

// EXTMEM.L1_DBUS3_ACS_MISS_CNT: L1-DCache bus3 Miss-Access Counter register
func (o *EXTMEM_Type) SetL1_DBUS3_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS3_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_DBUS3_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS3_ACS_MISS_CNT.Reg)
}

// EXTMEM.L1_DBUS3_ACS_CONFLICT_CNT: L1-DCache bus3 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL1_DBUS3_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS3_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_DBUS3_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS3_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L1_DBUS3_ACS_NXTLVL_CNT: L1-DCache bus3 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL1_DBUS3_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L1_DBUS3_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL1_DBUS3_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L1_DBUS3_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L1_ICACHE0_ACS_FAIL_ID_ATTR: L1-ICache0 Access Fail ID/attribution information register
func (o *EXTMEM_Type) SetL1_ICACHE0_ACS_FAIL_ID_ATTR_L1_ICACHE0_FAIL_ID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE0_ACS_FAIL_ID_ATTR.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_ACS_FAIL_ID_ATTR_L1_ICACHE0_FAIL_ID() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_ACS_FAIL_ID_ATTR.Reg) & 0xffff
}
func (o *EXTMEM_Type) SetL1_ICACHE0_ACS_FAIL_ID_ATTR_L1_ICACHE0_FAIL_ATTR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE0_ACS_FAIL_ID_ATTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_ACS_FAIL_ID_ATTR_L1_ICACHE0_FAIL_ATTR() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE0_ACS_FAIL_ID_ATTR.Reg) & 0xffff0000) >> 16
}

// EXTMEM.L1_ICACHE0_ACS_FAIL_ADDR: L1-ICache0 Access Fail Address information register
func (o *EXTMEM_Type) SetL1_ICACHE0_ACS_FAIL_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE0_ACS_FAIL_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE0_ACS_FAIL_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE0_ACS_FAIL_ADDR.Reg)
}

// EXTMEM.L1_ICACHE1_ACS_FAIL_ID_ATTR: L1-ICache0 Access Fail ID/attribution information register
func (o *EXTMEM_Type) SetL1_ICACHE1_ACS_FAIL_ID_ATTR_L1_ICACHE1_FAIL_ID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE1_ACS_FAIL_ID_ATTR.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_ACS_FAIL_ID_ATTR_L1_ICACHE1_FAIL_ID() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_ACS_FAIL_ID_ATTR.Reg) & 0xffff
}
func (o *EXTMEM_Type) SetL1_ICACHE1_ACS_FAIL_ID_ATTR_L1_ICACHE1_FAIL_ATTR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE1_ACS_FAIL_ID_ATTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_ACS_FAIL_ID_ATTR_L1_ICACHE1_FAIL_ATTR() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE1_ACS_FAIL_ID_ATTR.Reg) & 0xffff0000) >> 16
}

// EXTMEM.L1_ICACHE1_ACS_FAIL_ADDR: L1-ICache0 Access Fail Address information register
func (o *EXTMEM_Type) SetL1_ICACHE1_ACS_FAIL_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE1_ACS_FAIL_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE1_ACS_FAIL_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE1_ACS_FAIL_ADDR.Reg)
}

// EXTMEM.L1_ICACHE2_ACS_FAIL_ID_ATTR: L1-ICache0 Access Fail ID/attribution information register
func (o *EXTMEM_Type) SetL1_ICACHE2_ACS_FAIL_ID_ATTR_L1_ICACHE2_FAIL_ID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE2_ACS_FAIL_ID_ATTR.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_ACS_FAIL_ID_ATTR_L1_ICACHE2_FAIL_ID() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_ACS_FAIL_ID_ATTR.Reg) & 0xffff
}
func (o *EXTMEM_Type) SetL1_ICACHE2_ACS_FAIL_ID_ATTR_L1_ICACHE2_FAIL_ATTR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE2_ACS_FAIL_ID_ATTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_ACS_FAIL_ID_ATTR_L1_ICACHE2_FAIL_ATTR() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE2_ACS_FAIL_ID_ATTR.Reg) & 0xffff0000) >> 16
}

// EXTMEM.L1_ICACHE2_ACS_FAIL_ADDR: L1-ICache0 Access Fail Address information register
func (o *EXTMEM_Type) SetL1_ICACHE2_ACS_FAIL_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE2_ACS_FAIL_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE2_ACS_FAIL_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE2_ACS_FAIL_ADDR.Reg)
}

// EXTMEM.L1_ICACHE3_ACS_FAIL_ID_ATTR: L1-ICache0 Access Fail ID/attribution information register
func (o *EXTMEM_Type) SetL1_ICACHE3_ACS_FAIL_ID_ATTR_L1_ICACHE3_FAIL_ID(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE3_ACS_FAIL_ID_ATTR.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_ACS_FAIL_ID_ATTR_L1_ICACHE3_FAIL_ID() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_ACS_FAIL_ID_ATTR.Reg) & 0xffff
}
func (o *EXTMEM_Type) SetL1_ICACHE3_ACS_FAIL_ID_ATTR_L1_ICACHE3_FAIL_ATTR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_ICACHE3_ACS_FAIL_ID_ATTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_ACS_FAIL_ID_ATTR_L1_ICACHE3_FAIL_ATTR() uint32 {
	return (volatile.LoadUint32(&o.L1_ICACHE3_ACS_FAIL_ID_ATTR.Reg) & 0xffff0000) >> 16
}

// EXTMEM.L1_ICACHE3_ACS_FAIL_ADDR: L1-ICache0 Access Fail Address information register
func (o *EXTMEM_Type) SetL1_ICACHE3_ACS_FAIL_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_ICACHE3_ACS_FAIL_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_ICACHE3_ACS_FAIL_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_ICACHE3_ACS_FAIL_ADDR.Reg)
}

// EXTMEM.L1_CACHE_ACS_FAIL_ID_ATTR: L1-Cache Access Fail ID/attribution information register
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_ID_ATTR_L1_CACHE_FAIL_ID(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_ID_ATTR.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_ID_ATTR_L1_CACHE_FAIL_ID() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_ID_ATTR.Reg) & 0xffff
}
func (o *EXTMEM_Type) SetL1_CACHE_ACS_FAIL_ID_ATTR_L1_CACHE_FAIL_ATTR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_ID_ATTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *EXTMEM_Type) GetL1_CACHE_ACS_FAIL_ID_ATTR_L1_CACHE_FAIL_ATTR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_ACS_FAIL_ID_ATTR.Reg) & 0xffff0000) >> 16
}

// EXTMEM.L1_DCACHE_ACS_FAIL_ADDR: L1-Cache Access Fail Address information register
func (o *EXTMEM_Type) SetL1_DCACHE_ACS_FAIL_ADDR(value uint32) {
	volatile.StoreUint32(&o.L1_DCACHE_ACS_FAIL_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_DCACHE_ACS_FAIL_ADDR() uint32 {
	return volatile.LoadUint32(&o.L1_DCACHE_ACS_FAIL_ADDR.Reg)
}

// EXTMEM.L1_CACHE_SYNC_PRELOAD_INT_ENA: L1-Cache Access Fail Interrupt enable register
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE0_PLD_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE0_PLD_DONE_INT_ENA() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE1_PLD_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE1_PLD_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE2_PLD_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE2_PLD_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE3_PLD_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE3_PLD_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_CACHE_PLD_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_CACHE_PLD_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ENA_CACHE_SYNC_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ENA_CACHE_SYNC_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE0_PLD_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE0_PLD_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE1_PLD_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE1_PLD_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE2_PLD_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE2_PLD_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE3_PLD_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_ICACHE3_PLD_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_CACHE_PLD_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ENA_L1_CACHE_PLD_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ENA_CACHE_SYNC_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ENA_CACHE_SYNC_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x2000) >> 13
}

// EXTMEM.L1_CACHE_SYNC_PRELOAD_INT_CLR: Sync Preload operation Interrupt clear register
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE0_PLD_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE0_PLD_DONE_INT_CLR() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE1_PLD_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE1_PLD_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE2_PLD_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE2_PLD_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE3_PLD_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE3_PLD_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_CACHE_PLD_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_CACHE_PLD_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_CLR_CACHE_SYNC_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_CLR_CACHE_SYNC_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE0_PLD_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE0_PLD_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE1_PLD_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE1_PLD_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE2_PLD_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE2_PLD_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE3_PLD_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_ICACHE3_PLD_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_CACHE_PLD_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_CLR_L1_CACHE_PLD_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_CLR_CACHE_SYNC_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_CLR_CACHE_SYNC_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x2000) >> 13
}

// EXTMEM.L1_CACHE_SYNC_PRELOAD_INT_RAW: Sync Preload operation Interrupt raw register
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE0_PLD_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE0_PLD_DONE_INT_RAW() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE1_PLD_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE1_PLD_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE2_PLD_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE2_PLD_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE3_PLD_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE3_PLD_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_CACHE_PLD_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_CACHE_PLD_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_RAW_CACHE_SYNC_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_RAW_CACHE_SYNC_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE0_PLD_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE0_PLD_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE1_PLD_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE1_PLD_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE2_PLD_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE2_PLD_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE3_PLD_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_ICACHE3_PLD_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_CACHE_PLD_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_RAW_L1_CACHE_PLD_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_RAW_CACHE_SYNC_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_RAW_CACHE_SYNC_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x2000) >> 13
}

// EXTMEM.L1_CACHE_SYNC_PRELOAD_INT_ST: L1-Cache Access Fail Interrupt status register
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE0_PLD_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE0_PLD_DONE_INT_ST() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE1_PLD_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE1_PLD_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE2_PLD_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE2_PLD_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE3_PLD_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE3_PLD_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_CACHE_PLD_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_CACHE_PLD_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ST_CACHE_SYNC_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ST_CACHE_SYNC_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE0_PLD_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE0_PLD_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE1_PLD_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE1_PLD_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE2_PLD_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE2_PLD_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE3_PLD_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_ICACHE3_PLD_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_CACHE_PLD_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ST_L1_CACHE_PLD_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_INT_ST_CACHE_SYNC_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_INT_ST_CACHE_SYNC_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x2000) >> 13
}

// EXTMEM.L1_CACHE_SYNC_PRELOAD_EXCEPTION: Cache Sync/Preload Operation exception register
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_EXCEPTION_L1_ICACHE0_PLD_ERR_CODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg)&^(0x3)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_EXCEPTION_L1_ICACHE0_PLD_ERR_CODE() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg) & 0x3
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_EXCEPTION_L1_ICACHE1_PLD_ERR_CODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg)&^(0xc)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_EXCEPTION_L1_ICACHE1_PLD_ERR_CODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg) & 0xc) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_EXCEPTION_L1_ICACHE2_PLD_ERR_CODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg)&^(0x30)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_EXCEPTION_L1_ICACHE2_PLD_ERR_CODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg) & 0x30) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_EXCEPTION_L1_ICACHE3_PLD_ERR_CODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg)&^(0xc0)|value<<6)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_EXCEPTION_L1_ICACHE3_PLD_ERR_CODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg) & 0xc0) >> 6
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_EXCEPTION_L1_CACHE_PLD_ERR_CODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg)&^(0x300)|value<<8)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_EXCEPTION_L1_CACHE_PLD_ERR_CODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg) & 0x300) >> 8
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_PRELOAD_EXCEPTION_CACHE_SYNC_ERR_CODE(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg)&^(0x3000)|value<<12)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_PRELOAD_EXCEPTION_CACHE_SYNC_ERR_CODE() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_PRELOAD_EXCEPTION.Reg) & 0x3000) >> 12
}

// EXTMEM.L1_CACHE_SYNC_RST_CTRL: Cache Sync Reset control register
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE0_SYNC_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE0_SYNC_RST() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE1_SYNC_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE1_SYNC_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE2_SYNC_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE2_SYNC_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE3_SYNC_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_RST_CTRL_L1_ICACHE3_SYNC_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_SYNC_RST_CTRL_L1_CACHE_SYNC_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_SYNC_RST_CTRL_L1_CACHE_SYNC_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_SYNC_RST_CTRL.Reg) & 0x10) >> 4
}

// EXTMEM.L1_CACHE_PRELOAD_RST_CTRL: Cache Preload Reset control register
func (o *EXTMEM_Type) SetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE0_PLD_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE0_PLD_RST() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE1_PLD_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE1_PLD_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE2_PLD_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE2_PLD_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE3_PLD_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_PRELOAD_RST_CTRL_L1_ICACHE3_PLD_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_PRELOAD_RST_CTRL_L1_CACHE_PLD_RST(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_PRELOAD_RST_CTRL_L1_CACHE_PLD_RST() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_PRELOAD_RST_CTRL.Reg) & 0x10) >> 4
}

// EXTMEM.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL: Cache Autoload buffer clear control register
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE0_ALD_BUF_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE0_ALD_BUF_CLR() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE1_ALD_BUF_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE1_ALD_BUF_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE2_ALD_BUF_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE2_ALD_BUF_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE3_ALD_BUF_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_ICACHE3_ALD_BUF_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_CACHE_ALD_BUF_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_AUTOLOAD_BUF_CLR_CTRL_L1_CACHE_ALD_BUF_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg) & 0x10) >> 4
}

// EXTMEM.L1_UNALLOCATE_BUFFER_CLEAR: Unallocate request buffer clear registers
func (o *EXTMEM_Type) SetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE0_UNALLOC_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg, volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE0_UNALLOC_CLR() uint32 {
	return volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE1_UNALLOC_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg, volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE1_UNALLOC_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE2_UNALLOC_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg, volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE2_UNALLOC_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE3_UNALLOC_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg, volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_UNALLOCATE_BUFFER_CLEAR_L1_ICACHE3_UNALLOC_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_UNALLOCATE_BUFFER_CLEAR_L1_CACHE_UNALLOC_CLR(value uint32) {
	volatile.StoreUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg, volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_UNALLOCATE_BUFFER_CLEAR_L1_CACHE_UNALLOC_CLR() uint32 {
	return (volatile.LoadUint32(&o.L1_UNALLOCATE_BUFFER_CLEAR.Reg) & 0x10) >> 4
}

// EXTMEM.L1_CACHE_OBJECT_CTRL: Cache Tag and Data memory Object control register
func (o *EXTMEM_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE0_TAG_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE0_TAG_OBJECT() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE1_TAG_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE1_TAG_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE2_TAG_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE2_TAG_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE3_TAG_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE3_TAG_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL1_CACHE_OBJECT_CTRL_L1_CACHE_TAG_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL1_CACHE_OBJECT_CTRL_L1_CACHE_TAG_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE0_MEM_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE0_MEM_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE1_MEM_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE1_MEM_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE2_MEM_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE2_MEM_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL1_CACHE_OBJECT_CTRL_L1_ICACHE3_MEM_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL1_CACHE_OBJECT_CTRL_L1_ICACHE3_MEM_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL1_CACHE_OBJECT_CTRL_L1_CACHE_MEM_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL1_CACHE_OBJECT_CTRL_L1_CACHE_MEM_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L1_CACHE_OBJECT_CTRL.Reg) & 0x400) >> 10
}

// EXTMEM.L1_CACHE_WAY_OBJECT: Cache Tag and Data memory way register
func (o *EXTMEM_Type) SetL1_CACHE_WAY_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_WAY_OBJECT.Reg, volatile.LoadUint32(&o.L1_CACHE_WAY_OBJECT.Reg)&^(0x7)|value)
}
func (o *EXTMEM_Type) GetL1_CACHE_WAY_OBJECT() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_WAY_OBJECT.Reg) & 0x7
}

// EXTMEM.L1_CACHE_VADDR: Cache Vaddr register
func (o *EXTMEM_Type) SetL1_CACHE_VADDR(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL1_CACHE_VADDR() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_VADDR.Reg)
}

// EXTMEM.L1_CACHE_DEBUG_BUS: Cache Tag/data memory content register
func (o *EXTMEM_Type) SetL1_CACHE_DEBUG_BUS(value uint32) {
	volatile.StoreUint32(&o.L1_CACHE_DEBUG_BUS.Reg, value)
}
func (o *EXTMEM_Type) GetL1_CACHE_DEBUG_BUS() uint32 {
	return volatile.LoadUint32(&o.L1_CACHE_DEBUG_BUS.Reg)
}

// EXTMEM.LEVEL_SPLIT0: USED TO SPLIT L1 CACHE AND L2 CACHE
func (o *EXTMEM_Type) SetLEVEL_SPLIT0(value uint32) {
	volatile.StoreUint32(&o.LEVEL_SPLIT0.Reg, value)
}
func (o *EXTMEM_Type) GetLEVEL_SPLIT0() uint32 {
	return volatile.LoadUint32(&o.LEVEL_SPLIT0.Reg)
}

// EXTMEM.L2_CACHE_CTRL: L2 Cache(L2-Cache) control register
func (o *EXTMEM_Type) SetL2_CACHE_CTRL_L2_CACHE_SHUT_DMA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_CTRL.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL2_CACHE_CTRL_L2_CACHE_SHUT_DMA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CTRL.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL2_CACHE_CTRL_L2_CACHE_UNDEF_OP(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_CTRL.Reg)&^(0x1e0)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_CTRL_L2_CACHE_UNDEF_OP() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CTRL.Reg) & 0x1e0) >> 5
}

// EXTMEM.L2_BYPASS_CACHE_CONF: Bypass Cache configure register
func (o *EXTMEM_Type) SetL2_BYPASS_CACHE_CONF_BYPASS_L2_CACHE_EN(value uint32) {
	volatile.StoreUint32(&o.L2_BYPASS_CACHE_CONF.Reg, volatile.LoadUint32(&o.L2_BYPASS_CACHE_CONF.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_BYPASS_CACHE_CONF_BYPASS_L2_CACHE_EN() uint32 {
	return (volatile.LoadUint32(&o.L2_BYPASS_CACHE_CONF.Reg) & 0x20) >> 5
}

// EXTMEM.L2_CACHE_CACHESIZE_CONF: L2 Cache CacheSize mode configure register
func (o *EXTMEM_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_1K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_1K() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_2K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_2K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_4K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_4K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_8K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_8K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_16K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_16K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_32K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_32K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_64K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x40)|value<<6)
}
func (o *EXTMEM_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_64K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x40) >> 6
}
func (o *EXTMEM_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_128K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x80)|value<<7)
}
func (o *EXTMEM_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_128K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x80) >> 7
}
func (o *EXTMEM_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_256K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_256K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_512K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_512K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_1024K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_1024K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_2048K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_2048K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_4096K(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL2_CACHE_CACHESIZE_CONF_L2_CACHE_CACHESIZE_4096K() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_CACHESIZE_CONF.Reg) & 0x1000) >> 12
}

// EXTMEM.L2_CACHE_BLOCKSIZE_CONF: L2 Cache BlockSize mode configure register
func (o *EXTMEM_Type) SetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_8(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_8() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_16(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_16() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_32(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_32() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_64(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_64() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg) & 0x8) >> 3
}
func (o *EXTMEM_Type) SetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_128(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg)&^(0x10)|value<<4)
}
func (o *EXTMEM_Type) GetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_128() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg) & 0x10) >> 4
}
func (o *EXTMEM_Type) SetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_256(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_BLOCKSIZE_CONF_L2_CACHE_BLOCKSIZE_256() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_BLOCKSIZE_CONF.Reg) & 0x20) >> 5
}

// EXTMEM.L2_CACHE_WRAP_AROUND_CTRL: Cache wrap around control register
func (o *EXTMEM_Type) SetL2_CACHE_WRAP_AROUND_CTRL_L2_CACHE_WRAP(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_WRAP_AROUND_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_WRAP_AROUND_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_WRAP_AROUND_CTRL_L2_CACHE_WRAP() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_WRAP_AROUND_CTRL.Reg) & 0x20) >> 5
}

// EXTMEM.L2_CACHE_TAG_MEM_POWER_CTRL: Cache tag memory power control register
func (o *EXTMEM_Type) SetL2_CACHE_TAG_MEM_POWER_CTRL_L2_CACHE_TAG_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *EXTMEM_Type) GetL2_CACHE_TAG_MEM_POWER_CTRL_L2_CACHE_TAG_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x100000) >> 20
}
func (o *EXTMEM_Type) SetL2_CACHE_TAG_MEM_POWER_CTRL_L2_CACHE_TAG_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *EXTMEM_Type) GetL2_CACHE_TAG_MEM_POWER_CTRL_L2_CACHE_TAG_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x200000) >> 21
}
func (o *EXTMEM_Type) SetL2_CACHE_TAG_MEM_POWER_CTRL_L2_CACHE_TAG_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *EXTMEM_Type) GetL2_CACHE_TAG_MEM_POWER_CTRL_L2_CACHE_TAG_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_POWER_CTRL.Reg) & 0x400000) >> 22
}

// EXTMEM.L2_CACHE_DATA_MEM_POWER_CTRL: Cache data memory power control register
func (o *EXTMEM_Type) SetL2_CACHE_DATA_MEM_POWER_CTRL_L2_CACHE_DATA_MEM_FORCE_ON(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *EXTMEM_Type) GetL2_CACHE_DATA_MEM_POWER_CTRL_L2_CACHE_DATA_MEM_FORCE_ON() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x100000) >> 20
}
func (o *EXTMEM_Type) SetL2_CACHE_DATA_MEM_POWER_CTRL_L2_CACHE_DATA_MEM_FORCE_PD(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *EXTMEM_Type) GetL2_CACHE_DATA_MEM_POWER_CTRL_L2_CACHE_DATA_MEM_FORCE_PD() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x200000) >> 21
}
func (o *EXTMEM_Type) SetL2_CACHE_DATA_MEM_POWER_CTRL_L2_CACHE_DATA_MEM_FORCE_PU(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *EXTMEM_Type) GetL2_CACHE_DATA_MEM_POWER_CTRL_L2_CACHE_DATA_MEM_FORCE_PU() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_POWER_CTRL.Reg) & 0x400000) >> 22
}

// EXTMEM.L2_CACHE_FREEZE_CTRL: Cache Freeze control register
func (o *EXTMEM_Type) SetL2_CACHE_FREEZE_CTRL_L2_CACHE_FREEZE_EN(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_FREEZE_CTRL.Reg)&^(0x100000)|value<<20)
}
func (o *EXTMEM_Type) GetL2_CACHE_FREEZE_CTRL_L2_CACHE_FREEZE_EN() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_FREEZE_CTRL.Reg) & 0x100000) >> 20
}
func (o *EXTMEM_Type) SetL2_CACHE_FREEZE_CTRL_L2_CACHE_FREEZE_MODE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_FREEZE_CTRL.Reg)&^(0x200000)|value<<21)
}
func (o *EXTMEM_Type) GetL2_CACHE_FREEZE_CTRL_L2_CACHE_FREEZE_MODE() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_FREEZE_CTRL.Reg) & 0x200000) >> 21
}
func (o *EXTMEM_Type) SetL2_CACHE_FREEZE_CTRL_L2_CACHE_FREEZE_DONE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_FREEZE_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_FREEZE_CTRL.Reg)&^(0x400000)|value<<22)
}
func (o *EXTMEM_Type) GetL2_CACHE_FREEZE_CTRL_L2_CACHE_FREEZE_DONE() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_FREEZE_CTRL.Reg) & 0x400000) >> 22
}

// EXTMEM.L2_CACHE_DATA_MEM_ACS_CONF: Cache data memory access configure register
func (o *EXTMEM_Type) SetL2_CACHE_DATA_MEM_ACS_CONF_L2_CACHE_DATA_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *EXTMEM_Type) GetL2_CACHE_DATA_MEM_ACS_CONF_L2_CACHE_DATA_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x100000) >> 20
}
func (o *EXTMEM_Type) SetL2_CACHE_DATA_MEM_ACS_CONF_L2_CACHE_DATA_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_DATA_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_ACS_CONF.Reg)&^(0x200000)|value<<21)
}
func (o *EXTMEM_Type) GetL2_CACHE_DATA_MEM_ACS_CONF_L2_CACHE_DATA_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_DATA_MEM_ACS_CONF.Reg) & 0x200000) >> 21
}

// EXTMEM.L2_CACHE_TAG_MEM_ACS_CONF: Cache tag memory access configure register
func (o *EXTMEM_Type) SetL2_CACHE_TAG_MEM_ACS_CONF_L2_CACHE_TAG_MEM_RD_EN(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x100000)|value<<20)
}
func (o *EXTMEM_Type) GetL2_CACHE_TAG_MEM_ACS_CONF_L2_CACHE_TAG_MEM_RD_EN() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x100000) >> 20
}
func (o *EXTMEM_Type) SetL2_CACHE_TAG_MEM_ACS_CONF_L2_CACHE_TAG_MEM_WR_EN(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_TAG_MEM_ACS_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_ACS_CONF.Reg)&^(0x200000)|value<<21)
}
func (o *EXTMEM_Type) GetL2_CACHE_TAG_MEM_ACS_CONF_L2_CACHE_TAG_MEM_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_TAG_MEM_ACS_CONF.Reg) & 0x200000) >> 21
}

// EXTMEM.L2_CACHE_PRELOCK_CONF: L2 Cache prelock configure register
func (o *EXTMEM_Type) SetL2_CACHE_PRELOCK_CONF_L2_CACHE_PRELOCK_SCT0_EN(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOCK_CONF.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL2_CACHE_PRELOCK_CONF_L2_CACHE_PRELOCK_SCT0_EN() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_PRELOCK_CONF.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL2_CACHE_PRELOCK_CONF_L2_CACHE_PRELOCK_SCT1_EN(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOCK_CONF.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL2_CACHE_PRELOCK_CONF_L2_CACHE_PRELOCK_SCT1_EN() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_PRELOCK_CONF.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL2_CACHE_PRELOCK_CONF_L2_CACHE_PRELOCK_RGID(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOCK_CONF.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOCK_CONF.Reg)&^(0x3c)|value<<2)
}
func (o *EXTMEM_Type) GetL2_CACHE_PRELOCK_CONF_L2_CACHE_PRELOCK_RGID() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_PRELOCK_CONF.Reg) & 0x3c) >> 2
}

// EXTMEM.L2_CACHE_PRELOCK_SCT0_ADDR: L2 Cache prelock section0 address configure register
func (o *EXTMEM_Type) SetL2_CACHE_PRELOCK_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOCK_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL2_CACHE_PRELOCK_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_PRELOCK_SCT0_ADDR.Reg)
}

// EXTMEM.L2_CACHE_PRELOCK_SCT1_ADDR: L2 Cache prelock section1 address configure register
func (o *EXTMEM_Type) SetL2_CACHE_PRELOCK_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOCK_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL2_CACHE_PRELOCK_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_PRELOCK_SCT1_ADDR.Reg)
}

// EXTMEM.L2_CACHE_PRELOCK_SCT_SIZE: L2 Cache prelock section size configure register
func (o *EXTMEM_Type) SetL2_CACHE_PRELOCK_SCT_SIZE_L2_CACHE_PRELOCK_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOCK_SCT_SIZE.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetL2_CACHE_PRELOCK_SCT_SIZE_L2_CACHE_PRELOCK_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_PRELOCK_SCT_SIZE.Reg) & 0xffff
}
func (o *EXTMEM_Type) SetL2_CACHE_PRELOCK_SCT_SIZE_L2_CACHE_PRELOCK_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOCK_SCT_SIZE.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOCK_SCT_SIZE.Reg)&^(0xffff0000)|value<<16)
}
func (o *EXTMEM_Type) GetL2_CACHE_PRELOCK_SCT_SIZE_L2_CACHE_PRELOCK_SCT1_SIZE() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_PRELOCK_SCT_SIZE.Reg) & 0xffff0000) >> 16
}

// EXTMEM.L2_CACHE_PRELOAD_CTRL: L2 Cache preload-operation control register
func (o *EXTMEM_Type) SetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg)&^(0x78)|value<<3)
}
func (o *EXTMEM_Type) GetL2_CACHE_PRELOAD_CTRL_L2_CACHE_PRELOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_PRELOAD_CTRL.Reg) & 0x78) >> 3
}

// EXTMEM.L2_CACHE_PRELOAD_ADDR: L2 Cache preload address configure register
func (o *EXTMEM_Type) SetL2_CACHE_PRELOAD_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOAD_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL2_CACHE_PRELOAD_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_PRELOAD_ADDR.Reg)
}

// EXTMEM.L2_CACHE_PRELOAD_SIZE: L2 Cache preload size configure register
func (o *EXTMEM_Type) SetL2_CACHE_PRELOAD_SIZE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOAD_SIZE.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOAD_SIZE.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetL2_CACHE_PRELOAD_SIZE() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_PRELOAD_SIZE.Reg) & 0xffff
}

// EXTMEM.L2_CACHE_AUTOLOAD_CTRL: L2 Cache autoload-operation control register
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_ENA() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_DONE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_DONE() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_ORDER(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_ORDER() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_TRIGGER_MODE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x18)|value<<3)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_TRIGGER_MODE() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x18) >> 3
}
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT0_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT0_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT1_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT1_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT2_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT2_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT3_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_SCT3_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_RGID(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg)&^(0xf000)|value<<12)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_CTRL_L2_CACHE_AUTOLOAD_RGID() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_CTRL.Reg) & 0xf000) >> 12
}

// EXTMEM.L2_CACHE_AUTOLOAD_SCT0_ADDR: L2 Cache autoload section 0 address configure register
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_SCT0_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT0_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_SCT0_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT0_ADDR.Reg)
}

// EXTMEM.L2_CACHE_AUTOLOAD_SCT0_SIZE: L2 Cache autoload section 0 size configure register
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_SCT0_SIZE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT0_SIZE.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT0_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_SCT0_SIZE() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT0_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L2_CACHE_AUTOLOAD_SCT1_ADDR: L2 Cache autoload section 1 address configure register
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_SCT1_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT1_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_SCT1_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT1_ADDR.Reg)
}

// EXTMEM.L2_CACHE_AUTOLOAD_SCT1_SIZE: L2 Cache autoload section 1 size configure register
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_SCT1_SIZE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT1_SIZE.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT1_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_SCT1_SIZE() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT1_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L2_CACHE_AUTOLOAD_SCT2_ADDR: L2 Cache autoload section 2 address configure register
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_SCT2_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT2_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_SCT2_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT2_ADDR.Reg)
}

// EXTMEM.L2_CACHE_AUTOLOAD_SCT2_SIZE: L2 Cache autoload section 2 size configure register
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_SCT2_SIZE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT2_SIZE.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT2_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_SCT2_SIZE() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT2_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L2_CACHE_AUTOLOAD_SCT3_ADDR: L2 Cache autoload section 3 address configure register
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_SCT3_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT3_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_SCT3_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT3_ADDR.Reg)
}

// EXTMEM.L2_CACHE_AUTOLOAD_SCT3_SIZE: L2 Cache autoload section 3 size configure register
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_SCT3_SIZE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_SCT3_SIZE.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT3_SIZE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_SCT3_SIZE() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_SCT3_SIZE.Reg) & 0xfffffff
}

// EXTMEM.L2_CACHE_ACS_CNT_INT_ENA: Cache Access Counter Interrupt enable register
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS0_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS0_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS1_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS1_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS2_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS2_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS3_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_IBUS3_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS0_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS0_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x1000) >> 12
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS1_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS1_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x2000) >> 13
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS2_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x4000)|value<<14)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS2_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x4000) >> 14
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS3_OVF_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg)&^(0x8000)|value<<15)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ENA_L2_DBUS3_OVF_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ENA.Reg) & 0x8000) >> 15
}

// EXTMEM.L2_CACHE_ACS_CNT_INT_CLR: Cache Access Counter Interrupt clear register
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS0_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS0_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS1_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS1_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS2_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS2_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS3_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_IBUS3_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS0_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS0_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x1000) >> 12
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS1_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS1_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x2000) >> 13
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS2_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS2_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x4000) >> 14
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS3_OVF_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_CLR_L2_DBUS3_OVF_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_CLR.Reg) & 0x8000) >> 15
}

// EXTMEM.L2_CACHE_ACS_CNT_INT_RAW: Cache Access Counter Interrupt raw register
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS0_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS0_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS1_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS1_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS2_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS2_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS3_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_IBUS3_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS0_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS0_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x1000) >> 12
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS1_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS1_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x2000) >> 13
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS2_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x4000)|value<<14)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS2_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x4000) >> 14
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS3_OVF_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg)&^(0x8000)|value<<15)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_RAW_L2_DBUS3_OVF_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_RAW.Reg) & 0x8000) >> 15
}

// EXTMEM.L2_CACHE_ACS_CNT_INT_ST: Cache Access Counter Interrupt status register
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS0_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS0_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS1_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS1_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS2_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS2_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS3_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_IBUS3_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS0_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS0_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x1000) >> 12
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS1_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS1_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x2000) >> 13
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS2_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x4000)|value<<14)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS2_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x4000) >> 14
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS3_OVF_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg)&^(0x8000)|value<<15)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_INT_ST_L2_DBUS3_OVF_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_INT_ST.Reg) & 0x8000) >> 15
}

// EXTMEM.L2_CACHE_ACS_FAIL_INT_ENA: Cache Access Fail Interrupt enable register
func (o *EXTMEM_Type) SetL2_CACHE_ACS_FAIL_INT_ENA_L2_CACHE_FAIL_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_FAIL_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_FAIL_INT_ENA_L2_CACHE_FAIL_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_ENA.Reg) & 0x20) >> 5
}

// EXTMEM.L2_CACHE_ACS_FAIL_INT_CLR: L1-Cache Access Fail Interrupt clear register
func (o *EXTMEM_Type) SetL2_CACHE_ACS_FAIL_INT_CLR_L2_CACHE_FAIL_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_FAIL_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_FAIL_INT_CLR_L2_CACHE_FAIL_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_CLR.Reg) & 0x20) >> 5
}

// EXTMEM.L2_CACHE_ACS_FAIL_INT_RAW: Cache Access Fail Interrupt raw register
func (o *EXTMEM_Type) SetL2_CACHE_ACS_FAIL_INT_RAW_L2_CACHE_FAIL_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_FAIL_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_FAIL_INT_RAW_L2_CACHE_FAIL_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_RAW.Reg) & 0x20) >> 5
}

// EXTMEM.L2_CACHE_ACS_FAIL_INT_ST: Cache Access Fail Interrupt status register
func (o *EXTMEM_Type) SetL2_CACHE_ACS_FAIL_INT_ST_L2_CACHE_FAIL_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_FAIL_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_FAIL_INT_ST_L2_CACHE_FAIL_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_INT_ST.Reg) & 0x20) >> 5
}

// EXTMEM.L2_CACHE_ACS_CNT_CTRL: Cache Access Counter enable and clear register
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS0_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x100)|value<<8)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS0_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x100) >> 8
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS1_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x200)|value<<9)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS1_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x200) >> 9
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS2_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x400)|value<<10)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS2_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x400) >> 10
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS3_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS3_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x800) >> 11
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS0_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS0_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x1000) >> 12
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS1_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS1_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x2000) >> 13
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS2_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS2_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x4000) >> 14
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS3_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS3_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x8000) >> 15
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS0_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS0_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x1000000) >> 24
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS1_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS1_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x2000000) >> 25
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS2_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS2_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x4000000) >> 26
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_IBUS3_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_IBUS3_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x8000000) >> 27
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS0_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS0_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x10000000) >> 28
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS1_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS1_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x20000000) >> 29
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS2_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS2_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x40000000) >> 30
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_CNT_CTRL_L2_DBUS3_CNT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_CNT_CTRL_L2_DBUS3_CNT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_CNT_CTRL.Reg) & 0x80000000) >> 31
}

// EXTMEM.L2_IBUS0_ACS_HIT_CNT: L2-Cache bus0 Hit-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS0_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS0_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS0_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS0_ACS_HIT_CNT.Reg)
}

// EXTMEM.L2_IBUS0_ACS_MISS_CNT: L2-Cache bus0 Miss-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS0_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS0_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS0_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS0_ACS_MISS_CNT.Reg)
}

// EXTMEM.L2_IBUS0_ACS_CONFLICT_CNT: L2-Cache bus0 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS0_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS0_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS0_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS0_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L2_IBUS0_ACS_NXTLVL_CNT: L2-Cache bus0 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS0_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS0_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS0_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS0_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L2_IBUS1_ACS_HIT_CNT: L2-Cache bus1 Hit-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS1_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS1_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS1_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS1_ACS_HIT_CNT.Reg)
}

// EXTMEM.L2_IBUS1_ACS_MISS_CNT: L2-Cache bus1 Miss-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS1_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS1_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS1_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS1_ACS_MISS_CNT.Reg)
}

// EXTMEM.L2_IBUS1_ACS_CONFLICT_CNT: L2-Cache bus1 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS1_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS1_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS1_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS1_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L2_IBUS1_ACS_NXTLVL_CNT: L2-Cache bus1 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS1_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS1_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS1_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS1_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L2_IBUS2_ACS_HIT_CNT: L2-Cache bus2 Hit-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS2_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS2_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS2_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS2_ACS_HIT_CNT.Reg)
}

// EXTMEM.L2_IBUS2_ACS_MISS_CNT: L2-Cache bus2 Miss-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS2_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS2_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS2_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS2_ACS_MISS_CNT.Reg)
}

// EXTMEM.L2_IBUS2_ACS_CONFLICT_CNT: L2-Cache bus2 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS2_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS2_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS2_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS2_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L2_IBUS2_ACS_NXTLVL_CNT: L2-Cache bus2 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS2_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS2_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS2_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS2_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L2_IBUS3_ACS_HIT_CNT: L2-Cache bus3 Hit-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS3_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS3_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS3_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS3_ACS_HIT_CNT.Reg)
}

// EXTMEM.L2_IBUS3_ACS_MISS_CNT: L2-Cache bus3 Miss-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS3_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS3_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS3_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS3_ACS_MISS_CNT.Reg)
}

// EXTMEM.L2_IBUS3_ACS_CONFLICT_CNT: L2-Cache bus3 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS3_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS3_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS3_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS3_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L2_IBUS3_ACS_NXTLVL_CNT: L2-Cache bus3 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL2_IBUS3_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_IBUS3_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_IBUS3_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_IBUS3_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L2_DBUS0_ACS_HIT_CNT: L2-Cache bus0 Hit-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS0_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS0_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS0_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS0_ACS_HIT_CNT.Reg)
}

// EXTMEM.L2_DBUS0_ACS_MISS_CNT: L2-Cache bus0 Miss-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS0_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS0_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS0_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS0_ACS_MISS_CNT.Reg)
}

// EXTMEM.L2_DBUS0_ACS_CONFLICT_CNT: L2-Cache bus0 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS0_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS0_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS0_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS0_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L2_DBUS0_ACS_NXTLVL_CNT: L2-Cache bus0 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS0_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS0_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS0_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS0_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L2_DBUS1_ACS_HIT_CNT: L2-Cache bus1 Hit-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS1_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS1_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS1_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS1_ACS_HIT_CNT.Reg)
}

// EXTMEM.L2_DBUS1_ACS_MISS_CNT: L2-Cache bus1 Miss-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS1_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS1_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS1_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS1_ACS_MISS_CNT.Reg)
}

// EXTMEM.L2_DBUS1_ACS_CONFLICT_CNT: L2-Cache bus1 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS1_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS1_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS1_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS1_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L2_DBUS1_ACS_NXTLVL_CNT: L2-Cache bus1 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS1_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS1_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS1_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS1_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L2_DBUS2_ACS_HIT_CNT: L2-Cache bus2 Hit-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS2_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS2_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS2_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS2_ACS_HIT_CNT.Reg)
}

// EXTMEM.L2_DBUS2_ACS_MISS_CNT: L2-Cache bus2 Miss-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS2_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS2_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS2_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS2_ACS_MISS_CNT.Reg)
}

// EXTMEM.L2_DBUS2_ACS_CONFLICT_CNT: L2-Cache bus2 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS2_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS2_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS2_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS2_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L2_DBUS2_ACS_NXTLVL_CNT: L2-Cache bus2 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS2_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS2_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS2_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS2_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L2_DBUS3_ACS_HIT_CNT: L2-Cache bus3 Hit-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS3_ACS_HIT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS3_ACS_HIT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS3_ACS_HIT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS3_ACS_HIT_CNT.Reg)
}

// EXTMEM.L2_DBUS3_ACS_MISS_CNT: L2-Cache bus3 Miss-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS3_ACS_MISS_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS3_ACS_MISS_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS3_ACS_MISS_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS3_ACS_MISS_CNT.Reg)
}

// EXTMEM.L2_DBUS3_ACS_CONFLICT_CNT: L2-Cache bus3 Conflict-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS3_ACS_CONFLICT_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS3_ACS_CONFLICT_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS3_ACS_CONFLICT_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS3_ACS_CONFLICT_CNT.Reg)
}

// EXTMEM.L2_DBUS3_ACS_NXTLVL_CNT: L2-Cache bus3 Next-Level-Access Counter register
func (o *EXTMEM_Type) SetL2_DBUS3_ACS_NXTLVL_CNT(value uint32) {
	volatile.StoreUint32(&o.L2_DBUS3_ACS_NXTLVL_CNT.Reg, value)
}
func (o *EXTMEM_Type) GetL2_DBUS3_ACS_NXTLVL_CNT() uint32 {
	return volatile.LoadUint32(&o.L2_DBUS3_ACS_NXTLVL_CNT.Reg)
}

// EXTMEM.L2_CACHE_ACS_FAIL_ID_ATTR: L2-Cache Access Fail ID/attribution information register
func (o *EXTMEM_Type) SetL2_CACHE_ACS_FAIL_ID_ATTR_L2_CACHE_FAIL_ID(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_ID_ATTR.Reg)&^(0xffff)|value)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_FAIL_ID_ATTR_L2_CACHE_FAIL_ID() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_ID_ATTR.Reg) & 0xffff
}
func (o *EXTMEM_Type) SetL2_CACHE_ACS_FAIL_ID_ATTR_L2_CACHE_FAIL_ATTR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_FAIL_ID_ATTR.Reg, volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_ID_ATTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_FAIL_ID_ATTR_L2_CACHE_FAIL_ATTR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_ID_ATTR.Reg) & 0xffff0000) >> 16
}

// EXTMEM.L2_CACHE_ACS_FAIL_ADDR: L2-Cache Access Fail Address information register
func (o *EXTMEM_Type) SetL2_CACHE_ACS_FAIL_ADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACS_FAIL_ADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACS_FAIL_ADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_ACS_FAIL_ADDR.Reg)
}

// EXTMEM.L2_CACHE_SYNC_PRELOAD_INT_ENA: L1-Cache Access Fail Interrupt enable register
func (o *EXTMEM_Type) SetL2_CACHE_SYNC_PRELOAD_INT_ENA_L2_CACHE_PLD_DONE_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_SYNC_PRELOAD_INT_ENA_L2_CACHE_PLD_DONE_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL2_CACHE_SYNC_PRELOAD_INT_ENA_L2_CACHE_PLD_ERR_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ENA.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ENA.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL2_CACHE_SYNC_PRELOAD_INT_ENA_L2_CACHE_PLD_ERR_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ENA.Reg) & 0x1000) >> 12
}

// EXTMEM.L2_CACHE_SYNC_PRELOAD_INT_CLR: Sync Preload operation Interrupt clear register
func (o *EXTMEM_Type) SetL2_CACHE_SYNC_PRELOAD_INT_CLR_L2_CACHE_PLD_DONE_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_SYNC_PRELOAD_INT_CLR_L2_CACHE_PLD_DONE_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL2_CACHE_SYNC_PRELOAD_INT_CLR_L2_CACHE_PLD_ERR_INT_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_CLR.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL2_CACHE_SYNC_PRELOAD_INT_CLR_L2_CACHE_PLD_ERR_INT_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_CLR.Reg) & 0x1000) >> 12
}

// EXTMEM.L2_CACHE_SYNC_PRELOAD_INT_RAW: Sync Preload operation Interrupt raw register
func (o *EXTMEM_Type) SetL2_CACHE_SYNC_PRELOAD_INT_RAW_L2_CACHE_PLD_DONE_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_SYNC_PRELOAD_INT_RAW_L2_CACHE_PLD_DONE_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL2_CACHE_SYNC_PRELOAD_INT_RAW_L2_CACHE_PLD_ERR_INT_RAW(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_RAW.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_RAW.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL2_CACHE_SYNC_PRELOAD_INT_RAW_L2_CACHE_PLD_ERR_INT_RAW() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_RAW.Reg) & 0x1000) >> 12
}

// EXTMEM.L2_CACHE_SYNC_PRELOAD_INT_ST: L1-Cache Access Fail Interrupt status register
func (o *EXTMEM_Type) SetL2_CACHE_SYNC_PRELOAD_INT_ST_L2_CACHE_PLD_DONE_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_SYNC_PRELOAD_INT_ST_L2_CACHE_PLD_DONE_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL2_CACHE_SYNC_PRELOAD_INT_ST_L2_CACHE_PLD_ERR_INT_ST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ST.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ST.Reg)&^(0x1000)|value<<12)
}
func (o *EXTMEM_Type) GetL2_CACHE_SYNC_PRELOAD_INT_ST_L2_CACHE_PLD_ERR_INT_ST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_INT_ST.Reg) & 0x1000) >> 12
}

// EXTMEM.L2_CACHE_SYNC_PRELOAD_EXCEPTION: Cache Sync/Preload Operation exception register
func (o *EXTMEM_Type) SetL2_CACHE_SYNC_PRELOAD_EXCEPTION_L2_CACHE_PLD_ERR_CODE(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_PRELOAD_EXCEPTION.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_EXCEPTION.Reg)&^(0xc00)|value<<10)
}
func (o *EXTMEM_Type) GetL2_CACHE_SYNC_PRELOAD_EXCEPTION_L2_CACHE_PLD_ERR_CODE() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_PRELOAD_EXCEPTION.Reg) & 0xc00) >> 10
}

// EXTMEM.L2_CACHE_SYNC_RST_CTRL: Cache Sync Reset control register
func (o *EXTMEM_Type) SetL2_CACHE_SYNC_RST_CTRL_L2_CACHE_SYNC_RST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_SYNC_RST_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_SYNC_RST_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_SYNC_RST_CTRL_L2_CACHE_SYNC_RST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_SYNC_RST_CTRL.Reg) & 0x20) >> 5
}

// EXTMEM.L2_CACHE_PRELOAD_RST_CTRL: Cache Preload Reset control register
func (o *EXTMEM_Type) SetL2_CACHE_PRELOAD_RST_CTRL_L2_CACHE_PLD_RST(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_PRELOAD_RST_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_PRELOAD_RST_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_PRELOAD_RST_CTRL_L2_CACHE_PLD_RST() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_PRELOAD_RST_CTRL.Reg) & 0x20) >> 5
}

// EXTMEM.L2_CACHE_AUTOLOAD_BUF_CLR_CTRL: Cache Autoload buffer clear control register
func (o *EXTMEM_Type) SetL2_CACHE_AUTOLOAD_BUF_CLR_CTRL_L2_CACHE_ALD_BUF_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_AUTOLOAD_BUF_CLR_CTRL_L2_CACHE_ALD_BUF_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_AUTOLOAD_BUF_CLR_CTRL.Reg) & 0x20) >> 5
}

// EXTMEM.L2_UNALLOCATE_BUFFER_CLEAR: Unallocate request buffer clear registers
func (o *EXTMEM_Type) SetL2_UNALLOCATE_BUFFER_CLEAR_L2_CACHE_UNALLOC_CLR(value uint32) {
	volatile.StoreUint32(&o.L2_UNALLOCATE_BUFFER_CLEAR.Reg, volatile.LoadUint32(&o.L2_UNALLOCATE_BUFFER_CLEAR.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_UNALLOCATE_BUFFER_CLEAR_L2_CACHE_UNALLOC_CLR() uint32 {
	return (volatile.LoadUint32(&o.L2_UNALLOCATE_BUFFER_CLEAR.Reg) & 0x20) >> 5
}

// EXTMEM.L2_CACHE_ACCESS_ATTR_CTRL: L1 Cache access Attribute propagation control register
func (o *EXTMEM_Type) SetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_CC(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_CC() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg) & 0x1
}
func (o *EXTMEM_Type) SetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_WB(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_WB() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg) & 0x2) >> 1
}
func (o *EXTMEM_Type) SetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_WMA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_WMA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg) & 0x4) >> 2
}
func (o *EXTMEM_Type) SetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_RMA(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *EXTMEM_Type) GetL2_CACHE_ACCESS_ATTR_CTRL_L2_CACHE_ACCESS_FORCE_RMA() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_ACCESS_ATTR_CTRL.Reg) & 0x8) >> 3
}

// EXTMEM.L2_CACHE_OBJECT_CTRL: Cache Tag and Data memory Object control register
func (o *EXTMEM_Type) SetL2_CACHE_OBJECT_CTRL_L2_CACHE_TAG_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_OBJECT_CTRL.Reg)&^(0x20)|value<<5)
}
func (o *EXTMEM_Type) GetL2_CACHE_OBJECT_CTRL_L2_CACHE_TAG_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_OBJECT_CTRL.Reg) & 0x20) >> 5
}
func (o *EXTMEM_Type) SetL2_CACHE_OBJECT_CTRL_L2_CACHE_MEM_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_OBJECT_CTRL.Reg, volatile.LoadUint32(&o.L2_CACHE_OBJECT_CTRL.Reg)&^(0x800)|value<<11)
}
func (o *EXTMEM_Type) GetL2_CACHE_OBJECT_CTRL_L2_CACHE_MEM_OBJECT() uint32 {
	return (volatile.LoadUint32(&o.L2_CACHE_OBJECT_CTRL.Reg) & 0x800) >> 11
}

// EXTMEM.L2_CACHE_WAY_OBJECT: Cache Tag and Data memory way register
func (o *EXTMEM_Type) SetL2_CACHE_WAY_OBJECT(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_WAY_OBJECT.Reg, volatile.LoadUint32(&o.L2_CACHE_WAY_OBJECT.Reg)&^(0x7)|value)
}
func (o *EXTMEM_Type) GetL2_CACHE_WAY_OBJECT() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_WAY_OBJECT.Reg) & 0x7
}

// EXTMEM.L2_CACHE_VADDR: Cache Vaddr register
func (o *EXTMEM_Type) SetL2_CACHE_VADDR(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_VADDR.Reg, value)
}
func (o *EXTMEM_Type) GetL2_CACHE_VADDR() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_VADDR.Reg)
}

// EXTMEM.L2_CACHE_DEBUG_BUS: Cache Tag/data memory content register
func (o *EXTMEM_Type) SetL2_CACHE_DEBUG_BUS(value uint32) {
	volatile.StoreUint32(&o.L2_CACHE_DEBUG_BUS.Reg, value)
}
func (o *EXTMEM_Type) GetL2_CACHE_DEBUG_BUS() uint32 {
	return volatile.LoadUint32(&o.L2_CACHE_DEBUG_BUS.Reg)
}

// EXTMEM.LEVEL_SPLIT1: USED TO SPLIT L1 CACHE AND L2 CACHE
func (o *EXTMEM_Type) SetLEVEL_SPLIT1(value uint32) {
	volatile.StoreUint32(&o.LEVEL_SPLIT1.Reg, value)
}
func (o *EXTMEM_Type) GetLEVEL_SPLIT1() uint32 {
	return volatile.LoadUint32(&o.LEVEL_SPLIT1.Reg)
}

// EXTMEM.CLOCK_GATE: Clock gate control register
func (o *EXTMEM_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *EXTMEM_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// EXTMEM.REDUNDANCY_SIG0: Cache redundancy signal 0 register
func (o *EXTMEM_Type) SetREDUNDANCY_SIG0(value uint32) {
	volatile.StoreUint32(&o.REDUNDANCY_SIG0.Reg, value)
}
func (o *EXTMEM_Type) GetREDUNDANCY_SIG0() uint32 {
	return volatile.LoadUint32(&o.REDUNDANCY_SIG0.Reg)
}

// EXTMEM.REDUNDANCY_SIG1: Cache redundancy signal 1 register
func (o *EXTMEM_Type) SetREDUNDANCY_SIG1(value uint32) {
	volatile.StoreUint32(&o.REDUNDANCY_SIG1.Reg, value)
}
func (o *EXTMEM_Type) GetREDUNDANCY_SIG1() uint32 {
	return volatile.LoadUint32(&o.REDUNDANCY_SIG1.Reg)
}

// EXTMEM.REDUNDANCY_SIG2: Cache redundancy signal 2 register
func (o *EXTMEM_Type) SetREDUNDANCY_SIG2(value uint32) {
	volatile.StoreUint32(&o.REDUNDANCY_SIG2.Reg, value)
}
func (o *EXTMEM_Type) GetREDUNDANCY_SIG2() uint32 {
	return volatile.LoadUint32(&o.REDUNDANCY_SIG2.Reg)
}

// EXTMEM.REDUNDANCY_SIG3: Cache redundancy signal 3 register
func (o *EXTMEM_Type) SetREDUNDANCY_SIG3(value uint32) {
	volatile.StoreUint32(&o.REDUNDANCY_SIG3.Reg, value)
}
func (o *EXTMEM_Type) GetREDUNDANCY_SIG3() uint32 {
	return volatile.LoadUint32(&o.REDUNDANCY_SIG3.Reg)
}

// EXTMEM.REDUNDANCY_SIG4: Cache redundancy signal 0 register
func (o *EXTMEM_Type) SetREDUNDANCY_SIG4_CACHE_REDCY_SIG4(value uint32) {
	volatile.StoreUint32(&o.REDUNDANCY_SIG4.Reg, volatile.LoadUint32(&o.REDUNDANCY_SIG4.Reg)&^(0xf)|value)
}
func (o *EXTMEM_Type) GetREDUNDANCY_SIG4_CACHE_REDCY_SIG4() uint32 {
	return volatile.LoadUint32(&o.REDUNDANCY_SIG4.Reg) & 0xf
}

// EXTMEM.DATE: Version control register
func (o *EXTMEM_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *EXTMEM_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// General Purpose Input/Output
type GPIO_Type struct {
	BT_SELECT          volatile.Register32 // 0x0
	OUT                volatile.Register32 // 0x4
	OUT_W1TS           volatile.Register32 // 0x8
	OUT_W1TC           volatile.Register32 // 0xC
	OUT1               volatile.Register32 // 0x10
	OUT1_W1TS          volatile.Register32 // 0x14
	OUT1_W1TC          volatile.Register32 // 0x18
	SDIO_SELECT        volatile.Register32 // 0x1C
	ENABLE             volatile.Register32 // 0x20
	ENABLE_W1TS        volatile.Register32 // 0x24
	ENABLE_W1TC        volatile.Register32 // 0x28
	ENABLE1            volatile.Register32 // 0x2C
	ENABLE1_W1TS       volatile.Register32 // 0x30
	ENABLE1_W1TC       volatile.Register32 // 0x34
	STRAP              volatile.Register32 // 0x38
	IN                 volatile.Register32 // 0x3C
	IN1                volatile.Register32 // 0x40
	STATUS             volatile.Register32 // 0x44
	STATUS_W1TS        volatile.Register32 // 0x48
	STATUS_W1TC        volatile.Register32 // 0x4C
	STATUS1            volatile.Register32 // 0x50
	STATUS1_W1TS       volatile.Register32 // 0x54
	STATUS1_W1TC       volatile.Register32 // 0x58
	PCPU_INT           volatile.Register32 // 0x5C
	PCPU_NMI_INT       volatile.Register32 // 0x60
	CPUSDIO_INT        volatile.Register32 // 0x64
	PCPU_INT1          volatile.Register32 // 0x68
	PCPU_NMI_INT1      volatile.Register32 // 0x6C
	CPUSDIO_INT1       volatile.Register32 // 0x70
	PIN0               volatile.Register32 // 0x74
	PIN1               volatile.Register32 // 0x78
	PIN2               volatile.Register32 // 0x7C
	PIN3               volatile.Register32 // 0x80
	PIN4               volatile.Register32 // 0x84
	PIN5               volatile.Register32 // 0x88
	PIN6               volatile.Register32 // 0x8C
	PIN7               volatile.Register32 // 0x90
	PIN8               volatile.Register32 // 0x94
	PIN9               volatile.Register32 // 0x98
	PIN10              volatile.Register32 // 0x9C
	PIN11              volatile.Register32 // 0xA0
	PIN12              volatile.Register32 // 0xA4
	PIN13              volatile.Register32 // 0xA8
	PIN14              volatile.Register32 // 0xAC
	PIN15              volatile.Register32 // 0xB0
	PIN16              volatile.Register32 // 0xB4
	PIN17              volatile.Register32 // 0xB8
	PIN18              volatile.Register32 // 0xBC
	PIN19              volatile.Register32 // 0xC0
	PIN20              volatile.Register32 // 0xC4
	PIN21              volatile.Register32 // 0xC8
	PIN22              volatile.Register32 // 0xCC
	PIN23              volatile.Register32 // 0xD0
	PIN24              volatile.Register32 // 0xD4
	PIN25              volatile.Register32 // 0xD8
	PIN26              volatile.Register32 // 0xDC
	PIN27              volatile.Register32 // 0xE0
	PIN28              volatile.Register32 // 0xE4
	PIN29              volatile.Register32 // 0xE8
	PIN30              volatile.Register32 // 0xEC
	PIN31              volatile.Register32 // 0xF0
	PIN32              volatile.Register32 // 0xF4
	PIN33              volatile.Register32 // 0xF8
	PIN34              volatile.Register32 // 0xFC
	_                  [76]byte
	STATUS_NEXT        volatile.Register32 // 0x14C
	STATUS_NEXT1       volatile.Register32 // 0x150
	FUNC0_IN_SEL_CFG   volatile.Register32 // 0x154
	FUNC1_IN_SEL_CFG   volatile.Register32 // 0x158
	FUNC2_IN_SEL_CFG   volatile.Register32 // 0x15C
	FUNC3_IN_SEL_CFG   volatile.Register32 // 0x160
	FUNC4_IN_SEL_CFG   volatile.Register32 // 0x164
	FUNC5_IN_SEL_CFG   volatile.Register32 // 0x168
	FUNC6_IN_SEL_CFG   volatile.Register32 // 0x16C
	FUNC7_IN_SEL_CFG   volatile.Register32 // 0x170
	FUNC8_IN_SEL_CFG   volatile.Register32 // 0x174
	FUNC9_IN_SEL_CFG   volatile.Register32 // 0x178
	FUNC10_IN_SEL_CFG  volatile.Register32 // 0x17C
	FUNC11_IN_SEL_CFG  volatile.Register32 // 0x180
	FUNC12_IN_SEL_CFG  volatile.Register32 // 0x184
	FUNC13_IN_SEL_CFG  volatile.Register32 // 0x188
	FUNC14_IN_SEL_CFG  volatile.Register32 // 0x18C
	FUNC15_IN_SEL_CFG  volatile.Register32 // 0x190
	FUNC16_IN_SEL_CFG  volatile.Register32 // 0x194
	FUNC17_IN_SEL_CFG  volatile.Register32 // 0x198
	FUNC18_IN_SEL_CFG  volatile.Register32 // 0x19C
	FUNC19_IN_SEL_CFG  volatile.Register32 // 0x1A0
	FUNC20_IN_SEL_CFG  volatile.Register32 // 0x1A4
	FUNC21_IN_SEL_CFG  volatile.Register32 // 0x1A8
	FUNC22_IN_SEL_CFG  volatile.Register32 // 0x1AC
	FUNC23_IN_SEL_CFG  volatile.Register32 // 0x1B0
	FUNC24_IN_SEL_CFG  volatile.Register32 // 0x1B4
	FUNC25_IN_SEL_CFG  volatile.Register32 // 0x1B8
	FUNC26_IN_SEL_CFG  volatile.Register32 // 0x1BC
	FUNC27_IN_SEL_CFG  volatile.Register32 // 0x1C0
	FUNC28_IN_SEL_CFG  volatile.Register32 // 0x1C4
	FUNC29_IN_SEL_CFG  volatile.Register32 // 0x1C8
	FUNC30_IN_SEL_CFG  volatile.Register32 // 0x1CC
	FUNC31_IN_SEL_CFG  volatile.Register32 // 0x1D0
	FUNC32_IN_SEL_CFG  volatile.Register32 // 0x1D4
	FUNC33_IN_SEL_CFG  volatile.Register32 // 0x1D8
	FUNC34_IN_SEL_CFG  volatile.Register32 // 0x1DC
	FUNC35_IN_SEL_CFG  volatile.Register32 // 0x1E0
	FUNC36_IN_SEL_CFG  volatile.Register32 // 0x1E4
	FUNC37_IN_SEL_CFG  volatile.Register32 // 0x1E8
	FUNC38_IN_SEL_CFG  volatile.Register32 // 0x1EC
	FUNC39_IN_SEL_CFG  volatile.Register32 // 0x1F0
	FUNC40_IN_SEL_CFG  volatile.Register32 // 0x1F4
	FUNC41_IN_SEL_CFG  volatile.Register32 // 0x1F8
	FUNC42_IN_SEL_CFG  volatile.Register32 // 0x1FC
	FUNC43_IN_SEL_CFG  volatile.Register32 // 0x200
	FUNC44_IN_SEL_CFG  volatile.Register32 // 0x204
	FUNC45_IN_SEL_CFG  volatile.Register32 // 0x208
	FUNC46_IN_SEL_CFG  volatile.Register32 // 0x20C
	FUNC47_IN_SEL_CFG  volatile.Register32 // 0x210
	FUNC48_IN_SEL_CFG  volatile.Register32 // 0x214
	FUNC49_IN_SEL_CFG  volatile.Register32 // 0x218
	FUNC50_IN_SEL_CFG  volatile.Register32 // 0x21C
	FUNC51_IN_SEL_CFG  volatile.Register32 // 0x220
	FUNC52_IN_SEL_CFG  volatile.Register32 // 0x224
	FUNC53_IN_SEL_CFG  volatile.Register32 // 0x228
	FUNC54_IN_SEL_CFG  volatile.Register32 // 0x22C
	FUNC55_IN_SEL_CFG  volatile.Register32 // 0x230
	FUNC56_IN_SEL_CFG  volatile.Register32 // 0x234
	FUNC57_IN_SEL_CFG  volatile.Register32 // 0x238
	FUNC58_IN_SEL_CFG  volatile.Register32 // 0x23C
	FUNC59_IN_SEL_CFG  volatile.Register32 // 0x240
	FUNC60_IN_SEL_CFG  volatile.Register32 // 0x244
	FUNC61_IN_SEL_CFG  volatile.Register32 // 0x248
	FUNC62_IN_SEL_CFG  volatile.Register32 // 0x24C
	FUNC63_IN_SEL_CFG  volatile.Register32 // 0x250
	FUNC64_IN_SEL_CFG  volatile.Register32 // 0x254
	FUNC65_IN_SEL_CFG  volatile.Register32 // 0x258
	FUNC66_IN_SEL_CFG  volatile.Register32 // 0x25C
	FUNC67_IN_SEL_CFG  volatile.Register32 // 0x260
	FUNC68_IN_SEL_CFG  volatile.Register32 // 0x264
	FUNC69_IN_SEL_CFG  volatile.Register32 // 0x268
	FUNC70_IN_SEL_CFG  volatile.Register32 // 0x26C
	FUNC71_IN_SEL_CFG  volatile.Register32 // 0x270
	FUNC72_IN_SEL_CFG  volatile.Register32 // 0x274
	FUNC73_IN_SEL_CFG  volatile.Register32 // 0x278
	FUNC74_IN_SEL_CFG  volatile.Register32 // 0x27C
	FUNC75_IN_SEL_CFG  volatile.Register32 // 0x280
	FUNC76_IN_SEL_CFG  volatile.Register32 // 0x284
	FUNC77_IN_SEL_CFG  volatile.Register32 // 0x288
	FUNC78_IN_SEL_CFG  volatile.Register32 // 0x28C
	FUNC79_IN_SEL_CFG  volatile.Register32 // 0x290
	FUNC80_IN_SEL_CFG  volatile.Register32 // 0x294
	FUNC81_IN_SEL_CFG  volatile.Register32 // 0x298
	FUNC82_IN_SEL_CFG  volatile.Register32 // 0x29C
	FUNC83_IN_SEL_CFG  volatile.Register32 // 0x2A0
	FUNC84_IN_SEL_CFG  volatile.Register32 // 0x2A4
	FUNC85_IN_SEL_CFG  volatile.Register32 // 0x2A8
	FUNC86_IN_SEL_CFG  volatile.Register32 // 0x2AC
	FUNC87_IN_SEL_CFG  volatile.Register32 // 0x2B0
	FUNC88_IN_SEL_CFG  volatile.Register32 // 0x2B4
	FUNC89_IN_SEL_CFG  volatile.Register32 // 0x2B8
	FUNC90_IN_SEL_CFG  volatile.Register32 // 0x2BC
	FUNC91_IN_SEL_CFG  volatile.Register32 // 0x2C0
	FUNC92_IN_SEL_CFG  volatile.Register32 // 0x2C4
	FUNC93_IN_SEL_CFG  volatile.Register32 // 0x2C8
	FUNC94_IN_SEL_CFG  volatile.Register32 // 0x2CC
	FUNC95_IN_SEL_CFG  volatile.Register32 // 0x2D0
	FUNC96_IN_SEL_CFG  volatile.Register32 // 0x2D4
	FUNC97_IN_SEL_CFG  volatile.Register32 // 0x2D8
	FUNC98_IN_SEL_CFG  volatile.Register32 // 0x2DC
	FUNC99_IN_SEL_CFG  volatile.Register32 // 0x2E0
	FUNC100_IN_SEL_CFG volatile.Register32 // 0x2E4
	FUNC101_IN_SEL_CFG volatile.Register32 // 0x2E8
	FUNC102_IN_SEL_CFG volatile.Register32 // 0x2EC
	FUNC103_IN_SEL_CFG volatile.Register32 // 0x2F0
	FUNC104_IN_SEL_CFG volatile.Register32 // 0x2F4
	FUNC105_IN_SEL_CFG volatile.Register32 // 0x2F8
	FUNC106_IN_SEL_CFG volatile.Register32 // 0x2FC
	FUNC107_IN_SEL_CFG volatile.Register32 // 0x300
	FUNC108_IN_SEL_CFG volatile.Register32 // 0x304
	FUNC109_IN_SEL_CFG volatile.Register32 // 0x308
	FUNC110_IN_SEL_CFG volatile.Register32 // 0x30C
	FUNC111_IN_SEL_CFG volatile.Register32 // 0x310
	FUNC112_IN_SEL_CFG volatile.Register32 // 0x314
	FUNC113_IN_SEL_CFG volatile.Register32 // 0x318
	FUNC114_IN_SEL_CFG volatile.Register32 // 0x31C
	FUNC115_IN_SEL_CFG volatile.Register32 // 0x320
	FUNC116_IN_SEL_CFG volatile.Register32 // 0x324
	FUNC117_IN_SEL_CFG volatile.Register32 // 0x328
	FUNC118_IN_SEL_CFG volatile.Register32 // 0x32C
	FUNC119_IN_SEL_CFG volatile.Register32 // 0x330
	FUNC120_IN_SEL_CFG volatile.Register32 // 0x334
	FUNC121_IN_SEL_CFG volatile.Register32 // 0x338
	FUNC122_IN_SEL_CFG volatile.Register32 // 0x33C
	FUNC123_IN_SEL_CFG volatile.Register32 // 0x340
	FUNC124_IN_SEL_CFG volatile.Register32 // 0x344
	FUNC125_IN_SEL_CFG volatile.Register32 // 0x348
	FUNC126_IN_SEL_CFG volatile.Register32 // 0x34C
	FUNC127_IN_SEL_CFG volatile.Register32 // 0x350
	_                  [512]byte
	FUNC0_OUT_SEL_CFG  volatile.Register32 // 0x554
	FUNC1_OUT_SEL_CFG  volatile.Register32 // 0x558
	FUNC2_OUT_SEL_CFG  volatile.Register32 // 0x55C
	FUNC3_OUT_SEL_CFG  volatile.Register32 // 0x560
	FUNC4_OUT_SEL_CFG  volatile.Register32 // 0x564
	FUNC5_OUT_SEL_CFG  volatile.Register32 // 0x568
	FUNC6_OUT_SEL_CFG  volatile.Register32 // 0x56C
	FUNC7_OUT_SEL_CFG  volatile.Register32 // 0x570
	FUNC8_OUT_SEL_CFG  volatile.Register32 // 0x574
	FUNC9_OUT_SEL_CFG  volatile.Register32 // 0x578
	FUNC10_OUT_SEL_CFG volatile.Register32 // 0x57C
	FUNC11_OUT_SEL_CFG volatile.Register32 // 0x580
	FUNC12_OUT_SEL_CFG volatile.Register32 // 0x584
	FUNC13_OUT_SEL_CFG volatile.Register32 // 0x588
	FUNC14_OUT_SEL_CFG volatile.Register32 // 0x58C
	FUNC15_OUT_SEL_CFG volatile.Register32 // 0x590
	FUNC16_OUT_SEL_CFG volatile.Register32 // 0x594
	FUNC17_OUT_SEL_CFG volatile.Register32 // 0x598
	FUNC18_OUT_SEL_CFG volatile.Register32 // 0x59C
	FUNC19_OUT_SEL_CFG volatile.Register32 // 0x5A0
	FUNC20_OUT_SEL_CFG volatile.Register32 // 0x5A4
	FUNC21_OUT_SEL_CFG volatile.Register32 // 0x5A8
	FUNC22_OUT_SEL_CFG volatile.Register32 // 0x5AC
	FUNC23_OUT_SEL_CFG volatile.Register32 // 0x5B0
	FUNC24_OUT_SEL_CFG volatile.Register32 // 0x5B4
	FUNC25_OUT_SEL_CFG volatile.Register32 // 0x5B8
	FUNC26_OUT_SEL_CFG volatile.Register32 // 0x5BC
	FUNC27_OUT_SEL_CFG volatile.Register32 // 0x5C0
	FUNC28_OUT_SEL_CFG volatile.Register32 // 0x5C4
	FUNC29_OUT_SEL_CFG volatile.Register32 // 0x5C8
	_                  [96]byte
	CLOCK_GATE         volatile.Register32 // 0x62C
	_                  [204]byte
	DATE               volatile.Register32 // 0x6FC
}

// GPIO.BT_SELECT: GPIO bit select register
func (o *GPIO_Type) SetBT_SELECT(value uint32) {
	volatile.StoreUint32(&o.BT_SELECT.Reg, value)
}
func (o *GPIO_Type) GetBT_SELECT() uint32 {
	return volatile.LoadUint32(&o.BT_SELECT.Reg)
}

// GPIO.OUT: GPIO output register for GPIO0-31
func (o *GPIO_Type) SetOUT(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, value)
}
func (o *GPIO_Type) GetOUT() uint32 {
	return volatile.LoadUint32(&o.OUT.Reg)
}

// GPIO.OUT_W1TS: GPIO output set register for GPIO0-31
func (o *GPIO_Type) SetOUT_W1TS(value uint32) {
	volatile.StoreUint32(&o.OUT_W1TS.Reg, value)
}
func (o *GPIO_Type) GetOUT_W1TS() uint32 {
	return volatile.LoadUint32(&o.OUT_W1TS.Reg)
}

// GPIO.OUT_W1TC: GPIO output clear register for GPIO0-31
func (o *GPIO_Type) SetOUT_W1TC(value uint32) {
	volatile.StoreUint32(&o.OUT_W1TC.Reg, value)
}
func (o *GPIO_Type) GetOUT_W1TC() uint32 {
	return volatile.LoadUint32(&o.OUT_W1TC.Reg)
}

// GPIO.OUT1: GPIO output register for GPIO32-34
func (o *GPIO_Type) SetOUT1_DATA_ORIG(value uint32) {
	volatile.StoreUint32(&o.OUT1.Reg, volatile.LoadUint32(&o.OUT1.Reg)&^(0x7)|value)
}
func (o *GPIO_Type) GetOUT1_DATA_ORIG() uint32 {
	return volatile.LoadUint32(&o.OUT1.Reg) & 0x7
}

// GPIO.OUT1_W1TS: GPIO output set register for GPIO32-34
func (o *GPIO_Type) SetOUT1_W1TS(value uint32) {
	volatile.StoreUint32(&o.OUT1_W1TS.Reg, volatile.LoadUint32(&o.OUT1_W1TS.Reg)&^(0x7)|value)
}
func (o *GPIO_Type) GetOUT1_W1TS() uint32 {
	return volatile.LoadUint32(&o.OUT1_W1TS.Reg) & 0x7
}

// GPIO.OUT1_W1TC: GPIO output clear register for GPIO32-34
func (o *GPIO_Type) SetOUT1_W1TC(value uint32) {
	volatile.StoreUint32(&o.OUT1_W1TC.Reg, volatile.LoadUint32(&o.OUT1_W1TC.Reg)&^(0x7)|value)
}
func (o *GPIO_Type) GetOUT1_W1TC() uint32 {
	return volatile.LoadUint32(&o.OUT1_W1TC.Reg) & 0x7
}

// GPIO.SDIO_SELECT: GPIO sdio select register
func (o *GPIO_Type) SetSDIO_SELECT_SDIO_SEL(value uint32) {
	volatile.StoreUint32(&o.SDIO_SELECT.Reg, volatile.LoadUint32(&o.SDIO_SELECT.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetSDIO_SELECT_SDIO_SEL() uint32 {
	return volatile.LoadUint32(&o.SDIO_SELECT.Reg) & 0xff
}

// GPIO.ENABLE: GPIO output enable register for GPIO0-31
func (o *GPIO_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, value)
}
func (o *GPIO_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg)
}

// GPIO.ENABLE_W1TS: GPIO output enable set register for GPIO0-31
func (o *GPIO_Type) SetENABLE_W1TS(value uint32) {
	volatile.StoreUint32(&o.ENABLE_W1TS.Reg, value)
}
func (o *GPIO_Type) GetENABLE_W1TS() uint32 {
	return volatile.LoadUint32(&o.ENABLE_W1TS.Reg)
}

// GPIO.ENABLE_W1TC: GPIO output enable clear register for GPIO0-31
func (o *GPIO_Type) SetENABLE_W1TC(value uint32) {
	volatile.StoreUint32(&o.ENABLE_W1TC.Reg, value)
}
func (o *GPIO_Type) GetENABLE_W1TC() uint32 {
	return volatile.LoadUint32(&o.ENABLE_W1TC.Reg)
}

// GPIO.ENABLE1: GPIO output enable register for GPIO32-34
func (o *GPIO_Type) SetENABLE1_DATA(value uint32) {
	volatile.StoreUint32(&o.ENABLE1.Reg, volatile.LoadUint32(&o.ENABLE1.Reg)&^(0x7)|value)
}
func (o *GPIO_Type) GetENABLE1_DATA() uint32 {
	return volatile.LoadUint32(&o.ENABLE1.Reg) & 0x7
}

// GPIO.ENABLE1_W1TS: GPIO output enable set register for GPIO32-34
func (o *GPIO_Type) SetENABLE1_W1TS(value uint32) {
	volatile.StoreUint32(&o.ENABLE1_W1TS.Reg, volatile.LoadUint32(&o.ENABLE1_W1TS.Reg)&^(0x7)|value)
}
func (o *GPIO_Type) GetENABLE1_W1TS() uint32 {
	return volatile.LoadUint32(&o.ENABLE1_W1TS.Reg) & 0x7
}

// GPIO.ENABLE1_W1TC: GPIO output enable clear register for GPIO32-34
func (o *GPIO_Type) SetENABLE1_W1TC(value uint32) {
	volatile.StoreUint32(&o.ENABLE1_W1TC.Reg, volatile.LoadUint32(&o.ENABLE1_W1TC.Reg)&^(0x7)|value)
}
func (o *GPIO_Type) GetENABLE1_W1TC() uint32 {
	return volatile.LoadUint32(&o.ENABLE1_W1TC.Reg) & 0x7
}

// GPIO.STRAP: pad strapping register
func (o *GPIO_Type) SetSTRAP_STRAPPING(value uint32) {
	volatile.StoreUint32(&o.STRAP.Reg, volatile.LoadUint32(&o.STRAP.Reg)&^(0xffff)|value)
}
func (o *GPIO_Type) GetSTRAP_STRAPPING() uint32 {
	return volatile.LoadUint32(&o.STRAP.Reg) & 0xffff
}

// GPIO.IN: GPIO input register for GPIO0-31
func (o *GPIO_Type) SetIN(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, value)
}
func (o *GPIO_Type) GetIN() uint32 {
	return volatile.LoadUint32(&o.IN.Reg)
}

// GPIO.IN1: GPIO input register for GPIO32-34
func (o *GPIO_Type) SetIN1_DATA_NEXT(value uint32) {
	volatile.StoreUint32(&o.IN1.Reg, volatile.LoadUint32(&o.IN1.Reg)&^(0x7)|value)
}
func (o *GPIO_Type) GetIN1_DATA_NEXT() uint32 {
	return volatile.LoadUint32(&o.IN1.Reg) & 0x7
}

// GPIO.STATUS: GPIO interrupt status register for GPIO0-31
func (o *GPIO_Type) SetSTATUS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, value)
}
func (o *GPIO_Type) GetSTATUS() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg)
}

// GPIO.STATUS_W1TS: GPIO interrupt status set register for GPIO0-31
func (o *GPIO_Type) SetSTATUS_W1TS(value uint32) {
	volatile.StoreUint32(&o.STATUS_W1TS.Reg, value)
}
func (o *GPIO_Type) GetSTATUS_W1TS() uint32 {
	return volatile.LoadUint32(&o.STATUS_W1TS.Reg)
}

// GPIO.STATUS_W1TC: GPIO interrupt status clear register for GPIO0-31
func (o *GPIO_Type) SetSTATUS_W1TC(value uint32) {
	volatile.StoreUint32(&o.STATUS_W1TC.Reg, value)
}
func (o *GPIO_Type) GetSTATUS_W1TC() uint32 {
	return volatile.LoadUint32(&o.STATUS_W1TC.Reg)
}

// GPIO.STATUS1: GPIO interrupt status register for GPIO32-34
func (o *GPIO_Type) SetSTATUS1_INTERRUPT(value uint32) {
	volatile.StoreUint32(&o.STATUS1.Reg, volatile.LoadUint32(&o.STATUS1.Reg)&^(0x7)|value)
}
func (o *GPIO_Type) GetSTATUS1_INTERRUPT() uint32 {
	return volatile.LoadUint32(&o.STATUS1.Reg) & 0x7
}

// GPIO.STATUS1_W1TS: GPIO interrupt status set register for GPIO32-34
func (o *GPIO_Type) SetSTATUS1_W1TS(value uint32) {
	volatile.StoreUint32(&o.STATUS1_W1TS.Reg, volatile.LoadUint32(&o.STATUS1_W1TS.Reg)&^(0x7)|value)
}
func (o *GPIO_Type) GetSTATUS1_W1TS() uint32 {
	return volatile.LoadUint32(&o.STATUS1_W1TS.Reg) & 0x7
}

// GPIO.STATUS1_W1TC: GPIO interrupt status clear register for GPIO32-34
func (o *GPIO_Type) SetSTATUS1_W1TC(value uint32) {
	volatile.StoreUint32(&o.STATUS1_W1TC.Reg, volatile.LoadUint32(&o.STATUS1_W1TC.Reg)&^(0x7)|value)
}
func (o *GPIO_Type) GetSTATUS1_W1TC() uint32 {
	return volatile.LoadUint32(&o.STATUS1_W1TC.Reg) & 0x7
}

// GPIO.PCPU_INT: GPIO PRO_CPU interrupt status register for GPIO0-31
func (o *GPIO_Type) SetPCPU_INT(value uint32) {
	volatile.StoreUint32(&o.PCPU_INT.Reg, value)
}
func (o *GPIO_Type) GetPCPU_INT() uint32 {
	return volatile.LoadUint32(&o.PCPU_INT.Reg)
}

// GPIO.PCPU_NMI_INT: GPIO PRO_CPU(not shielded) interrupt status register for GPIO0-31
func (o *GPIO_Type) SetPCPU_NMI_INT(value uint32) {
	volatile.StoreUint32(&o.PCPU_NMI_INT.Reg, value)
}
func (o *GPIO_Type) GetPCPU_NMI_INT() uint32 {
	return volatile.LoadUint32(&o.PCPU_NMI_INT.Reg)
}

// GPIO.CPUSDIO_INT: GPIO CPUSDIO interrupt status register for GPIO0-31
func (o *GPIO_Type) SetCPUSDIO_INT(value uint32) {
	volatile.StoreUint32(&o.CPUSDIO_INT.Reg, value)
}
func (o *GPIO_Type) GetCPUSDIO_INT() uint32 {
	return volatile.LoadUint32(&o.CPUSDIO_INT.Reg)
}

// GPIO.PCPU_INT1: GPIO PRO_CPU interrupt status register for GPIO32-34
func (o *GPIO_Type) SetPCPU_INT1_PROCPU_INT1(value uint32) {
	volatile.StoreUint32(&o.PCPU_INT1.Reg, volatile.LoadUint32(&o.PCPU_INT1.Reg)&^(0x7)|value)
}
func (o *GPIO_Type) GetPCPU_INT1_PROCPU_INT1() uint32 {
	return volatile.LoadUint32(&o.PCPU_INT1.Reg) & 0x7
}

// GPIO.PCPU_NMI_INT1: GPIO PRO_CPU(not shielded) interrupt status register for GPIO32-34
func (o *GPIO_Type) SetPCPU_NMI_INT1_PROCPU_NMI_INT1(value uint32) {
	volatile.StoreUint32(&o.PCPU_NMI_INT1.Reg, volatile.LoadUint32(&o.PCPU_NMI_INT1.Reg)&^(0x7)|value)
}
func (o *GPIO_Type) GetPCPU_NMI_INT1_PROCPU_NMI_INT1() uint32 {
	return volatile.LoadUint32(&o.PCPU_NMI_INT1.Reg) & 0x7
}

// GPIO.CPUSDIO_INT1: GPIO CPUSDIO interrupt status register for GPIO32-34
func (o *GPIO_Type) SetCPUSDIO_INT1_SDIO_INT1(value uint32) {
	volatile.StoreUint32(&o.CPUSDIO_INT1.Reg, volatile.LoadUint32(&o.CPUSDIO_INT1.Reg)&^(0x7)|value)
}
func (o *GPIO_Type) GetCPUSDIO_INT1_SDIO_INT1() uint32 {
	return volatile.LoadUint32(&o.CPUSDIO_INT1.Reg) & 0x7
}

// GPIO.PIN0: GPIO pin configuration register
func (o *GPIO_Type) SetPIN0_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN0_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN0.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN0_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN0_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN0_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN0_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN0_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN0_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN0_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN0_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN0_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN0_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN0_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN0_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x3e000) >> 13
}

// GPIO.PIN1: GPIO pin configuration register
func (o *GPIO_Type) SetPIN1_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN1_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN1.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN1_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN1_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN1_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN1_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN1_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN1_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN1_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN1_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN1_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN1_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN1_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN1_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x3e000) >> 13
}

// GPIO.PIN2: GPIO pin configuration register
func (o *GPIO_Type) SetPIN2_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN2_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN2.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN2_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN2_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN2_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN2_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN2_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN2_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN2_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN2_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN2_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN2_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN2_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN2_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x3e000) >> 13
}

// GPIO.PIN3: GPIO pin configuration register
func (o *GPIO_Type) SetPIN3_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN3_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN3.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN3_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN3_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN3_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN3_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN3_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN3_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN3_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN3_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN3_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN3_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN3_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN3_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x3e000) >> 13
}

// GPIO.PIN4: GPIO pin configuration register
func (o *GPIO_Type) SetPIN4_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN4_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN4.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN4_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN4_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN4_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN4_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN4_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN4_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN4_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN4_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN4_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN4_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN4_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN4_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x3e000) >> 13
}

// GPIO.PIN5: GPIO pin configuration register
func (o *GPIO_Type) SetPIN5_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN5_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN5.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN5_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN5_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN5_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN5_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN5_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN5_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN5_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN5_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN5_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN5_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN5_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN5_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x3e000) >> 13
}

// GPIO.PIN6: GPIO pin configuration register
func (o *GPIO_Type) SetPIN6_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN6_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN6.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN6_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN6_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN6_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN6_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN6_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN6_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN6_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN6_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN6_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN6_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN6_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN6.Reg, volatile.LoadUint32(&o.PIN6.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN6_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN6.Reg) & 0x3e000) >> 13
}

// GPIO.PIN7: GPIO pin configuration register
func (o *GPIO_Type) SetPIN7_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN7_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN7.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN7_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN7_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN7_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN7_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN7_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN7_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN7_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN7_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN7_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN7_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN7_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN7.Reg, volatile.LoadUint32(&o.PIN7.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN7_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN7.Reg) & 0x3e000) >> 13
}

// GPIO.PIN8: GPIO pin configuration register
func (o *GPIO_Type) SetPIN8_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN8_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN8.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN8_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN8_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN8_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN8_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN8_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN8_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN8_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN8_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN8_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN8_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN8_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN8.Reg, volatile.LoadUint32(&o.PIN8.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN8_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN8.Reg) & 0x3e000) >> 13
}

// GPIO.PIN9: GPIO pin configuration register
func (o *GPIO_Type) SetPIN9_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN9_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN9.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN9_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN9_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN9_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN9_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN9_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN9_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN9_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN9_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN9_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN9_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN9_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN9.Reg, volatile.LoadUint32(&o.PIN9.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN9_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN9.Reg) & 0x3e000) >> 13
}

// GPIO.PIN10: GPIO pin configuration register
func (o *GPIO_Type) SetPIN10_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN10_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN10.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN10_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN10_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN10_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN10_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN10_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN10_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN10_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN10_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN10_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN10_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN10_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN10.Reg, volatile.LoadUint32(&o.PIN10.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN10_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN10.Reg) & 0x3e000) >> 13
}

// GPIO.PIN11: GPIO pin configuration register
func (o *GPIO_Type) SetPIN11_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN11_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN11.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN11_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN11_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN11_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN11_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN11_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN11_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN11_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN11_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN11_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN11_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN11_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN11.Reg, volatile.LoadUint32(&o.PIN11.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN11_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN11.Reg) & 0x3e000) >> 13
}

// GPIO.PIN12: GPIO pin configuration register
func (o *GPIO_Type) SetPIN12_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN12_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN12.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN12_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN12_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN12_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN12_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN12_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN12_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN12_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN12_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN12_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN12_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN12_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN12.Reg, volatile.LoadUint32(&o.PIN12.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN12_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN12.Reg) & 0x3e000) >> 13
}

// GPIO.PIN13: GPIO pin configuration register
func (o *GPIO_Type) SetPIN13_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN13_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN13.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN13_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN13_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN13_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN13_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN13_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN13_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN13_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN13_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN13_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN13_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN13_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN13.Reg, volatile.LoadUint32(&o.PIN13.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN13_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN13.Reg) & 0x3e000) >> 13
}

// GPIO.PIN14: GPIO pin configuration register
func (o *GPIO_Type) SetPIN14_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN14_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN14.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN14_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN14_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN14_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN14_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN14_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN14_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN14_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN14_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN14_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN14_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN14_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN14.Reg, volatile.LoadUint32(&o.PIN14.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN14_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN14.Reg) & 0x3e000) >> 13
}

// GPIO.PIN15: GPIO pin configuration register
func (o *GPIO_Type) SetPIN15_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN15_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN15.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN15_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN15_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN15_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN15_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN15_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN15_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN15_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN15_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN15_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN15_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN15_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN15.Reg, volatile.LoadUint32(&o.PIN15.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN15_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN15.Reg) & 0x3e000) >> 13
}

// GPIO.PIN16: GPIO pin configuration register
func (o *GPIO_Type) SetPIN16_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN16_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN16.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN16_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN16_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN16_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN16_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN16_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN16_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN16_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN16_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN16_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN16_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN16_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN16.Reg, volatile.LoadUint32(&o.PIN16.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN16_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN16.Reg) & 0x3e000) >> 13
}

// GPIO.PIN17: GPIO pin configuration register
func (o *GPIO_Type) SetPIN17_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN17_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN17.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN17_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN17_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN17_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN17_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN17_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN17_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN17_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN17_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN17_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN17_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN17_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN17.Reg, volatile.LoadUint32(&o.PIN17.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN17_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN17.Reg) & 0x3e000) >> 13
}

// GPIO.PIN18: GPIO pin configuration register
func (o *GPIO_Type) SetPIN18_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN18_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN18.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN18_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN18_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN18_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN18_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN18_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN18_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN18_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN18_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN18_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN18_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN18_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN18.Reg, volatile.LoadUint32(&o.PIN18.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN18_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN18.Reg) & 0x3e000) >> 13
}

// GPIO.PIN19: GPIO pin configuration register
func (o *GPIO_Type) SetPIN19_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN19_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN19.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN19_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN19_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN19_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN19_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN19_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN19_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN19_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN19_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN19_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN19_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN19_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN19.Reg, volatile.LoadUint32(&o.PIN19.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN19_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN19.Reg) & 0x3e000) >> 13
}

// GPIO.PIN20: GPIO pin configuration register
func (o *GPIO_Type) SetPIN20_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN20_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN20.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN20_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN20_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN20_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN20_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN20_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN20_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN20_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN20_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN20_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN20_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN20_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN20.Reg, volatile.LoadUint32(&o.PIN20.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN20_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN20.Reg) & 0x3e000) >> 13
}

// GPIO.PIN21: GPIO pin configuration register
func (o *GPIO_Type) SetPIN21_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN21_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN21.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN21_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN21_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN21_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN21_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN21_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN21_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN21_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN21_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN21_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN21_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN21_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN21.Reg, volatile.LoadUint32(&o.PIN21.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN21_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN21.Reg) & 0x3e000) >> 13
}

// GPIO.PIN22: GPIO pin configuration register
func (o *GPIO_Type) SetPIN22_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN22_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN22.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN22_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN22_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN22_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN22_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN22_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN22_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN22_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN22_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN22_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN22_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN22_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN22.Reg, volatile.LoadUint32(&o.PIN22.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN22_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN22.Reg) & 0x3e000) >> 13
}

// GPIO.PIN23: GPIO pin configuration register
func (o *GPIO_Type) SetPIN23_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN23_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN23.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN23_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN23_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN23_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN23_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN23_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN23_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN23_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN23_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN23_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN23_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN23_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN23.Reg, volatile.LoadUint32(&o.PIN23.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN23_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN23.Reg) & 0x3e000) >> 13
}

// GPIO.PIN24: GPIO pin configuration register
func (o *GPIO_Type) SetPIN24_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN24_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN24.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN24_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN24_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN24_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN24_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN24_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN24_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN24_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN24_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN24_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN24_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN24_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN24.Reg, volatile.LoadUint32(&o.PIN24.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN24_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN24.Reg) & 0x3e000) >> 13
}

// GPIO.PIN25: GPIO pin configuration register
func (o *GPIO_Type) SetPIN25_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN25_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN25.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN25_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN25_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN25_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN25_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN25_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN25_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN25_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN25_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN25_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN25_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN25_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN25.Reg, volatile.LoadUint32(&o.PIN25.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN25_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN25.Reg) & 0x3e000) >> 13
}

// GPIO.PIN26: GPIO pin configuration register
func (o *GPIO_Type) SetPIN26_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN26_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN26.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN26_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN26_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN26_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN26_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN26_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN26_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN26_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN26_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN26_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN26_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN26_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN26.Reg, volatile.LoadUint32(&o.PIN26.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN26_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN26.Reg) & 0x3e000) >> 13
}

// GPIO.PIN27: GPIO pin configuration register
func (o *GPIO_Type) SetPIN27_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN27_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN27.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN27_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN27_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN27_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN27_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN27_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN27_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN27_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN27_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN27_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN27_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN27_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN27.Reg, volatile.LoadUint32(&o.PIN27.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN27_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN27.Reg) & 0x3e000) >> 13
}

// GPIO.PIN28: GPIO pin configuration register
func (o *GPIO_Type) SetPIN28_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN28_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN28.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN28_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN28_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN28_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN28_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN28_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN28_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN28_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN28_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN28_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN28_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN28_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN28.Reg, volatile.LoadUint32(&o.PIN28.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN28_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN28.Reg) & 0x3e000) >> 13
}

// GPIO.PIN29: GPIO pin configuration register
func (o *GPIO_Type) SetPIN29_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN29_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN29.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN29_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN29_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN29_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN29_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN29_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN29_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN29_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN29_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN29_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN29_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN29_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN29.Reg, volatile.LoadUint32(&o.PIN29.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN29_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN29.Reg) & 0x3e000) >> 13
}

// GPIO.PIN30: GPIO pin configuration register
func (o *GPIO_Type) SetPIN30_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN30_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN30.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN30_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN30_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN30_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN30_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN30_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN30_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN30_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN30_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN30_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN30_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN30_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN30.Reg, volatile.LoadUint32(&o.PIN30.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN30_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN30.Reg) & 0x3e000) >> 13
}

// GPIO.PIN31: GPIO pin configuration register
func (o *GPIO_Type) SetPIN31_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN31_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN31.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN31_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN31_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN31_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN31_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN31_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN31_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN31_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN31_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN31_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN31_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN31_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN31.Reg, volatile.LoadUint32(&o.PIN31.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN31_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN31.Reg) & 0x3e000) >> 13
}

// GPIO.PIN32: GPIO pin configuration register
func (o *GPIO_Type) SetPIN32_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN32_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN32.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN32_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN32_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN32_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN32_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN32_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN32_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN32_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN32_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN32_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN32_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN32_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN32.Reg, volatile.LoadUint32(&o.PIN32.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN32_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN32.Reg) & 0x3e000) >> 13
}

// GPIO.PIN33: GPIO pin configuration register
func (o *GPIO_Type) SetPIN33_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN33_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN33.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN33_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN33_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN33_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN33_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN33_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN33_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN33_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN33_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN33_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN33_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN33_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN33.Reg, volatile.LoadUint32(&o.PIN33.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN33_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN33.Reg) & 0x3e000) >> 13
}

// GPIO.PIN34: GPIO pin configuration register
func (o *GPIO_Type) SetPIN34_SYNC2_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPIN34_SYNC2_BYPASS() uint32 {
	return volatile.LoadUint32(&o.PIN34.Reg) & 0x3
}
func (o *GPIO_Type) SetPIN34_PAD_DRIVER(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN34_PAD_DRIVER() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN34_SYNC1_BYPASS(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x18)|value<<3)
}
func (o *GPIO_Type) GetPIN34_SYNC1_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x18) >> 3
}
func (o *GPIO_Type) SetPIN34_INT_TYPE(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x380)|value<<7)
}
func (o *GPIO_Type) GetPIN34_INT_TYPE() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x380) >> 7
}
func (o *GPIO_Type) SetPIN34_WAKEUP_ENABLE(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN34_WAKEUP_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN34_CONFIG(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x1800)|value<<11)
}
func (o *GPIO_Type) GetPIN34_CONFIG() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x1800) >> 11
}
func (o *GPIO_Type) SetPIN34_INT_ENA(value uint32) {
	volatile.StoreUint32(&o.PIN34.Reg, volatile.LoadUint32(&o.PIN34.Reg)&^(0x3e000)|value<<13)
}
func (o *GPIO_Type) GetPIN34_INT_ENA() uint32 {
	return (volatile.LoadUint32(&o.PIN34.Reg) & 0x3e000) >> 13
}

// GPIO.STATUS_NEXT: GPIO interrupt source register for GPIO0-31
func (o *GPIO_Type) SetSTATUS_NEXT(value uint32) {
	volatile.StoreUint32(&o.STATUS_NEXT.Reg, value)
}
func (o *GPIO_Type) GetSTATUS_NEXT() uint32 {
	return volatile.LoadUint32(&o.STATUS_NEXT.Reg)
}

// GPIO.STATUS_NEXT1: GPIO interrupt source register for GPIO32-34
func (o *GPIO_Type) SetSTATUS_NEXT1_STATUS_INTERRUPT_NEXT1(value uint32) {
	volatile.StoreUint32(&o.STATUS_NEXT1.Reg, volatile.LoadUint32(&o.STATUS_NEXT1.Reg)&^(0x7)|value)
}
func (o *GPIO_Type) GetSTATUS_NEXT1_STATUS_INTERRUPT_NEXT1() uint32 {
	return volatile.LoadUint32(&o.STATUS_NEXT1.Reg) & 0x7
}

// GPIO.FUNC0_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC0_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC0_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC1_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC1_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC1_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC2_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC2_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC2_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC3_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC3_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC3_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC4_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC4_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC4_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC5_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC5_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC5_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC6_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC6_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC6_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC7_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC7_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC7_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC8_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC8_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC8_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC9_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC9_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC9_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC10_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC10_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC10_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC11_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC11_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC11_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC12_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC12_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC12_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC13_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC13_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC13_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC14_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC14_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC14_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC15_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC15_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC15_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC16_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC16_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC16_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC17_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC17_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC17_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC18_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC18_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC18_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC19_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC19_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC19_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC20_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC20_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC20_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC21_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC21_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC21_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC22_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC22_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC22_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC23_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC23_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC23_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC24_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC24_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC24_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC25_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC25_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC25_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC26_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC26_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC26_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC27_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC27_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC27_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC28_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC28_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC28_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC29_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC29_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC29_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC30_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC30_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC30_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC30_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC30_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC31_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC31_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC31_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC31_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC31_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC32_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC32_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC32_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC32_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC32_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC33_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC33_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC33_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC33_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC33_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC34_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC34_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC34_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC34_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC34_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC35_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC35_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC35_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC35_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC35_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC36_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC36_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC36_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC36_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC36_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC37_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC37_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC37_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC37_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC37_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC38_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC38_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC38_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC38_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC38_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC39_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC39_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC39_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC39_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC39_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC40_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC40_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC40_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC40_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC40_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC41_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC41_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC41_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC41_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC41_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC42_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC42_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC42_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC42_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC42_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC43_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC43_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC43_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC43_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC43_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC44_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC44_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC44_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC44_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC44_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC45_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC45_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC45_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC45_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC45_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC46_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC46_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC46_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC46_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC46_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC47_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC47_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC47_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC47_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC47_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC48_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC48_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC48_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC48_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC48_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC49_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC49_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC49_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC49_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC49_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC50_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC50_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC50_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC50_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC50_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC51_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC51_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC51_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC51_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC51_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC52_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC52_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC52_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC52_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC52_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC53_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC53_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC53_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC53_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC53_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC54_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC54_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC54_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC54_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC54_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC55_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC55_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC55_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC55_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC55_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC56_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC56_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC56_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC56_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC56_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC57_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC57_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC57_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC57_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC57_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC58_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC58_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC58_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC58_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC58_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC59_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC59_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC59_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC59_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC59_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC60_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC60_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC60_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC60_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC60_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC61_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC61_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC61_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC61_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC61_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC62_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC62_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC62_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC62_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC62_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC63_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC63_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC63_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC63_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC63_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC64_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC64_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC64_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC64_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC64_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC65_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC65_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC65_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC65_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC65_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC66_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC66_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC66_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC66_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC66_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC67_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC67_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC67_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC67_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC67_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC68_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC68_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC68_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC68_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC68_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC69_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC69_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC69_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC69_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC69_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC70_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC70_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC70_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC70_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC70_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC71_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC71_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC71_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC71_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC71_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC72_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC72_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC72_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC72_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC72_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC73_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC73_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC73_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC73_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC73_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC74_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC74_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC74_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC74_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC74_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC75_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC75_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC75_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC75_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC75_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC76_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC76_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC76_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC76_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC76_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC77_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC77_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC77_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC77_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC77_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC78_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC78_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC78_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC78_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC78_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC79_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC79_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC79_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC79_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC79_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC80_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC80_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC80_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC80_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC80_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC81_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC81_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC81_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC81_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC81_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC82_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC82_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC82_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC82_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC82_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC83_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC83_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC83_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC83_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC83_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC84_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC84_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC84_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC84_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC84_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC85_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC85_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC85_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC85_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC85_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC86_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC86_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC86_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC86_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC86_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC87_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC87_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC87_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC87_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC87_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC88_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC88_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC88_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC88_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC88_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC89_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC89_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC89_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC89_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC89_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC90_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC90_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC90_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC90_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC90_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC91_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC91_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC91_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC91_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC91_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC92_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC92_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC92_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC92_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC92_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC93_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC93_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC93_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC93_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC93_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC94_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC94_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC94_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC94_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC94_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC95_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC95_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC95_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC95_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC95_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC96_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC96_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC96_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC96_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC96_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC97_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC97_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC97_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC97_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC97_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC98_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC98_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC98_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC98_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC98_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC99_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC99_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC99_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC99_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC99_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC100_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC100_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC100_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC100_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC100_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC101_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC101_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC101_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC101_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC101_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC102_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC102_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC102_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC102_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC102_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC103_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC103_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC103_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC103_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC103_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC104_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC104_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC104_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC104_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC104_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC105_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC105_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC105_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC105_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC105_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC106_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC106_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC106_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC106_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC106_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC107_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC107_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC107_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC107_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC107_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC108_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC108_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC108_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC108_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC108_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC109_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC109_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC109_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC109_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC109_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC110_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC110_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC110_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC110_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC110_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC111_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC111_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC111_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC111_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC111_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC112_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC112_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC112_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC112_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC112_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC113_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC113_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC113_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC113_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC113_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC114_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC114_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC114_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC114_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC114_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC115_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC115_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC115_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC115_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC115_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC116_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC116_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC116_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC116_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC116_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC117_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC117_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC117_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC117_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC117_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC118_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC118_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC118_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC118_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC118_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC119_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC119_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC119_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC119_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC119_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC120_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC120_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC120_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC120_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC120_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC121_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC121_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC121_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC121_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC121_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC122_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC122_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC122_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC122_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC122_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC123_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC123_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC123_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC123_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC123_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC124_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC124_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC124_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC124_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC124_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC125_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC125_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC125_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC125_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC125_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC126_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC126_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC126_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC126_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC126_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC127_IN_SEL_CFG: GPIO input function configuration register
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_IN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x3f)|value)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_IN_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x3f
}
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_IN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_IN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetFUNC127_IN_SEL_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC127_IN_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetFUNC127_IN_SEL_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC127_IN_SEL_CFG.Reg) & 0x80) >> 7
}

// GPIO.FUNC0_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC0_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC0_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC0_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC0_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC1_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC1_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC1_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC1_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC1_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC2_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC2_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC2_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC2_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC2_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC3_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC3_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC3_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC3_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC3_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC4_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC4_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC4_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC4_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC4_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC5_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC5_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC5_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC5_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC5_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC6_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC6_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC6_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC6_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC6_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC7_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC7_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC7_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC7_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC7_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC8_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC8_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC8_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC8_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC8_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC9_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC9_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC9_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC9_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC9_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC10_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC10_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC10_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC10_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC10_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC11_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC11_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC11_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC11_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC11_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC12_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC12_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC12_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC12_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC12_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC13_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC13_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC13_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC13_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC13_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC14_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC14_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC14_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC14_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC14_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC15_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC15_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC15_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC15_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC15_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC16_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC16_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC16_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC16_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC16_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC17_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC17_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC17_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC17_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC17_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC18_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC18_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC18_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC18_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC18_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC19_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC19_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC19_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC19_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC19_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC20_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC20_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC20_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC20_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC20_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC21_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC21_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC21_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC21_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC21_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC22_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC22_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC22_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC22_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC22_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC23_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC23_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC23_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC23_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC23_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC24_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC24_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC24_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC24_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC24_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC25_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC25_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC25_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC25_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC25_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC26_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC26_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC26_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC26_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC26_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC26_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC26_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC26_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC26_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC26_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC26_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC27_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC27_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC27_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC27_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC27_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC27_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC27_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC27_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC27_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC27_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC27_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC28_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC28_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC28_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC28_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC28_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC28_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC28_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC28_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC28_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC28_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC28_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.FUNC29_OUT_SEL_CFG: GPIO output function select register
func (o *GPIO_Type) SetFUNC29_OUT_SEL_CFG_OUT_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg)&^(0xff)|value)
}
func (o *GPIO_Type) GetFUNC29_OUT_SEL_CFG_OUT_SEL() uint32 {
	return volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg) & 0xff
}
func (o *GPIO_Type) SetFUNC29_OUT_SEL_CFG_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetFUNC29_OUT_SEL_CFG_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetFUNC29_OUT_SEL_CFG_OEN_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetFUNC29_OUT_SEL_CFG_OEN_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetFUNC29_OUT_SEL_CFG_OEN_INV_SEL(value uint32) {
	volatile.StoreUint32(&o.FUNC29_OUT_SEL_CFG.Reg, volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetFUNC29_OUT_SEL_CFG_OEN_INV_SEL() uint32 {
	return (volatile.LoadUint32(&o.FUNC29_OUT_SEL_CFG.Reg) & 0x400) >> 10
}

// GPIO.CLOCK_GATE: GPIO clock gate register
func (o *GPIO_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// GPIO.DATE: GPIO version register
func (o *GPIO_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *GPIO_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// Sigma-Delta Modulation
type GPIOSD_Type struct {
	SIGMADELTA0       volatile.Register32 // 0x0
	SIGMADELTA1       volatile.Register32 // 0x4
	SIGMADELTA2       volatile.Register32 // 0x8
	SIGMADELTA3       volatile.Register32 // 0xC
	_                 [16]byte
	CLOCK_GATE        volatile.Register32 // 0x20
	SIGMADELTA_MISC   volatile.Register32 // 0x24
	_                 [8]byte
	GLITCH_FILTER_CH0 volatile.Register32 // 0x30
	GLITCH_FILTER_CH1 volatile.Register32 // 0x34
	GLITCH_FILTER_CH2 volatile.Register32 // 0x38
	GLITCH_FILTER_CH3 volatile.Register32 // 0x3C
	GLITCH_FILTER_CH4 volatile.Register32 // 0x40
	GLITCH_FILTER_CH5 volatile.Register32 // 0x44
	GLITCH_FILTER_CH6 volatile.Register32 // 0x48
	GLITCH_FILTER_CH7 volatile.Register32 // 0x4C
	_                 [16]byte
	ETM_EVENT_CH0_CFG volatile.Register32 // 0x60
	ETM_EVENT_CH1_CFG volatile.Register32 // 0x64
	ETM_EVENT_CH2_CFG volatile.Register32 // 0x68
	ETM_EVENT_CH3_CFG volatile.Register32 // 0x6C
	ETM_EVENT_CH4_CFG volatile.Register32 // 0x70
	ETM_EVENT_CH5_CFG volatile.Register32 // 0x74
	ETM_EVENT_CH6_CFG volatile.Register32 // 0x78
	ETM_EVENT_CH7_CFG volatile.Register32 // 0x7C
	_                 [32]byte
	ETM_TASK_P0_CFG   volatile.Register32 // 0xA0
	ETM_TASK_P1_CFG   volatile.Register32 // 0xA4
	ETM_TASK_P2_CFG   volatile.Register32 // 0xA8
	ETM_TASK_P3_CFG   volatile.Register32 // 0xAC
	ETM_TASK_P4_CFG   volatile.Register32 // 0xB0
	ETM_TASK_P5_CFG   volatile.Register32 // 0xB4
	ETM_TASK_P6_CFG   volatile.Register32 // 0xB8
	ETM_TASK_P7_CFG   volatile.Register32 // 0xBC
	_                 [60]byte
	VERSION           volatile.Register32 // 0xFC
}

// GPIOSD.SIGMADELTA0: Duty Cycle Configure Register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA0_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA0.Reg, volatile.LoadUint32(&o.SIGMADELTA0.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA0_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA0.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA0_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA0.Reg, volatile.LoadUint32(&o.SIGMADELTA0.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA0_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA0.Reg) & 0xff00) >> 8
}

// GPIOSD.SIGMADELTA1: Duty Cycle Configure Register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA1_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA1.Reg, volatile.LoadUint32(&o.SIGMADELTA1.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA1_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA1.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA1_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA1.Reg, volatile.LoadUint32(&o.SIGMADELTA1.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA1_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA1.Reg) & 0xff00) >> 8
}

// GPIOSD.SIGMADELTA2: Duty Cycle Configure Register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA2_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA2.Reg, volatile.LoadUint32(&o.SIGMADELTA2.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA2_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA2.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA2_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA2.Reg, volatile.LoadUint32(&o.SIGMADELTA2.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA2_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA2.Reg) & 0xff00) >> 8
}

// GPIOSD.SIGMADELTA3: Duty Cycle Configure Register of SDM%s
func (o *GPIOSD_Type) SetSIGMADELTA3_SD0_IN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA3.Reg, volatile.LoadUint32(&o.SIGMADELTA3.Reg)&^(0xff)|value)
}
func (o *GPIOSD_Type) GetSIGMADELTA3_SD0_IN() uint32 {
	return volatile.LoadUint32(&o.SIGMADELTA3.Reg) & 0xff
}
func (o *GPIOSD_Type) SetSIGMADELTA3_SD0_PRESCALE(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA3.Reg, volatile.LoadUint32(&o.SIGMADELTA3.Reg)&^(0xff00)|value<<8)
}
func (o *GPIOSD_Type) GetSIGMADELTA3_SD0_PRESCALE() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA3.Reg) & 0xff00) >> 8
}

// GPIOSD.CLOCK_GATE: Clock Gating Configure Register
func (o *GPIOSD_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// GPIOSD.SIGMADELTA_MISC: MISC Register
func (o *GPIOSD_Type) SetSIGMADELTA_MISC_FUNCTION_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA_MISC.Reg, volatile.LoadUint32(&o.SIGMADELTA_MISC.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOSD_Type) GetSIGMADELTA_MISC_FUNCTION_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA_MISC.Reg) & 0x40000000) >> 30
}
func (o *GPIOSD_Type) SetSIGMADELTA_MISC_SPI_SWAP(value uint32) {
	volatile.StoreUint32(&o.SIGMADELTA_MISC.Reg, volatile.LoadUint32(&o.SIGMADELTA_MISC.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOSD_Type) GetSIGMADELTA_MISC_SPI_SWAP() uint32 {
	return (volatile.LoadUint32(&o.SIGMADELTA_MISC.Reg) & 0x80000000) >> 31
}

// GPIOSD.GLITCH_FILTER_CH0: Glitch Filter Configure Register of Channel%s
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH0_FILTER_CH0_EN(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH0.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH0.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH0_FILTER_CH0_EN() uint32 {
	return volatile.LoadUint32(&o.GLITCH_FILTER_CH0.Reg) & 0x1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH0_FILTER_CH0_INPUT_IO_NUM(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH0.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH0.Reg)&^(0x7e)|value<<1)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH0_FILTER_CH0_INPUT_IO_NUM() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH0.Reg) & 0x7e) >> 1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH0_FILTER_CH0_WINDOW_THRES(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH0.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH0.Reg)&^(0x1f80)|value<<7)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH0_FILTER_CH0_WINDOW_THRES() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH0.Reg) & 0x1f80) >> 7
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH0_FILTER_CH0_WINDOW_WIDTH(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH0.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH0.Reg)&^(0x7e000)|value<<13)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH0_FILTER_CH0_WINDOW_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH0.Reg) & 0x7e000) >> 13
}

// GPIOSD.GLITCH_FILTER_CH1: Glitch Filter Configure Register of Channel%s
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH1_FILTER_CH0_EN(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH1.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH1.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH1_FILTER_CH0_EN() uint32 {
	return volatile.LoadUint32(&o.GLITCH_FILTER_CH1.Reg) & 0x1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH1_FILTER_CH0_INPUT_IO_NUM(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH1.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH1.Reg)&^(0x7e)|value<<1)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH1_FILTER_CH0_INPUT_IO_NUM() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH1.Reg) & 0x7e) >> 1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH1_FILTER_CH0_WINDOW_THRES(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH1.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH1.Reg)&^(0x1f80)|value<<7)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH1_FILTER_CH0_WINDOW_THRES() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH1.Reg) & 0x1f80) >> 7
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH1_FILTER_CH0_WINDOW_WIDTH(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH1.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH1.Reg)&^(0x7e000)|value<<13)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH1_FILTER_CH0_WINDOW_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH1.Reg) & 0x7e000) >> 13
}

// GPIOSD.GLITCH_FILTER_CH2: Glitch Filter Configure Register of Channel%s
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH2_FILTER_CH0_EN(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH2.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH2.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH2_FILTER_CH0_EN() uint32 {
	return volatile.LoadUint32(&o.GLITCH_FILTER_CH2.Reg) & 0x1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH2_FILTER_CH0_INPUT_IO_NUM(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH2.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH2.Reg)&^(0x7e)|value<<1)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH2_FILTER_CH0_INPUT_IO_NUM() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH2.Reg) & 0x7e) >> 1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH2_FILTER_CH0_WINDOW_THRES(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH2.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH2.Reg)&^(0x1f80)|value<<7)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH2_FILTER_CH0_WINDOW_THRES() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH2.Reg) & 0x1f80) >> 7
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH2_FILTER_CH0_WINDOW_WIDTH(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH2.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH2.Reg)&^(0x7e000)|value<<13)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH2_FILTER_CH0_WINDOW_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH2.Reg) & 0x7e000) >> 13
}

// GPIOSD.GLITCH_FILTER_CH3: Glitch Filter Configure Register of Channel%s
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH3_FILTER_CH0_EN(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH3.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH3.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH3_FILTER_CH0_EN() uint32 {
	return volatile.LoadUint32(&o.GLITCH_FILTER_CH3.Reg) & 0x1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH3_FILTER_CH0_INPUT_IO_NUM(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH3.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH3.Reg)&^(0x7e)|value<<1)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH3_FILTER_CH0_INPUT_IO_NUM() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH3.Reg) & 0x7e) >> 1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH3_FILTER_CH0_WINDOW_THRES(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH3.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH3.Reg)&^(0x1f80)|value<<7)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH3_FILTER_CH0_WINDOW_THRES() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH3.Reg) & 0x1f80) >> 7
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH3_FILTER_CH0_WINDOW_WIDTH(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH3.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH3.Reg)&^(0x7e000)|value<<13)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH3_FILTER_CH0_WINDOW_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH3.Reg) & 0x7e000) >> 13
}

// GPIOSD.GLITCH_FILTER_CH4: Glitch Filter Configure Register of Channel%s
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH4_FILTER_CH0_EN(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH4.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH4.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH4_FILTER_CH0_EN() uint32 {
	return volatile.LoadUint32(&o.GLITCH_FILTER_CH4.Reg) & 0x1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH4_FILTER_CH0_INPUT_IO_NUM(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH4.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH4.Reg)&^(0x7e)|value<<1)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH4_FILTER_CH0_INPUT_IO_NUM() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH4.Reg) & 0x7e) >> 1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH4_FILTER_CH0_WINDOW_THRES(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH4.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH4.Reg)&^(0x1f80)|value<<7)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH4_FILTER_CH0_WINDOW_THRES() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH4.Reg) & 0x1f80) >> 7
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH4_FILTER_CH0_WINDOW_WIDTH(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH4.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH4.Reg)&^(0x7e000)|value<<13)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH4_FILTER_CH0_WINDOW_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH4.Reg) & 0x7e000) >> 13
}

// GPIOSD.GLITCH_FILTER_CH5: Glitch Filter Configure Register of Channel%s
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH5_FILTER_CH0_EN(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH5.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH5.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH5_FILTER_CH0_EN() uint32 {
	return volatile.LoadUint32(&o.GLITCH_FILTER_CH5.Reg) & 0x1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH5_FILTER_CH0_INPUT_IO_NUM(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH5.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH5.Reg)&^(0x7e)|value<<1)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH5_FILTER_CH0_INPUT_IO_NUM() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH5.Reg) & 0x7e) >> 1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH5_FILTER_CH0_WINDOW_THRES(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH5.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH5.Reg)&^(0x1f80)|value<<7)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH5_FILTER_CH0_WINDOW_THRES() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH5.Reg) & 0x1f80) >> 7
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH5_FILTER_CH0_WINDOW_WIDTH(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH5.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH5.Reg)&^(0x7e000)|value<<13)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH5_FILTER_CH0_WINDOW_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH5.Reg) & 0x7e000) >> 13
}

// GPIOSD.GLITCH_FILTER_CH6: Glitch Filter Configure Register of Channel%s
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH6_FILTER_CH0_EN(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH6.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH6.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH6_FILTER_CH0_EN() uint32 {
	return volatile.LoadUint32(&o.GLITCH_FILTER_CH6.Reg) & 0x1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH6_FILTER_CH0_INPUT_IO_NUM(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH6.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH6.Reg)&^(0x7e)|value<<1)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH6_FILTER_CH0_INPUT_IO_NUM() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH6.Reg) & 0x7e) >> 1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH6_FILTER_CH0_WINDOW_THRES(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH6.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH6.Reg)&^(0x1f80)|value<<7)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH6_FILTER_CH0_WINDOW_THRES() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH6.Reg) & 0x1f80) >> 7
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH6_FILTER_CH0_WINDOW_WIDTH(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH6.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH6.Reg)&^(0x7e000)|value<<13)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH6_FILTER_CH0_WINDOW_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH6.Reg) & 0x7e000) >> 13
}

// GPIOSD.GLITCH_FILTER_CH7: Glitch Filter Configure Register of Channel%s
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH7_FILTER_CH0_EN(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH7.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH7.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH7_FILTER_CH0_EN() uint32 {
	return volatile.LoadUint32(&o.GLITCH_FILTER_CH7.Reg) & 0x1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH7_FILTER_CH0_INPUT_IO_NUM(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH7.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH7.Reg)&^(0x7e)|value<<1)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH7_FILTER_CH0_INPUT_IO_NUM() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH7.Reg) & 0x7e) >> 1
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH7_FILTER_CH0_WINDOW_THRES(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH7.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH7.Reg)&^(0x1f80)|value<<7)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH7_FILTER_CH0_WINDOW_THRES() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH7.Reg) & 0x1f80) >> 7
}
func (o *GPIOSD_Type) SetGLITCH_FILTER_CH7_FILTER_CH0_WINDOW_WIDTH(value uint32) {
	volatile.StoreUint32(&o.GLITCH_FILTER_CH7.Reg, volatile.LoadUint32(&o.GLITCH_FILTER_CH7.Reg)&^(0x7e000)|value<<13)
}
func (o *GPIOSD_Type) GetGLITCH_FILTER_CH7_FILTER_CH0_WINDOW_WIDTH() uint32 {
	return (volatile.LoadUint32(&o.GLITCH_FILTER_CH7.Reg) & 0x7e000) >> 13
}

// GPIOSD.ETM_EVENT_CH0_CFG: Etm Config register of Channel%s
func (o *GPIOSD_Type) SetETM_EVENT_CH0_CFG_ETM_CH0_EVENT_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH0_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH0_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH0_CFG_ETM_CH0_EVENT_SEL() uint32 {
	return volatile.LoadUint32(&o.ETM_EVENT_CH0_CFG.Reg) & 0x1f
}
func (o *GPIOSD_Type) SetETM_EVENT_CH0_CFG_ETM_CH0_EVENT_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH0_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH0_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH0_CFG_ETM_CH0_EVENT_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_EVENT_CH0_CFG.Reg) & 0x80) >> 7
}

// GPIOSD.ETM_EVENT_CH1_CFG: Etm Config register of Channel%s
func (o *GPIOSD_Type) SetETM_EVENT_CH1_CFG_ETM_CH0_EVENT_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH1_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH1_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH1_CFG_ETM_CH0_EVENT_SEL() uint32 {
	return volatile.LoadUint32(&o.ETM_EVENT_CH1_CFG.Reg) & 0x1f
}
func (o *GPIOSD_Type) SetETM_EVENT_CH1_CFG_ETM_CH0_EVENT_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH1_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH1_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH1_CFG_ETM_CH0_EVENT_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_EVENT_CH1_CFG.Reg) & 0x80) >> 7
}

// GPIOSD.ETM_EVENT_CH2_CFG: Etm Config register of Channel%s
func (o *GPIOSD_Type) SetETM_EVENT_CH2_CFG_ETM_CH0_EVENT_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH2_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH2_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH2_CFG_ETM_CH0_EVENT_SEL() uint32 {
	return volatile.LoadUint32(&o.ETM_EVENT_CH2_CFG.Reg) & 0x1f
}
func (o *GPIOSD_Type) SetETM_EVENT_CH2_CFG_ETM_CH0_EVENT_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH2_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH2_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH2_CFG_ETM_CH0_EVENT_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_EVENT_CH2_CFG.Reg) & 0x80) >> 7
}

// GPIOSD.ETM_EVENT_CH3_CFG: Etm Config register of Channel%s
func (o *GPIOSD_Type) SetETM_EVENT_CH3_CFG_ETM_CH0_EVENT_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH3_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH3_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH3_CFG_ETM_CH0_EVENT_SEL() uint32 {
	return volatile.LoadUint32(&o.ETM_EVENT_CH3_CFG.Reg) & 0x1f
}
func (o *GPIOSD_Type) SetETM_EVENT_CH3_CFG_ETM_CH0_EVENT_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH3_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH3_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH3_CFG_ETM_CH0_EVENT_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_EVENT_CH3_CFG.Reg) & 0x80) >> 7
}

// GPIOSD.ETM_EVENT_CH4_CFG: Etm Config register of Channel%s
func (o *GPIOSD_Type) SetETM_EVENT_CH4_CFG_ETM_CH0_EVENT_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH4_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH4_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH4_CFG_ETM_CH0_EVENT_SEL() uint32 {
	return volatile.LoadUint32(&o.ETM_EVENT_CH4_CFG.Reg) & 0x1f
}
func (o *GPIOSD_Type) SetETM_EVENT_CH4_CFG_ETM_CH0_EVENT_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH4_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH4_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH4_CFG_ETM_CH0_EVENT_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_EVENT_CH4_CFG.Reg) & 0x80) >> 7
}

// GPIOSD.ETM_EVENT_CH5_CFG: Etm Config register of Channel%s
func (o *GPIOSD_Type) SetETM_EVENT_CH5_CFG_ETM_CH0_EVENT_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH5_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH5_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH5_CFG_ETM_CH0_EVENT_SEL() uint32 {
	return volatile.LoadUint32(&o.ETM_EVENT_CH5_CFG.Reg) & 0x1f
}
func (o *GPIOSD_Type) SetETM_EVENT_CH5_CFG_ETM_CH0_EVENT_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH5_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH5_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH5_CFG_ETM_CH0_EVENT_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_EVENT_CH5_CFG.Reg) & 0x80) >> 7
}

// GPIOSD.ETM_EVENT_CH6_CFG: Etm Config register of Channel%s
func (o *GPIOSD_Type) SetETM_EVENT_CH6_CFG_ETM_CH0_EVENT_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH6_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH6_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH6_CFG_ETM_CH0_EVENT_SEL() uint32 {
	return volatile.LoadUint32(&o.ETM_EVENT_CH6_CFG.Reg) & 0x1f
}
func (o *GPIOSD_Type) SetETM_EVENT_CH6_CFG_ETM_CH0_EVENT_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH6_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH6_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH6_CFG_ETM_CH0_EVENT_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_EVENT_CH6_CFG.Reg) & 0x80) >> 7
}

// GPIOSD.ETM_EVENT_CH7_CFG: Etm Config register of Channel%s
func (o *GPIOSD_Type) SetETM_EVENT_CH7_CFG_ETM_CH0_EVENT_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH7_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH7_CFG.Reg)&^(0x1f)|value)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH7_CFG_ETM_CH0_EVENT_SEL() uint32 {
	return volatile.LoadUint32(&o.ETM_EVENT_CH7_CFG.Reg) & 0x1f
}
func (o *GPIOSD_Type) SetETM_EVENT_CH7_CFG_ETM_CH0_EVENT_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_EVENT_CH7_CFG.Reg, volatile.LoadUint32(&o.ETM_EVENT_CH7_CFG.Reg)&^(0x80)|value<<7)
}
func (o *GPIOSD_Type) GetETM_EVENT_CH7_CFG_ETM_CH0_EVENT_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_EVENT_CH7_CFG.Reg) & 0x80) >> 7
}

// GPIOSD.ETM_TASK_P0_CFG: Etm Configure Register to decide which GPIO been chosen
func (o *GPIOSD_Type) SetETM_TASK_P0_CFG_ETM_TASK_GPIO0_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P0_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetETM_TASK_P0_CFG_ETM_TASK_GPIO0_EN() uint32 {
	return volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg) & 0x1
}
func (o *GPIOSD_Type) SetETM_TASK_P0_CFG_ETM_TASK_GPIO0_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P0_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg)&^(0xe)|value<<1)
}
func (o *GPIOSD_Type) GetETM_TASK_P0_CFG_ETM_TASK_GPIO0_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg) & 0xe) >> 1
}
func (o *GPIOSD_Type) SetETM_TASK_P0_CFG_ETM_TASK_GPIO1_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P0_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIOSD_Type) GetETM_TASK_P0_CFG_ETM_TASK_GPIO1_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg) & 0x100) >> 8
}
func (o *GPIOSD_Type) SetETM_TASK_P0_CFG_ETM_TASK_GPIO1_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P0_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg)&^(0xe00)|value<<9)
}
func (o *GPIOSD_Type) GetETM_TASK_P0_CFG_ETM_TASK_GPIO1_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg) & 0xe00) >> 9
}
func (o *GPIOSD_Type) SetETM_TASK_P0_CFG_ETM_TASK_GPIO2_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P0_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOSD_Type) GetETM_TASK_P0_CFG_ETM_TASK_GPIO2_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg) & 0x10000) >> 16
}
func (o *GPIOSD_Type) SetETM_TASK_P0_CFG_ETM_TASK_GPIO2_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P0_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg)&^(0xe0000)|value<<17)
}
func (o *GPIOSD_Type) GetETM_TASK_P0_CFG_ETM_TASK_GPIO2_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg) & 0xe0000) >> 17
}
func (o *GPIOSD_Type) SetETM_TASK_P0_CFG_ETM_TASK_GPIO3_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P0_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOSD_Type) GetETM_TASK_P0_CFG_ETM_TASK_GPIO3_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg) & 0x1000000) >> 24
}
func (o *GPIOSD_Type) SetETM_TASK_P0_CFG_ETM_TASK_GPIO3_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P0_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg)&^(0xe000000)|value<<25)
}
func (o *GPIOSD_Type) GetETM_TASK_P0_CFG_ETM_TASK_GPIO3_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P0_CFG.Reg) & 0xe000000) >> 25
}

// GPIOSD.ETM_TASK_P1_CFG: Etm Configure Register to decide which GPIO been chosen
func (o *GPIOSD_Type) SetETM_TASK_P1_CFG_ETM_TASK_GPIO4_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P1_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetETM_TASK_P1_CFG_ETM_TASK_GPIO4_EN() uint32 {
	return volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg) & 0x1
}
func (o *GPIOSD_Type) SetETM_TASK_P1_CFG_ETM_TASK_GPIO4_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P1_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg)&^(0xe)|value<<1)
}
func (o *GPIOSD_Type) GetETM_TASK_P1_CFG_ETM_TASK_GPIO4_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg) & 0xe) >> 1
}
func (o *GPIOSD_Type) SetETM_TASK_P1_CFG_ETM_TASK_GPIO5_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P1_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIOSD_Type) GetETM_TASK_P1_CFG_ETM_TASK_GPIO5_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg) & 0x100) >> 8
}
func (o *GPIOSD_Type) SetETM_TASK_P1_CFG_ETM_TASK_GPIO5_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P1_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg)&^(0xe00)|value<<9)
}
func (o *GPIOSD_Type) GetETM_TASK_P1_CFG_ETM_TASK_GPIO5_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg) & 0xe00) >> 9
}
func (o *GPIOSD_Type) SetETM_TASK_P1_CFG_ETM_TASK_GPIO6_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P1_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOSD_Type) GetETM_TASK_P1_CFG_ETM_TASK_GPIO6_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg) & 0x10000) >> 16
}
func (o *GPIOSD_Type) SetETM_TASK_P1_CFG_ETM_TASK_GPIO6_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P1_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg)&^(0xe0000)|value<<17)
}
func (o *GPIOSD_Type) GetETM_TASK_P1_CFG_ETM_TASK_GPIO6_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg) & 0xe0000) >> 17
}
func (o *GPIOSD_Type) SetETM_TASK_P1_CFG_ETM_TASK_GPIO7_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P1_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOSD_Type) GetETM_TASK_P1_CFG_ETM_TASK_GPIO7_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg) & 0x1000000) >> 24
}
func (o *GPIOSD_Type) SetETM_TASK_P1_CFG_ETM_TASK_GPIO7_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P1_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg)&^(0xe000000)|value<<25)
}
func (o *GPIOSD_Type) GetETM_TASK_P1_CFG_ETM_TASK_GPIO7_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P1_CFG.Reg) & 0xe000000) >> 25
}

// GPIOSD.ETM_TASK_P2_CFG: Etm Configure Register to decide which GPIO been chosen
func (o *GPIOSD_Type) SetETM_TASK_P2_CFG_ETM_TASK_GPIO8_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P2_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetETM_TASK_P2_CFG_ETM_TASK_GPIO8_EN() uint32 {
	return volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg) & 0x1
}
func (o *GPIOSD_Type) SetETM_TASK_P2_CFG_ETM_TASK_GPIO8_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P2_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg)&^(0xe)|value<<1)
}
func (o *GPIOSD_Type) GetETM_TASK_P2_CFG_ETM_TASK_GPIO8_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg) & 0xe) >> 1
}
func (o *GPIOSD_Type) SetETM_TASK_P2_CFG_ETM_TASK_GPIO9_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P2_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIOSD_Type) GetETM_TASK_P2_CFG_ETM_TASK_GPIO9_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg) & 0x100) >> 8
}
func (o *GPIOSD_Type) SetETM_TASK_P2_CFG_ETM_TASK_GPIO9_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P2_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg)&^(0xe00)|value<<9)
}
func (o *GPIOSD_Type) GetETM_TASK_P2_CFG_ETM_TASK_GPIO9_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg) & 0xe00) >> 9
}
func (o *GPIOSD_Type) SetETM_TASK_P2_CFG_ETM_TASK_GPIO10_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P2_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOSD_Type) GetETM_TASK_P2_CFG_ETM_TASK_GPIO10_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg) & 0x10000) >> 16
}
func (o *GPIOSD_Type) SetETM_TASK_P2_CFG_ETM_TASK_GPIO10_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P2_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg)&^(0xe0000)|value<<17)
}
func (o *GPIOSD_Type) GetETM_TASK_P2_CFG_ETM_TASK_GPIO10_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg) & 0xe0000) >> 17
}
func (o *GPIOSD_Type) SetETM_TASK_P2_CFG_ETM_TASK_GPIO11_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P2_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOSD_Type) GetETM_TASK_P2_CFG_ETM_TASK_GPIO11_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg) & 0x1000000) >> 24
}
func (o *GPIOSD_Type) SetETM_TASK_P2_CFG_ETM_TASK_GPIO11_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P2_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg)&^(0xe000000)|value<<25)
}
func (o *GPIOSD_Type) GetETM_TASK_P2_CFG_ETM_TASK_GPIO11_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P2_CFG.Reg) & 0xe000000) >> 25
}

// GPIOSD.ETM_TASK_P3_CFG: Etm Configure Register to decide which GPIO been chosen
func (o *GPIOSD_Type) SetETM_TASK_P3_CFG_ETM_TASK_GPIO12_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P3_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetETM_TASK_P3_CFG_ETM_TASK_GPIO12_EN() uint32 {
	return volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg) & 0x1
}
func (o *GPIOSD_Type) SetETM_TASK_P3_CFG_ETM_TASK_GPIO12_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P3_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg)&^(0xe)|value<<1)
}
func (o *GPIOSD_Type) GetETM_TASK_P3_CFG_ETM_TASK_GPIO12_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg) & 0xe) >> 1
}
func (o *GPIOSD_Type) SetETM_TASK_P3_CFG_ETM_TASK_GPIO13_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P3_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIOSD_Type) GetETM_TASK_P3_CFG_ETM_TASK_GPIO13_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg) & 0x100) >> 8
}
func (o *GPIOSD_Type) SetETM_TASK_P3_CFG_ETM_TASK_GPIO13_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P3_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg)&^(0xe00)|value<<9)
}
func (o *GPIOSD_Type) GetETM_TASK_P3_CFG_ETM_TASK_GPIO13_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg) & 0xe00) >> 9
}
func (o *GPIOSD_Type) SetETM_TASK_P3_CFG_ETM_TASK_GPIO14_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P3_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOSD_Type) GetETM_TASK_P3_CFG_ETM_TASK_GPIO14_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg) & 0x10000) >> 16
}
func (o *GPIOSD_Type) SetETM_TASK_P3_CFG_ETM_TASK_GPIO14_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P3_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg)&^(0xe0000)|value<<17)
}
func (o *GPIOSD_Type) GetETM_TASK_P3_CFG_ETM_TASK_GPIO14_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg) & 0xe0000) >> 17
}
func (o *GPIOSD_Type) SetETM_TASK_P3_CFG_ETM_TASK_GPIO15_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P3_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOSD_Type) GetETM_TASK_P3_CFG_ETM_TASK_GPIO15_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg) & 0x1000000) >> 24
}
func (o *GPIOSD_Type) SetETM_TASK_P3_CFG_ETM_TASK_GPIO15_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P3_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg)&^(0xe000000)|value<<25)
}
func (o *GPIOSD_Type) GetETM_TASK_P3_CFG_ETM_TASK_GPIO15_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P3_CFG.Reg) & 0xe000000) >> 25
}

// GPIOSD.ETM_TASK_P4_CFG: Etm Configure Register to decide which GPIO been chosen
func (o *GPIOSD_Type) SetETM_TASK_P4_CFG_ETM_TASK_GPIO16_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P4_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetETM_TASK_P4_CFG_ETM_TASK_GPIO16_EN() uint32 {
	return volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg) & 0x1
}
func (o *GPIOSD_Type) SetETM_TASK_P4_CFG_ETM_TASK_GPIO16_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P4_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg)&^(0xe)|value<<1)
}
func (o *GPIOSD_Type) GetETM_TASK_P4_CFG_ETM_TASK_GPIO16_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg) & 0xe) >> 1
}
func (o *GPIOSD_Type) SetETM_TASK_P4_CFG_ETM_TASK_GPIO17_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P4_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIOSD_Type) GetETM_TASK_P4_CFG_ETM_TASK_GPIO17_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg) & 0x100) >> 8
}
func (o *GPIOSD_Type) SetETM_TASK_P4_CFG_ETM_TASK_GPIO17_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P4_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg)&^(0xe00)|value<<9)
}
func (o *GPIOSD_Type) GetETM_TASK_P4_CFG_ETM_TASK_GPIO17_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg) & 0xe00) >> 9
}
func (o *GPIOSD_Type) SetETM_TASK_P4_CFG_ETM_TASK_GPIO18_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P4_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOSD_Type) GetETM_TASK_P4_CFG_ETM_TASK_GPIO18_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg) & 0x10000) >> 16
}
func (o *GPIOSD_Type) SetETM_TASK_P4_CFG_ETM_TASK_GPIO18_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P4_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg)&^(0xe0000)|value<<17)
}
func (o *GPIOSD_Type) GetETM_TASK_P4_CFG_ETM_TASK_GPIO18_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg) & 0xe0000) >> 17
}
func (o *GPIOSD_Type) SetETM_TASK_P4_CFG_ETM_TASK_GPIO19_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P4_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOSD_Type) GetETM_TASK_P4_CFG_ETM_TASK_GPIO19_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg) & 0x1000000) >> 24
}
func (o *GPIOSD_Type) SetETM_TASK_P4_CFG_ETM_TASK_GPIO19_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P4_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg)&^(0xe000000)|value<<25)
}
func (o *GPIOSD_Type) GetETM_TASK_P4_CFG_ETM_TASK_GPIO19_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P4_CFG.Reg) & 0xe000000) >> 25
}

// GPIOSD.ETM_TASK_P5_CFG: Etm Configure Register to decide which GPIO been chosen
func (o *GPIOSD_Type) SetETM_TASK_P5_CFG_ETM_TASK_GPIO20_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P5_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetETM_TASK_P5_CFG_ETM_TASK_GPIO20_EN() uint32 {
	return volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg) & 0x1
}
func (o *GPIOSD_Type) SetETM_TASK_P5_CFG_ETM_TASK_GPIO20_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P5_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg)&^(0xe)|value<<1)
}
func (o *GPIOSD_Type) GetETM_TASK_P5_CFG_ETM_TASK_GPIO20_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg) & 0xe) >> 1
}
func (o *GPIOSD_Type) SetETM_TASK_P5_CFG_ETM_TASK_GPIO21_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P5_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIOSD_Type) GetETM_TASK_P5_CFG_ETM_TASK_GPIO21_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg) & 0x100) >> 8
}
func (o *GPIOSD_Type) SetETM_TASK_P5_CFG_ETM_TASK_GPIO21_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P5_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg)&^(0xe00)|value<<9)
}
func (o *GPIOSD_Type) GetETM_TASK_P5_CFG_ETM_TASK_GPIO21_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg) & 0xe00) >> 9
}
func (o *GPIOSD_Type) SetETM_TASK_P5_CFG_ETM_TASK_GPIO22_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P5_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOSD_Type) GetETM_TASK_P5_CFG_ETM_TASK_GPIO22_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg) & 0x10000) >> 16
}
func (o *GPIOSD_Type) SetETM_TASK_P5_CFG_ETM_TASK_GPIO22_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P5_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg)&^(0xe0000)|value<<17)
}
func (o *GPIOSD_Type) GetETM_TASK_P5_CFG_ETM_TASK_GPIO22_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg) & 0xe0000) >> 17
}
func (o *GPIOSD_Type) SetETM_TASK_P5_CFG_ETM_TASK_GPIO23_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P5_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOSD_Type) GetETM_TASK_P5_CFG_ETM_TASK_GPIO23_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg) & 0x1000000) >> 24
}
func (o *GPIOSD_Type) SetETM_TASK_P5_CFG_ETM_TASK_GPIO23_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P5_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg)&^(0xe000000)|value<<25)
}
func (o *GPIOSD_Type) GetETM_TASK_P5_CFG_ETM_TASK_GPIO23_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P5_CFG.Reg) & 0xe000000) >> 25
}

// GPIOSD.ETM_TASK_P6_CFG: Etm Configure Register to decide which GPIO been chosen
func (o *GPIOSD_Type) SetETM_TASK_P6_CFG_ETM_TASK_GPIO24_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P6_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetETM_TASK_P6_CFG_ETM_TASK_GPIO24_EN() uint32 {
	return volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg) & 0x1
}
func (o *GPIOSD_Type) SetETM_TASK_P6_CFG_ETM_TASK_GPIO24_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P6_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg)&^(0xe)|value<<1)
}
func (o *GPIOSD_Type) GetETM_TASK_P6_CFG_ETM_TASK_GPIO24_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg) & 0xe) >> 1
}
func (o *GPIOSD_Type) SetETM_TASK_P6_CFG_ETM_TASK_GPIO25_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P6_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIOSD_Type) GetETM_TASK_P6_CFG_ETM_TASK_GPIO25_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg) & 0x100) >> 8
}
func (o *GPIOSD_Type) SetETM_TASK_P6_CFG_ETM_TASK_GPIO25_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P6_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg)&^(0xe00)|value<<9)
}
func (o *GPIOSD_Type) GetETM_TASK_P6_CFG_ETM_TASK_GPIO25_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg) & 0xe00) >> 9
}
func (o *GPIOSD_Type) SetETM_TASK_P6_CFG_ETM_TASK_GPIO26_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P6_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOSD_Type) GetETM_TASK_P6_CFG_ETM_TASK_GPIO26_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg) & 0x10000) >> 16
}
func (o *GPIOSD_Type) SetETM_TASK_P6_CFG_ETM_TASK_GPIO26_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P6_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg)&^(0xe0000)|value<<17)
}
func (o *GPIOSD_Type) GetETM_TASK_P6_CFG_ETM_TASK_GPIO26_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg) & 0xe0000) >> 17
}
func (o *GPIOSD_Type) SetETM_TASK_P6_CFG_ETM_TASK_GPIO27_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P6_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOSD_Type) GetETM_TASK_P6_CFG_ETM_TASK_GPIO27_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg) & 0x1000000) >> 24
}
func (o *GPIOSD_Type) SetETM_TASK_P6_CFG_ETM_TASK_GPIO27_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P6_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg)&^(0xe000000)|value<<25)
}
func (o *GPIOSD_Type) GetETM_TASK_P6_CFG_ETM_TASK_GPIO27_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P6_CFG.Reg) & 0xe000000) >> 25
}

// GPIOSD.ETM_TASK_P7_CFG: Etm Configure Register to decide which GPIO been chosen
func (o *GPIOSD_Type) SetETM_TASK_P7_CFG_ETM_TASK_GPIO28_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P7_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P7_CFG.Reg)&^(0x1)|value)
}
func (o *GPIOSD_Type) GetETM_TASK_P7_CFG_ETM_TASK_GPIO28_EN() uint32 {
	return volatile.LoadUint32(&o.ETM_TASK_P7_CFG.Reg) & 0x1
}
func (o *GPIOSD_Type) SetETM_TASK_P7_CFG_ETM_TASK_GPIO28_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P7_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P7_CFG.Reg)&^(0xe)|value<<1)
}
func (o *GPIOSD_Type) GetETM_TASK_P7_CFG_ETM_TASK_GPIO28_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P7_CFG.Reg) & 0xe) >> 1
}
func (o *GPIOSD_Type) SetETM_TASK_P7_CFG_ETM_TASK_GPIO29_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P7_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P7_CFG.Reg)&^(0x100)|value<<8)
}
func (o *GPIOSD_Type) GetETM_TASK_P7_CFG_ETM_TASK_GPIO29_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P7_CFG.Reg) & 0x100) >> 8
}
func (o *GPIOSD_Type) SetETM_TASK_P7_CFG_ETM_TASK_GPIO29_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P7_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P7_CFG.Reg)&^(0xe00)|value<<9)
}
func (o *GPIOSD_Type) GetETM_TASK_P7_CFG_ETM_TASK_GPIO29_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P7_CFG.Reg) & 0xe00) >> 9
}
func (o *GPIOSD_Type) SetETM_TASK_P7_CFG_ETM_TASK_GPIO30_EN(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P7_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P7_CFG.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOSD_Type) GetETM_TASK_P7_CFG_ETM_TASK_GPIO30_EN() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P7_CFG.Reg) & 0x10000) >> 16
}
func (o *GPIOSD_Type) SetETM_TASK_P7_CFG_ETM_TASK_GPIO30_SEL(value uint32) {
	volatile.StoreUint32(&o.ETM_TASK_P7_CFG.Reg, volatile.LoadUint32(&o.ETM_TASK_P7_CFG.Reg)&^(0xe0000)|value<<17)
}
func (o *GPIOSD_Type) GetETM_TASK_P7_CFG_ETM_TASK_GPIO30_SEL() uint32 {
	return (volatile.LoadUint32(&o.ETM_TASK_P7_CFG.Reg) & 0xe0000) >> 17
}

// GPIOSD.VERSION: Version Control Register
func (o *GPIOSD_Type) SetVERSION_GPIO_SD_DATE(value uint32) {
	volatile.StoreUint32(&o.VERSION.Reg, volatile.LoadUint32(&o.VERSION.Reg)&^(0xfffffff)|value)
}
func (o *GPIOSD_Type) GetVERSION_GPIO_SD_DATE() uint32 {
	return volatile.LoadUint32(&o.VERSION.Reg) & 0xfffffff
}

// HINF Peripheral
type HINF_Type struct {
	CFG_DATA0           volatile.Register32 // 0x0
	CFG_DATA1           volatile.Register32 // 0x4
	CFG_TIMING          volatile.Register32 // 0x8
	CFG_UPDATE          volatile.Register32 // 0xC
	_                   [12]byte
	CFG_DATA7           volatile.Register32 // 0x1C
	CIS_CONF_W0         volatile.Register32 // 0x20
	CIS_CONF_W1         volatile.Register32 // 0x24
	CIS_CONF_W2         volatile.Register32 // 0x28
	CIS_CONF_W3         volatile.Register32 // 0x2C
	CIS_CONF_W4         volatile.Register32 // 0x30
	CIS_CONF_W5         volatile.Register32 // 0x34
	CIS_CONF_W6         volatile.Register32 // 0x38
	CIS_CONF_W7         volatile.Register32 // 0x3C
	CFG_DATA16          volatile.Register32 // 0x40
	CFG_UHS1_INT_MODE   volatile.Register32 // 0x44
	_                   [12]byte
	CONF_STATUS         volatile.Register32 // 0x54
	_                   [76]byte
	SDIO_SLAVE_ECO_LOW  volatile.Register32 // 0xA4
	SDIO_SLAVE_ECO_HIGH volatile.Register32 // 0xA8
	SDIO_SLAVE_ECO_CONF volatile.Register32 // 0xAC
	SDIO_SLAVE_LDO_CONF volatile.Register32 // 0xB0
	_                   [72]byte
	SDIO_DATE           volatile.Register32 // 0xFC
}

// HINF.CFG_DATA0: Configure sdio cis content
func (o *HINF_Type) SetCFG_DATA0_DEVICE_ID_FN1(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA0.Reg, volatile.LoadUint32(&o.CFG_DATA0.Reg)&^(0xffff)|value)
}
func (o *HINF_Type) GetCFG_DATA0_DEVICE_ID_FN1() uint32 {
	return volatile.LoadUint32(&o.CFG_DATA0.Reg) & 0xffff
}
func (o *HINF_Type) SetCFG_DATA0_USER_ID_FN1(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA0.Reg, volatile.LoadUint32(&o.CFG_DATA0.Reg)&^(0xffff0000)|value<<16)
}
func (o *HINF_Type) GetCFG_DATA0_USER_ID_FN1() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA0.Reg) & 0xffff0000) >> 16
}

// HINF.CFG_DATA1: SDIO configuration register
func (o *HINF_Type) SetCFG_DATA1_SDIO_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x1)|value)
}
func (o *HINF_Type) GetCFG_DATA1_SDIO_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x1
}
func (o *HINF_Type) SetCFG_DATA1_SDIO_IOREADY1(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x2)|value<<1)
}
func (o *HINF_Type) GetCFG_DATA1_SDIO_IOREADY1() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x2) >> 1
}
func (o *HINF_Type) SetCFG_DATA1_HIGHSPEED_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x4)|value<<2)
}
func (o *HINF_Type) GetCFG_DATA1_HIGHSPEED_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x4) >> 2
}
func (o *HINF_Type) SetCFG_DATA1_HIGHSPEED_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x8)|value<<3)
}
func (o *HINF_Type) GetCFG_DATA1_HIGHSPEED_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x8) >> 3
}
func (o *HINF_Type) SetCFG_DATA1_SDIO_CD_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x10)|value<<4)
}
func (o *HINF_Type) GetCFG_DATA1_SDIO_CD_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x10) >> 4
}
func (o *HINF_Type) SetCFG_DATA1_SDIO_IOREADY2(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x20)|value<<5)
}
func (o *HINF_Type) GetCFG_DATA1_SDIO_IOREADY2() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x20) >> 5
}
func (o *HINF_Type) SetCFG_DATA1_SDIO_INT_MASK(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x40)|value<<6)
}
func (o *HINF_Type) GetCFG_DATA1_SDIO_INT_MASK() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x40) >> 6
}
func (o *HINF_Type) SetCFG_DATA1_IOENABLE2(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x80)|value<<7)
}
func (o *HINF_Type) GetCFG_DATA1_IOENABLE2() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x80) >> 7
}
func (o *HINF_Type) SetCFG_DATA1_CD_DISABLE(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x100)|value<<8)
}
func (o *HINF_Type) GetCFG_DATA1_CD_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x100) >> 8
}
func (o *HINF_Type) SetCFG_DATA1_FUNC1_EPS(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x200)|value<<9)
}
func (o *HINF_Type) GetCFG_DATA1_FUNC1_EPS() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x200) >> 9
}
func (o *HINF_Type) SetCFG_DATA1_EMP(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x400)|value<<10)
}
func (o *HINF_Type) GetCFG_DATA1_EMP() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x400) >> 10
}
func (o *HINF_Type) SetCFG_DATA1_IOENABLE1(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x800)|value<<11)
}
func (o *HINF_Type) GetCFG_DATA1_IOENABLE1() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x800) >> 11
}
func (o *HINF_Type) SetCFG_DATA1_SDIO_VER(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0xfff000)|value<<12)
}
func (o *HINF_Type) GetCFG_DATA1_SDIO_VER() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0xfff000) >> 12
}
func (o *HINF_Type) SetCFG_DATA1_FUNC2_EPS(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0x1000000)|value<<24)
}
func (o *HINF_Type) GetCFG_DATA1_FUNC2_EPS() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0x1000000) >> 24
}
func (o *HINF_Type) SetCFG_DATA1_SDIO20_CONF(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA1.Reg, volatile.LoadUint32(&o.CFG_DATA1.Reg)&^(0xfe000000)|value<<25)
}
func (o *HINF_Type) GetCFG_DATA1_SDIO20_CONF() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA1.Reg) & 0xfe000000) >> 25
}

// HINF.CFG_TIMING: Timing configuration registers
func (o *HINF_Type) SetCFG_TIMING_NCRC(value uint32) {
	volatile.StoreUint32(&o.CFG_TIMING.Reg, volatile.LoadUint32(&o.CFG_TIMING.Reg)&^(0x7)|value)
}
func (o *HINF_Type) GetCFG_TIMING_NCRC() uint32 {
	return volatile.LoadUint32(&o.CFG_TIMING.Reg) & 0x7
}
func (o *HINF_Type) SetCFG_TIMING_PST_END_CMD_LOW_VALUE(value uint32) {
	volatile.StoreUint32(&o.CFG_TIMING.Reg, volatile.LoadUint32(&o.CFG_TIMING.Reg)&^(0x3f8)|value<<3)
}
func (o *HINF_Type) GetCFG_TIMING_PST_END_CMD_LOW_VALUE() uint32 {
	return (volatile.LoadUint32(&o.CFG_TIMING.Reg) & 0x3f8) >> 3
}
func (o *HINF_Type) SetCFG_TIMING_PST_END_DATA_LOW_VALUE(value uint32) {
	volatile.StoreUint32(&o.CFG_TIMING.Reg, volatile.LoadUint32(&o.CFG_TIMING.Reg)&^(0xfc00)|value<<10)
}
func (o *HINF_Type) GetCFG_TIMING_PST_END_DATA_LOW_VALUE() uint32 {
	return (volatile.LoadUint32(&o.CFG_TIMING.Reg) & 0xfc00) >> 10
}
func (o *HINF_Type) SetCFG_TIMING_SDCLK_STOP_THRES(value uint32) {
	volatile.StoreUint32(&o.CFG_TIMING.Reg, volatile.LoadUint32(&o.CFG_TIMING.Reg)&^(0x7ff0000)|value<<16)
}
func (o *HINF_Type) GetCFG_TIMING_SDCLK_STOP_THRES() uint32 {
	return (volatile.LoadUint32(&o.CFG_TIMING.Reg) & 0x7ff0000) >> 16
}
func (o *HINF_Type) SetCFG_TIMING_SAMPLE_CLK_DIVIDER(value uint32) {
	volatile.StoreUint32(&o.CFG_TIMING.Reg, volatile.LoadUint32(&o.CFG_TIMING.Reg)&^(0xf0000000)|value<<28)
}
func (o *HINF_Type) GetCFG_TIMING_SAMPLE_CLK_DIVIDER() uint32 {
	return (volatile.LoadUint32(&o.CFG_TIMING.Reg) & 0xf0000000) >> 28
}

// HINF.CFG_UPDATE: update sdio configurations
func (o *HINF_Type) SetCFG_UPDATE_CONF_UPDATE(value uint32) {
	volatile.StoreUint32(&o.CFG_UPDATE.Reg, volatile.LoadUint32(&o.CFG_UPDATE.Reg)&^(0x1)|value)
}
func (o *HINF_Type) GetCFG_UPDATE_CONF_UPDATE() uint32 {
	return volatile.LoadUint32(&o.CFG_UPDATE.Reg) & 0x1
}

// HINF.CFG_DATA7: SDIO configuration register
func (o *HINF_Type) SetCFG_DATA7_PIN_STATE(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0xff)|value)
}
func (o *HINF_Type) GetCFG_DATA7_PIN_STATE() uint32 {
	return volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0xff
}
func (o *HINF_Type) SetCFG_DATA7_CHIP_STATE(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0xff00)|value<<8)
}
func (o *HINF_Type) GetCFG_DATA7_CHIP_STATE() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0xff00) >> 8
}
func (o *HINF_Type) SetCFG_DATA7_SDIO_RST(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x10000)|value<<16)
}
func (o *HINF_Type) GetCFG_DATA7_SDIO_RST() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x10000) >> 16
}
func (o *HINF_Type) SetCFG_DATA7_SDIO_IOREADY0(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x20000)|value<<17)
}
func (o *HINF_Type) GetCFG_DATA7_SDIO_IOREADY0() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x20000) >> 17
}
func (o *HINF_Type) SetCFG_DATA7_SDIO_MEM_PD(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x40000)|value<<18)
}
func (o *HINF_Type) GetCFG_DATA7_SDIO_MEM_PD() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x40000) >> 18
}
func (o *HINF_Type) SetCFG_DATA7_ESDIO_DATA1_INT_EN(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x80000)|value<<19)
}
func (o *HINF_Type) GetCFG_DATA7_ESDIO_DATA1_INT_EN() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x80000) >> 19
}
func (o *HINF_Type) SetCFG_DATA7_SDIO_SWITCH_VOLT_SW(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x100000)|value<<20)
}
func (o *HINF_Type) GetCFG_DATA7_SDIO_SWITCH_VOLT_SW() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x100000) >> 20
}
func (o *HINF_Type) SetCFG_DATA7_DDR50_BLK_LEN_FIX_EN(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x200000)|value<<21)
}
func (o *HINF_Type) GetCFG_DATA7_DDR50_BLK_LEN_FIX_EN() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x200000) >> 21
}
func (o *HINF_Type) SetCFG_DATA7_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x400000)|value<<22)
}
func (o *HINF_Type) GetCFG_DATA7_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x400000) >> 22
}
func (o *HINF_Type) SetCFG_DATA7_SDDR50(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x800000)|value<<23)
}
func (o *HINF_Type) GetCFG_DATA7_SDDR50() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x800000) >> 23
}
func (o *HINF_Type) SetCFG_DATA7_SSDR104(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x1000000)|value<<24)
}
func (o *HINF_Type) GetCFG_DATA7_SSDR104() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x1000000) >> 24
}
func (o *HINF_Type) SetCFG_DATA7_SSDR50(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x2000000)|value<<25)
}
func (o *HINF_Type) GetCFG_DATA7_SSDR50() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x2000000) >> 25
}
func (o *HINF_Type) SetCFG_DATA7_SDTD(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x4000000)|value<<26)
}
func (o *HINF_Type) GetCFG_DATA7_SDTD() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x4000000) >> 26
}
func (o *HINF_Type) SetCFG_DATA7_SDTA(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x8000000)|value<<27)
}
func (o *HINF_Type) GetCFG_DATA7_SDTA() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x8000000) >> 27
}
func (o *HINF_Type) SetCFG_DATA7_SDTC(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x10000000)|value<<28)
}
func (o *HINF_Type) GetCFG_DATA7_SDTC() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x10000000) >> 28
}
func (o *HINF_Type) SetCFG_DATA7_SAI(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x20000000)|value<<29)
}
func (o *HINF_Type) GetCFG_DATA7_SAI() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x20000000) >> 29
}
func (o *HINF_Type) SetCFG_DATA7_SDIO_WAKEUP_CLR(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA7.Reg, volatile.LoadUint32(&o.CFG_DATA7.Reg)&^(0x40000000)|value<<30)
}
func (o *HINF_Type) GetCFG_DATA7_SDIO_WAKEUP_CLR() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA7.Reg) & 0x40000000) >> 30
}

// HINF.CIS_CONF_W0: SDIO cis configuration register
func (o *HINF_Type) SetCIS_CONF_W0(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF_W0.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF_W0() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF_W0.Reg)
}

// HINF.CIS_CONF_W1: SDIO cis configuration register
func (o *HINF_Type) SetCIS_CONF_W1(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF_W1.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF_W1() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF_W1.Reg)
}

// HINF.CIS_CONF_W2: SDIO cis configuration register
func (o *HINF_Type) SetCIS_CONF_W2(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF_W2.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF_W2() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF_W2.Reg)
}

// HINF.CIS_CONF_W3: SDIO cis configuration register
func (o *HINF_Type) SetCIS_CONF_W3(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF_W3.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF_W3() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF_W3.Reg)
}

// HINF.CIS_CONF_W4: SDIO cis configuration register
func (o *HINF_Type) SetCIS_CONF_W4(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF_W4.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF_W4() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF_W4.Reg)
}

// HINF.CIS_CONF_W5: SDIO cis configuration register
func (o *HINF_Type) SetCIS_CONF_W5(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF_W5.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF_W5() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF_W5.Reg)
}

// HINF.CIS_CONF_W6: SDIO cis configuration register
func (o *HINF_Type) SetCIS_CONF_W6(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF_W6.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF_W6() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF_W6.Reg)
}

// HINF.CIS_CONF_W7: SDIO cis configuration register
func (o *HINF_Type) SetCIS_CONF_W7(value uint32) {
	volatile.StoreUint32(&o.CIS_CONF_W7.Reg, value)
}
func (o *HINF_Type) GetCIS_CONF_W7() uint32 {
	return volatile.LoadUint32(&o.CIS_CONF_W7.Reg)
}

// HINF.CFG_DATA16: SDIO cis configuration register
func (o *HINF_Type) SetCFG_DATA16_DEVICE_ID_FN2(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA16.Reg, volatile.LoadUint32(&o.CFG_DATA16.Reg)&^(0xffff)|value)
}
func (o *HINF_Type) GetCFG_DATA16_DEVICE_ID_FN2() uint32 {
	return volatile.LoadUint32(&o.CFG_DATA16.Reg) & 0xffff
}
func (o *HINF_Type) SetCFG_DATA16_USER_ID_FN2(value uint32) {
	volatile.StoreUint32(&o.CFG_DATA16.Reg, volatile.LoadUint32(&o.CFG_DATA16.Reg)&^(0xffff0000)|value<<16)
}
func (o *HINF_Type) GetCFG_DATA16_USER_ID_FN2() uint32 {
	return (volatile.LoadUint32(&o.CFG_DATA16.Reg) & 0xffff0000) >> 16
}

// HINF.CFG_UHS1_INT_MODE: configure int to start and end ahead of time in uhs1 mode
func (o *HINF_Type) SetCFG_UHS1_INT_MODE_INTOE_END_AHEAD_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG_UHS1_INT_MODE.Reg, volatile.LoadUint32(&o.CFG_UHS1_INT_MODE.Reg)&^(0x3)|value)
}
func (o *HINF_Type) GetCFG_UHS1_INT_MODE_INTOE_END_AHEAD_MODE() uint32 {
	return volatile.LoadUint32(&o.CFG_UHS1_INT_MODE.Reg) & 0x3
}
func (o *HINF_Type) SetCFG_UHS1_INT_MODE_INT_END_AHEAD_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG_UHS1_INT_MODE.Reg, volatile.LoadUint32(&o.CFG_UHS1_INT_MODE.Reg)&^(0xc)|value<<2)
}
func (o *HINF_Type) GetCFG_UHS1_INT_MODE_INT_END_AHEAD_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG_UHS1_INT_MODE.Reg) & 0xc) >> 2
}
func (o *HINF_Type) SetCFG_UHS1_INT_MODE_INTOE_ST_AHEAD_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG_UHS1_INT_MODE.Reg, volatile.LoadUint32(&o.CFG_UHS1_INT_MODE.Reg)&^(0x30)|value<<4)
}
func (o *HINF_Type) GetCFG_UHS1_INT_MODE_INTOE_ST_AHEAD_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG_UHS1_INT_MODE.Reg) & 0x30) >> 4
}
func (o *HINF_Type) SetCFG_UHS1_INT_MODE_INT_ST_AHEAD_MODE(value uint32) {
	volatile.StoreUint32(&o.CFG_UHS1_INT_MODE.Reg, volatile.LoadUint32(&o.CFG_UHS1_INT_MODE.Reg)&^(0xc0)|value<<6)
}
func (o *HINF_Type) GetCFG_UHS1_INT_MODE_INT_ST_AHEAD_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFG_UHS1_INT_MODE.Reg) & 0xc0) >> 6
}

// HINF.CONF_STATUS: func0 config0 status
func (o *HINF_Type) SetCONF_STATUS_FUNC0_CONFIG0(value uint32) {
	volatile.StoreUint32(&o.CONF_STATUS.Reg, volatile.LoadUint32(&o.CONF_STATUS.Reg)&^(0xff)|value)
}
func (o *HINF_Type) GetCONF_STATUS_FUNC0_CONFIG0() uint32 {
	return volatile.LoadUint32(&o.CONF_STATUS.Reg) & 0xff
}
func (o *HINF_Type) SetCONF_STATUS_SDR25_ST(value uint32) {
	volatile.StoreUint32(&o.CONF_STATUS.Reg, volatile.LoadUint32(&o.CONF_STATUS.Reg)&^(0x100)|value<<8)
}
func (o *HINF_Type) GetCONF_STATUS_SDR25_ST() uint32 {
	return (volatile.LoadUint32(&o.CONF_STATUS.Reg) & 0x100) >> 8
}
func (o *HINF_Type) SetCONF_STATUS_SDR50_ST(value uint32) {
	volatile.StoreUint32(&o.CONF_STATUS.Reg, volatile.LoadUint32(&o.CONF_STATUS.Reg)&^(0x200)|value<<9)
}
func (o *HINF_Type) GetCONF_STATUS_SDR50_ST() uint32 {
	return (volatile.LoadUint32(&o.CONF_STATUS.Reg) & 0x200) >> 9
}
func (o *HINF_Type) SetCONF_STATUS_SDR104_ST(value uint32) {
	volatile.StoreUint32(&o.CONF_STATUS.Reg, volatile.LoadUint32(&o.CONF_STATUS.Reg)&^(0x400)|value<<10)
}
func (o *HINF_Type) GetCONF_STATUS_SDR104_ST() uint32 {
	return (volatile.LoadUint32(&o.CONF_STATUS.Reg) & 0x400) >> 10
}
func (o *HINF_Type) SetCONF_STATUS_DDR50_ST(value uint32) {
	volatile.StoreUint32(&o.CONF_STATUS.Reg, volatile.LoadUint32(&o.CONF_STATUS.Reg)&^(0x800)|value<<11)
}
func (o *HINF_Type) GetCONF_STATUS_DDR50_ST() uint32 {
	return (volatile.LoadUint32(&o.CONF_STATUS.Reg) & 0x800) >> 11
}
func (o *HINF_Type) SetCONF_STATUS_TUNE_ST(value uint32) {
	volatile.StoreUint32(&o.CONF_STATUS.Reg, volatile.LoadUint32(&o.CONF_STATUS.Reg)&^(0x7000)|value<<12)
}
func (o *HINF_Type) GetCONF_STATUS_TUNE_ST() uint32 {
	return (volatile.LoadUint32(&o.CONF_STATUS.Reg) & 0x7000) >> 12
}
func (o *HINF_Type) SetCONF_STATUS_SDIO_SWITCH_VOLT_ST(value uint32) {
	volatile.StoreUint32(&o.CONF_STATUS.Reg, volatile.LoadUint32(&o.CONF_STATUS.Reg)&^(0x8000)|value<<15)
}
func (o *HINF_Type) GetCONF_STATUS_SDIO_SWITCH_VOLT_ST() uint32 {
	return (volatile.LoadUint32(&o.CONF_STATUS.Reg) & 0x8000) >> 15
}
func (o *HINF_Type) SetCONF_STATUS_SDIO_SWITCH_END(value uint32) {
	volatile.StoreUint32(&o.CONF_STATUS.Reg, volatile.LoadUint32(&o.CONF_STATUS.Reg)&^(0x10000)|value<<16)
}
func (o *HINF_Type) GetCONF_STATUS_SDIO_SWITCH_END() uint32 {
	return (volatile.LoadUint32(&o.CONF_STATUS.Reg) & 0x10000) >> 16
}

// HINF.SDIO_SLAVE_ECO_LOW: sdio_slave redundant control registers
func (o *HINF_Type) SetSDIO_SLAVE_ECO_LOW(value uint32) {
	volatile.StoreUint32(&o.SDIO_SLAVE_ECO_LOW.Reg, value)
}
func (o *HINF_Type) GetSDIO_SLAVE_ECO_LOW() uint32 {
	return volatile.LoadUint32(&o.SDIO_SLAVE_ECO_LOW.Reg)
}

// HINF.SDIO_SLAVE_ECO_HIGH: sdio_slave redundant control registers
func (o *HINF_Type) SetSDIO_SLAVE_ECO_HIGH(value uint32) {
	volatile.StoreUint32(&o.SDIO_SLAVE_ECO_HIGH.Reg, value)
}
func (o *HINF_Type) GetSDIO_SLAVE_ECO_HIGH() uint32 {
	return volatile.LoadUint32(&o.SDIO_SLAVE_ECO_HIGH.Reg)
}

// HINF.SDIO_SLAVE_ECO_CONF: sdio_slave redundant control registers
func (o *HINF_Type) SetSDIO_SLAVE_ECO_CONF_SDIO_SLAVE_RDN_RESULT(value uint32) {
	volatile.StoreUint32(&o.SDIO_SLAVE_ECO_CONF.Reg, volatile.LoadUint32(&o.SDIO_SLAVE_ECO_CONF.Reg)&^(0x1)|value)
}
func (o *HINF_Type) GetSDIO_SLAVE_ECO_CONF_SDIO_SLAVE_RDN_RESULT() uint32 {
	return volatile.LoadUint32(&o.SDIO_SLAVE_ECO_CONF.Reg) & 0x1
}
func (o *HINF_Type) SetSDIO_SLAVE_ECO_CONF_SDIO_SLAVE_RDN_ENA(value uint32) {
	volatile.StoreUint32(&o.SDIO_SLAVE_ECO_CONF.Reg, volatile.LoadUint32(&o.SDIO_SLAVE_ECO_CONF.Reg)&^(0x2)|value<<1)
}
func (o *HINF_Type) GetSDIO_SLAVE_ECO_CONF_SDIO_SLAVE_RDN_ENA() uint32 {
	return (volatile.LoadUint32(&o.SDIO_SLAVE_ECO_CONF.Reg) & 0x2) >> 1
}
func (o *HINF_Type) SetSDIO_SLAVE_ECO_CONF_SDIO_SLAVE_SDIO_CLK_RDN_RESULT(value uint32) {
	volatile.StoreUint32(&o.SDIO_SLAVE_ECO_CONF.Reg, volatile.LoadUint32(&o.SDIO_SLAVE_ECO_CONF.Reg)&^(0x4)|value<<2)
}
func (o *HINF_Type) GetSDIO_SLAVE_ECO_CONF_SDIO_SLAVE_SDIO_CLK_RDN_RESULT() uint32 {
	return (volatile.LoadUint32(&o.SDIO_SLAVE_ECO_CONF.Reg) & 0x4) >> 2
}
func (o *HINF_Type) SetSDIO_SLAVE_ECO_CONF_SDIO_SLAVE_SDIO_CLK_RDN_ENA(value uint32) {
	volatile.StoreUint32(&o.SDIO_SLAVE_ECO_CONF.Reg, volatile.LoadUint32(&o.SDIO_SLAVE_ECO_CONF.Reg)&^(0x8)|value<<3)
}
func (o *HINF_Type) GetSDIO_SLAVE_ECO_CONF_SDIO_SLAVE_SDIO_CLK_RDN_ENA() uint32 {
	return (volatile.LoadUint32(&o.SDIO_SLAVE_ECO_CONF.Reg) & 0x8) >> 3
}
func (o *HINF_Type) SetSDIO_SLAVE_ECO_CONF_SDIO_SLAVE_SDCLK_PAD_RDN_RESULT(value uint32) {
	volatile.StoreUint32(&o.SDIO_SLAVE_ECO_CONF.Reg, volatile.LoadUint32(&o.SDIO_SLAVE_ECO_CONF.Reg)&^(0x10)|value<<4)
}
func (o *HINF_Type) GetSDIO_SLAVE_ECO_CONF_SDIO_SLAVE_SDCLK_PAD_RDN_RESULT() uint32 {
	return (volatile.LoadUint32(&o.SDIO_SLAVE_ECO_CONF.Reg) & 0x10) >> 4
}
func (o *HINF_Type) SetSDIO_SLAVE_ECO_CONF_SDIO_SLAVE_SDCLK_PAD_RDN_ENA(value uint32) {
	volatile.StoreUint32(&o.SDIO_SLAVE_ECO_CONF.Reg, volatile.LoadUint32(&o.SDIO_SLAVE_ECO_CONF.Reg)&^(0x20)|value<<5)
}
func (o *HINF_Type) GetSDIO_SLAVE_ECO_CONF_SDIO_SLAVE_SDCLK_PAD_RDN_ENA() uint32 {
	return (volatile.LoadUint32(&o.SDIO_SLAVE_ECO_CONF.Reg) & 0x20) >> 5
}

// HINF.SDIO_SLAVE_LDO_CONF: sdio slave ldo control register
func (o *HINF_Type) SetSDIO_SLAVE_LDO_CONF_LDO_READY_CTL_IN_EN(value uint32) {
	volatile.StoreUint32(&o.SDIO_SLAVE_LDO_CONF.Reg, volatile.LoadUint32(&o.SDIO_SLAVE_LDO_CONF.Reg)&^(0x1)|value)
}
func (o *HINF_Type) GetSDIO_SLAVE_LDO_CONF_LDO_READY_CTL_IN_EN() uint32 {
	return volatile.LoadUint32(&o.SDIO_SLAVE_LDO_CONF.Reg) & 0x1
}
func (o *HINF_Type) SetSDIO_SLAVE_LDO_CONF_LDO_READY_THRES(value uint32) {
	volatile.StoreUint32(&o.SDIO_SLAVE_LDO_CONF.Reg, volatile.LoadUint32(&o.SDIO_SLAVE_LDO_CONF.Reg)&^(0x3e)|value<<1)
}
func (o *HINF_Type) GetSDIO_SLAVE_LDO_CONF_LDO_READY_THRES() uint32 {
	return (volatile.LoadUint32(&o.SDIO_SLAVE_LDO_CONF.Reg) & 0x3e) >> 1
}
func (o *HINF_Type) SetSDIO_SLAVE_LDO_CONF_LDO_READY_IGNORE_EN(value uint32) {
	volatile.StoreUint32(&o.SDIO_SLAVE_LDO_CONF.Reg, volatile.LoadUint32(&o.SDIO_SLAVE_LDO_CONF.Reg)&^(0x40)|value<<6)
}
func (o *HINF_Type) GetSDIO_SLAVE_LDO_CONF_LDO_READY_IGNORE_EN() uint32 {
	return (volatile.LoadUint32(&o.SDIO_SLAVE_LDO_CONF.Reg) & 0x40) >> 6
}

// HINF.SDIO_DATE: ******* Description ***********
func (o *HINF_Type) SetSDIO_DATE(value uint32) {
	volatile.StoreUint32(&o.SDIO_DATE.Reg, value)
}
func (o *HINF_Type) GetSDIO_DATE() uint32 {
	return volatile.LoadUint32(&o.SDIO_DATE.Reg)
}

// HMAC (Hash-based Message Authentication Code) Accelerator
type HMAC_Type struct {
	_                   [64]byte
	SET_START           volatile.Register32 // 0x40
	SET_PARA_PURPOSE    volatile.Register32 // 0x44
	SET_PARA_KEY        volatile.Register32 // 0x48
	SET_PARA_FINISH     volatile.Register32 // 0x4C
	SET_MESSAGE_ONE     volatile.Register32 // 0x50
	SET_MESSAGE_ING     volatile.Register32 // 0x54
	SET_MESSAGE_END     volatile.Register32 // 0x58
	SET_RESULT_FINISH   volatile.Register32 // 0x5C
	SET_INVALIDATE_JTAG volatile.Register32 // 0x60
	SET_INVALIDATE_DS   volatile.Register32 // 0x64
	QUERY_ERROR         volatile.Register32 // 0x68
	QUERY_BUSY          volatile.Register32 // 0x6C
	_                   [16]byte
	WR_MESSAGE_MEM      [64]volatile.Register8 // 0x80
	RD_RESULT_MEM       [32]volatile.Register8 // 0xC0
	_                   [16]byte
	SET_MESSAGE_PAD     volatile.Register32 // 0xF0
	ONE_BLOCK           volatile.Register32 // 0xF4
	SOFT_JTAG_CTRL      volatile.Register32 // 0xF8
	WR_JTAG             volatile.Register32 // 0xFC
	_                   [252]byte
	DATE                volatile.Register32 // 0x1FC
}

// HMAC.SET_START: Process control register 0.
func (o *HMAC_Type) SetSET_START(value uint32) {
	volatile.StoreUint32(&o.SET_START.Reg, volatile.LoadUint32(&o.SET_START.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_START() uint32 {
	return volatile.LoadUint32(&o.SET_START.Reg) & 0x1
}

// HMAC.SET_PARA_PURPOSE: Configure purpose.
func (o *HMAC_Type) SetSET_PARA_PURPOSE_PURPOSE_SET(value uint32) {
	volatile.StoreUint32(&o.SET_PARA_PURPOSE.Reg, volatile.LoadUint32(&o.SET_PARA_PURPOSE.Reg)&^(0xf)|value)
}
func (o *HMAC_Type) GetSET_PARA_PURPOSE_PURPOSE_SET() uint32 {
	return volatile.LoadUint32(&o.SET_PARA_PURPOSE.Reg) & 0xf
}

// HMAC.SET_PARA_KEY: Configure key.
func (o *HMAC_Type) SetSET_PARA_KEY_KEY_SET(value uint32) {
	volatile.StoreUint32(&o.SET_PARA_KEY.Reg, volatile.LoadUint32(&o.SET_PARA_KEY.Reg)&^(0x7)|value)
}
func (o *HMAC_Type) GetSET_PARA_KEY_KEY_SET() uint32 {
	return volatile.LoadUint32(&o.SET_PARA_KEY.Reg) & 0x7
}

// HMAC.SET_PARA_FINISH: Finish initial configuration.
func (o *HMAC_Type) SetSET_PARA_FINISH_SET_PARA_END(value uint32) {
	volatile.StoreUint32(&o.SET_PARA_FINISH.Reg, volatile.LoadUint32(&o.SET_PARA_FINISH.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_PARA_FINISH_SET_PARA_END() uint32 {
	return volatile.LoadUint32(&o.SET_PARA_FINISH.Reg) & 0x1
}

// HMAC.SET_MESSAGE_ONE: Process control register 1.
func (o *HMAC_Type) SetSET_MESSAGE_ONE_SET_TEXT_ONE(value uint32) {
	volatile.StoreUint32(&o.SET_MESSAGE_ONE.Reg, volatile.LoadUint32(&o.SET_MESSAGE_ONE.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_MESSAGE_ONE_SET_TEXT_ONE() uint32 {
	return volatile.LoadUint32(&o.SET_MESSAGE_ONE.Reg) & 0x1
}

// HMAC.SET_MESSAGE_ING: Process control register 2.
func (o *HMAC_Type) SetSET_MESSAGE_ING_SET_TEXT_ING(value uint32) {
	volatile.StoreUint32(&o.SET_MESSAGE_ING.Reg, volatile.LoadUint32(&o.SET_MESSAGE_ING.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_MESSAGE_ING_SET_TEXT_ING() uint32 {
	return volatile.LoadUint32(&o.SET_MESSAGE_ING.Reg) & 0x1
}

// HMAC.SET_MESSAGE_END: Process control register 3.
func (o *HMAC_Type) SetSET_MESSAGE_END_SET_TEXT_END(value uint32) {
	volatile.StoreUint32(&o.SET_MESSAGE_END.Reg, volatile.LoadUint32(&o.SET_MESSAGE_END.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_MESSAGE_END_SET_TEXT_END() uint32 {
	return volatile.LoadUint32(&o.SET_MESSAGE_END.Reg) & 0x1
}

// HMAC.SET_RESULT_FINISH: Process control register 4.
func (o *HMAC_Type) SetSET_RESULT_FINISH_SET_RESULT_END(value uint32) {
	volatile.StoreUint32(&o.SET_RESULT_FINISH.Reg, volatile.LoadUint32(&o.SET_RESULT_FINISH.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_RESULT_FINISH_SET_RESULT_END() uint32 {
	return volatile.LoadUint32(&o.SET_RESULT_FINISH.Reg) & 0x1
}

// HMAC.SET_INVALIDATE_JTAG: Invalidate register 0.
func (o *HMAC_Type) SetSET_INVALIDATE_JTAG(value uint32) {
	volatile.StoreUint32(&o.SET_INVALIDATE_JTAG.Reg, volatile.LoadUint32(&o.SET_INVALIDATE_JTAG.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_INVALIDATE_JTAG() uint32 {
	return volatile.LoadUint32(&o.SET_INVALIDATE_JTAG.Reg) & 0x1
}

// HMAC.SET_INVALIDATE_DS: Invalidate register 1.
func (o *HMAC_Type) SetSET_INVALIDATE_DS(value uint32) {
	volatile.StoreUint32(&o.SET_INVALIDATE_DS.Reg, volatile.LoadUint32(&o.SET_INVALIDATE_DS.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_INVALIDATE_DS() uint32 {
	return volatile.LoadUint32(&o.SET_INVALIDATE_DS.Reg) & 0x1
}

// HMAC.QUERY_ERROR: Error register.
func (o *HMAC_Type) SetQUERY_ERROR_QUERY_CHECK(value uint32) {
	volatile.StoreUint32(&o.QUERY_ERROR.Reg, volatile.LoadUint32(&o.QUERY_ERROR.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetQUERY_ERROR_QUERY_CHECK() uint32 {
	return volatile.LoadUint32(&o.QUERY_ERROR.Reg) & 0x1
}

// HMAC.QUERY_BUSY: Busy register.
func (o *HMAC_Type) SetQUERY_BUSY_BUSY_STATE(value uint32) {
	volatile.StoreUint32(&o.QUERY_BUSY.Reg, volatile.LoadUint32(&o.QUERY_BUSY.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetQUERY_BUSY_BUSY_STATE() uint32 {
	return volatile.LoadUint32(&o.QUERY_BUSY.Reg) & 0x1
}

// HMAC.SET_MESSAGE_PAD: Process control register 5.
func (o *HMAC_Type) SetSET_MESSAGE_PAD_SET_TEXT_PAD(value uint32) {
	volatile.StoreUint32(&o.SET_MESSAGE_PAD.Reg, volatile.LoadUint32(&o.SET_MESSAGE_PAD.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSET_MESSAGE_PAD_SET_TEXT_PAD() uint32 {
	return volatile.LoadUint32(&o.SET_MESSAGE_PAD.Reg) & 0x1
}

// HMAC.ONE_BLOCK: Process control register 6.
func (o *HMAC_Type) SetONE_BLOCK_SET_ONE_BLOCK(value uint32) {
	volatile.StoreUint32(&o.ONE_BLOCK.Reg, volatile.LoadUint32(&o.ONE_BLOCK.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetONE_BLOCK_SET_ONE_BLOCK() uint32 {
	return volatile.LoadUint32(&o.ONE_BLOCK.Reg) & 0x1
}

// HMAC.SOFT_JTAG_CTRL: Jtag register 0.
func (o *HMAC_Type) SetSOFT_JTAG_CTRL(value uint32) {
	volatile.StoreUint32(&o.SOFT_JTAG_CTRL.Reg, volatile.LoadUint32(&o.SOFT_JTAG_CTRL.Reg)&^(0x1)|value)
}
func (o *HMAC_Type) GetSOFT_JTAG_CTRL() uint32 {
	return volatile.LoadUint32(&o.SOFT_JTAG_CTRL.Reg) & 0x1
}

// HMAC.WR_JTAG: Jtag register 1.
func (o *HMAC_Type) SetWR_JTAG(value uint32) {
	volatile.StoreUint32(&o.WR_JTAG.Reg, value)
}
func (o *HMAC_Type) GetWR_JTAG() uint32 {
	return volatile.LoadUint32(&o.WR_JTAG.Reg)
}

// HMAC.DATE: Date register.
func (o *HMAC_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0x3fffffff)|value)
}
func (o *HMAC_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0x3fffffff
}

// HP_APM Peripheral
type HP_APM_Type struct {
	REGION_FILTER_EN    volatile.Register32 // 0x0
	REGION0_ADDR_START  volatile.Register32 // 0x4
	REGION0_ADDR_END    volatile.Register32 // 0x8
	REGION0_PMS_ATTR    volatile.Register32 // 0xC
	REGION1_ADDR_START  volatile.Register32 // 0x10
	REGION1_ADDR_END    volatile.Register32 // 0x14
	REGION1_PMS_ATTR    volatile.Register32 // 0x18
	REGION2_ADDR_START  volatile.Register32 // 0x1C
	REGION2_ADDR_END    volatile.Register32 // 0x20
	REGION2_PMS_ATTR    volatile.Register32 // 0x24
	REGION3_ADDR_START  volatile.Register32 // 0x28
	REGION3_ADDR_END    volatile.Register32 // 0x2C
	REGION3_PMS_ATTR    volatile.Register32 // 0x30
	REGION4_ADDR_START  volatile.Register32 // 0x34
	REGION4_ADDR_END    volatile.Register32 // 0x38
	REGION4_PMS_ATTR    volatile.Register32 // 0x3C
	REGION5_ADDR_START  volatile.Register32 // 0x40
	REGION5_ADDR_END    volatile.Register32 // 0x44
	REGION5_PMS_ATTR    volatile.Register32 // 0x48
	REGION6_ADDR_START  volatile.Register32 // 0x4C
	REGION6_ADDR_END    volatile.Register32 // 0x50
	REGION6_PMS_ATTR    volatile.Register32 // 0x54
	REGION7_ADDR_START  volatile.Register32 // 0x58
	REGION7_ADDR_END    volatile.Register32 // 0x5C
	REGION7_PMS_ATTR    volatile.Register32 // 0x60
	REGION8_ADDR_START  volatile.Register32 // 0x64
	REGION8_ADDR_END    volatile.Register32 // 0x68
	REGION8_PMS_ATTR    volatile.Register32 // 0x6C
	REGION9_ADDR_START  volatile.Register32 // 0x70
	REGION9_ADDR_END    volatile.Register32 // 0x74
	REGION9_PMS_ATTR    volatile.Register32 // 0x78
	REGION10_ADDR_START volatile.Register32 // 0x7C
	REGION10_ADDR_END   volatile.Register32 // 0x80
	REGION10_PMS_ATTR   volatile.Register32 // 0x84
	REGION11_ADDR_START volatile.Register32 // 0x88
	REGION11_ADDR_END   volatile.Register32 // 0x8C
	REGION11_PMS_ATTR   volatile.Register32 // 0x90
	REGION12_ADDR_START volatile.Register32 // 0x94
	REGION12_ADDR_END   volatile.Register32 // 0x98
	REGION12_PMS_ATTR   volatile.Register32 // 0x9C
	REGION13_ADDR_START volatile.Register32 // 0xA0
	REGION13_ADDR_END   volatile.Register32 // 0xA4
	REGION13_PMS_ATTR   volatile.Register32 // 0xA8
	REGION14_ADDR_START volatile.Register32 // 0xAC
	REGION14_ADDR_END   volatile.Register32 // 0xB0
	REGION14_PMS_ATTR   volatile.Register32 // 0xB4
	REGION15_ADDR_START volatile.Register32 // 0xB8
	REGION15_ADDR_END   volatile.Register32 // 0xBC
	REGION15_PMS_ATTR   volatile.Register32 // 0xC0
	FUNC_CTRL           volatile.Register32 // 0xC4
	M0_STATUS           volatile.Register32 // 0xC8
	M0_STATUS_CLR       volatile.Register32 // 0xCC
	M0_EXCEPTION_INFO0  volatile.Register32 // 0xD0
	M0_EXCEPTION_INFO1  volatile.Register32 // 0xD4
	M1_STATUS           volatile.Register32 // 0xD8
	M1_STATUS_CLR       volatile.Register32 // 0xDC
	M1_EXCEPTION_INFO0  volatile.Register32 // 0xE0
	M1_EXCEPTION_INFO1  volatile.Register32 // 0xE4
	M2_STATUS           volatile.Register32 // 0xE8
	M2_STATUS_CLR       volatile.Register32 // 0xEC
	M2_EXCEPTION_INFO0  volatile.Register32 // 0xF0
	M2_EXCEPTION_INFO1  volatile.Register32 // 0xF4
	M3_STATUS           volatile.Register32 // 0xF8
	M3_STATUS_CLR       volatile.Register32 // 0xFC
	M3_EXCEPTION_INFO0  volatile.Register32 // 0x100
	M3_EXCEPTION_INFO1  volatile.Register32 // 0x104
	INT_EN              volatile.Register32 // 0x108
	CLOCK_GATE          volatile.Register32 // 0x10C
	_                   [1772]byte
	DATE                volatile.Register32 // 0x7FC
}

// HP_APM.REGION_FILTER_EN: Region filter enable register
func (o *HP_APM_Type) SetREGION_FILTER_EN(value uint32) {
	volatile.StoreUint32(&o.REGION_FILTER_EN.Reg, volatile.LoadUint32(&o.REGION_FILTER_EN.Reg)&^(0xffff)|value)
}
func (o *HP_APM_Type) GetREGION_FILTER_EN() uint32 {
	return volatile.LoadUint32(&o.REGION_FILTER_EN.Reg) & 0xffff
}

// HP_APM.REGION0_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION0_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION0_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION0_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION0_ADDR_START.Reg)
}

// HP_APM.REGION0_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION0_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION0_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION0_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION0_ADDR_END.Reg)
}

// HP_APM.REGION0_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION0_PMS_ATTR_REGION0_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION0_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION0_PMS_ATTR_REGION0_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION0_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.REGION1_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION1_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION1_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION1_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION1_ADDR_START.Reg)
}

// HP_APM.REGION1_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION1_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION1_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION1_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION1_ADDR_END.Reg)
}

// HP_APM.REGION1_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION1_PMS_ATTR_REGION1_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION1_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION1_PMS_ATTR_REGION1_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION1_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.REGION2_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION2_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION2_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION2_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION2_ADDR_START.Reg)
}

// HP_APM.REGION2_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION2_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION2_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION2_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION2_ADDR_END.Reg)
}

// HP_APM.REGION2_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION2_PMS_ATTR_REGION2_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION2_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION2_PMS_ATTR_REGION2_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION2_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.REGION3_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION3_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION3_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION3_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION3_ADDR_START.Reg)
}

// HP_APM.REGION3_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION3_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION3_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION3_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION3_ADDR_END.Reg)
}

// HP_APM.REGION3_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION3_PMS_ATTR_REGION3_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION3_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION3_PMS_ATTR_REGION3_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION3_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.REGION4_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION4_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION4_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION4_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION4_ADDR_START.Reg)
}

// HP_APM.REGION4_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION4_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION4_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION4_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION4_ADDR_END.Reg)
}

// HP_APM.REGION4_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION4_PMS_ATTR_REGION4_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION4_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION4_PMS_ATTR_REGION4_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION4_PMS_ATTR_REGION4_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION4_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION4_PMS_ATTR_REGION4_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION4_PMS_ATTR_REGION4_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION4_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION4_PMS_ATTR_REGION4_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION4_PMS_ATTR_REGION4_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION4_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION4_PMS_ATTR_REGION4_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION4_PMS_ATTR_REGION4_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION4_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION4_PMS_ATTR_REGION4_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION4_PMS_ATTR_REGION4_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION4_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION4_PMS_ATTR_REGION4_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION4_PMS_ATTR_REGION4_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION4_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION4_PMS_ATTR_REGION4_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION4_PMS_ATTR_REGION4_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION4_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION4_PMS_ATTR_REGION4_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION4_PMS_ATTR_REGION4_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION4_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION4_PMS_ATTR_REGION4_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION4_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.REGION5_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION5_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION5_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION5_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION5_ADDR_START.Reg)
}

// HP_APM.REGION5_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION5_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION5_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION5_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION5_ADDR_END.Reg)
}

// HP_APM.REGION5_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION5_PMS_ATTR_REGION5_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION5_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION5_PMS_ATTR_REGION5_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION5_PMS_ATTR_REGION5_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION5_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION5_PMS_ATTR_REGION5_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION5_PMS_ATTR_REGION5_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION5_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION5_PMS_ATTR_REGION5_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION5_PMS_ATTR_REGION5_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION5_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION5_PMS_ATTR_REGION5_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION5_PMS_ATTR_REGION5_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION5_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION5_PMS_ATTR_REGION5_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION5_PMS_ATTR_REGION5_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION5_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION5_PMS_ATTR_REGION5_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION5_PMS_ATTR_REGION5_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION5_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION5_PMS_ATTR_REGION5_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION5_PMS_ATTR_REGION5_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION5_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION5_PMS_ATTR_REGION5_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION5_PMS_ATTR_REGION5_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION5_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION5_PMS_ATTR_REGION5_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION5_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.REGION6_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION6_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION6_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION6_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION6_ADDR_START.Reg)
}

// HP_APM.REGION6_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION6_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION6_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION6_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION6_ADDR_END.Reg)
}

// HP_APM.REGION6_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION6_PMS_ATTR_REGION6_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION6_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION6_PMS_ATTR_REGION6_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION6_PMS_ATTR_REGION6_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION6_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION6_PMS_ATTR_REGION6_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION6_PMS_ATTR_REGION6_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION6_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION6_PMS_ATTR_REGION6_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION6_PMS_ATTR_REGION6_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION6_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION6_PMS_ATTR_REGION6_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION6_PMS_ATTR_REGION6_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION6_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION6_PMS_ATTR_REGION6_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION6_PMS_ATTR_REGION6_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION6_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION6_PMS_ATTR_REGION6_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION6_PMS_ATTR_REGION6_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION6_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION6_PMS_ATTR_REGION6_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION6_PMS_ATTR_REGION6_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION6_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION6_PMS_ATTR_REGION6_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION6_PMS_ATTR_REGION6_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION6_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION6_PMS_ATTR_REGION6_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION6_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.REGION7_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION7_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION7_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION7_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION7_ADDR_START.Reg)
}

// HP_APM.REGION7_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION7_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION7_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION7_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION7_ADDR_END.Reg)
}

// HP_APM.REGION7_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION7_PMS_ATTR_REGION7_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION7_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION7_PMS_ATTR_REGION7_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION7_PMS_ATTR_REGION7_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION7_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION7_PMS_ATTR_REGION7_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION7_PMS_ATTR_REGION7_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION7_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION7_PMS_ATTR_REGION7_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION7_PMS_ATTR_REGION7_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION7_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION7_PMS_ATTR_REGION7_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION7_PMS_ATTR_REGION7_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION7_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION7_PMS_ATTR_REGION7_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION7_PMS_ATTR_REGION7_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION7_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION7_PMS_ATTR_REGION7_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION7_PMS_ATTR_REGION7_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION7_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION7_PMS_ATTR_REGION7_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION7_PMS_ATTR_REGION7_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION7_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION7_PMS_ATTR_REGION7_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION7_PMS_ATTR_REGION7_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION7_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION7_PMS_ATTR_REGION7_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION7_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.REGION8_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION8_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION8_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION8_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION8_ADDR_START.Reg)
}

// HP_APM.REGION8_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION8_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION8_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION8_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION8_ADDR_END.Reg)
}

// HP_APM.REGION8_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION8_PMS_ATTR_REGION8_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION8_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION8_PMS_ATTR_REGION8_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION8_PMS_ATTR_REGION8_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION8_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION8_PMS_ATTR_REGION8_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION8_PMS_ATTR_REGION8_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION8_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION8_PMS_ATTR_REGION8_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION8_PMS_ATTR_REGION8_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION8_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION8_PMS_ATTR_REGION8_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION8_PMS_ATTR_REGION8_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION8_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION8_PMS_ATTR_REGION8_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION8_PMS_ATTR_REGION8_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION8_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION8_PMS_ATTR_REGION8_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION8_PMS_ATTR_REGION8_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION8_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION8_PMS_ATTR_REGION8_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION8_PMS_ATTR_REGION8_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION8_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION8_PMS_ATTR_REGION8_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION8_PMS_ATTR_REGION8_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION8_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION8_PMS_ATTR_REGION8_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION8_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.REGION9_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION9_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION9_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION9_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION9_ADDR_START.Reg)
}

// HP_APM.REGION9_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION9_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION9_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION9_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION9_ADDR_END.Reg)
}

// HP_APM.REGION9_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION9_PMS_ATTR_REGION9_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION9_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION9_PMS_ATTR_REGION9_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION9_PMS_ATTR_REGION9_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION9_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION9_PMS_ATTR_REGION9_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION9_PMS_ATTR_REGION9_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION9_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION9_PMS_ATTR_REGION9_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION9_PMS_ATTR_REGION9_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION9_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION9_PMS_ATTR_REGION9_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION9_PMS_ATTR_REGION9_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION9_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION9_PMS_ATTR_REGION9_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION9_PMS_ATTR_REGION9_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION9_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION9_PMS_ATTR_REGION9_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION9_PMS_ATTR_REGION9_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION9_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION9_PMS_ATTR_REGION9_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION9_PMS_ATTR_REGION9_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION9_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION9_PMS_ATTR_REGION9_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION9_PMS_ATTR_REGION9_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION9_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION9_PMS_ATTR_REGION9_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION9_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.REGION10_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION10_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION10_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION10_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION10_ADDR_START.Reg)
}

// HP_APM.REGION10_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION10_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION10_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION10_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION10_ADDR_END.Reg)
}

// HP_APM.REGION10_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION10_PMS_ATTR_REGION10_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION10_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION10_PMS_ATTR_REGION10_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION10_PMS_ATTR_REGION10_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION10_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION10_PMS_ATTR_REGION10_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION10_PMS_ATTR_REGION10_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION10_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION10_PMS_ATTR_REGION10_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION10_PMS_ATTR_REGION10_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION10_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION10_PMS_ATTR_REGION10_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION10_PMS_ATTR_REGION10_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION10_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION10_PMS_ATTR_REGION10_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION10_PMS_ATTR_REGION10_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION10_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION10_PMS_ATTR_REGION10_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION10_PMS_ATTR_REGION10_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION10_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION10_PMS_ATTR_REGION10_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION10_PMS_ATTR_REGION10_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION10_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION10_PMS_ATTR_REGION10_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION10_PMS_ATTR_REGION10_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION10_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION10_PMS_ATTR_REGION10_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION10_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.REGION11_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION11_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION11_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION11_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION11_ADDR_START.Reg)
}

// HP_APM.REGION11_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION11_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION11_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION11_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION11_ADDR_END.Reg)
}

// HP_APM.REGION11_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION11_PMS_ATTR_REGION11_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION11_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION11_PMS_ATTR_REGION11_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION11_PMS_ATTR_REGION11_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION11_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION11_PMS_ATTR_REGION11_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION11_PMS_ATTR_REGION11_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION11_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION11_PMS_ATTR_REGION11_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION11_PMS_ATTR_REGION11_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION11_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION11_PMS_ATTR_REGION11_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION11_PMS_ATTR_REGION11_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION11_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION11_PMS_ATTR_REGION11_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION11_PMS_ATTR_REGION11_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION11_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION11_PMS_ATTR_REGION11_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION11_PMS_ATTR_REGION11_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION11_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION11_PMS_ATTR_REGION11_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION11_PMS_ATTR_REGION11_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION11_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION11_PMS_ATTR_REGION11_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION11_PMS_ATTR_REGION11_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION11_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION11_PMS_ATTR_REGION11_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION11_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.REGION12_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION12_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION12_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION12_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION12_ADDR_START.Reg)
}

// HP_APM.REGION12_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION12_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION12_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION12_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION12_ADDR_END.Reg)
}

// HP_APM.REGION12_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION12_PMS_ATTR_REGION12_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION12_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION12_PMS_ATTR_REGION12_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION12_PMS_ATTR_REGION12_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION12_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION12_PMS_ATTR_REGION12_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION12_PMS_ATTR_REGION12_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION12_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION12_PMS_ATTR_REGION12_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION12_PMS_ATTR_REGION12_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION12_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION12_PMS_ATTR_REGION12_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION12_PMS_ATTR_REGION12_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION12_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION12_PMS_ATTR_REGION12_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION12_PMS_ATTR_REGION12_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION12_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION12_PMS_ATTR_REGION12_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION12_PMS_ATTR_REGION12_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION12_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION12_PMS_ATTR_REGION12_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION12_PMS_ATTR_REGION12_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION12_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION12_PMS_ATTR_REGION12_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION12_PMS_ATTR_REGION12_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION12_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION12_PMS_ATTR_REGION12_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION12_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.REGION13_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION13_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION13_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION13_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION13_ADDR_START.Reg)
}

// HP_APM.REGION13_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION13_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION13_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION13_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION13_ADDR_END.Reg)
}

// HP_APM.REGION13_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION13_PMS_ATTR_REGION13_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION13_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION13_PMS_ATTR_REGION13_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION13_PMS_ATTR_REGION13_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION13_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION13_PMS_ATTR_REGION13_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION13_PMS_ATTR_REGION13_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION13_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION13_PMS_ATTR_REGION13_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION13_PMS_ATTR_REGION13_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION13_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION13_PMS_ATTR_REGION13_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION13_PMS_ATTR_REGION13_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION13_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION13_PMS_ATTR_REGION13_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION13_PMS_ATTR_REGION13_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION13_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION13_PMS_ATTR_REGION13_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION13_PMS_ATTR_REGION13_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION13_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION13_PMS_ATTR_REGION13_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION13_PMS_ATTR_REGION13_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION13_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION13_PMS_ATTR_REGION13_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION13_PMS_ATTR_REGION13_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION13_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION13_PMS_ATTR_REGION13_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION13_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.REGION14_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION14_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION14_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION14_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION14_ADDR_START.Reg)
}

// HP_APM.REGION14_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION14_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION14_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION14_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION14_ADDR_END.Reg)
}

// HP_APM.REGION14_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION14_PMS_ATTR_REGION14_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION14_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION14_PMS_ATTR_REGION14_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION14_PMS_ATTR_REGION14_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION14_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION14_PMS_ATTR_REGION14_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION14_PMS_ATTR_REGION14_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION14_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION14_PMS_ATTR_REGION14_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION14_PMS_ATTR_REGION14_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION14_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION14_PMS_ATTR_REGION14_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION14_PMS_ATTR_REGION14_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION14_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION14_PMS_ATTR_REGION14_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION14_PMS_ATTR_REGION14_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION14_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION14_PMS_ATTR_REGION14_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION14_PMS_ATTR_REGION14_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION14_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION14_PMS_ATTR_REGION14_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION14_PMS_ATTR_REGION14_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION14_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION14_PMS_ATTR_REGION14_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION14_PMS_ATTR_REGION14_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION14_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION14_PMS_ATTR_REGION14_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION14_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.REGION15_ADDR_START: Region address register
func (o *HP_APM_Type) SetREGION15_ADDR_START(value uint32) {
	volatile.StoreUint32(&o.REGION15_ADDR_START.Reg, value)
}
func (o *HP_APM_Type) GetREGION15_ADDR_START() uint32 {
	return volatile.LoadUint32(&o.REGION15_ADDR_START.Reg)
}

// HP_APM.REGION15_ADDR_END: Region address register
func (o *HP_APM_Type) SetREGION15_ADDR_END(value uint32) {
	volatile.StoreUint32(&o.REGION15_ADDR_END.Reg, value)
}
func (o *HP_APM_Type) GetREGION15_ADDR_END() uint32 {
	return volatile.LoadUint32(&o.REGION15_ADDR_END.Reg)
}

// HP_APM.REGION15_PMS_ATTR: Region access authority attribute register
func (o *HP_APM_Type) SetREGION15_PMS_ATTR_REGION15_R0_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION15_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetREGION15_PMS_ATTR_REGION15_R0_PMS_X() uint32 {
	return volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg) & 0x1
}
func (o *HP_APM_Type) SetREGION15_PMS_ATTR_REGION15_R0_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION15_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetREGION15_PMS_ATTR_REGION15_R0_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetREGION15_PMS_ATTR_REGION15_R0_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION15_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetREGION15_PMS_ATTR_REGION15_R0_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetREGION15_PMS_ATTR_REGION15_R1_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION15_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg)&^(0x10)|value<<4)
}
func (o *HP_APM_Type) GetREGION15_PMS_ATTR_REGION15_R1_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg) & 0x10) >> 4
}
func (o *HP_APM_Type) SetREGION15_PMS_ATTR_REGION15_R1_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION15_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg)&^(0x20)|value<<5)
}
func (o *HP_APM_Type) GetREGION15_PMS_ATTR_REGION15_R1_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg) & 0x20) >> 5
}
func (o *HP_APM_Type) SetREGION15_PMS_ATTR_REGION15_R1_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION15_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg)&^(0x40)|value<<6)
}
func (o *HP_APM_Type) GetREGION15_PMS_ATTR_REGION15_R1_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg) & 0x40) >> 6
}
func (o *HP_APM_Type) SetREGION15_PMS_ATTR_REGION15_R2_PMS_X(value uint32) {
	volatile.StoreUint32(&o.REGION15_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg)&^(0x100)|value<<8)
}
func (o *HP_APM_Type) GetREGION15_PMS_ATTR_REGION15_R2_PMS_X() uint32 {
	return (volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg) & 0x100) >> 8
}
func (o *HP_APM_Type) SetREGION15_PMS_ATTR_REGION15_R2_PMS_W(value uint32) {
	volatile.StoreUint32(&o.REGION15_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg)&^(0x200)|value<<9)
}
func (o *HP_APM_Type) GetREGION15_PMS_ATTR_REGION15_R2_PMS_W() uint32 {
	return (volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg) & 0x200) >> 9
}
func (o *HP_APM_Type) SetREGION15_PMS_ATTR_REGION15_R2_PMS_R(value uint32) {
	volatile.StoreUint32(&o.REGION15_PMS_ATTR.Reg, volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg)&^(0x400)|value<<10)
}
func (o *HP_APM_Type) GetREGION15_PMS_ATTR_REGION15_R2_PMS_R() uint32 {
	return (volatile.LoadUint32(&o.REGION15_PMS_ATTR.Reg) & 0x400) >> 10
}

// HP_APM.FUNC_CTRL: PMS function control register
func (o *HP_APM_Type) SetFUNC_CTRL_M0_PMS_FUNC_EN(value uint32) {
	volatile.StoreUint32(&o.FUNC_CTRL.Reg, volatile.LoadUint32(&o.FUNC_CTRL.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetFUNC_CTRL_M0_PMS_FUNC_EN() uint32 {
	return volatile.LoadUint32(&o.FUNC_CTRL.Reg) & 0x1
}
func (o *HP_APM_Type) SetFUNC_CTRL_M1_PMS_FUNC_EN(value uint32) {
	volatile.StoreUint32(&o.FUNC_CTRL.Reg, volatile.LoadUint32(&o.FUNC_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetFUNC_CTRL_M1_PMS_FUNC_EN() uint32 {
	return (volatile.LoadUint32(&o.FUNC_CTRL.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetFUNC_CTRL_M2_PMS_FUNC_EN(value uint32) {
	volatile.StoreUint32(&o.FUNC_CTRL.Reg, volatile.LoadUint32(&o.FUNC_CTRL.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetFUNC_CTRL_M2_PMS_FUNC_EN() uint32 {
	return (volatile.LoadUint32(&o.FUNC_CTRL.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetFUNC_CTRL_M3_PMS_FUNC_EN(value uint32) {
	volatile.StoreUint32(&o.FUNC_CTRL.Reg, volatile.LoadUint32(&o.FUNC_CTRL.Reg)&^(0x8)|value<<3)
}
func (o *HP_APM_Type) GetFUNC_CTRL_M3_PMS_FUNC_EN() uint32 {
	return (volatile.LoadUint32(&o.FUNC_CTRL.Reg) & 0x8) >> 3
}

// HP_APM.M0_STATUS: M0 status register
func (o *HP_APM_Type) SetM0_STATUS_M0_EXCEPTION_STATUS(value uint32) {
	volatile.StoreUint32(&o.M0_STATUS.Reg, volatile.LoadUint32(&o.M0_STATUS.Reg)&^(0x3)|value)
}
func (o *HP_APM_Type) GetM0_STATUS_M0_EXCEPTION_STATUS() uint32 {
	return volatile.LoadUint32(&o.M0_STATUS.Reg) & 0x3
}

// HP_APM.M0_STATUS_CLR: M0 status clear register
func (o *HP_APM_Type) SetM0_STATUS_CLR_M0_REGION_STATUS_CLR(value uint32) {
	volatile.StoreUint32(&o.M0_STATUS_CLR.Reg, volatile.LoadUint32(&o.M0_STATUS_CLR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetM0_STATUS_CLR_M0_REGION_STATUS_CLR() uint32 {
	return volatile.LoadUint32(&o.M0_STATUS_CLR.Reg) & 0x1
}

// HP_APM.M0_EXCEPTION_INFO0: M0 exception_info0 register
func (o *HP_APM_Type) SetM0_EXCEPTION_INFO0_M0_EXCEPTION_REGION(value uint32) {
	volatile.StoreUint32(&o.M0_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M0_EXCEPTION_INFO0.Reg)&^(0xffff)|value)
}
func (o *HP_APM_Type) GetM0_EXCEPTION_INFO0_M0_EXCEPTION_REGION() uint32 {
	return volatile.LoadUint32(&o.M0_EXCEPTION_INFO0.Reg) & 0xffff
}
func (o *HP_APM_Type) SetM0_EXCEPTION_INFO0_M0_EXCEPTION_MODE(value uint32) {
	volatile.StoreUint32(&o.M0_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M0_EXCEPTION_INFO0.Reg)&^(0x30000)|value<<16)
}
func (o *HP_APM_Type) GetM0_EXCEPTION_INFO0_M0_EXCEPTION_MODE() uint32 {
	return (volatile.LoadUint32(&o.M0_EXCEPTION_INFO0.Reg) & 0x30000) >> 16
}
func (o *HP_APM_Type) SetM0_EXCEPTION_INFO0_M0_EXCEPTION_ID(value uint32) {
	volatile.StoreUint32(&o.M0_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M0_EXCEPTION_INFO0.Reg)&^(0x7c0000)|value<<18)
}
func (o *HP_APM_Type) GetM0_EXCEPTION_INFO0_M0_EXCEPTION_ID() uint32 {
	return (volatile.LoadUint32(&o.M0_EXCEPTION_INFO0.Reg) & 0x7c0000) >> 18
}

// HP_APM.M0_EXCEPTION_INFO1: M0 exception_info1 register
func (o *HP_APM_Type) SetM0_EXCEPTION_INFO1(value uint32) {
	volatile.StoreUint32(&o.M0_EXCEPTION_INFO1.Reg, value)
}
func (o *HP_APM_Type) GetM0_EXCEPTION_INFO1() uint32 {
	return volatile.LoadUint32(&o.M0_EXCEPTION_INFO1.Reg)
}

// HP_APM.M1_STATUS: M1 status register
func (o *HP_APM_Type) SetM1_STATUS_M1_EXCEPTION_STATUS(value uint32) {
	volatile.StoreUint32(&o.M1_STATUS.Reg, volatile.LoadUint32(&o.M1_STATUS.Reg)&^(0x3)|value)
}
func (o *HP_APM_Type) GetM1_STATUS_M1_EXCEPTION_STATUS() uint32 {
	return volatile.LoadUint32(&o.M1_STATUS.Reg) & 0x3
}

// HP_APM.M1_STATUS_CLR: M1 status clear register
func (o *HP_APM_Type) SetM1_STATUS_CLR_M1_REGION_STATUS_CLR(value uint32) {
	volatile.StoreUint32(&o.M1_STATUS_CLR.Reg, volatile.LoadUint32(&o.M1_STATUS_CLR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetM1_STATUS_CLR_M1_REGION_STATUS_CLR() uint32 {
	return volatile.LoadUint32(&o.M1_STATUS_CLR.Reg) & 0x1
}

// HP_APM.M1_EXCEPTION_INFO0: M1 exception_info0 register
func (o *HP_APM_Type) SetM1_EXCEPTION_INFO0_M1_EXCEPTION_REGION(value uint32) {
	volatile.StoreUint32(&o.M1_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M1_EXCEPTION_INFO0.Reg)&^(0xffff)|value)
}
func (o *HP_APM_Type) GetM1_EXCEPTION_INFO0_M1_EXCEPTION_REGION() uint32 {
	return volatile.LoadUint32(&o.M1_EXCEPTION_INFO0.Reg) & 0xffff
}
func (o *HP_APM_Type) SetM1_EXCEPTION_INFO0_M1_EXCEPTION_MODE(value uint32) {
	volatile.StoreUint32(&o.M1_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M1_EXCEPTION_INFO0.Reg)&^(0x30000)|value<<16)
}
func (o *HP_APM_Type) GetM1_EXCEPTION_INFO0_M1_EXCEPTION_MODE() uint32 {
	return (volatile.LoadUint32(&o.M1_EXCEPTION_INFO0.Reg) & 0x30000) >> 16
}
func (o *HP_APM_Type) SetM1_EXCEPTION_INFO0_M1_EXCEPTION_ID(value uint32) {
	volatile.StoreUint32(&o.M1_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M1_EXCEPTION_INFO0.Reg)&^(0x7c0000)|value<<18)
}
func (o *HP_APM_Type) GetM1_EXCEPTION_INFO0_M1_EXCEPTION_ID() uint32 {
	return (volatile.LoadUint32(&o.M1_EXCEPTION_INFO0.Reg) & 0x7c0000) >> 18
}

// HP_APM.M1_EXCEPTION_INFO1: M1 exception_info1 register
func (o *HP_APM_Type) SetM1_EXCEPTION_INFO1(value uint32) {
	volatile.StoreUint32(&o.M1_EXCEPTION_INFO1.Reg, value)
}
func (o *HP_APM_Type) GetM1_EXCEPTION_INFO1() uint32 {
	return volatile.LoadUint32(&o.M1_EXCEPTION_INFO1.Reg)
}

// HP_APM.M2_STATUS: M2 status register
func (o *HP_APM_Type) SetM2_STATUS_M2_EXCEPTION_STATUS(value uint32) {
	volatile.StoreUint32(&o.M2_STATUS.Reg, volatile.LoadUint32(&o.M2_STATUS.Reg)&^(0x3)|value)
}
func (o *HP_APM_Type) GetM2_STATUS_M2_EXCEPTION_STATUS() uint32 {
	return volatile.LoadUint32(&o.M2_STATUS.Reg) & 0x3
}

// HP_APM.M2_STATUS_CLR: M2 status clear register
func (o *HP_APM_Type) SetM2_STATUS_CLR_M2_REGION_STATUS_CLR(value uint32) {
	volatile.StoreUint32(&o.M2_STATUS_CLR.Reg, volatile.LoadUint32(&o.M2_STATUS_CLR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetM2_STATUS_CLR_M2_REGION_STATUS_CLR() uint32 {
	return volatile.LoadUint32(&o.M2_STATUS_CLR.Reg) & 0x1
}

// HP_APM.M2_EXCEPTION_INFO0: M2 exception_info0 register
func (o *HP_APM_Type) SetM2_EXCEPTION_INFO0_M2_EXCEPTION_REGION(value uint32) {
	volatile.StoreUint32(&o.M2_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M2_EXCEPTION_INFO0.Reg)&^(0xffff)|value)
}
func (o *HP_APM_Type) GetM2_EXCEPTION_INFO0_M2_EXCEPTION_REGION() uint32 {
	return volatile.LoadUint32(&o.M2_EXCEPTION_INFO0.Reg) & 0xffff
}
func (o *HP_APM_Type) SetM2_EXCEPTION_INFO0_M2_EXCEPTION_MODE(value uint32) {
	volatile.StoreUint32(&o.M2_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M2_EXCEPTION_INFO0.Reg)&^(0x30000)|value<<16)
}
func (o *HP_APM_Type) GetM2_EXCEPTION_INFO0_M2_EXCEPTION_MODE() uint32 {
	return (volatile.LoadUint32(&o.M2_EXCEPTION_INFO0.Reg) & 0x30000) >> 16
}
func (o *HP_APM_Type) SetM2_EXCEPTION_INFO0_M2_EXCEPTION_ID(value uint32) {
	volatile.StoreUint32(&o.M2_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M2_EXCEPTION_INFO0.Reg)&^(0x7c0000)|value<<18)
}
func (o *HP_APM_Type) GetM2_EXCEPTION_INFO0_M2_EXCEPTION_ID() uint32 {
	return (volatile.LoadUint32(&o.M2_EXCEPTION_INFO0.Reg) & 0x7c0000) >> 18
}

// HP_APM.M2_EXCEPTION_INFO1: M2 exception_info1 register
func (o *HP_APM_Type) SetM2_EXCEPTION_INFO1(value uint32) {
	volatile.StoreUint32(&o.M2_EXCEPTION_INFO1.Reg, value)
}
func (o *HP_APM_Type) GetM2_EXCEPTION_INFO1() uint32 {
	return volatile.LoadUint32(&o.M2_EXCEPTION_INFO1.Reg)
}

// HP_APM.M3_STATUS: M3 status register
func (o *HP_APM_Type) SetM3_STATUS_M3_EXCEPTION_STATUS(value uint32) {
	volatile.StoreUint32(&o.M3_STATUS.Reg, volatile.LoadUint32(&o.M3_STATUS.Reg)&^(0x3)|value)
}
func (o *HP_APM_Type) GetM3_STATUS_M3_EXCEPTION_STATUS() uint32 {
	return volatile.LoadUint32(&o.M3_STATUS.Reg) & 0x3
}

// HP_APM.M3_STATUS_CLR: M3 status clear register
func (o *HP_APM_Type) SetM3_STATUS_CLR_M3_REGION_STATUS_CLR(value uint32) {
	volatile.StoreUint32(&o.M3_STATUS_CLR.Reg, volatile.LoadUint32(&o.M3_STATUS_CLR.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetM3_STATUS_CLR_M3_REGION_STATUS_CLR() uint32 {
	return volatile.LoadUint32(&o.M3_STATUS_CLR.Reg) & 0x1
}

// HP_APM.M3_EXCEPTION_INFO0: M3 exception_info0 register
func (o *HP_APM_Type) SetM3_EXCEPTION_INFO0_M3_EXCEPTION_REGION(value uint32) {
	volatile.StoreUint32(&o.M3_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M3_EXCEPTION_INFO0.Reg)&^(0xffff)|value)
}
func (o *HP_APM_Type) GetM3_EXCEPTION_INFO0_M3_EXCEPTION_REGION() uint32 {
	return volatile.LoadUint32(&o.M3_EXCEPTION_INFO0.Reg) & 0xffff
}
func (o *HP_APM_Type) SetM3_EXCEPTION_INFO0_M3_EXCEPTION_MODE(value uint32) {
	volatile.StoreUint32(&o.M3_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M3_EXCEPTION_INFO0.Reg)&^(0x30000)|value<<16)
}
func (o *HP_APM_Type) GetM3_EXCEPTION_INFO0_M3_EXCEPTION_MODE() uint32 {
	return (volatile.LoadUint32(&o.M3_EXCEPTION_INFO0.Reg) & 0x30000) >> 16
}
func (o *HP_APM_Type) SetM3_EXCEPTION_INFO0_M3_EXCEPTION_ID(value uint32) {
	volatile.StoreUint32(&o.M3_EXCEPTION_INFO0.Reg, volatile.LoadUint32(&o.M3_EXCEPTION_INFO0.Reg)&^(0x7c0000)|value<<18)
}
func (o *HP_APM_Type) GetM3_EXCEPTION_INFO0_M3_EXCEPTION_ID() uint32 {
	return (volatile.LoadUint32(&o.M3_EXCEPTION_INFO0.Reg) & 0x7c0000) >> 18
}

// HP_APM.M3_EXCEPTION_INFO1: M3 exception_info1 register
func (o *HP_APM_Type) SetM3_EXCEPTION_INFO1(value uint32) {
	volatile.StoreUint32(&o.M3_EXCEPTION_INFO1.Reg, value)
}
func (o *HP_APM_Type) GetM3_EXCEPTION_INFO1() uint32 {
	return volatile.LoadUint32(&o.M3_EXCEPTION_INFO1.Reg)
}

// HP_APM.INT_EN: APM interrupt enable register
func (o *HP_APM_Type) SetINT_EN_M0_APM_INT_EN(value uint32) {
	volatile.StoreUint32(&o.INT_EN.Reg, volatile.LoadUint32(&o.INT_EN.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetINT_EN_M0_APM_INT_EN() uint32 {
	return volatile.LoadUint32(&o.INT_EN.Reg) & 0x1
}
func (o *HP_APM_Type) SetINT_EN_M1_APM_INT_EN(value uint32) {
	volatile.StoreUint32(&o.INT_EN.Reg, volatile.LoadUint32(&o.INT_EN.Reg)&^(0x2)|value<<1)
}
func (o *HP_APM_Type) GetINT_EN_M1_APM_INT_EN() uint32 {
	return (volatile.LoadUint32(&o.INT_EN.Reg) & 0x2) >> 1
}
func (o *HP_APM_Type) SetINT_EN_M2_APM_INT_EN(value uint32) {
	volatile.StoreUint32(&o.INT_EN.Reg, volatile.LoadUint32(&o.INT_EN.Reg)&^(0x4)|value<<2)
}
func (o *HP_APM_Type) GetINT_EN_M2_APM_INT_EN() uint32 {
	return (volatile.LoadUint32(&o.INT_EN.Reg) & 0x4) >> 2
}
func (o *HP_APM_Type) SetINT_EN_M3_APM_INT_EN(value uint32) {
	volatile.StoreUint32(&o.INT_EN.Reg, volatile.LoadUint32(&o.INT_EN.Reg)&^(0x8)|value<<3)
}
func (o *HP_APM_Type) GetINT_EN_M3_APM_INT_EN() uint32 {
	return (volatile.LoadUint32(&o.INT_EN.Reg) & 0x8) >> 3
}

// HP_APM.CLOCK_GATE: clock gating register
func (o *HP_APM_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *HP_APM_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// HP_APM.DATE: Version register
func (o *HP_APM_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *HP_APM_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// High-Power System
type HP_SYS_Type struct {
	EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL volatile.Register32 // 0x0
	SRAM_USAGE_CONF                         volatile.Register32 // 0x4
	SEC_DPA_CONF                            volatile.Register32 // 0x8
	CPU_PERI_TIMEOUT_CONF                   volatile.Register32 // 0xC
	CPU_PERI_TIMEOUT_ADDR                   volatile.Register32 // 0x10
	CPU_PERI_TIMEOUT_UID                    volatile.Register32 // 0x14
	HP_PERI_TIMEOUT_CONF                    volatile.Register32 // 0x18
	HP_PERI_TIMEOUT_ADDR                    volatile.Register32 // 0x1C
	HP_PERI_TIMEOUT_UID                     volatile.Register32 // 0x20
	MODEM_PERI_TIMEOUT_CONF                 volatile.Register32 // 0x24
	MODEM_PERI_TIMEOUT_ADDR                 volatile.Register32 // 0x28
	MODEM_PERI_TIMEOUT_UID                  volatile.Register32 // 0x2C
	SDIO_CTRL                               volatile.Register32 // 0x30
	RETENTION_CONF                          volatile.Register32 // 0x34
	ROM_TABLE_LOCK                          volatile.Register32 // 0x38
	ROM_TABLE                               volatile.Register32 // 0x3C
	CORE_DEBUG_RUNSTALL_CONF                volatile.Register32 // 0x40
	MEM_TEST_CONF                           volatile.Register32 // 0x44
	_                                       [920]byte
	RND_ECO                                 volatile.Register32 // 0x3E0
	RND_ECO_LOW                             volatile.Register32 // 0x3E4
	RND_ECO_HIGH                            volatile.Register32 // 0x3E8
	_                                       [12]byte
	CLOCK_GATE                              volatile.Register32 // 0x3F8
	DATE                                    volatile.Register32 // 0x3FC
}

// HP_SYS.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL: EXTERNAL DEVICE ENCRYPTION/DECRYPTION configuration register
func (o *HP_SYS_Type) SetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_SPI_MANUAL_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg, volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg)&^(0x1)|value)
}
func (o *HP_SYS_Type) GetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_SPI_MANUAL_ENCRYPT() uint32 {
	return volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg) & 0x1
}
func (o *HP_SYS_Type) SetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_DOWNLOAD_DB_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg, volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg)&^(0x2)|value<<1)
}
func (o *HP_SYS_Type) GetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_DOWNLOAD_DB_ENCRYPT() uint32 {
	return (volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg) & 0x2) >> 1
}
func (o *HP_SYS_Type) SetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_DOWNLOAD_G0CB_DECRYPT(value uint32) {
	volatile.StoreUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg, volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg)&^(0x4)|value<<2)
}
func (o *HP_SYS_Type) GetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_DOWNLOAD_G0CB_DECRYPT() uint32 {
	return (volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg) & 0x4) >> 2
}
func (o *HP_SYS_Type) SetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_DOWNLOAD_MANUAL_ENCRYPT(value uint32) {
	volatile.StoreUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg, volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg)&^(0x8)|value<<3)
}
func (o *HP_SYS_Type) GetEXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL_ENABLE_DOWNLOAD_MANUAL_ENCRYPT() uint32 {
	return (volatile.LoadUint32(&o.EXTERNAL_DEVICE_ENCRYPT_DECRYPT_CONTROL.Reg) & 0x8) >> 3
}

// HP_SYS.SRAM_USAGE_CONF: HP memory usage configuration register
func (o *HP_SYS_Type) SetSRAM_USAGE_CONF_CACHE_USAGE(value uint32) {
	volatile.StoreUint32(&o.SRAM_USAGE_CONF.Reg, volatile.LoadUint32(&o.SRAM_USAGE_CONF.Reg)&^(0x1)|value)
}
func (o *HP_SYS_Type) GetSRAM_USAGE_CONF_CACHE_USAGE() uint32 {
	return volatile.LoadUint32(&o.SRAM_USAGE_CONF.Reg) & 0x1
}
func (o *HP_SYS_Type) SetSRAM_USAGE_CONF_SRAM_USAGE(value uint32) {
	volatile.StoreUint32(&o.SRAM_USAGE_CONF.Reg, volatile.LoadUint32(&o.SRAM_USAGE_CONF.Reg)&^(0xf00)|value<<8)
}
func (o *HP_SYS_Type) GetSRAM_USAGE_CONF_SRAM_USAGE() uint32 {
	return (volatile.LoadUint32(&o.SRAM_USAGE_CONF.Reg) & 0xf00) >> 8
}
func (o *HP_SYS_Type) SetSRAM_USAGE_CONF_MAC_DUMP_ALLOC(value uint32) {
	volatile.StoreUint32(&o.SRAM_USAGE_CONF.Reg, volatile.LoadUint32(&o.SRAM_USAGE_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *HP_SYS_Type) GetSRAM_USAGE_CONF_MAC_DUMP_ALLOC() uint32 {
	return (volatile.LoadUint32(&o.SRAM_USAGE_CONF.Reg) & 0x10000) >> 16
}

// HP_SYS.SEC_DPA_CONF: HP anti-DPA security configuration register
func (o *HP_SYS_Type) SetSEC_DPA_CONF_SEC_DPA_LEVEL(value uint32) {
	volatile.StoreUint32(&o.SEC_DPA_CONF.Reg, volatile.LoadUint32(&o.SEC_DPA_CONF.Reg)&^(0x3)|value)
}
func (o *HP_SYS_Type) GetSEC_DPA_CONF_SEC_DPA_LEVEL() uint32 {
	return volatile.LoadUint32(&o.SEC_DPA_CONF.Reg) & 0x3
}
func (o *HP_SYS_Type) SetSEC_DPA_CONF_SEC_DPA_CFG_SEL(value uint32) {
	volatile.StoreUint32(&o.SEC_DPA_CONF.Reg, volatile.LoadUint32(&o.SEC_DPA_CONF.Reg)&^(0x4)|value<<2)
}
func (o *HP_SYS_Type) GetSEC_DPA_CONF_SEC_DPA_CFG_SEL() uint32 {
	return (volatile.LoadUint32(&o.SEC_DPA_CONF.Reg) & 0x4) >> 2
}

// HP_SYS.CPU_PERI_TIMEOUT_CONF: CPU_PERI_TIMEOUT configuration register
func (o *HP_SYS_Type) SetCPU_PERI_TIMEOUT_CONF_CPU_PERI_TIMEOUT_THRES(value uint32) {
	volatile.StoreUint32(&o.CPU_PERI_TIMEOUT_CONF.Reg, volatile.LoadUint32(&o.CPU_PERI_TIMEOUT_CONF.Reg)&^(0xffff)|value)
}
func (o *HP_SYS_Type) GetCPU_PERI_TIMEOUT_CONF_CPU_PERI_TIMEOUT_THRES() uint32 {
	return volatile.LoadUint32(&o.CPU_PERI_TIMEOUT_CONF.Reg) & 0xffff
}
func (o *HP_SYS_Type) SetCPU_PERI_TIMEOUT_CONF_CPU_PERI_TIMEOUT_INT_CLEAR(value uint32) {
	volatile.StoreUint32(&o.CPU_PERI_TIMEOUT_CONF.Reg, volatile.LoadUint32(&o.CPU_PERI_TIMEOUT_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *HP_SYS_Type) GetCPU_PERI_TIMEOUT_CONF_CPU_PERI_TIMEOUT_INT_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.CPU_PERI_TIMEOUT_CONF.Reg) & 0x10000) >> 16
}
func (o *HP_SYS_Type) SetCPU_PERI_TIMEOUT_CONF_CPU_PERI_TIMEOUT_PROTECT_EN(value uint32) {
	volatile.StoreUint32(&o.CPU_PERI_TIMEOUT_CONF.Reg, volatile.LoadUint32(&o.CPU_PERI_TIMEOUT_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *HP_SYS_Type) GetCPU_PERI_TIMEOUT_CONF_CPU_PERI_TIMEOUT_PROTECT_EN() uint32 {
	return (volatile.LoadUint32(&o.CPU_PERI_TIMEOUT_CONF.Reg) & 0x20000) >> 17
}

// HP_SYS.CPU_PERI_TIMEOUT_ADDR: CPU_PERI_TIMEOUT_ADDR register
func (o *HP_SYS_Type) SetCPU_PERI_TIMEOUT_ADDR(value uint32) {
	volatile.StoreUint32(&o.CPU_PERI_TIMEOUT_ADDR.Reg, value)
}
func (o *HP_SYS_Type) GetCPU_PERI_TIMEOUT_ADDR() uint32 {
	return volatile.LoadUint32(&o.CPU_PERI_TIMEOUT_ADDR.Reg)
}

// HP_SYS.CPU_PERI_TIMEOUT_UID: CPU_PERI_TIMEOUT_UID register
func (o *HP_SYS_Type) SetCPU_PERI_TIMEOUT_UID(value uint32) {
	volatile.StoreUint32(&o.CPU_PERI_TIMEOUT_UID.Reg, volatile.LoadUint32(&o.CPU_PERI_TIMEOUT_UID.Reg)&^(0x7f)|value)
}
func (o *HP_SYS_Type) GetCPU_PERI_TIMEOUT_UID() uint32 {
	return volatile.LoadUint32(&o.CPU_PERI_TIMEOUT_UID.Reg) & 0x7f
}

// HP_SYS.HP_PERI_TIMEOUT_CONF: HP_PERI_TIMEOUT configuration register
func (o *HP_SYS_Type) SetHP_PERI_TIMEOUT_CONF_HP_PERI_TIMEOUT_THRES(value uint32) {
	volatile.StoreUint32(&o.HP_PERI_TIMEOUT_CONF.Reg, volatile.LoadUint32(&o.HP_PERI_TIMEOUT_CONF.Reg)&^(0xffff)|value)
}
func (o *HP_SYS_Type) GetHP_PERI_TIMEOUT_CONF_HP_PERI_TIMEOUT_THRES() uint32 {
	return volatile.LoadUint32(&o.HP_PERI_TIMEOUT_CONF.Reg) & 0xffff
}
func (o *HP_SYS_Type) SetHP_PERI_TIMEOUT_CONF_HP_PERI_TIMEOUT_INT_CLEAR(value uint32) {
	volatile.StoreUint32(&o.HP_PERI_TIMEOUT_CONF.Reg, volatile.LoadUint32(&o.HP_PERI_TIMEOUT_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *HP_SYS_Type) GetHP_PERI_TIMEOUT_CONF_HP_PERI_TIMEOUT_INT_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.HP_PERI_TIMEOUT_CONF.Reg) & 0x10000) >> 16
}
func (o *HP_SYS_Type) SetHP_PERI_TIMEOUT_CONF_HP_PERI_TIMEOUT_PROTECT_EN(value uint32) {
	volatile.StoreUint32(&o.HP_PERI_TIMEOUT_CONF.Reg, volatile.LoadUint32(&o.HP_PERI_TIMEOUT_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *HP_SYS_Type) GetHP_PERI_TIMEOUT_CONF_HP_PERI_TIMEOUT_PROTECT_EN() uint32 {
	return (volatile.LoadUint32(&o.HP_PERI_TIMEOUT_CONF.Reg) & 0x20000) >> 17
}

// HP_SYS.HP_PERI_TIMEOUT_ADDR: HP_PERI_TIMEOUT_ADDR register
func (o *HP_SYS_Type) SetHP_PERI_TIMEOUT_ADDR(value uint32) {
	volatile.StoreUint32(&o.HP_PERI_TIMEOUT_ADDR.Reg, value)
}
func (o *HP_SYS_Type) GetHP_PERI_TIMEOUT_ADDR() uint32 {
	return volatile.LoadUint32(&o.HP_PERI_TIMEOUT_ADDR.Reg)
}

// HP_SYS.HP_PERI_TIMEOUT_UID: HP_PERI_TIMEOUT_UID register
func (o *HP_SYS_Type) SetHP_PERI_TIMEOUT_UID(value uint32) {
	volatile.StoreUint32(&o.HP_PERI_TIMEOUT_UID.Reg, volatile.LoadUint32(&o.HP_PERI_TIMEOUT_UID.Reg)&^(0x7f)|value)
}
func (o *HP_SYS_Type) GetHP_PERI_TIMEOUT_UID() uint32 {
	return volatile.LoadUint32(&o.HP_PERI_TIMEOUT_UID.Reg) & 0x7f
}

// HP_SYS.MODEM_PERI_TIMEOUT_CONF: MODEM_PERI_TIMEOUT configuration register
func (o *HP_SYS_Type) SetMODEM_PERI_TIMEOUT_CONF_MODEM_PERI_TIMEOUT_THRES(value uint32) {
	volatile.StoreUint32(&o.MODEM_PERI_TIMEOUT_CONF.Reg, volatile.LoadUint32(&o.MODEM_PERI_TIMEOUT_CONF.Reg)&^(0xffff)|value)
}
func (o *HP_SYS_Type) GetMODEM_PERI_TIMEOUT_CONF_MODEM_PERI_TIMEOUT_THRES() uint32 {
	return volatile.LoadUint32(&o.MODEM_PERI_TIMEOUT_CONF.Reg) & 0xffff
}
func (o *HP_SYS_Type) SetMODEM_PERI_TIMEOUT_CONF_MODEM_PERI_TIMEOUT_INT_CLEAR(value uint32) {
	volatile.StoreUint32(&o.MODEM_PERI_TIMEOUT_CONF.Reg, volatile.LoadUint32(&o.MODEM_PERI_TIMEOUT_CONF.Reg)&^(0x10000)|value<<16)
}
func (o *HP_SYS_Type) GetMODEM_PERI_TIMEOUT_CONF_MODEM_PERI_TIMEOUT_INT_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.MODEM_PERI_TIMEOUT_CONF.Reg) & 0x10000) >> 16
}
func (o *HP_SYS_Type) SetMODEM_PERI_TIMEOUT_CONF_MODEM_PERI_TIMEOUT_PROTECT_EN(value uint32) {
	volatile.StoreUint32(&o.MODEM_PERI_TIMEOUT_CONF.Reg, volatile.LoadUint32(&o.MODEM_PERI_TIMEOUT_CONF.Reg)&^(0x20000)|value<<17)
}
func (o *HP_SYS_Type) GetMODEM_PERI_TIMEOUT_CONF_MODEM_PERI_TIMEOUT_PROTECT_EN() uint32 {
	return (volatile.LoadUint32(&o.MODEM_PERI_TIMEOUT_CONF.Reg) & 0x20000) >> 17
}

// HP_SYS.MODEM_PERI_TIMEOUT_ADDR: MODEM_PERI_TIMEOUT_ADDR register
func (o *HP_SYS_Type) SetMODEM_PERI_TIMEOUT_ADDR(value uint32) {
	volatile.StoreUint32(&o.MODEM_PERI_TIMEOUT_ADDR.Reg, value)
}
func (o *HP_SYS_Type) GetMODEM_PERI_TIMEOUT_ADDR() uint32 {
	return volatile.LoadUint32(&o.MODEM_PERI_TIMEOUT_ADDR.Reg)
}

// HP_SYS.MODEM_PERI_TIMEOUT_UID: MODEM_PERI_TIMEOUT_UID register
func (o *HP_SYS_Type) SetMODEM_PERI_TIMEOUT_UID(value uint32) {
	volatile.StoreUint32(&o.MODEM_PERI_TIMEOUT_UID.Reg, volatile.LoadUint32(&o.MODEM_PERI_TIMEOUT_UID.Reg)&^(0x7f)|value)
}
func (o *HP_SYS_Type) GetMODEM_PERI_TIMEOUT_UID() uint32 {
	return volatile.LoadUint32(&o.MODEM_PERI_TIMEOUT_UID.Reg) & 0x7f
}

// HP_SYS.SDIO_CTRL: SDIO Control configuration register
func (o *HP_SYS_Type) SetSDIO_CTRL_DIS_SDIO_PROB(value uint32) {
	volatile.StoreUint32(&o.SDIO_CTRL.Reg, volatile.LoadUint32(&o.SDIO_CTRL.Reg)&^(0x1)|value)
}
func (o *HP_SYS_Type) GetSDIO_CTRL_DIS_SDIO_PROB() uint32 {
	return volatile.LoadUint32(&o.SDIO_CTRL.Reg) & 0x1
}
func (o *HP_SYS_Type) SetSDIO_CTRL_SDIO_WIN_ACCESS_EN(value uint32) {
	volatile.StoreUint32(&o.SDIO_CTRL.Reg, volatile.LoadUint32(&o.SDIO_CTRL.Reg)&^(0x2)|value<<1)
}
func (o *HP_SYS_Type) GetSDIO_CTRL_SDIO_WIN_ACCESS_EN() uint32 {
	return (volatile.LoadUint32(&o.SDIO_CTRL.Reg) & 0x2) >> 1
}

// HP_SYS.RETENTION_CONF: Retention configuration register
func (o *HP_SYS_Type) SetRETENTION_CONF_RETENTION_DISABLE(value uint32) {
	volatile.StoreUint32(&o.RETENTION_CONF.Reg, volatile.LoadUint32(&o.RETENTION_CONF.Reg)&^(0x1)|value)
}
func (o *HP_SYS_Type) GetRETENTION_CONF_RETENTION_DISABLE() uint32 {
	return volatile.LoadUint32(&o.RETENTION_CONF.Reg) & 0x1
}

// HP_SYS.ROM_TABLE_LOCK: Rom-Table lock register
func (o *HP_SYS_Type) SetROM_TABLE_LOCK(value uint32) {
	volatile.StoreUint32(&o.ROM_TABLE_LOCK.Reg, volatile.LoadUint32(&o.ROM_TABLE_LOCK.Reg)&^(0x1)|value)
}
func (o *HP_SYS_Type) GetROM_TABLE_LOCK() uint32 {
	return volatile.LoadUint32(&o.ROM_TABLE_LOCK.Reg) & 0x1
}

// HP_SYS.ROM_TABLE: Rom-Table register
func (o *HP_SYS_Type) SetROM_TABLE(value uint32) {
	volatile.StoreUint32(&o.ROM_TABLE.Reg, value)
}
func (o *HP_SYS_Type) GetROM_TABLE() uint32 {
	return volatile.LoadUint32(&o.ROM_TABLE.Reg)
}

// HP_SYS.CORE_DEBUG_RUNSTALL_CONF: Core Debug runstall configure register
func (o *HP_SYS_Type) SetCORE_DEBUG_RUNSTALL_CONF_CORE_DEBUG_RUNSTALL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CORE_DEBUG_RUNSTALL_CONF.Reg, volatile.LoadUint32(&o.CORE_DEBUG_RUNSTALL_CONF.Reg)&^(0x1)|value)
}
func (o *HP_SYS_Type) GetCORE_DEBUG_RUNSTALL_CONF_CORE_DEBUG_RUNSTALL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CORE_DEBUG_RUNSTALL_CONF.Reg) & 0x1
}

// HP_SYS.MEM_TEST_CONF: MEM_TEST configuration register
func (o *HP_SYS_Type) SetMEM_TEST_CONF_HP_MEM_WPULSE(value uint32) {
	volatile.StoreUint32(&o.MEM_TEST_CONF.Reg, volatile.LoadUint32(&o.MEM_TEST_CONF.Reg)&^(0x7)|value)
}
func (o *HP_SYS_Type) GetMEM_TEST_CONF_HP_MEM_WPULSE() uint32 {
	return volatile.LoadUint32(&o.MEM_TEST_CONF.Reg) & 0x7
}
func (o *HP_SYS_Type) SetMEM_TEST_CONF_HP_MEM_WA(value uint32) {
	volatile.StoreUint32(&o.MEM_TEST_CONF.Reg, volatile.LoadUint32(&o.MEM_TEST_CONF.Reg)&^(0x38)|value<<3)
}
func (o *HP_SYS_Type) GetMEM_TEST_CONF_HP_MEM_WA() uint32 {
	return (volatile.LoadUint32(&o.MEM_TEST_CONF.Reg) & 0x38) >> 3
}
func (o *HP_SYS_Type) SetMEM_TEST_CONF_HP_MEM_RA(value uint32) {
	volatile.StoreUint32(&o.MEM_TEST_CONF.Reg, volatile.LoadUint32(&o.MEM_TEST_CONF.Reg)&^(0xc0)|value<<6)
}
func (o *HP_SYS_Type) GetMEM_TEST_CONF_HP_MEM_RA() uint32 {
	return (volatile.LoadUint32(&o.MEM_TEST_CONF.Reg) & 0xc0) >> 6
}

// HP_SYS.RND_ECO: redcy eco register.
func (o *HP_SYS_Type) SetRND_ECO_REDCY_ENA(value uint32) {
	volatile.StoreUint32(&o.RND_ECO.Reg, volatile.LoadUint32(&o.RND_ECO.Reg)&^(0x1)|value)
}
func (o *HP_SYS_Type) GetRND_ECO_REDCY_ENA() uint32 {
	return volatile.LoadUint32(&o.RND_ECO.Reg) & 0x1
}
func (o *HP_SYS_Type) SetRND_ECO_REDCY_RESULT(value uint32) {
	volatile.StoreUint32(&o.RND_ECO.Reg, volatile.LoadUint32(&o.RND_ECO.Reg)&^(0x2)|value<<1)
}
func (o *HP_SYS_Type) GetRND_ECO_REDCY_RESULT() uint32 {
	return (volatile.LoadUint32(&o.RND_ECO.Reg) & 0x2) >> 1
}

// HP_SYS.RND_ECO_LOW: redcy eco low register.
func (o *HP_SYS_Type) SetRND_ECO_LOW(value uint32) {
	volatile.StoreUint32(&o.RND_ECO_LOW.Reg, value)
}
func (o *HP_SYS_Type) GetRND_ECO_LOW() uint32 {
	return volatile.LoadUint32(&o.RND_ECO_LOW.Reg)
}

// HP_SYS.RND_ECO_HIGH: redcy eco high register.
func (o *HP_SYS_Type) SetRND_ECO_HIGH(value uint32) {
	volatile.StoreUint32(&o.RND_ECO_HIGH.Reg, value)
}
func (o *HP_SYS_Type) GetRND_ECO_HIGH() uint32 {
	return volatile.LoadUint32(&o.RND_ECO_HIGH.Reg)
}

// HP_SYS.CLOCK_GATE: HP-SYSTEM clock gating configure register
func (o *HP_SYS_Type) SetCLOCK_GATE_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLOCK_GATE.Reg, volatile.LoadUint32(&o.CLOCK_GATE.Reg)&^(0x1)|value)
}
func (o *HP_SYS_Type) GetCLOCK_GATE_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLOCK_GATE.Reg) & 0x1
}

// HP_SYS.DATE: Date register.
func (o *HP_SYS_Type) SetDATE(value uint32) {
	volatile.StoreUint32(&o.DATE.Reg, volatile.LoadUint32(&o.DATE.Reg)&^(0xfffffff)|value)
}
func (o *HP_SYS_Type) GetDATE() uint32 {
	return volatile.LoadUint32(&o.DATE.Reg) & 0xfffffff
}

// I2C (Inter-Integrated Circuit) Controller 0
type I2C_Type struct {
	SCL_LOW_PERIOD       volatile.Register32 // 0x0
	CTR                  volatile.Register32 // 0x4
	SR                   volatile.Register32 // 0x8
	TO                   volatile.Register32 // 0xC
	SLAVE_ADDR           volatile.Register32 // 0x10
	FIFO_ST              volatile.Register32 // 0x14
	FIFO_CONF            volatile.Register32 // 0x18
	DATA                 volatile.Register32 // 0x1C
	INT_RAW              volatile.Register32 // 0x20
	INT_CLR              volatile.Register32 // 0x24
	INT_ENA              volatile.Register32 // 0x28
	INT_STATUS           volatile.Register32 // 0x2C
	SDA_HOLD             volatile.Register32 // 0x30
	SDA_SAMPLE           volatile.Register32 // 0x34
	SCL_HIGH_PERIOD      volatile.Register32 // 0x38
	_                    [4]byte
	SCL_START_HOLD       volatile.Register32 // 0x40
	SCL_RSTART_SETUP     volatile.Register32 // 0x44
	SCL_STOP_HOLD        volatile.Register32 // 0x48
	SCL_STOP_SETUP       volatile.Register32 // 0x4C
	FILTER_CFG           volatile.Register32 // 0x50
	CLK_CONF             volatile.Register32 // 0x54
	COMD0                volatile.Register32 // 0x58
	COMD1                volatile.Register32 // 0x5C
	COMD2                volatile.Register32 // 0x60
	COMD3                volatile.Register32 // 0x64
	COMD4                volatile.Register32 // 0x68
	COMD5                volatile.Register32 // 0x6C
	COMD6                volatile.Register32 // 0x70
	COMD7                volatile.Register32 // 0x74
	SCL_ST_TIME_OUT      volatile.Register32 // 0x78
	SCL_MAIN_ST_TIME_OUT volatile.Register32 // 0x7C
	SCL_SP_CONF          volatile.Register32 // 0x80
	SCL_STRETCH_CONF     volatile.Register32 // 0x84
	_                    [112]byte
	DATE                 volatile.Register32 // 0xF8
	_                    [4]byte
	TXFIFO_START_ADDR    volatile.Register32 // 0x100
	_                    [124]byte
	RXFIFO_START_ADDR    volatile.Register32 // 0x180
}

// I2C.SCL_LOW_PERIOD: Configures the low level width of the SCL Clock
func (o *I2C_Type) SetSCL_LOW_PERIOD(value uint32) {
	volatile.StoreUint32(&o.SCL_LOW_PERIOD.Reg, volatile.LoadUint32(&o.SCL_LOW_PERIOD.Reg)&^(0x1ff)|value)
}
func (o *I2C_Type) GetSCL_LOW_PERIOD() uint32 {
	return volatile.LoadUint32(&o.SCL_LOW_PERIOD.Reg) & 0x1ff
}

// I2C.CTR: Transmission setting
func (o *I2C_Type) SetCTR_SDA_FORCE_OUT(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCTR_SDA_FORCE_OUT() uint32 {
	return volatile.LoadUint32(&o.CTR.Reg) & 0x1
}
func (o *I2C_Type) SetCTR_SCL_FORCE_OUT(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCTR_SCL_FORCE_OUT() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCTR_SAMPLE_SCL_LEVEL(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCTR_SAMPLE_SCL_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCTR_RX_FULL_ACK_LEVEL(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCTR_RX_FULL_ACK_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCTR_MS_MODE(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCTR_MS_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCTR_TRANS_START(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCTR_TRANS_START() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCTR_TX_LSB_FIRST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCTR_TX_LSB_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCTR_RX_LSB_FIRST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCTR_RX_LSB_FIRST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCTR_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetCTR_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetCTR_ARBITRATION_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetCTR_ARBITRATION_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetCTR_FSM_RST(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCTR_FSM_RST() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCTR_CONF_UPGATE(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCTR_CONF_UPGATE() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCTR_SLV_TX_AUTO_START_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCTR_SLV_TX_AUTO_START_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCTR_ADDR_10BIT_RW_CHECK_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCTR_ADDR_10BIT_RW_CHECK_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCTR_ADDR_BROADCASTING_EN(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCTR_ADDR_BROADCASTING_EN() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0x4000) >> 14
}

// I2C.SR: Describe I2C work status.
func (o *I2C_Type) SetSR_RESP_REC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetSR_RESP_REC() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *I2C_Type) SetSR_SLAVE_RW(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetSR_SLAVE_RW() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetSR_ARB_LOST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetSR_ARB_LOST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetSR_BUS_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetSR_BUS_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetSR_SLAVE_ADDRESSED(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetSR_SLAVE_ADDRESSED() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetSR_RXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x3f00)|value<<8)
}
func (o *I2C_Type) GetSR_RXFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x3f00) >> 8
}
func (o *I2C_Type) SetSR_STRETCH_CAUSE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xc000)|value<<14)
}
func (o *I2C_Type) GetSR_STRETCH_CAUSE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xc000) >> 14
}
func (o *I2C_Type) SetSR_TXFIFO_CNT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xfc0000)|value<<18)
}
func (o *I2C_Type) GetSR_TXFIFO_CNT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xfc0000) >> 18
}
func (o *I2C_Type) SetSR_SCL_MAIN_STATE_LAST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7000000)|value<<24)
}
func (o *I2C_Type) GetSR_SCL_MAIN_STATE_LAST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x7000000) >> 24
}
func (o *I2C_Type) SetSR_SCL_STATE_LAST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x70000000)|value<<28)
}
func (o *I2C_Type) GetSR_SCL_STATE_LAST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x70000000) >> 28
}

// I2C.TO: Setting time out control for receiving data.
func (o *I2C_Type) SetTO_TIME_OUT_VALUE(value uint32) {
	volatile.StoreUint32(&o.TO.Reg, volatile.LoadUint32(&o.TO.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetTO_TIME_OUT_VALUE() uint32 {
	return volatile.LoadUint32(&o.TO.Reg) & 0x1f
}
func (o *I2C_Type) SetTO_TIME_OUT_EN(value uint32) {
	volatile.StoreUint32(&o.TO.Reg, volatile.LoadUint32(&o.TO.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetTO_TIME_OUT_EN() uint32 {
	return (volatile.LoadUint32(&o.TO.Reg) & 0x20) >> 5
}

// I2C.SLAVE_ADDR: Local slave address setting
func (o *I2C_Type) SetSLAVE_ADDR(value uint32) {
	volatile.StoreUint32(&o.SLAVE_ADDR.Reg, volatile.LoadUint32(&o.SLAVE_ADDR.Reg)&^(0x7fff)|value)
}
func (o *I2C_Type) GetSLAVE_ADDR() uint32 {
	return volatile.LoadUint32(&o.SLAVE_ADDR.Reg) & 0x7fff
}
func (o *I2C_Type) SetSLAVE_ADDR_ADDR_10BIT_EN(value uint32) {
	volatile.StoreUint32(&o.SLAVE_ADDR.Reg, volatile.LoadUint32(&o.SLAVE_ADDR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetSLAVE_ADDR_ADDR_10BIT_EN() uint32 {
	return (volatile.LoadUint32(&o.SLAVE_ADDR.Reg) & 0x80000000) >> 31
}

// I2C.FIFO_ST: FIFO status register.
func (o *I2C_Type) SetFIFO_ST_RXFIFO_RADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetFIFO_ST_RXFIFO_RADDR() uint32 {
	return volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x1f
}
func (o *I2C_Type) SetFIFO_ST_RXFIFO_WADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x3e0)|value<<5)
}
func (o *I2C_Type) GetFIFO_ST_RXFIFO_WADDR() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x3e0) >> 5
}
func (o *I2C_Type) SetFIFO_ST_TXFIFO_RADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x7c00)|value<<10)
}
func (o *I2C_Type) GetFIFO_ST_TXFIFO_RADDR() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x7c00) >> 10
}
func (o *I2C_Type) SetFIFO_ST_TXFIFO_WADDR(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0xf8000)|value<<15)
}
func (o *I2C_Type) GetFIFO_ST_TXFIFO_WADDR() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0xf8000) >> 15
}
func (o *I2C_Type) SetFIFO_ST_SLAVE_RW_POINT(value uint32) {
	volatile.StoreUint32(&o.FIFO_ST.Reg, volatile.LoadUint32(&o.FIFO_ST.Reg)&^(0x3fc00000)|value<<22)
}
func (o *I2C_Type) GetFIFO_ST_SLAVE_RW_POINT() uint32 {
	return (volatile.LoadUint32(&o.FIFO_ST.Reg) & 0x3fc00000) >> 22
}

// I2C.FIFO_CONF: FIFO configuration register.
func (o *I2C_Type) SetFIFO_CONF_RXFIFO_WM_THRHD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x1f)|value)
}
func (o *I2C_Type) GetFIFO_CONF_RXFIFO_WM_THRHD() uint32 {
	return volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x1f
}
func (o *I2C_Type) SetFIFO_CONF_TXFIFO_WM_THRHD(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x3e0)|value<<5)
}
func (o *I2C_Type) GetFIFO_CONF_TXFIFO_WM_THRHD() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x3e0) >> 5
}
func (o *I2C_Type) SetFIFO_CONF_NONFIFO_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetFIFO_CONF_NONFIFO_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetFIFO_CONF_FIFO_ADDR_CFG_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetFIFO_CONF_FIFO_ADDR_CFG_EN() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetFIFO_CONF_RX_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetFIFO_CONF_RX_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetFIFO_CONF_TX_FIFO_RST(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetFIFO_CONF_TX_FIFO_RST() uint32 {
	return (volatile.LoadUint32(&o.FIFO_CONF.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetFIFO_CONF_FIFO_PRT_EN(value uint32) {
	volatile.StoreUint32(&o.FIFO_CONF.Reg, volatile.LoadUint32(&o.FIFO_CONF.Reg