/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves.rewrite;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.catalina.util.URLEncoder;
import org.apache.catalina.valves.rewrite.Resolver;
import org.apache.catalina.valves.rewrite.RewriteMap;
import org.apache.tomcat.util.res.StringManager;

public class Substitution {
    protected static final StringManager sm = StringManager.getManager(Substitution.class);
    protected SubstitutionElement[] elements = null;
    protected String sub = null;
    private boolean escapeBackReferences;

    public String getSub() {
        return this.sub;
    }

    public void setSub(String string) {
        this.sub = string;
    }

    void setEscapeBackReferences(boolean bl) {
        this.escapeBackReferences = bl;
    }

    public void parse(Map<String, RewriteMap> map) {
        this.elements = this.parseSubstitution(this.sub, map);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SubstitutionElement[] parseSubstitution(String string, Map<String, RewriteMap> map) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n < string.length()) {
            void var8_24;
            int n5;
            int n6;
            int n7;
            n2 = string.indexOf(37, n);
            n3 = string.indexOf(36, n);
            n4 = string.indexOf(92, n);
            if (n2 == -1 && n3 == -1 && n4 == -1) {
                StaticElement staticElement = new StaticElement();
                staticElement.value = string.substring(n);
                n = string.length();
                arrayList.add(staticElement);
                continue;
            }
            if (this.isFirstPos(n4, n3, n2)) {
                if (n4 + 1 == string.length()) {
                    throw new IllegalArgumentException(sm.getString("substitution.invalid", new Object[]{string}));
                }
                StaticElement staticElement = new StaticElement();
                staticElement.value = string.substring(n, n4) + string.substring(n4 + 1, n4 + 2);
                n = n4 + 2;
                arrayList.add(staticElement);
                continue;
            }
            if (this.isFirstPos(n3, n2)) {
                if (n3 + 1 == string.length()) {
                    throw new IllegalArgumentException(sm.getString("substitution.invalid", new Object[]{string}));
                }
                if (n < n3) {
                    StaticElement staticElement = new StaticElement();
                    staticElement.value = string.substring(n, n3);
                    arrayList.add(staticElement);
                }
                if (Character.isDigit(string.charAt(n3 + 1))) {
                    RewriteRuleBackReferenceElement rewriteRuleBackReferenceElement = new RewriteRuleBackReferenceElement();
                    rewriteRuleBackReferenceElement.n = Character.digit(string.charAt(n3 + 1), 10);
                    n = n3 + 2;
                    arrayList.add(rewriteRuleBackReferenceElement);
                    continue;
                }
                if (string.charAt(n3 + 1) != '{') throw new IllegalArgumentException(sm.getString("substitution.missingDigit", new Object[]{string}));
                MapElement mapElement = new MapElement();
                n7 = string.indexOf(123, n3);
                n6 = Substitution.findMatchingColonOrBar(true, string, n7);
                n5 = Substitution.findMatchingColonOrBar(false, string, n7);
                int n8 = Substitution.findMatchingBrace(string, n7);
                if (-1 >= n7 || n7 >= n6 || n6 >= n8) {
                    throw new IllegalArgumentException(sm.getString("substitution.invalid", new Object[]{string}));
                }
                mapElement.map = map.get(string.substring(n7 + 1, n6));
                if (mapElement.map == null) {
                    throw new IllegalArgumentException(sm.getString("substitution.noMap", new Object[]{string.substring(n7 + 1, n6), string}));
                }
                String string2 = null;
                String string3 = null;
                if (n5 > -1) {
                    if (n6 >= n5 || n5 >= n8) {
                        throw new IllegalArgumentException(sm.getString("substitution.invalid", new Object[]{string}));
                    }
                    string2 = string.substring(n6 + 1, n5);
                    string3 = string.substring(n5 + 1, n8);
                } else {
                    string2 = string.substring(n6 + 1, n8);
                }
                mapElement.key = this.parseSubstitution(string2, map);
                if (string3 != null) {
                    mapElement.defaultValue = this.parseSubstitution(string3, map);
                }
                n = n8 + 1;
                arrayList.add(mapElement);
                continue;
            }
            if (n2 + 1 == string.length()) {
                throw new IllegalArgumentException(sm.getString("substitution.invalid", new Object[]{string}));
            }
            if (n < n2) {
                StaticElement staticElement = new StaticElement();
                staticElement.value = string.substring(n, n2);
                arrayList.add(staticElement);
            }
            if (Character.isDigit(string.charAt(n2 + 1))) {
                RewriteCondBackReferenceElement rewriteCondBackReferenceElement = new RewriteCondBackReferenceElement();
                rewriteCondBackReferenceElement.n = Character.digit(string.charAt(n2 + 1), 10);
                n = n2 + 2;
                arrayList.add(rewriteCondBackReferenceElement);
                continue;
            }
            if (string.charAt(n2 + 1) != '{') throw new IllegalArgumentException(sm.getString("substitution.missingDigit", new Object[]{string}));
            Object var8_18 = null;
            n7 = string.indexOf(123, n2);
            n6 = Substitution.findMatchingColonOrBar(true, string, n7);
            n5 = Substitution.findMatchingBrace(string, n7);
            if (-1 >= n7 || n7 >= n5) {
                throw new IllegalArgumentException(sm.getString("substitution.invalid", new Object[]{string}));
            }
            if (n6 > -1 && n7 < n6 && n6 < n5) {
                String string4 = string.substring(n7 + 1, n6);
                if (string4.equals("ENV")) {
                    ServerVariableEnvElement serverVariableEnvElement = new ServerVariableEnvElement();
                    serverVariableEnvElement.key = string.substring(n6 + 1, n5);
                } else if (string4.equals("SSL")) {
                    ServerVariableSslElement serverVariableSslElement = new ServerVariableSslElement();
                    serverVariableSslElement.key = string.substring(n6 + 1, n5);
                } else {
                    if (!string4.equals("HTTP")) throw new IllegalArgumentException(sm.getString("substitution.badType", new Object[]{string4, string}));
                    ServerVariableHttpElement serverVariableHttpElement = new ServerVariableHttpElement();
                    serverVariableHttpElement.key = string.substring(n6 + 1, n5);
                }
            } else {
                ServerVariableElement serverVariableElement = new ServerVariableElement();
                serverVariableElement.key = string.substring(n7 + 1, n5);
            }
            n = n5 + 1;
            arrayList.add(var8_24);
        }
        return arrayList.toArray(new SubstitutionElement[0]);
    }

    private static int findMatchingBrace(String string, int n) {
        int n2 = 1;
        for (int i = n + 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                char c2 = string.charAt(i - 1);
                if (c2 != '$' && c2 != '%') continue;
                ++n2;
                continue;
            }
            if (c != '}' || --n2 != 0) continue;
            return i;
        }
        return -1;
    }

    private static int findMatchingColonOrBar(boolean bl, String string, int n) {
        int n2 = 0;
        for (int i = n + 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '{') {
                char c2 = string.charAt(i - 1);
                if (c2 != '$' && c2 != '%') continue;
                ++n2;
                continue;
            }
            if (c == '}') {
                --n2;
                continue;
            }
            if (!(bl ? c == ':' : c == '|') || n2 != 0) continue;
            return i;
        }
        return -1;
    }

    public String evaluate(Matcher matcher, Matcher matcher2, Resolver resolver) {
        return this.evaluateSubstitution(this.elements, matcher, matcher2, resolver);
    }

    private String evaluateSubstitution(SubstitutionElement[] substitutionElementArray, Matcher matcher, Matcher matcher2, Resolver resolver) {
        StringBuilder stringBuilder = new StringBuilder();
        for (SubstitutionElement substitutionElement : substitutionElementArray) {
            stringBuilder.append(substitutionElement.evaluate(matcher, matcher2, resolver));
        }
        return stringBuilder.toString();
    }

    private boolean isFirstPos(int n, int ... nArray) {
        if (n < 0) {
            return false;
        }
        for (int n2 : nArray) {
            if (n2 < 0 || n2 >= n) continue;
            return false;
        }
        return true;
    }

    public class MapElement
    extends SubstitutionElement {
        public RewriteMap map = null;
        public SubstitutionElement[] defaultValue = null;
        public SubstitutionElement[] key = null;

        @Override
        public String evaluate(Matcher matcher, Matcher matcher2, Resolver resolver) {
            String string = this.map.lookup(Substitution.this.evaluateSubstitution(this.key, matcher, matcher2, resolver));
            if (string == null && this.defaultValue != null) {
                string = Substitution.this.evaluateSubstitution(this.defaultValue, matcher, matcher2, resolver);
            }
            return string;
        }
    }

    public static class ServerVariableHttpElement
    extends SubstitutionElement {
        public String key;

        @Override
        public String evaluate(Matcher matcher, Matcher matcher2, Resolver resolver) {
            return resolver.resolveHttp(this.key);
        }
    }

    public static class ServerVariableSslElement
    extends SubstitutionElement {
        public String key;

        @Override
        public String evaluate(Matcher matcher, Matcher matcher2, Resolver resolver) {
            return resolver.resolveSsl(this.key);
        }
    }

    public static class ServerVariableEnvElement
    extends SubstitutionElement {
        public String key;

        @Override
        public String evaluate(Matcher matcher, Matcher matcher2, Resolver resolver) {
            return resolver.resolveEnv(this.key);
        }
    }

    public static class ServerVariableElement
    extends SubstitutionElement {
        public String key;

        @Override
        public String evaluate(Matcher matcher, Matcher matcher2, Resolver resolver) {
            return resolver.resolve(this.key);
        }
    }

    public static class RewriteCondBackReferenceElement
    extends SubstitutionElement {
        public int n;

        @Override
        public String evaluate(Matcher matcher, Matcher matcher2, Resolver resolver) {
            return matcher2.group(this.n) == null ? "" : matcher2.group(this.n);
        }
    }

    public class RewriteRuleBackReferenceElement
    extends SubstitutionElement {
        public int n;

        @Override
        public String evaluate(Matcher matcher, Matcher matcher2, Resolver resolver) {
            String string = matcher.group(this.n);
            if (string == null) {
                string = "";
            }
            if (Substitution.this.escapeBackReferences) {
                return URLEncoder.DEFAULT.encode(string, resolver.getUriCharset());
            }
            return string;
        }
    }

    public static class StaticElement
    extends SubstitutionElement {
        public String value;

        @Override
        public String evaluate(Matcher matcher, Matcher matcher2, Resolver resolver) {
            return this.value;
        }
    }

    public static abstract class SubstitutionElement {
        public abstract String evaluate(Matcher var1, Matcher var2, Resolver var3);
    }
}

