/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.server.system;

import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.JMRuntimeException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class HeapDump {
    private static MBeanServer mserver;
    private static ObjectName hotspotDiag;
    private static boolean initialized;
    private static boolean runningOnJdk15;

    private HeapDump() {
    }

    public static void initialize(boolean jdk15) {
        runningOnJdk15 = jdk15;
        if (runningOnJdk15) {
            HeapDump.initialize15();
        } else {
            HeapDump.initialize16();
        }
    }

    public static String takeHeapDump(String outputFile) {
        if (runningOnJdk15) {
            return HeapDump.takeHeapDump15(outputFile);
        }
        return HeapDump.takeHeapDump16(outputFile);
    }

    private static native void initialize15();

    private static void initialize16() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            mserver = ManagementFactory.getPlatformMBeanServer();
        }
        catch (JMRuntimeException ex) {
            System.err.println(ex.getLocalizedMessage());
            initialized = false;
            return;
        }
        try {
            hotspotDiag = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
            mserver.getObjectInstance(hotspotDiag);
        }
        catch (MalformedObjectNameException ex) {
            ex.printStackTrace();
        }
        catch (InstanceNotFoundException ex) {
            System.err.println("Heap Dump is not available");
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
    }

    private static String takeHeapDump15(String outputFile) {
        int error = -1;
        try {
            error = HeapDump.takeHeapDump15Native(outputFile);
        }
        catch (Exception ex) {
            return ex.getLocalizedMessage();
        }
        if (error == -1) {
            return "Take heap dump is not available.";
        }
        return null;
    }

    private static native int takeHeapDump15Native(String var0);

    private static String takeHeapDump16(String outputFile) {
        String error = null;
        HeapDump.initialize16();
        if (mserver == null || hotspotDiag == null) {
            return "Take heap dump is not available.";
        }
        try {
            mserver.invoke(hotspotDiag, "dumpHeap", new Object[]{outputFile, true}, new String[]{String.class.getName(), Boolean.TYPE.getName()});
        }
        catch (IllegalArgumentException ex) {
            error = ex.getLocalizedMessage();
        }
        catch (InstanceNotFoundException ex) {
            error = ex.getLocalizedMessage();
        }
        catch (MBeanException ex) {
            error = ex.getLocalizedMessage();
        }
        catch (ReflectionException ex) {
            error = ex.getLocalizedMessage();
        }
        return error;
    }
}

