; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck %s

define amdgpu_kernel void @test0() {
; CHECK-LABEL: test0:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_endpgm
  tail call void @llvm.amdgcn.endpgm()
  unreachable
}

define void @test1() {
; CHECK-LABEL: test1:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; CHECK-NEXT:    s_endpgm
  tail call void @llvm.amdgcn.endpgm()
  unreachable
}

define amdgpu_kernel void @test2(i32* %p, i32 %x) {
; CHECK-LABEL: test2:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    s_load_dword s2, s[0:1], 0x2c
; CHECK-NEXT:    s_waitcnt lgkmcnt(0)
; CHECK-NEXT:    s_cmp_lt_i32 s2, 1
; CHECK-NEXT:    s_cbranch_scc0 BB2_2
; CHECK-NEXT:  ; %bb.1: ; %else
; CHECK-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x24
; CHECK-NEXT:    v_mov_b32_e32 v2, s2
; CHECK-NEXT:    s_waitcnt lgkmcnt(0)
; CHECK-NEXT:    v_mov_b32_e32 v0, s0
; CHECK-NEXT:    v_mov_b32_e32 v1, s1
; CHECK-NEXT:    flat_store_dword v[0:1], v2
; CHECK-NEXT:    s_endpgm
; CHECK-NEXT:  BB2_2: ; %then
; CHECK-NEXT:    s_endpgm
  %cond = icmp sgt i32 %x, 0
  br i1 %cond, label %then, label %else

then:
  tail call void @llvm.amdgcn.endpgm()
  unreachable

else:
  store i32 %x, i32* %p
  ret void
}

declare void @llvm.amdgcn.endpgm()
